/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.utils.ErChangeAccountConvertUtils;

public class ExpenseBillToAgentBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(ExpenseBillToAgentBillConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("expenseitem");
        e.addSrcField("costcompany");
        e.addSrcField("tripexpenseitem");
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        if (ErChangeAccountConvertUtils.pushValidator((AbstractConvertPlugIn)this, (BeforeBuildRowConditionEventArgs)e)) {
            return;
        }
        List selectedRows = e.getSelectedRows();
        List pkLists = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.getSrcMainType().getName(), (String)"costcompany.id,costcompany.name", (QFilter[])new QFilter[]{new QFilter("id", "in", pkLists)});
        boolean bankOrg = true;
        String errorMsg = null;
        for (DynamicObject srcBill : load) {
            if (ExpenseBillToAgentBillConvertPlugin.getBankRollOrg(srcBill.getDynamicObject("costcompany").getPkValue()) != 0L) continue;
            bankOrg = false;
            errorMsg = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201c%s\u201d\u672a\u8bbe\u7f6e\u8d44\u91d1\u7ec4\u7ec7\u59d4\u6258\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ExpenseBillToAgentBillConvertPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), srcBill.getDynamicObject("costcompany").get("name"));
            break;
        }
        if (!bankOrg) {
            e.setCustFilterDesc(errorMsg);
            e.setCustFilterExpression(" billstatus = '-1' ");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"-1");
            e.getCustQFilters().add(qFilter);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject relation;
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Object expenseitemid = null;
            if (e.getFldProperties().get("expenseitem") != null) {
                expenseitemid = ((DynamicProperty)e.getFldProperties().get("expenseitem")).getValue((Object)srcRow);
            }
            if (e.getFldProperties().get("tripexpenseitem") != null) {
                expenseitemid = ((DynamicProperty)e.getFldProperties().get("tripexpenseitem")).getValue((Object)srcRow);
            }
            if (expenseitemid != null && (relation = ErDaoFactory.getInstance((String)"er_rel_expense_fundflow").queryOne(new QFilter("expenseitem", "=", expenseitemid))) != null) {
                DynamicObject fundflowitem = relation.getDynamicObject("fundflowitem");
                DynamicObjectCollection coll = billDataEntity.getDataEntity().getDynamicObjectCollection("entry");
                coll.forEach(v -> v.set("e_fundflowitem_id", fundflowitem.getPkValue()));
            }
            Object costCompany = ((DynamicProperty)e.getFldProperties().get("costcompany")).getValue((Object)srcRow);
            Long bankRollOrg = ExpenseBillToAgentBillConvertPlugin.getBankRollOrg(costCompany);
            billDataEntity.getDataEntity().set("org_id", (Object)bankRollOrg);
        }
    }

    private static Long getBankRollOrg(Object org) {
        Long companyId = 0L;
        Long orgId = Long.valueOf(org.toString());
        try {
            String fromOrgType = "10";
            String toOrgType = "08";
            Long billTypeId = 0L;
            companyId = OrgServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)orgId, (Long)billTypeId);
        }
        catch (Exception e) {
            logger.info(String.format("getBankRollOrg error \uff1aorgId = %s", orgId) + "exmsg:" + e.getMessage());
        }
        if (companyId == 0L && ExpenseBillToAgentBillConvertPlugin.isBankRollOrg(orgId)) {
            companyId = orgId;
        }
        return companyId;
    }

    private static boolean isBankRollOrg(Long orgId) {
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        QFilter dutyFilter = new QFilter("fisbankroll", "=", (Object)true);
        QFilter[] filters = new QFilter[]{idFilter, dutyFilter};
        return QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters);
    }
}

