/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.utils.ErChangeAccountConvertUtils;

public class ExpenseBillToPayBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(ExpenseBillToPayBillConvertPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        ErChangeAccountConvertUtils.pushValidator((AbstractConvertPlugIn)this, (BeforeBuildRowConditionEventArgs)e);
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("expenseitem");
        e.addSrcField("tripexpenseitem");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject relation;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            this.setTargetBillPayerBank(targetBill);
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Object expenseitemid = ((DynamicProperty)e.getFldProperties().get("expenseitem")).getValue((Object)srcRow);
            if (e.getFldProperties().get("tripexpenseitem") != null) {
                expenseitemid = ((DynamicProperty)e.getFldProperties().get("tripexpenseitem")).getValue((Object)srcRow);
            }
            if ((relation = ErDaoFactory.getInstance((String)"er_rel_expense_fundflow").queryOne(new QFilter("expenseitem", "=", expenseitemid))) == null) continue;
            DynamicObject fundflowitem = relation.getDynamicObject("fundflowitem");
            Object pkvalue = fundflowitem.getPkValue();
            billDataEntity.setValue("fundflowitem_id", fundflowitem.getPkValue());
        }
    }

    private void setTargetBillPayerBank(DynamicObject targetBill) {
        DynamicObject payerAcctBank = targetBill.getDynamicObject("payeracctbank");
        if (payerAcctBank != null) {
            DynamicObject payerBank = payerAcctBank.getDynamicObject("bank");
            if (payerBank != null) {
                targetBill.set("payerbank_id", payerBank.getPkValue());
            } else {
                logger.info("\u8be5\u7ec4\u7ec7\u94f6\u884c\u8d26\u6237\u5bf9\u5e94\u91d1\u878d\u673a\u6784\u4e3a\u7a7a\uff1apayeracctbank -->" + SerializationUtils.toJsonString((Object)payerAcctBank) + "-->" + SerializationUtils.toJsonString((Object)payerBank));
            }
        }
    }
}

