/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;

public class OrderBillToRepaymentBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final String SOURCE_BOOKED_ID = "sourcebookedid";
    private static final String CURRENCY = "currency";
    private int currencyPrecision;
    private static final String EXPCOMMIT_COMNUM = "expcommitcomnum";
    private static final String COMPANY = "company";

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField(SOURCE_BOOKED_ID);
        e.addSrcField(CURRENCY);
        e.addSrcField(EXPCOMMIT_COMNUM);
        e.addSrcField(COMPANY);
        e.addSrcField("sourceexchangerate");
        e.addSrcField("totalnotactrecamt");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject src = (DynamicObject)srcRows.get(0);
            Long userId = (Long)((DynamicProperty)e.getFldProperties().get(SOURCE_BOOKED_ID)).getValue((Object)src);
            this.createUserInfo(billDataEntity, userId);
            DynamicObject currency = this.getCurrencyByUserId(userId);
            if (currency == null) continue;
            billDataEntity.setValue("currency_id", currency.getPkValue());
            DataEntityPropertyCollection currencyProps = currency.getDataEntityType().getProperties();
            IDataEntityProperty currencyProp = (IDataEntityProperty)currencyProps.get((Object)"amtprecision");
            this.currencyPrecision = 10;
            if (currencyProp != null) {
                this.currencyPrecision = currency.getInt("amtprecision");
            }
            Long targetCurrencyId = (Long)((DynamicProperty)e.getFldProperties().get(CURRENCY)).getValue((Object)src);
            Long companyId = (Long)((DynamicProperty)e.getFldProperties().get(COMPANY)).getValue((Object)src);
            Object costCompany = billDataEntity.getValue("costcompany");
            BigDecimal rate = CommonServiceHelper.getExchangeRate((Long)this.parseLong(currency.getPkValue()), (Long)targetCurrencyId, (Object)companyId, (Object)costCompany);
            DynamicObject bill = billDataEntity.getDataEntity();
            DynamicObjectCollection coll = bill.getDynamicObjectCollection("repaymententry");
            coll.forEach(v -> v.set("sourceexchangerate", (Object)rate));
            coll.forEach(v -> v.set("repayamount", (Object)v.getBigDecimal("orirepayamount").multiply(rate).setScale(this.currencyPrecision, RoundingMode.HALF_UP)));
            BigDecimal totalAmount = coll.stream().map(v -> v.getBigDecimal("repayamount")).reduce((v1, v2) -> v1.add((BigDecimal)v2)).get();
            billDataEntity.setValue("amount", (Object)totalAmount);
            billDataEntity.setValue("totalnotactrecamt", (Object)totalAmount);
        }
    }

    private Map<String, Object> createUserInfo(ExtendedDataEntity billDataEntity, Long applierId) {
        HashMap<String, Object> billMap = new HashMap<String, Object>();
        if (applierId == null) {
            return billMap;
        }
        billDataEntity.setValue("applier_id", (Object)applierId);
        Map userMap = CommonServiceHelper.getUserMap((Long)applierId);
        if (userMap == null) {
            return billMap;
        }
        DynamicObject dept = (DynamicObject)userMap.get("org");
        if (dept != null) {
            Long deptId = (Long)dept.getPkValue();
            billDataEntity.setValue("org_id", (Object)deptId);
            billDataEntity.setValue("costdept_id", (Object)deptId);
            Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
            if (company != null) {
                billDataEntity.setValue("company_id", company.get("id"));
                billDataEntity.setValue("costcompany_id", (Object)CoreBaseBillServiceHelper.getAccountOrgId((Long)deptId));
                DynamicObject currencyObject = BaseCurrencyServiceHelper.getBaseCurrencyObject(company.get("id"), (Object)billDataEntity.getValue("costcompany_id"));
                if (currencyObject != null) {
                    billDataEntity.setValue(CURRENCY, (Object)currencyObject);
                }
            }
        }
        billDataEntity.setValue("tel", userMap.get("tel"));
        billDataEntity.setValue("applierpositionstr", userMap.get("applierpositionstr"));
        billDataEntity.setValue("bizdate", (Object)TimeServiceHelper.getCurrentSystemTime());
        billDataEntity.setValue("creator_id", (Object)CommonServiceHelper.getCurrentUserID());
        return billMap;
    }

    private Long parseLong(Object pkValue) {
        Long value = 0L;
        if (pkValue != null) {
            value = Long.parseLong(pkValue.toString());
        }
        return value;
    }

    private DynamicObject getCurrencyByUserId(Object userId) {
        DynamicObject dept;
        Map userMap;
        DynamicObject currency = null;
        if (userId != null && (userMap = CommonServiceHelper.getUserMap((Long)Long.parseLong(userId.toString()))) != null && (dept = (DynamicObject)userMap.get("org")) != null) {
            Long deptId = (Long)dept.getPkValue();
            Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
            Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId((Long)deptId);
            currency = BaseCurrencyServiceHelper.getBaseCurrencyObject(company.get("id"), (Object)accountOrgId);
        }
        return currency;
    }
}

