/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.apply;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.component.ApprovalRecord;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import org.apache.commons.lang3.StringUtils;

public class ERDailyExpenseApplyMobPlugin
extends AbstractMobBillPlugIn {
    private static final Log logger = LogFactory.getLog(ERDailyExpenseApplyMobPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_toreimburse"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CommonViewControlUtil.initViewUserInfo(this.getModel(), this.getView());
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (view.getParentView() != null) {
            String billPageId = view.getPageId();
            IPageCache parentPageCache = (IPageCache)view.getParentView().getService(IPageCache.class);
            parentPageCache.put("billPageId", billPageId);
        }
        CommonViewControlUtil.expensePageRules(model, view);
        boolean isfromDatabase = model.getDataEntity().getDataEntityState().getFromDatabase();
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "bar_toreimburse": {
                Set currencyIdSet;
                DynamicObjectCollection billExpeEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
                if (billExpeEntry == null || billExpeEntry.size() <= 0 || (currencyIdSet = billExpeEntry.stream().map(v -> v.getDynamicObject("entrycurrency") != null ? (Long)v.getDynamicObject("entrycurrency").getPkValue() : 0L).collect(Collectors.toSet())) == null || currencyIdSet.size() <= 1) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d39\u7528\u7533\u8bf7\u5355\u5b58\u5728\u591a\u4e2a\u5e01\u79cd\uff0c\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u62a5\u9500\uff0c\u8bf7\u524d\u5f80PC\u7aef\u8fdb\u884c\u62a5\u9500\u3002", (String)"ERDailyExpenseApplyMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("currency".equals(propName)) {
            CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "save": {
                this.refreshBillAmount();
                break;
            }
            case "submit": {
                boolean validata = this.validata(args);
                if (validata) {
                    return;
                }
                this.refreshBillAmount();
                break;
            }
            case "reimburse": {
                HashMap<Long, String> map = new HashMap<Long, String>(4);
                map.put(Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()), (String)this.getModel().getValue("billno"));
                boolean flag = BotpDrawServiceUtil.existDownBill(map, (String)"er_dailyapplybill", (String)"er_dailyloanbill");
                if (!flag) break;
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5173\u8054\u6709\u501f\u6b3e\uff0c\u8bf7\u4ece\u5bf9\u5e94\u501f\u6b3e\u5355\u4e0b\u63a8\u3002", (String)"ERDailyExpenseApplyMobPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]), map.values()));
            }
        }
    }

    private boolean validata(BeforeDoOperationEventArgs args) {
        int expenseRowCount;
        boolean cancel = false;
        Object description = this.getModel().getValue("description");
        if (description == null || StringUtils.isBlank((CharSequence)description.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4e8b\u7531\u201d\u3002", (String)"ERDailyExpenseApplyMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            cancel = true;
        }
        if ((expenseRowCount = this.getModel().getEntryRowCount("expenseentryentity")) < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7533\u8bf7\u660e\u7ec6\u3002", (String)"ERDailyExpenseApplyMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            cancel = true;
        }
        args.setCancel(cancel);
        return cancel;
    }

    private void refreshBillAmount() {
        IDataModel dataModel = this.getModel();
        BigDecimal applyAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"currexpenseamount");
        dataModel.setValue("applyamount", (Object)applyAmount);
        BigDecimal expeAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"expeapprovecurramount");
        dataModel.setValue("approveamount", (Object)expeAmount);
        dataModel.setValue("balanceamount", (Object)expeAmount);
        dataModel.setValue("billcanloanamount", (Object)expeAmount);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        String key = afterDoOperationEventArgs.getOperateKey();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        switch (key) {
            case "submit": {
                String formID;
                if (parentView != null) {
                    view.getParentView().close();
                    view.sendFormAction(view.getParentView());
                }
                if (ErEntityTypeUtils.isReimCtlApplyBill((String)(formID = view.getEntityId()))) {
                    return;
                }
                BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
                if (billShowParameter.getBillStatus().getValue() != BillOperationStatus.ADDNEW.getValue() && billShowParameter.getBillStatus().getValue() != BillOperationStatus.SUBMIT.getValue() && billShowParameter.getBillStatus().getValue() != BillOperationStatus.EDIT.getValue()) break;
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("formId", formID);
                paramMap.put("templateId", "er_dapplybill_mobtemplate");
                HashMap<String, String> customPar = new HashMap<String, String>(1);
                customPar.put("need_refresh", "Y");
                paramMap.put("customParam", customPar);
                ShowPageUtils.showMobileBillList(paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "copy": {
                if (!StringUtils.equalsIgnoreCase((CharSequence)parentView.getEntityId(), (CharSequence)"er_dlbill_tabap")) break;
                ApprovalRecord approvalRecord = (ApprovalRecord)parentView.getControl("approvalrecordap");
                approvalRecord.setArData(null);
                parentView.updateView("approvalrecordap");
                view.sendFormAction(parentView);
            }
        }
    }
}

