/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.apply;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.formplugin.mobile.CoreBaseBillListNew;
import kd.fi.er.formplugin.mobile.MobileListStateInfo;
import kd.fi.er.formplugin.mobile.MultiLang;
import org.apache.commons.lang.ObjectUtils;

public class ErDailyApplyBillListPlugin
extends CoreBaseBillListNew
implements ClickListener,
TabSelectListener {
    private static final List<String> todoStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D"}));
    private static final List<String> doingStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"E"}));
    private static final List<String> didStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"H", "I"}));
    private static final MobileListStateInfo todoStateInfo = new MobileListStateInfo("todotab", todoStateList, new MultiLang(ErDailyApplyBillListPlugin.getApplyMsg(), "ErDailyApplyBillListPlugin_0", "fi-er-formplugin"));
    private static final MobileListStateInfo doingStateInfo = new MobileListStateInfo("doingtab", doingStateList, new MultiLang(ErDailyApplyBillListPlugin.getAuditMsg(), "ErDailyApplyBillListPlugin_1", "fi-er-formplugin"));
    private static final MobileListStateInfo didStateInfo = new MobileListStateInfo("didtab", didStateList, new MultiLang(ErDailyApplyBillListPlugin.getCompleteMsg(), "ErDailyApplyBillListPlugin_2", "fi-er-formplugin"));
    private static final List<MobileListStateInfo> stateInfoList = Lists.newArrayListWithExpectedSize((int)3);

    public ErDailyApplyBillListPlugin() {
        super(stateInfoList);
    }

    public void contextMenuClick(ContextMenuClickEvent e) {
        super.contextMenuClick(e);
        if (e.getItemKey().toLowerCase().equals("new_dailyapply")) {
            MobileBillShowParameter showParameter = new MobileBillShowParameter();
            showParameter.setFormId("er_dailyapplybill_mob");
            showParameter.setCaption(ResManager.loadKDString((String)"\u8d39\u7528\u7533\u8bf7\u5355", (String)"ErDailyApplyBillListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_dailyapplybill"));
            ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)ShowType.Floating, (Object)ShowType.Floating);
            showParameter.getOpenStyle().setShowType(showType);
            showParameter.setAppId("18X6P1ZSXS44");
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_reimburse"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRowCollection = list.getSelectedRows();
        if (listSelectedRowCollection.size() > 0) {
            switch (key) {
                case "pub_reimburse": 
                case "btn_reimburse": {
                    Set currencyIdSet;
                    Long billId = (Long)listSelectedRowCollection.get(0).getPrimaryKeyValue();
                    QFilter qFilter = new QFilter("id", "=", (Object)billId);
                    DynamicObjectCollection bill = QueryServiceHelper.query((String)"er_dailyapplybill", (String)"expenseentryentity.entrycurrency", (QFilter[])new QFilter[]{qFilter});
                    if (bill == null || bill.size() <= 0 || (currencyIdSet = bill.stream().map(v -> v.getLong("expenseentryentity.entrycurrency") != 0L ? v.getLong("expenseentryentity.entrycurrency") : 0L).collect(Collectors.toSet())) == null || currencyIdSet.size() <= 1) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d39\u7528\u7533\u8bf7\u5355\u5b58\u5728\u591a\u4e2a\u5e01\u79cd\u3002\u79fb\u52a8\u7aef\u4e0d\u652f\u6301\u591a\u5e01\u79cd\u62a5\u9500\uff0c\u8bf7\u524d\u5f80PC\u7aef\u62a5\u9500\u3002", (String)"ErDailyApplyBillListPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        MobileListShowParameter mobparameter = (MobileListShowParameter)this.getView().getFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long billId = (Long)billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        customParam.put("FormId", formId);
        customParam.put("Status", billShowParameter.getBillStatusValue());
        customParam.put("PageId", billShowParameter.getPageId());
        customParam.put("billId", billId);
        billShowParameter.setPkId(null);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCustomParams(customParam);
        formShowParameter.setFormId("er_dlbill_tabap");
        formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (e.getParameter().getBillStatus() != BillOperationStatus.ADDNEW) {
            String billStatus = ((IListView)this.getView()).getCurrentSelectedRowInfo().getBillStatus();
            if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRows;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Push && ErEntityTypeUtils.isDailyApplyBill((String)this.getEntityName()) && "reimburse".equals(((Push)args.getSource()).getOperateKey()) && (listSelectedRows = args.getListSelectedData()) != null && listSelectedRows.size() > 0) {
            HashMap<Long, String> map = new HashMap<Long, String>(4);
            for (ListSelectedRow row : listSelectedRows) {
                if (row.getPrimaryKeyValue() == null) continue;
                map.put(Long.parseLong(row.getPrimaryKeyValue().toString()), row.getBillNo());
            }
            boolean flag = BotpDrawServiceUtil.existDownBill(map, (String)"er_dailyapplybill", (String)"er_dailyloanbill");
            if (flag) {
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5173\u8054\u6709\u501f\u6b3e\uff0c\u8bf7\u4ece\u5bf9\u5e94\u501f\u6b3e\u5355\u4e0b\u63a8\u3002", (String)"ErDailyApplyBillListPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), map.values()));
            }
        }
    }

    private static String getApplyMsg() {
        return ResManager.loadKDString((String)"\u7533\u8bf7\u4e2d", (String)"ErDailyApplyBillListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getAuditMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"ErDailyApplyBillListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getCompleteMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ErDailyApplyBillListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    static {
        stateInfoList.add(todoStateInfo);
        stateInfoList.add(doingStateInfo);
        stateInfoList.add(didStateInfo);
    }
}

