/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.common;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.formplugin.mobile.ErReimburseUpRequestMobPlugin;

public class CommonUtilHelper {
    public static QFilter getSpecialDataPermissionFilter(IFormView view, String entityName) {
        ITimeService timeService = (ITimeService)view.getService(ITimeService.class);
        IUserService userService = (IUserService)view.getService(IUserService.class);
        String appId = view.getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)appId)) {
            String appNum = view.getFormShowParameter().getFormConfig().getAppId();
            appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNum);
        }
        return PermissionFilterUtil.getSpecialDataPermissionFilter((String)appId, (String)entityName, (String)"view", (ITimeService)timeService, (IUserService)userService);
    }

    public static boolean isDeptAdmin(Long deptId, Long userId) {
        return QueryServiceHelper.exists((String)"bos_user", (QFilter[])new QFilter[]{QFilter.of((String)"id=? and entryentity.dpt.id=? and entryentity.isincharge=?", (Object[])new Object[]{userId, deptId, Boolean.TRUE})});
    }

    public static void setWriteOffAmountLable(IDataModel model, IFormView view, boolean ... del) {
        DynamicObject companyCurrencyDO = model.getDataEntity().getDynamicObject("currency");
        if (companyCurrencyDO == null) {
            return;
        }
        CurrencyBO currencyBO = new CurrencyBO((Long)companyCurrencyDO.getPkValue());
        String symbol = currencyBO.getSymbol();
        BigDecimal totalAmount = AmountUtils.getEntryAmount((IDataModel)model, (String)"writeoffmoney", (String)"curraccloanamount");
        Label label = (Label)view.getControl("label_writeoff_account");
        if (label != null) {
            label.setText(AmountFormatsUtil.getLabelAmountAfterFormat((String)symbol, (BigDecimal)totalAmount, (int)currencyBO.getPrecision()));
            view.updateView("writeoffmoney");
            if (view instanceof MobileBillView && (del.length == 0 || del.length == 1 && del[0])) {
                ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(model, view, false);
            }
        }
    }
}

