/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.common;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.daily.mobile.util.MobileEntryUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ReimburseWriteOffMobPlugin
extends AbstractMobBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_save".equals(key)) {
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Integer rowIndex = (Integer)formShowParameter.getCustomParam("index");
            returnMap.put("rowIndex", rowIndex);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("writeoffmoney");
            if (entryEntity == null) {
                entryEntity = this.getModel().getEntryEntity("clearloanentry");
            }
            returnMap.put("data", entryEntity);
            this.getView().returnDataToParent((Object)returnMap);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal currLoanAmoun;
        BigDecimal writeOffCurrAmount;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        if ("curraccloanamount".equals(propName)) {
            writeOffCurrAmount = (BigDecimal)propValue;
            currLoanAmoun = (BigDecimal)this.getModel().getValue("currloanamount", rowIndex);
            if (writeOffCurrAmount.compareTo(currLoanAmoun) > 0) {
                model.setValue(propName, oldValue, rowIndex);
                return;
            }
            if (writeOffCurrAmount.compareTo(currLoanAmoun) == 0) {
                BigDecimal loanamount = (BigDecimal)model.getValue("loanamount", rowIndex);
                model.setValue("accloanamount", (Object)loanamount, rowIndex);
            } else {
                BigDecimal currAmount = BigDecimal.ZERO;
                BigDecimal exchangeRate1 = (BigDecimal)model.getValue("loanexchangerate", rowIndex);
                String quoteType = model.getProperty("writeoffquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("writeoffquotetype", rowIndex)), (Object)"0");
                DynamicObject entry = (DynamicObject)model.getEntryEntity("writeoffmoney").get(rowIndex);
                currAmount = StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? ((BigDecimal)propValue).divide(exchangeRate1, AmountUtils.getAmountFieldPrecision((DynamicObject)entry, (String)"accloanamount"), RoundingMode.HALF_UP) : ((BigDecimal)propValue).multiply(exchangeRate1).setScale(AmountUtils.getAmountFieldPrecision((DynamicObject)entry, (String)"accloanamount"), RoundingMode.HALF_UP);
                model.setValue("accloanamount", (Object)currAmount, rowIndex);
            }
        }
        if ("accloanamount".equals(propName)) {
            BigDecimal writeOffAmount = (BigDecimal)propValue;
            BigDecimal loanAmount = (BigDecimal)this.getModel().getValue("loanamount", rowIndex);
            if (writeOffAmount.compareTo(loanAmount) > 0) {
                this.getModel().setValue(propName, oldValue, rowIndex);
                return;
            }
            if (WriteOffTypeEnum.ORGI_WO.getValue().equals(this.getWriteOffType())) {
                if (!this.updateWoAmountValidator(rowIndex)) {
                    return;
                }
                AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)propValue), (String)"curraccloanamount", (String)"loanexchangerate", (String)"loancurrency", (String)"writeoffquotetype", (int)rowIndex);
            }
        }
        if ("loanclearoriamount".equals(propName)) {
            writeOffCurrAmount = (BigDecimal)propValue;
            currLoanAmoun = (BigDecimal)this.getModel().getValue("loanoribalanceamount", rowIndex);
            if (writeOffCurrAmount.compareTo(currLoanAmoun) > 0) {
                this.getModel().setValue(propName, oldValue, rowIndex);
                return;
            }
            if (WriteOffTypeEnum.ORGI_WO.getValue().equals(this.getWriteOffType()) && !this.upDateTripCleAmountValidator(rowIndex)) {
                return;
            }
            AmountUtils.refreshCurrAmount((IDataModel)this.getModel(), (BigDecimal)((BigDecimal)propValue), (String)"loanclearamount", (String)"loanexchangerate", (String)"loancurrency", (String)"loanentryquotetype", (int)rowIndex);
        }
        if ("loanclearamount".equals(propName) && (writeOffCurrAmount = (BigDecimal)propValue).compareTo(currLoanAmoun = (BigDecimal)this.getModel().getValue("loanaccbalanceamount", rowIndex)) > 0) {
            this.getModel().setValue(propName, oldValue, rowIndex);
            return;
        }
    }

    private Object getWriteOffType() {
        if (this.getView().getParentView().getModel().getProperty("writeofftype") != null) {
            return this.getView().getParentView().getModel().getValue("writeofftype");
        }
        return this.getView().getParentView().getModel().getValue("loanchecktype");
    }

    private boolean updateWoAmountValidator(int rowIndex) {
        boolean resultFlag = true;
        Set currencyIds = AmountUtils.getCurrencyIdSet((IDataModel)this.getView().getParentView().getModel(), (String)"expenseentryentity", (String)"entrycurrency");
        DynamicObject writeOffCurrency = (DynamicObject)this.getModel().getValue("loancurrency", rowIndex);
        BigDecimal woAloanAmount = (BigDecimal)this.getModel().getValue("accloanamount", rowIndex);
        if (writeOffCurrency != null && !currencyIds.contains(writeOffCurrency.getPkValue()) && woAloanAmount != null && woAloanAmount.compareTo(BigDecimal.ZERO) > 0) {
            resultFlag = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u4e0d\u5728\u8d39\u7528\u660e\u7ec6\u4e2d\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ErReimburseBaseBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("accloanamount", (Object)0.0, rowIndex);
            this.getModel().setValue("curraccloanamount", (Object)0.0, rowIndex);
        }
        return resultFlag;
    }

    private boolean upDateTripCleAmountValidator(int rowIndex) {
        Set currencyIds = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").stream().flatMap(card -> card.getDynamicObjectCollection("entryentity").stream()).map(row -> ErCommonUtils.getPk((Object)row.get("entrycurrency"))).collect(Collectors.toSet());
        BigDecimal clearAmount = (BigDecimal)this.getModel().getValue("loanclearoriamount", rowIndex);
        if (!currencyIds.contains(ErCommonUtils.getPk((Object)this.getModel().getValue("loancurrency", rowIndex))) && clearAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u4e0d\u5728\u5dee\u65c5\u660e\u7ec6\u4e2d\uff0c\u4e0d\u80fd\u51b2\u9500\u3002", (String)"ErReimburseBaseBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("loanclearoriamount", (Object)0.0, rowIndex);
            this.getModel().setValue("loanclearamount", (Object)0.0, rowIndex);
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView parentView;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer rowIndex = (Integer)formShowParameter.getCustomParam("index");
        if (rowIndex != null && rowIndex != -1 && (parentView = this.getView().getParentView()) != null) {
            IDataModel parentModel = parentView.getModel();
            this.getModel().setValue("currency", parentModel.getValue("currency"));
            String identifier = (String)formShowParameter.getCustomParams().get("entryIdentifier");
            DynamicObjectCollection collection = parentModel.getEntryEntity(identifier);
            this.getModel().beginInit();
            int newRowIndex = MobileEntryUtil.addEntryToModel(this.getModel(), identifier, (DynamicObject)collection.get(rowIndex.intValue()), true);
            this.getModel().endInit();
            this.getView().updateView(identifier, newRowIndex);
            this.getModel().setValue("company", parentView.getModel().getValue("company"));
        }
    }
}

