/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.repayment;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleInfo;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import org.apache.commons.lang3.StringUtils;

public class RepaymentBillEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final String LB_CHANGE = "lb_change";
    protected BillSettingRuleInfo ruleInfo = null;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CommonViewControlUtil.initViewUserInfo(this.getModel(), this.getView());
        OrmLocaleValue applierpositionstr = (OrmLocaleValue)this.getModel().getValue("applierpositionstr");
        if (applierpositionstr != null) {
            Label positionLabel = (Label)this.getView().getControl("lb_position");
            positionLabel.setText(applierpositionstr.getLocaleValue());
        }
        this.setViewStatus();
        IDataModel model = this.getModel();
        BigDecimal amount = new BigDecimal(0);
        DynamicObjectCollection rows = model.getDataEntity(true).getDynamicObjectCollection("repaymententry");
        for (DynamicObject row : rows) {
            BigDecimal repayamount = row.getBigDecimal("repayamount");
            if (repayamount == null) continue;
            amount = amount.add(repayamount);
        }
        model.setValue("amount", (Object)amount);
        CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)model);
        BillSettingRuleUtil.setFormTitleForMob((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldNameForMob((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldHidden((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldMustInput((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldLock((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LB_CHANGE, "tips", "amountcard", "idcard", "pay_label", "in", "in1", "in2", "bar_submit"});
        AbstractGrid entryentity = (AbstractGrid)this.getControl("repaymententry");
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
        this.setCostDeptF7Filter();
        this.setCostCompanyF7Filter();
    }

    protected void setCostDeptF7Filter() {
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        if (costDeptF7 != null) {
            BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getModel());
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    protected void setCostCompanyF7Filter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
        Object costDept = this.getModel().getValue("costdept");
        Object company = this.getModel().getValue("company");
        if (costCompanyF7 != null && costDept != null && company != null) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)costDept), ErCommonUtils.getPk((Object)company));
            costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
        }
    }

    public void afterCreateNewData(EventObject e) {
        ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)true);
    }

    public void afterLoadData(EventObject e) {
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"repaymententry", (CharSequence)key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setFormId("er_repayentryedit_mb");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_repayentryedit_mb"));
            showParameter.setCustomParam("billstatus", (Object)((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("billstatus", (Object)((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus());
        switch (key) {
            case "lb_change": {
                CommonViewControlUtil.changeApplier(this.getView().getEntityId(), (IFormPlugin)this, this.getView());
                break;
            }
            case "tips": 
            case "pay_label": 
            case "in2": 
            case "in": {
                showParameter.setFormId("er_payinfo_mb");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_payinfo_mb"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "amountcard": 
            case "idcard": 
            case "in1": {
                showParameter.setFormId("er_repayentryedit_mb");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_repayentryedit_mb"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "bar_submit": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_unsubmit"});
            }
        }
        if (LB_CHANGE.equals(key)) {
            CommonViewControlUtil.changeApplier(this.getView().getEntityId(), (IFormPlugin)this, this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (key) {
            case "repayamount": {
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
                amount = amount.subtract((BigDecimal)oldValue).add((BigDecimal)newValue);
                this.getModel().setValue("amount", (Object)amount);
                this.getModel().setValue("totalnotactrecamt", (Object)amount);
                this.getModel().setValue("approveamount", (Object)amount);
                this.getModel().setValue("approveamount", (Object)amount);
                break;
            }
            case "costdept": {
                if (newValue == null) {
                    newValue = oldValue;
                    this.getModel().setValue("costdept", (Object)ErCommonUtils.getPk((Object)newValue));
                }
                IDataModel model = this.getModel();
                DynamicObject company = (DynamicObject)model.getValue("company");
                DynamicObject costCompany = (DynamicObject)model.getValue("company");
                CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, this.getModel().getValue("costDept"), (Object)costCompany, (Object)company);
                Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
                model.setValue("costcompany", (Object)costCompanyId);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result != null && !result.isSuccess()) {
            return;
        }
        String key = afterDoOperationEventArgs.getOperateKey();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        switch (key) {
            case "submit": {
                BillShowParameter billShowParameter;
                if (parentView != null) {
                    parentView.close();
                    view.sendFormAction(this.getView().getParentView());
                }
                if ((billShowParameter = (BillShowParameter)view.getFormShowParameter()).getBillStatus() != BillOperationStatus.ADDNEW && billShowParameter.getBillStatus() != BillOperationStatus.SUBMIT && BillOperationStatus.EDIT != billShowParameter.getBillStatus()) break;
                HashMap<String, String> paramMap = new HashMap<String, String>(2);
                paramMap.put("formId", view.getEntityId());
                paramMap.put("templateId", "er_repaybill__mobtemplate");
                ShowPageUtils.showMobileBillList(paramMap, (AbstractFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        HashMap returnData = (HashMap)event.getReturnData();
        int currentRowIndex = -1;
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"er_repayentryedit_mb")) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex("repaymententry");
        }
        for (Map.Entry entry : returnData.entrySet()) {
            this.getModel().setValue((String)entry.getKey(), entry.getValue(), currentRowIndex);
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"er_payinfo_mb")) {
            IFormView view = this.getView();
            String payername = (String)this.getModel().getValue("payername");
            boolean visibleFlag = payername != null && !StringUtils.isBlank((CharSequence)payername);
            view.setVisible(Boolean.valueOf(visibleFlag), new String[]{"pay_label"});
            view.setVisible(Boolean.valueOf(!visibleFlag), new String[]{"tips"});
        }
    }

    private void setViewStatus() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setEnable(Boolean.valueOf(false), new String[]{"amount"});
        String payername = (String)this.getModel().getValue("payername");
        boolean visibleFlag = payername == null || StringUtils.isBlank((CharSequence)payername);
        view.setVisible(Boolean.valueOf(!visibleFlag), new String[]{"pay_label"});
        view.setVisible(Boolean.valueOf(visibleFlag), new String[]{"tips"});
    }

    protected BillSettingRuleInfo getBillSettingRuleInfo() {
        if (this.ruleInfo == null) {
            this.ruleInfo = BillSettingRuleUtil.getBillSettingRuleInfo((IDataModel)this.getModel());
        }
        return this.ruleInfo;
    }
}

