/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.daily.mobile.util.model.KeyVisibleControl;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonViewControlUtil {
    public static void initViewUserInfo(IDataModel model, IFormView formView) {
        String entityId;
        Label deptName;
        DynamicObject dept;
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        if (applier != null) {
            String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
            Image imageap_photo = (Image)formView.getControl("imageap_photo");
            imageap_photo.setUrl(applierPicUrl);
            String name = applier.getString("name");
            Label control = (Label)formView.getControl("lb_name");
            control.setText(name);
        }
        if ((dept = (DynamicObject)model.getValue("org")) != null && (deptName = (Label)formView.getControl("lb_org")) != null) {
            deptName.setText(dept.getString("name"));
        }
        if (!(ErEntityTypeUtils.isRepaymentBill((String)(entityId = formView.getEntityId())) || ErEntityTypeUtils.isDailyApplyBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyLoanBill((String)entityId))) {
            if (model.getProperty("accountentry") == null) {
                return;
            }
            int entryRowCount = model.getEntryRowCount("accountentry");
            DynamicObject payer = (DynamicObject)model.getValue("payer", 0);
            Object payerName = model.getValue("payername", 0);
            if (entryRowCount > 0 && payer != null) {
                CommonViewControlUtil.setPayerLabel(payer, formView);
            } else if (entryRowCount > 0 && payerName != null && StringUtils.isNotBlank((CharSequence)payerName.toString())) {
                CommonViewControlUtil.setPayerLabelForOther((DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("accountentry").get(0), formView);
            } else {
                formView.setVisible(Boolean.valueOf(false), new String[]{"lb_payaccount", "image_bankurl"});
                formView.setVisible(Boolean.valueOf(true), new String[]{"labelap_addpayer"});
            }
        }
    }

    public static void setPayerLabelForOther(DynamicObject accountEntry, IFormView view) {
        Image image;
        Label lbPayAccount = (Label)view.getControl("lb_payaccount");
        if (lbPayAccount != null) {
            lbPayAccount.setText(accountEntry.getString("payeraccount"));
        }
        if ((image = (Image)view.getControl("image_bankurl")) != null) {
            image.setUrl("/icons/pc/other/Yen_60_60.png");
        }
        view.setVisible(Boolean.valueOf(true), new String[]{"lb_payaccount", "image_bankurl"});
        view.setVisible(Boolean.valueOf(false), new String[]{"labelap_addpayer"});
    }

    public static void setPayerLabel(DynamicObject payer, IFormView view) {
        if (payer == null) {
            view.setVisible(Boolean.valueOf(false), new String[]{"lb_payaccount", "image_bankurl"});
            view.setVisible(Boolean.valueOf(true), new String[]{"labelap_addpayer"});
            return;
        }
        Label lbPayAccount = (Label)view.getControl("lb_payaccount");
        if (lbPayAccount != null) {
            lbPayAccount.setText(payer.getString("payeraccount02"));
        }
        if (!StringUtils.isEmpty((CharSequence)payer.getString("banklogo"))) {
            String bankUrl = payer.getString("banklogo");
            Image image = (Image)view.getControl("image_bankurl");
            if (image != null) {
                image.setUrl(bankUrl);
            }
        }
        view.setVisible(Boolean.valueOf(true), new String[]{"lb_payaccount", "image_bankurl"});
        view.setVisible(Boolean.valueOf(false), new String[]{"labelap_addpayer"});
    }

    public static void changeApplier(String billtype, IFormPlugin formPlugin, IFormView fromView) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        String operation = "changeapplier";
        customParams.put("operation", operation);
        customParams.put("billtype", billtype);
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        String formId = "er_daily_applier_mb";
        showParameter.setFormId(formId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u4fe1\u606f", (String)"CommonViewControlUtil_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack(formPlugin, formId));
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)ShowType.Floating, (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setCustomParams(customParams);
        showParameter.setHasRight(true);
        fromView.showForm((FormShowParameter)showParameter);
    }

    public static void expensePageRules(IDataModel model, IFormView view) {
        int expenseEntrySize = model.getEntryRowCount("expenseentryentity");
        KeyVisibleControl control = new KeyVisibleControl(view);
        view.setVisible(Boolean.valueOf(true), new String[]{"label_expense_delete"});
        view.setVisible(Boolean.valueOf(false), new String[]{"label_expense_done"});
        if (expenseEntrySize == 0) {
            view.setVisible(Boolean.valueOf(false), new String[]{"expenseflex"});
            view.setVisible(Boolean.valueOf(false), new String[]{"expenseentryentity"});
            view.setVisible(Boolean.valueOf(true), new String[]{"btn_expense_add"});
            view.setVisible(Boolean.valueOf(false), new String[]{"flex_attachment"});
            view.setVisible(Boolean.valueOf(true), new String[]{"btn_save"});
            view.setVisible(Boolean.valueOf(true), new String[]{"btn_submit"});
        } else {
            control.setTrue("btn_addsection", "flex_count");
            control.setFalse("label_expense_done", "lab_done");
            control.setTrue("btn_save", "btn_submit");
            view.setVisible(Boolean.valueOf(true), new String[]{"expenseflex"});
            view.setVisible(Boolean.valueOf(true), new String[]{"expenseentryentity"});
            view.setVisible(Boolean.valueOf(true), new String[]{"btn_expense_add"});
            view.setVisible(Boolean.valueOf(true), new String[]{"flex_attachment"});
        }
        control.refreshView();
    }

    public static void setExpenseAmount(IDataModel model, IFormView formView) {
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        BigDecimal reimburseamount = CommonViewControlUtil.setAmountToLabel(model, formView, "expenseentryentity", "currexpenseamount", "label_expense_amount", currency);
        if (null != model.getProperty("reimburseamount") && !ThreadCache.exists((Object)"updateReimburseAmount")) {
            model.setValue("reimburseamount", (Object)reimburseamount);
            ThreadCache.put((Object)"updateReimburseAmount", (Object)1);
        }
    }

    public static BigDecimal setAmountToLabel(IDataModel model, IFormView formView, String entryName, String amtFieldName, String labelName, DynamicObject currency) {
        BigDecimal loanAmount = AmountUtils.getEntryAmount((IDataModel)model, (String)entryName, (String)amtFieldName);
        String currencySign = "";
        int amountPrecition = 4;
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
            loanAmount = loanAmount.setScale(amountPrecition, RoundingMode.HALF_UP);
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)Long.valueOf(RequestContext.get().getUserId()), (String)currencySign, (int)amountPrecition, (BigDecimal)loanAmount);
        Label expenseAmount = (Label)formView.getControl(labelName);
        if (expenseAmount != null) {
            expenseAmount.setText(formatMoneyByUser);
            formView.updateView(labelName);
        }
        return loanAmount;
    }

    public static void contractPageRule(IDataModel model, IFormView view, boolean delete) {
        int contractEntrySize = model.getEntryRowCount("contractentry");
        KeyVisibleControl control = new KeyVisibleControl(view);
        if (delete) {
            view.setVisible(Boolean.valueOf(true), new String[]{"label_contract_done"});
            view.setVisible(Boolean.valueOf(false), new String[]{"label_conract_delete"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"label_contract_done"});
            view.setVisible(Boolean.valueOf(true), new String[]{"label_conract_delete"});
        }
        if (contractEntrySize == 0) {
            view.setVisible(Boolean.valueOf(false), new String[]{"contractflex"});
            view.setVisible(Boolean.valueOf(false), new String[]{"contractentry"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"contractflex"});
            view.setVisible(Boolean.valueOf(true), new String[]{"contractentry"});
            CardEntry accountCard = (CardEntry)view.getControl("contractentry");
            int accountEntrySize = model.getEntryRowCount("contractentry");
            for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
                accountCard.setChildVisible(delete, rowIndex, new String[]{"image_contract_delete"});
            }
        }
        control.refreshView();
    }
}

