/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.reimctl;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ReimburseQuotaCopyPlugin
extends AbstractFormPlugin {
    private static final HashMap<String, String> MAPPING_QUOTA_ID = new HashMap(8);
    private static final HashMap<String, String> MAPPING_QUOTA_COLUMN = new HashMap(8);
    private static final HashMap<String, String> MAPPING_REPEAT_ATTRIBUTE_P = new HashMap(8);
    private static final HashMap<String, String> MAPPING_REPEAT_ATTRIBUTE_D = new HashMap(4);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.expenseItemF7Init();
    }

    private void expenseItemF7Init() {
        BasedataEdit expitem = (BasedataEdit)this.getControl("expitem");
        expitem.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilterApplierF7 = new QFilter("enable", "=", (Object)"1").and("isleaf", "=", (Object)"1");
            Map<String, Object> formParams = this.getFormParams();
            if (formParams == null) {
                return;
            }
            String quotaType = (String)formParams.get("quotaType");
            if ("quotaPersonal".equals(quotaType)) {
                qFilterApplierF7.and("isreimburseamountctl", "=", (Object)"1");
            } else if ("quotaDepartmental".equals(quotaType)) {
                qFilterApplierF7.and("isreimburseamountctl", "=", (Object)"2");
            }
            listShowParameter.getListFilterParameter().getQFilters().add(qFilterApplierF7);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            if (this.getModel().getValue(MAPPING_QUOTA_ID.get(this.getModel().getValue("quota"))) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ef4\u5ea6\u5bf9\u5e94\u7684\u503c\u3002", (String)"ReimburseQuotaCopyPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("quotaCopyBackId", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u590d\u5236\u65b0\u589e\u7684\u6570\u636e\u5417\uff1f", (String)"ReimburseQuotaCopyPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("quotaCopyBackId".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u590d\u5236\u4e2d", (String)"ReimburseQuotaCopyPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0])), 100);
            this.quotaCopy();
            this.getView().hideLoading();
            IPageCache pageCache = this.getPageCache();
            String successCount = pageCache.get("successCount") == null ? "0" : pageCache.get("successCount");
            String repeatCount = pageCache.get("repeatCount") == null ? "0" : pageCache.get("repeatCount");
            String msg = String.format(ResManager.loadKDString((String)"\u65b0\u589e %1$s \u6761\u6570\u636e\u6210\u529f\uff0c\u68c0\u7d22\u5230 %2$s \u6761\u91cd\u590d\u6570\u636e\u672a\u65b0\u589e\u6210\u529f\u3002", (String)"ReimburseQuotaCopyPlugin_16", (String)"fi-er-formplugin", (Object[])new Object[0]), successCount, repeatCount);
            String copyToYearByExpItemCount = pageCache.get("copyToYearByExpItemCount");
            if (StringUtils.isNotBlank((CharSequence)copyToYearByExpItemCount) && Integer.parseInt(copyToYearByExpItemCount) > 0) {
                String copyToYearByExpItemMsg = String.format(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u8d39\u7528\u9879\u76ee\u63a7\u5236\u7b56\u7565\u7684\u6570\u636e %s \u6761\u672a\u65b0\u589e\u6210\u529f\u3002", (String)"ReimburseQuotaCopyPlugin_15", (String)"fi-er-formplugin", (Object[])new Object[0]), copyToYearByExpItemCount);
                msg = msg + copyToYearByExpItemMsg;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("quotaCopySuccessBackId", (IFormPlugin)this);
            this.getView().showMessage(msg, MessageTypes.ComingSoon, confirmCallBackListener);
        }
        if ("quotaCopySuccessBackId".equals(messageBoxClosedEvent.getCallBackId())) {
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initQuota();
        this.setRemiQuota("year");
    }

    private void initQuota() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("quota");
        Map<String, Object> formParams = this.getFormParams();
        if (formParams == null) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e74\u5ea6", (String)"ReimburseQuotaCopyPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0])), "year"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ReimburseQuotaCopyPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0])), "currency"));
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"ReimburseQuotaCopyPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0])), "expitem"));
        String quotaType = (String)formParams.get("quotaType");
        if ("quotaPersonal".equals(quotaType)) {
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u516c\u53f8", (String)"ReimburseQuotaCopyPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0])), "company"));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u804c\u5458", (String)"ReimburseQuotaCopyPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0])), "employee"));
        }
        if ("quotaDepartmental".equals(quotaType)) {
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u90e8\u95e8", (String)"ReimburseQuotaCopyPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0])), "dept"));
        }
        comboEdit.setComboItems(comboItems);
        ComboEdit comboYearEdit = (ComboEdit)this.getControl(MAPPING_QUOTA_ID.get("year"));
        ArrayList<ComboItem> comboYearItems = new ArrayList<ComboItem>(16);
        int year = LocalDate.now().minusYears(3L).getYear();
        for (int i = 0; i <= 10; ++i) {
            String strYear = ResManager.loadKDString((String)"%s\u5e74", (String)"ReimburseQuotaCopyPlugin_12", (String)"fi-er-formplugin", (Object[])new Object[0]);
            LocaleString localYear = new LocaleString(String.format(strYear, year));
            comboYearItems.add(new ComboItem(localYear, year + ""));
            ++year;
        }
        comboYearEdit.setComboItems(comboYearItems);
        this.getModel().setValue("expenseitemuseorg", formParams.get("costcompany"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("quota".equals(name)) {
            this.setRemiQuota((String)changeSet[0].getNewValue());
        }
    }

    public void setRemiQuota(String quota) {
        for (String id : MAPPING_QUOTA_ID.values()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{id});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{MAPPING_QUOTA_ID.get(quota)});
    }

    private void quotaCopy() {
        List<DynamicObject> quotaDataList = this.validAndGetQuotaData();
        if (!CollectionUtils.isEmpty(quotaDataList)) {
            this.saveQuotaData(quotaDataList);
        }
    }

    private Map<String, Object> getFormParams() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5217\u8868\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"ReimburseQuotaCopyPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return null;
        }
        return customParams;
    }

    private List<DynamicObject> validAndGetQuotaData() {
        String quota = (String)this.getModel().getValue("quota");
        Object quotaValue = this.getModel().getValue(MAPPING_QUOTA_ID.get(quota));
        Map<String, Object> customParams = this.getFormParams();
        if (customParams == null) {
            return new ArrayList<DynamicObject>(0);
        }
        JSONArray selectIds = (JSONArray)customParams.get("selectIds");
        if (selectIds.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        String billFormId = (String)customParams.get("billFormId");
        String quotaType = (String)customParams.get("quotaType");
        QFilter qFilter = new QFilter("id", "in", (Object)selectIds);
        Map reimburseQuotaArray = BusinessDataServiceHelper.loadFromCache((String)billFormId, (String)"costcompany,company,dept,employee,expenseitem,expenseitem.reimburseamountctlmethod,currency,dateyear,totalamount,quarter1,quarter2,quarter3,quarter4,month1,month2, month3, month4, month5, month6, month7, month8, month9, month10, month11, month12, amounttype,auditstatus,createtime,modifytime,creator,modifier", (QFilter[])new QFilter[]{qFilter});
        List<DynamicObject> reimburseQuotaList = reimburseQuotaArray.values().stream().collect(Collectors.toList());
        this.validateExpenseItem(quota, quotaValue, reimburseQuotaList);
        List<DynamicObject> reimburseQuotas = this.filterCheckbox(quotaType, reimburseQuotaList);
        List<DynamicObject> quotaDataList = this.removeRepeat(quota, quotaValue, billFormId, quotaType, reimburseQuotas);
        return quotaDataList;
    }

    private void validateExpenseItem(String quota, Object quotaValue, List<DynamicObject> reimburseQuotaList) {
        Long company;
        Long costcompany;
        if ("company".equals(quota) && (costcompany = CoreBaseBillServiceHelper.getAccountOrgId((Long)(company = (Long)((DynamicObject)quotaValue).getPkValue()), (Boolean)true)) != null) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)costcompany);
            Set expenseItemNumbers = reimburseQuotaList.stream().map(v -> v.getDynamicObject("expenseitem") != null ? v.getDynamicObject("expenseitem").getString("number") : null).collect(Collectors.toSet());
            for (String expenseItemNumber : expenseItemNumbers) {
                if (QueryServiceHelper.exists((String)"er_expenseitemedit", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)expenseItemNumber), baseDataFilter})) continue;
                this.getView().hideLoading();
                throw new KDBizException(ResManager.loadKDString((String)"\u5f85\u590d\u5236\u989d\u5ea6\u7684\u8d39\u7528\u9879\u76ee\uff0c\u5728\u76ee\u6807\u516c\u53f8\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReimburseQuotaCopyPlugin_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<DynamicObject> filterCheckbox(String quotaType, List<DynamicObject> reimburseQuotaList) {
        DynamicObject expenseItem;
        String quota = (String)this.getModel().getValue("quota");
        Object quotaValue = this.getModel().getValue(MAPPING_QUOTA_ID.get(quota));
        Boolean disabledPerson = (Boolean)this.getModel().getValue("disabledperson");
        List<Object> disabledEmployeeIds = new ArrayList();
        if ("quotaPersonal".equals(quotaType) && !disabledPerson.booleanValue()) {
            disabledEmployeeIds = this.getDisabledEmployeeIds(reimburseQuotaList);
        }
        Boolean disabledOrg = (Boolean)this.getModel().getValue("disabledorg");
        List<Object> disabledOrgIds = new ArrayList(16);
        if (!disabledOrg.booleanValue()) {
            disabledOrgIds = this.getDisabledOrgIds(reimburseQuotaList);
        }
        Boolean lastMonthNodata = (Boolean)this.getModel().getValue("lastmonthnodata");
        boolean isCopyToYearByExpItem = false;
        String expItemCtl = "";
        if ("expitem".equals(quota) && "C".equals(expItemCtl = (expenseItem = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)quotaValue).getPkValue(), (String)"er_expenseitemedit")).getString("reimburseamountctlmethod"))) {
            isCopyToYearByExpItem = true;
        }
        ArrayList<DynamicObject> reimburseQuotas = new ArrayList<DynamicObject>(reimburseQuotaList.size());
        int disabledPersonCount = 0;
        int disabledOrgCount = 0;
        int copyToYearByExpItemCount = 0;
        for (DynamicObject reimburseQuota : reimburseQuotaList) {
            boolean includeDisabledOrg;
            String expItemControlMethod = reimburseQuota.getString("expenseitem.reimburseamountctlmethod");
            if ("C".equals(expItemControlMethod)) {
                if ("expitem".equals(quota) && !isCopyToYearByExpItem) {
                    ++copyToYearByExpItemCount;
                    continue;
                }
            } else {
                BigDecimal lastMoney = BigDecimal.ZERO;
                if ("E".equals(expItemControlMethod)) {
                    lastMoney = reimburseQuota.getBigDecimal("quarter4");
                }
                if ("A".equals(expItemControlMethod) || "B".equals(expItemControlMethod)) {
                    lastMoney = reimburseQuota.getBigDecimal("month12");
                }
                if (!lastMonthNodata.booleanValue() && BigDecimal.ZERO.compareTo(lastMoney) >= 0) continue;
            }
            if ("expitem".equals(quota)) {
                boolean a;
                if (("A".equals(expItemControlMethod) || "B".equals(expItemControlMethod)) && !(a = "A".equals(expItemCtl) || "B".equals(expItemCtl) || "C".equals(expItemCtl)) || "E".equals(expItemControlMethod) && !(a = "E".equals(expItemCtl) || "C".equals(expItemCtl))) continue;
                if (isCopyToYearByExpItem) {
                    for (int i = 1; i <= 12; ++i) {
                        reimburseQuota.set("month" + i, (Object)BigDecimal.ZERO);
                        if (i > 4) continue;
                        reimburseQuota.set("quarter" + i, (Object)BigDecimal.ZERO);
                    }
                }
            }
            if ("quotaPersonal".equals(quotaType)) {
                Long employeeId = (Long)reimburseQuota.get("employee.id");
                if (!disabledPerson.booleanValue() && !disabledEmployeeIds.isEmpty() && disabledEmployeeIds.contains(employeeId)) {
                    ++disabledPersonCount;
                    continue;
                }
            }
            Long companyId = (Long)reimburseQuota.get("company.id");
            Long deptId = (Long)reimburseQuota.get("dept.id");
            boolean bl = includeDisabledOrg = disabledOrgIds.contains(companyId) || disabledOrgIds.contains(deptId);
            if (!disabledOrg.booleanValue() && !disabledOrgIds.isEmpty() && includeDisabledOrg) {
                ++disabledOrgCount;
                continue;
            }
            reimburseQuotas.add(reimburseQuota);
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.put("disabledPersonCount", disabledPersonCount + "");
        pageCache.put("disabledOrgCount", disabledOrgCount + "");
        pageCache.put("copyToYearByExpItemCount", copyToYearByExpItemCount + "");
        return reimburseQuotas;
    }

    private List<DynamicObject> removeRepeat(String quota, Object quotaValue, String billFormId, String quotaType, List<DynamicObject> reimburseQuotas) {
        ArrayList<DynamicObject> QuotaDataList = new ArrayList<DynamicObject>(reimburseQuotas.size());
        int repeatCount = 0;
        if (reimburseQuotas.size() > 1) {
            List reimburseQuotaList = reimburseQuotas.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(o -> this.getRepeatItems(quota, quotaType, (DynamicObject)o)))), ArrayList::new));
            repeatCount = reimburseQuotas.size() - reimburseQuotaList.size();
            reimburseQuotas = reimburseQuotaList;
        }
        for (DynamicObject reimburse : reimburseQuotas) {
            QFilter[] repeatFilters = this.getRepeatFilters(quotaType, reimburse, quota, quotaValue);
            DynamicObject repeatQuota = BusinessDataServiceHelper.loadSingleFromCache((String)billFormId, (QFilter[])repeatFilters);
            if (repeatQuota != null) {
                ++repeatCount;
                continue;
            }
            QuotaDataList.add(reimburse);
        }
        this.getPageCache().put("repeatCount", repeatCount + "");
        return QuotaDataList;
    }

    private String getRepeatItems(String quota, String quotaType, DynamicObject quotaData) {
        String repeatAttr = "";
        if ("quotaPersonal".equals(quotaType)) {
            repeatAttr = MAPPING_REPEAT_ATTRIBUTE_P.get(quota);
        }
        if ("quotaDepartmental".equals(quotaType)) {
            repeatAttr = MAPPING_REPEAT_ATTRIBUTE_D.get(quota);
        }
        String[] split = repeatAttr.split(",");
        StringBuilder quotaAttr = new StringBuilder();
        for (String attr : split) {
            quotaAttr.append(quotaData.getString(attr)).append('#');
        }
        return quotaAttr.toString();
    }

    private void saveQuotaData(List<DynamicObject> quotaDataList) {
        String quota = (String)this.getModel().getValue("quota");
        Object quotaValue = this.getModel().getValue(MAPPING_QUOTA_ID.get(quota));
        Date now = new Date();
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String quotaType = "quotaPersonal";
        Map<String, Object> formParams = this.getFormParams();
        if (!formParams.isEmpty()) {
            quotaType = (String)formParams.get("quotaType");
        }
        ArrayList<DynamicObject> remiQuotas = new ArrayList<DynamicObject>(quotaDataList.size());
        for (DynamicObject reimburseQuota : quotaDataList) {
            DynamicObject remiQuota = BusinessDataServiceHelper.newDynamicObject((String)((String)formParams.get("billFormId")));
            remiQuota.set("company", reimburseQuota.get("company.id"));
            remiQuota.set("expenseitem", reimburseQuota.get("expenseitem.id"));
            remiQuota.set("currency", reimburseQuota.get("currency.id"));
            remiQuota.set("dateyear", reimburseQuota.get("dateyear"));
            remiQuota.set("totalamount", reimburseQuota.get("totalamount"));
            remiQuota.set("costcompany", reimburseQuota.get("costcompany"));
            for (int i = 1; i <= 12; ++i) {
                remiQuota.set("month" + i, reimburseQuota.get("month" + i));
                if (i > 4) continue;
                remiQuota.set("quarter" + i, reimburseQuota.get("quarter" + i));
            }
            if ("quotaPersonal".equals(quotaType)) {
                remiQuota.set("amounttype", (Object)"1");
                remiQuota.set("employee", reimburseQuota.get("employee.id"));
                remiQuota.set("dept", reimburseQuota.get("dept.id"));
                if ("company".equals(quota)) {
                    remiQuota.set("dept", ((DynamicObject)quotaValue).getPkValue());
                }
            }
            if ("quotaDepartmental".equals(quotaType)) {
                Map companyByOrg;
                remiQuota.set("amounttype", (Object)"2");
                remiQuota.set("dept", reimburseQuota.get("dept.id"));
                if ("dept".equals(quota) && (companyByOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)((Long)((DynamicObject)quotaValue).getPkValue()))) != null) {
                    remiQuota.set("company", companyByOrg.get("id"));
                }
            }
            remiQuota.set(MAPPING_QUOTA_COLUMN.get(quota), quotaValue);
            remiQuota.set("auditstatus", (Object)"0");
            remiQuota.set("createtime", (Object)now);
            remiQuota.set("modifytime", (Object)now);
            remiQuota.set("creator", (Object)currentUserId);
            remiQuota.set("modifier", (Object)currentUserId);
            remiQuota.set("wbsrcbilltype", (Object)"er_reimctl_new");
            remiQuotas.add(remiQuota);
        }
        if (!CollectionUtils.isEmpty(remiQuotas)) {
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])remiQuotas.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.getView().hideLoading();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u989d\u5ea6\u590d\u5236\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReimburseQuotaCopyPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getPageCache().put("successCount", remiQuotas.size() + "");
    }

    private QFilter[] getRepeatFilters(String quotaType, DynamicObject reimburse, String quota, Object quotaValue) {
        QFilter qFilter = null;
        QFilter companyFilter = new QFilter("company", "=", reimburse.get("company.id"));
        QFilter deptFilter = new QFilter("dept", "=", reimburse.get("dept.id"));
        QFilter employeeFilter = new QFilter("employee", "=", reimburse.get("employee.id"));
        QFilter expenseItemFilter = new QFilter("expenseitem", "=", reimburse.get("expenseitem.id"));
        QFilter currencyFilter = new QFilter("currency", "=", reimburse.get("currency.id"));
        QFilter yearFilter = new QFilter("dateyear", "=", reimburse.get("dateyear"));
        if ("year".equals(quota)) {
            yearFilter = new QFilter("dateyear", "=", quotaValue);
            qFilter = yearFilter.and(expenseItemFilter).and(currencyFilter);
            if ("quotaPersonal".equals(quotaType)) {
                qFilter = qFilter.and(companyFilter).and(employeeFilter);
            }
            if ("quotaDepartmental".equals(quotaType)) {
                qFilter = qFilter.and(deptFilter);
            }
        }
        if ("currency".equals(quota)) {
            currencyFilter = new QFilter("currency", "=", ((DynamicObject)quotaValue).getPkValue());
            qFilter = currencyFilter.and(expenseItemFilter).and(yearFilter);
            if ("quotaPersonal".equals(quotaType)) {
                qFilter = qFilter.and(companyFilter).and(employeeFilter);
            }
            if ("quotaDepartmental".equals(quotaType)) {
                qFilter = qFilter.and(deptFilter);
            }
        }
        if ("expitem".equals(quota)) {
            expenseItemFilter = new QFilter("expenseitem", "=", ((DynamicObject)quotaValue).getPkValue());
            qFilter = expenseItemFilter.and(currencyFilter).and(yearFilter);
            if ("quotaPersonal".equals(quotaType)) {
                qFilter = qFilter.and(companyFilter).and(employeeFilter);
            }
            if ("quotaDepartmental".equals(quotaType)) {
                qFilter = qFilter.and(deptFilter);
            }
        }
        if ("employee".equals(quota)) {
            employeeFilter = new QFilter("employee", "=", ((DynamicObject)quotaValue).getPkValue());
            qFilter = employeeFilter.and(yearFilter).and(currencyFilter).and(companyFilter).and(expenseItemFilter);
        }
        if ("company".equals(quota)) {
            companyFilter = new QFilter("company", "=", ((DynamicObject)quotaValue).getPkValue());
            qFilter = companyFilter.and(currencyFilter).and(yearFilter).and(expenseItemFilter).and(employeeFilter);
        }
        if ("dept".equals(quota)) {
            deptFilter = new QFilter("dept", "=", ((DynamicObject)quotaValue).getPkValue());
            qFilter = deptFilter.and(currencyFilter).and(yearFilter).and(expenseItemFilter);
        }
        return new QFilter[]{qFilter};
    }

    private List<Long> getDisabledEmployeeIds(List<DynamicObject> reimburseQuotaList) {
        ArrayList<Long> invalidEmployeeIds = new ArrayList<Long>(reimburseQuotaList.size());
        Set employees = reimburseQuotaList.stream().map(e -> (Long)e.get("employee.id")).collect(Collectors.toSet());
        if (employees.isEmpty()) {
            return invalidEmployeeIds;
        }
        List userList = UserServiceHelper.get(new ArrayList(employees));
        if (!userList.isEmpty()) {
            for (Map user : userList) {
                if (!"0".equals(user.get("enable"))) continue;
                invalidEmployeeIds.add((Long)user.get("id"));
            }
        }
        return invalidEmployeeIds;
    }

    private List<Long> getDisabledOrgIds(List<DynamicObject> reimburseQuotaList) {
        ArrayList<Long> disabledOrgIds = new ArrayList<Long>(reimburseQuotaList.size());
        Set companyIds = reimburseQuotaList.stream().map(e -> (Long)e.get("company.id")).collect(Collectors.toSet());
        Set deptIds = reimburseQuotaList.stream().map(e -> (Long)e.get("dept.id")).collect(Collectors.toSet());
        HashSet orgIds = new HashSet(reimburseQuotaList.size());
        if (!CollectionUtils.isEmpty(companyIds)) {
            orgIds.addAll(companyIds);
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            orgIds.addAll(deptIds);
        }
        for (Long orgId : orgIds) {
            QFilter idFilter = new QFilter("org", "=", (Object)orgId);
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"id,enable,isfreeze", (QFilter[])filters);
            if (org == null) continue;
            String enable = (String)org.get("enable");
            Boolean isfreeze = (Boolean)org.get("isfreeze");
            if (!"0".equals(enable) && !Boolean.TRUE.equals(isfreeze)) continue;
            disabledOrgIds.add(orgId);
        }
        return disabledOrgIds;
    }

    static {
        MAPPING_QUOTA_ID.put("year", "year");
        MAPPING_QUOTA_ID.put("currency", "currency");
        MAPPING_QUOTA_ID.put("expitem", "expitem");
        MAPPING_QUOTA_ID.put("company", "company");
        MAPPING_QUOTA_ID.put("dept", "dept");
        MAPPING_QUOTA_ID.put("employee", "employee");
        MAPPING_QUOTA_COLUMN.put("year", "dateyear");
        MAPPING_QUOTA_COLUMN.put("currency", "currency");
        MAPPING_QUOTA_COLUMN.put("expitem", "expenseitem");
        MAPPING_QUOTA_COLUMN.put("company", "company");
        MAPPING_QUOTA_COLUMN.put("dept", "dept");
        MAPPING_QUOTA_COLUMN.put("employee", "employee");
        MAPPING_REPEAT_ATTRIBUTE_P.put("year", "currency.id,expenseitem.id,company.id,employee.id");
        MAPPING_REPEAT_ATTRIBUTE_P.put("currency", "dateyear,expenseitem.id,company.id,employee.id,");
        MAPPING_REPEAT_ATTRIBUTE_P.put("expitem", "dateyear,currency.id,company.id,employee.id");
        MAPPING_REPEAT_ATTRIBUTE_P.put("company", "dateyear,currency.id,expenseitem.id,employee.id");
        MAPPING_REPEAT_ATTRIBUTE_P.put("employee", "dateyear,currency.id,expenseitem.id,company.id");
        MAPPING_REPEAT_ATTRIBUTE_D.put("year", "currency.id,expenseitem.id,dept.id");
        MAPPING_REPEAT_ATTRIBUTE_D.put("currency", "dateyear,expenseitem.id,dept.id");
        MAPPING_REPEAT_ATTRIBUTE_D.put("expitem", "dateyear,currency.id,dept.id");
        MAPPING_REPEAT_ATTRIBUTE_D.put("dept", "dateyear,currency.id,expenseitem.id,");
    }
}

