/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.servicehelper.ListConstructorHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.PayerTypeEnum;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPublicRBSReceivePlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static String[] payerTypeArray = new String[]{PayerTypeEnum.PAYER.getType(), PayerTypeEnum.CASORG.getType(), PayerTypeEnum.CUSTOMER.getType(), PayerTypeEnum.SUPPLIER.getType()};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit payerName = (TextEdit)this.getControl("payername");
        TextEdit payerAccount = (TextEdit)this.getControl("payeraccount");
        payerName.addButtonClickListener((ClickListener)this);
        payerAccount.addButtonClickListener((ClickListener)this);
    }

    protected String getPayerType() {
        EntryGrid entry = (EntryGrid)this.getControl("accountentry");
        int rowIndex = entry.getEntryState().getFocusRow();
        return (String)this.getModel().getValue("payertype", rowIndex);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        Object newValue = changeData.getNewValue();
        IFormView view = this.getView();
        switch (fieldKey) {
            case "supplier": 
            case "customer": 
            case "casorg": 
            case "payer": {
                this.setAccountInfoByPayer(fieldKey, rowIndex);
                break;
            }
            case "payertype": {
                PublicReimbursePayerAcctUtils.clearOldPayer((IFormView)view, (Integer)rowIndex, (String)((String)newValue));
                break;
            }
            case "payername": {
                String payerName = (String)newValue;
                this.payerNameChangeAction(payerName, rowIndex);
                break;
            }
            case "payeraccount": {
                String payeraccount = (String)newValue;
                if (payeraccount == null) break;
                model.setValue("payeraccount", (Object)payeraccount.replaceAll("\\s", ""), rowIndex);
                break;
            }
            case "paymode": {
                if (newValue == null) {
                    return;
                }
                String settlementtype = ((DynamicObject)newValue).getString("settlementtype");
                if (!"0".equals(settlementtype)) break;
                PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)model, (String)"payeraccount02", null, (int)rowIndex);
                PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)model, (String)"payeraccount01", null, (int)rowIndex);
                PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)model, (String)"payeraccount", null, (int)rowIndex);
                PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)model, (String)"payerbank", null, (int)rowIndex);
                PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)model, (String)"payeraccountname", null, (int)rowIndex);
            }
        }
    }

    public String getFieldNameByPayerType(String payerType) {
        if (StringUtils.equalsIgnoreCase((CharSequence)PayerTypeEnum.SUPPLIER.getType(), (CharSequence)payerType)) {
            return "supplier";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)PayerTypeEnum.CUSTOMER.getType(), (CharSequence)payerType)) {
            return "customer";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)PayerTypeEnum.CASORG.getType(), (CharSequence)payerType)) {
            return "casorg";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)PayerTypeEnum.PAYER.getType(), (CharSequence)payerType)) {
            return "payer";
        }
        return "";
    }

    private void payerNameChangeAction(String payerName, int rowIndex) {
        IDataModel thisModel = this.getModel();
        Object payerType = PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)thisModel, (String)"payertype", (int)rowIndex);
        if (payerType == null) {
            return;
        }
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerType.toString());
        if (payerTypeEnum != null) {
            DynamicObject payer = null;
            switch (payerTypeEnum) {
                case SUPPLIER: {
                    payer = (DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)thisModel, (String)"supplier", (int)rowIndex);
                    break;
                }
                case CUSTOMER: {
                    payer = (DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)thisModel, (String)"customer", (int)rowIndex);
                    break;
                }
                case CASORG: {
                    payer = (DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)thisModel, (String)"casorg", (int)rowIndex);
                    break;
                }
                case PAYER: {
                    payer = (DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)thisModel, (String)"payer", (int)rowIndex);
                    break;
                }
                case OTHER: {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payeraccountname", (Object)payerName, (int)rowIndex);
                    PayeeServiceHelper.clearLimitInfo((IDataModel)this.getModel());
                    return;
                }
            }
            boolean isOther = false;
            DynamicObject payMode = (DynamicObject)thisModel.getValue("paymode", rowIndex);
            String settlementtype = null;
            if (payMode != null) {
                settlementtype = payMode.getString("settlementtype");
            }
            if (payer == null && !payerTypeEnum.getType().equals(PayerTypeEnum.OTHER.getType())) {
                isOther = true;
            }
            if (payer != null) {
                String payerStr;
                if (payerTypeEnum == PayerTypeEnum.PAYER) {
                    payerStr = payer.getString("outpayer");
                    if (settlementtype == null || !"0".equals(settlementtype)) {
                        PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payeraccountname", (Object)payer.get("payeraccountname"), (int)rowIndex);
                    }
                } else {
                    String string = payerStr = payer.getLocaleString("name") == null ? null : payer.getLocaleString("name").getLocaleValue();
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trim((String)payerStr), (CharSequence)StringUtils.trim((String)payerName))) {
                    isOther = true;
                }
            }
            if (isOther) {
                if (!StringUtils.isEmpty((CharSequence)payerName)) {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payertype", (Object)PayerTypeEnum.OTHER.getType(), (int)rowIndex);
                    if (settlementtype == null || !"0".equals(settlementtype)) {
                        PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payeraccountname", (Object)payerName, (int)rowIndex);
                    }
                }
                thisModel.beginInit();
                IDataEntityProperty property = thisModel.getProperty("supplier");
                if (property != null) {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"supplier", null, (int)rowIndex);
                }
                if ((property = thisModel.getProperty("customer")) != null) {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"customer", null, (int)rowIndex);
                }
                if ((property = thisModel.getProperty("casorg")) != null) {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"casorg", null, (int)rowIndex);
                }
                if ((property = thisModel.getProperty("payeraccount")) != null) {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payeraccount", null, (int)rowIndex);
                }
                if ((property = thisModel.getProperty("payeraccountname")) != null) {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payeraccountname", null, (int)rowIndex);
                }
                if ((property = thisModel.getProperty("payerbank")) != null) {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payerbank", null, (int)rowIndex);
                }
                PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payer", null, (int)rowIndex);
                thisModel.endInit();
                this.getView().updateView();
            }
            if (thisModel.getEntryEntity("accountentry") != null) {
                ((DynamicObject)thisModel.getEntryEntity("accountentry").get(rowIndex)).beginInit();
                PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payername", (Object)StringUtils.abbreviate((String)payerName, (int)100), (int)rowIndex);
                ((DynamicObject)thisModel.getEntryEntity("accountentry").get(rowIndex)).endInit();
                this.getView().updateView("payername", rowIndex);
            } else {
                thisModel.beginInit();
                PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thisModel, (String)"payername", (Object)StringUtils.abbreviate((String)payerName, (int)100), (int)rowIndex);
                thisModel.endInit();
            }
        }
    }

    public void click(EventObject evt) {
        String keyName;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (keyName = control.getKey()) {
            case "payername": {
                this.selectPayer();
                break;
            }
            case "payeraccount": {
                this.selectAccountByPayer();
            }
        }
    }

    private void selectPayer() {
        String payerType = this.getPayerType();
        if (StringUtils.isBlank((CharSequence)payerType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"AbstractPublicRBSReceivePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerType);
        if (payerTypeEnum != null) {
            BasedataEdit basedataEdit = null;
            switch (payerTypeEnum) {
                case SUPPLIER: {
                    basedataEdit = (BasedataEdit)this.getControl("supplier");
                    break;
                }
                case CUSTOMER: {
                    basedataEdit = (BasedataEdit)this.getControl("customer");
                    break;
                }
                case CASORG: {
                    basedataEdit = (BasedataEdit)this.getControl("casorg");
                    break;
                }
                case PAYER: {
                    basedataEdit = (BasedataEdit)this.getControl("payer");
                    basedataEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                        String isgetaccountcurrency = "0";
                        if (this.getModel().getValue("company") != null) {
                            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
                        }
                        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                        if ("1".equals(isgetaccountcurrency)) {
                            int i = 0;
                            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("currency", "!=", (Object)i));
                        }
                    });
                    break;
                }
                case OTHER: {
                    return;
                }
            }
            if (basedataEdit != null) {
                basedataEdit.click();
            }
        }
    }

    private void selectAccountByPayer() {
        String payerType = this.getPayerType();
        if (StringUtils.isBlank((CharSequence)payerType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"AbstractPublicRBSReceivePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerType);
        if (payerTypeEnum != null) {
            DynamicObject payer = null;
            switch (payerTypeEnum) {
                case SUPPLIER: {
                    payer = (DynamicObject)this.getModel().getValue("supplier");
                    break;
                }
                case CUSTOMER: {
                    payer = (DynamicObject)this.getModel().getValue("customer");
                    break;
                }
                case CASORG: {
                    payer = (DynamicObject)this.getModel().getValue("casorg");
                    break;
                }
                case PAYER: 
                case OTHER: {
                    return;
                }
            }
            if (payer == null && payerTypeEnum != PayerTypeEnum.PAYER) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"AbstractPublicRBSReceivePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (payer != null) {
                this.showBankInfo(payerType, (Long)payer.getPkValue());
            }
        }
    }

    protected void setAccountInfoByPayer(String payerKindName, Integer rowIndex) {
        IDataModel thismodel = this.getModel();
        String payerType = null;
        switch (payerKindName) {
            case "supplier": {
                payerType = PayerTypeEnum.SUPPLIER.getType();
                break;
            }
            case "customer": {
                payerType = PayerTypeEnum.CUSTOMER.getType();
                break;
            }
            case "casorg": {
                payerType = PayerTypeEnum.CASORG.getType();
                break;
            }
            case "payer": {
                payerType = PayerTypeEnum.PAYER.getType();
            }
        }
        if (payerType == null) {
            Object[] objectArray = new Object[1];
            rowIndex = rowIndex + 1;
            objectArray[0] = rowIndex;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u6536\u6b3e\u4eba\u7c7b\u578b\u4e3a\u7a7a", (String)"AbstractPublicRBSReceivePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), objectArray));
            return;
        }
        IPageCache thisPageCache = this.getPageCache();
        thisPageCache.put("payertype", payerType);
        thismodel.beginInit();
        PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)thismodel, (String)"payertype", (Object)payerType, (int)rowIndex);
        PublicReimbursePayerAcctUtils.updateViewDIY((IFormView)this.getView(), (String)"payertype", (int)rowIndex);
        this.clearOtherPayer(payerType, rowIndex);
        thismodel.endInit();
        if (payerKindName.equalsIgnoreCase("payer")) {
            return;
        }
        DynamicObject payer = (DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)thismodel, (String)payerKindName, (int)rowIndex);
        if (payer == null) {
            PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)this.getModel(), (String)"payername", null, (int)rowIndex);
            return;
        }
        Object payerId = payer.getPkValue();
        String payerName = ((DynamicObject)PublicReimbursePayerAcctUtils.getValueDIY((IDataModel)thismodel, (String)payerKindName, (int)rowIndex)).getLocaleString("name").getLocaleValue();
        if (payerId == null) {
            PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)this.getModel(), (String)"payername", null, (int)rowIndex);
            return;
        }
        if (StringUtils.isBlank((CharSequence)payerName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u8be5\u6536\u6b3e\u4eba\u4fe1\u606f\u662f\u5426\u6b63\u786e\u7ef4\u62a4\u3002", (String)"AbstractPublicRBSReceivePlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            payerName = null;
        }
        PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)this.getModel(), (String)"payername", (Object)payerName, (int)rowIndex);
        AccountInfo accountInfo = PublicReimbursePayerAcctUtils.getPayerDefaultInfo((String)payerType, (Long)((Long)payerId));
        PublicReimbursePayerAcctUtils.fillBankInfo((IDataModel)thismodel, (AccountInfo)accountInfo, (Integer)rowIndex);
    }

    private void showBankInfo(String payerEntityType, Long payerId) {
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerEntityType);
        ListShowParameter lsp = null;
        switch (payerTypeEnum) {
            case SUPPLIER: {
                lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)payerId);
                break;
            }
            case CUSTOMER: {
                lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)payerId);
                break;
            }
            case CASORG: {
                lsp = ListConstructorHelper.getCasOrgBankInfoShowParameter((Object)payerId);
            }
        }
        Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.receiveBankInfoF7", "receiveBankInfoF7", new Object[]{payerEntityType, payerId, this.getModel()}, new Class[]{String.class, Long.class, BillModel.class});
        if (invokeExtService != null && !"-1".equals(invokeExtService)) {
            lsp = (ListShowParameter)invokeExtService;
        }
        if (lsp != null) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("payeeaccountbank".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            EntryGrid entry = (EntryGrid)this.getControl("accountentry");
            int rowIndex = entry != null ? entry.getEntryState().getFocusRow() : -1;
            String payerType = this.getPayerType();
            Object entryKey = PayerTypeEnum.CASORG.getType().equals(payerType) ? rowInfo.getPrimaryKeyValues()[0] : rowInfo.getEntryPrimaryKeyValues()[0];
            AccountInfo accountInfo = PublicReimbursePayerAcctUtils.getBankInfo((String)payerType, (long)((Long)entryKey));
            PublicReimbursePayerAcctUtils.fillBankInfo((IDataModel)this.getModel(), (AccountInfo)accountInfo, (Integer)rowIndex);
            ErExpandServiceFacade.get().invokeExtService("ext.service.er.fillbankInfoPC", "fillbankInfoPC", new Object[]{payerType, (Long)entryKey, this.getModel(), rowIndex}, new Class[]{String.class, Long.class, IDataModel.class, Integer.class});
        }
    }

    private void clearOtherPayer(String payerType, int rowIndex) {
        ArrayList<String> payerTypeList = new ArrayList<String>();
        for (String payerTypeTemp : payerTypeArray) {
            if (StringUtils.equalsIgnoreCase((CharSequence)payerType, (CharSequence)payerTypeTemp)) continue;
            payerTypeList.add(payerTypeTemp);
        }
        for (String payerTypeTemp : payerTypeList) {
            PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerTypeTemp);
            IDataEntityProperty property = null;
            switch (payerTypeEnum) {
                case SUPPLIER: {
                    property = this.getModel().getProperty("supplier");
                    if (property == null) break;
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)this.getModel(), (String)"supplier", null, (int)rowIndex);
                    break;
                }
                case CUSTOMER: {
                    property = this.getModel().getProperty("customer");
                    if (property == null) break;
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)this.getModel(), (String)"customer", null, (int)rowIndex);
                    break;
                }
                case CASORG: {
                    property = this.getModel().getProperty("casorg");
                    if (property == null) break;
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)this.getModel(), (String)"casorg", null, (int)rowIndex);
                    break;
                }
                case PAYER: {
                    PublicReimbursePayerAcctUtils.setValueDIY((IDataModel)this.getModel(), (String)"payer", null, (int)rowIndex);
                    break;
                }
                case OTHER: {
                    return;
                }
            }
        }
    }
}

