/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.apply;

import java.math.BigDecimal;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.daily.web.AbstractExpenseBaseBillPlugin;

public class ErApplyBaseBillEdit
extends AbstractExpenseBaseBillPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "currexpenseamount": {
                dataModel.setValue("expeapproveamount", dataModel.getValue("expenseamount", rowIndex), rowIndex);
                dataModel.setValue("expeapprovecurramount", newValue, rowIndex);
                break;
            }
            case "expeapprovecurramount": {
                Object approveAmount = dataModel.getValue("expeapproveamount", rowIndex);
                dataModel.setValue("orgiexpebalanceamount", approveAmount, rowIndex);
                dataModel.setValue("expebalanceamount", newValue, rowIndex);
                dataModel.setValue("canloanamount", approveAmount, rowIndex);
                dataModel.setValue("canloancurramount", newValue, rowIndex);
                if (dataModel.getProperty("oriexpcancontractamount") != null && dataModel.getProperty("expcancontractamount") != null) {
                    dataModel.setValue("oriexpcancontractamount", approveAmount, rowIndex);
                    dataModel.setValue("expcancontractamount", newValue, rowIndex);
                }
                this.sumBillAmount(dataModel);
                break;
            }
            case "entrycostcompany": {
                int entryRowCount = dataModel.getEntryRowCount("expenseentryentity");
                if (entryRowCount <= 0 || this.checkExpenseItem(rowIndex)) break;
                dataModel.setValue("expenseitem", null, rowIndex);
            }
        }
    }

    private boolean checkExpenseItem(int rowIndex) {
        IDataEntityProperty expItemDT = (IDataEntityProperty)((EntryProp)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"expenseentryentity")).getDynamicCollectionItemPropertyType().getProperties().get((Object)"expenseitem");
        if (expItemDT == null) {
            return true;
        }
        Long expItemId = ErCommonUtils.getPk((Object)this.getModel().getValue("expenseitem", rowIndex));
        if (expItemId == null) {
            return true;
        }
        return ExpenseItemServiceHelper.checkExpenseItem((IDataModel)this.getModel(), (int)rowIndex, (Long)expItemId);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        switch (entryName) {
            case "expenseentryentity": {
                this.sumBillAmount(dataModel);
            }
        }
    }

    private void sumBillAmount(IDataModel dataModel) {
        String detailtype;
        BigDecimal applyAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"currexpenseamount");
        dataModel.setValue("applyamount", (Object)applyAmount);
        String amountProp = "expeapprovecurramount";
        if (ErEntityTypeUtils.isContractBill((String)dataModel.getDataEntityType().getName())) {
            amountProp = "currexpenseamount";
        }
        BigDecimal approveAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)amountProp);
        dataModel.setValue("approveamount", (Object)approveAmount);
        dataModel.setValue("balanceamount", (Object)approveAmount);
        dataModel.setValue("billcanloanamount", (Object)approveAmount);
        if (dataModel.getProperty("cancontractamount") != null) {
            dataModel.setValue("cancontractamount", (Object)approveAmount);
        }
        if (dataModel.getProperty("invoiceamountremain") != null) {
            dataModel.setValue("invoiceamountremain", (Object)approveAmount);
        }
        if (ErEntityTypeUtils.isApplyProjectBill((String)dataModel.getDataEntityType().getName()) && "biztype_applybill".equals(detailtype = (String)dataModel.getValue("detailtype"))) {
            BigDecimal nonpayamount = (BigDecimal)dataModel.getValue("nonpayamount");
            BigDecimal costimateamount = (BigDecimal)dataModel.getValue("costimateamount");
            BigDecimal contractamount = (BigDecimal)dataModel.getValue("contractamount");
            BigDecimal notpayamount = approveAmount.subtract(contractamount).subtract(costimateamount);
            BigDecimal availableAmount = notpayamount.subtract(nonpayamount);
            dataModel.setValue("notpayamount", (Object)notpayamount);
            dataModel.setValue("availableamount", (Object)availableAmount);
        }
    }
}

