/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.loan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.daily.web.AbstractExpenseBaseBillPlugin;
import kd.fi.er.formplugin.daily.web.util.TempEncashAmountUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ErLoanBaseBillEdit
extends AbstractExpenseBaseBillPlugin {
    private static Log logger = LogFactory.getLog(ErLoanBaseBillEdit.class);
    private static String MODIFYBYCODE = "modifyByCode";
    private static final String deleteExpenseEntry = "deleteExpenseEntry";

    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection expense;
        String status;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        boolean dataChange = model.getDataChanged();
        this.setPayAmountLabel(model);
        String isgetaccountcurrency = "0";
        if (this.getModel().getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        if ("A".equals(status = (String)model.getValue("billstatus")) || "D".equals(status)) {
            int entryRowCount = this.getModel().getEntryRowCount("accountentry");
            if (entryRowCount < 1) {
                CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)model);
                BigDecimal payAmount = (BigDecimal)this.getModel().getValue("loanamount");
                this.getModel().setValue("orireceiveamount", (Object)payAmount, 0);
                this.getModel().setValue("receiveamount", (Object)payAmount, 0);
            }
            if (model.getEntryRowCount("accountentry") == 1 && model.getValue("accountcurrency", 0) == null && "0".equals(isgetaccountcurrency)) {
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                model.setValue("accountcurrency", currency == null ? null : currency.getPkValue(), 0);
            }
        }
        if ((this.getModel().getDataEntity().getDataEntityState().isPushChanged() || Boolean.TRUE.equals((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy"))) && (expense = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity")) != null && expense.size() > 0) {
            BigDecimal approveCurrAmountOld = (BigDecimal)model.getValue("expeapprovecurramount", 0);
            model.beginInit();
            model.setValue("expeapprovecurramount", (Object)0, 0);
            model.endInit();
            model.setValue("expeapprovecurramount", (Object)approveCurrAmountOld, 0);
        }
        if (this.isDownBill() && !ErEntityTypeUtils.isPrePayBill((String)this.getView().getEntityId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"addloancheck1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_copyentry"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_entryimport"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"iscurrency"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"addloancheck1"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_copyentry"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_entryimport"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"iscurrency"});
        }
        if (this.getModel().getValue("repaymentdate") == null && this.isDownBill()) {
            this.refreshRepaymentDate();
        }
        if (!dataChange) {
            model.setDataChanged(dataChange);
        }
    }

    private void refreshRepaymentDate() {
        this.getModel().setValue("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((IDataModel)this.getModel()));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    private void setPayAmountLabel(IDataModel dataModel) {
        Label signLabel = (Label)this.getControl("label_sign");
        BigDecimal payAmount = (BigDecimal)dataModel.getValue("approveamount");
        String currencySign = "";
        int amountPrecition = 4;
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
            payAmount = payAmount.setScale(amountPrecition, RoundingMode.HALF_UP);
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)Long.valueOf(RequestContext.get().getUserId()), (String)currencySign, (int)amountPrecition, (BigDecimal)payAmount);
        Label amountLabel = (Label)this.getControl("totalencashamountlabel");
        this.getPageCache().put("cueerncy_sign", currencySign);
        signLabel.setText("");
        amountLabel.setText(formatMoneyByUser);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel dataModel = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "currexpenseamount": {
                dataModel.setValue("expeapproveamount", dataModel.getValue("expenseamount", rowIndex), rowIndex);
                dataModel.setValue("expeapprovecurramount", propValue, rowIndex);
                break;
            }
            case "entrycurrency": {
                this.refreshExchangeRate(dataModel, (DynamicObject)propValue, "exchangerate", "expquotetype", rowIndex);
                break;
            }
            case "expeapprovecurramount": {
                this.refreshApproveOriAmount(rowIndex);
                this.refreshBillAmount(dataModel);
                this.refreshReceiveAmount(dataModel);
                break;
            }
            case "bizdate": 
            case "company": {
                this.refreshRepaymentDate();
                break;
            }
            case "currency": {
                Object relatedbizType;
                this.refreshBillAmount(dataModel);
                String billtype = dataModel.getDataEntityType().getName();
                if (!ErEntityTypeUtils.isDailyLoanBill((String)billtype) || !"relatedtype_project".equals(relatedbizType = dataModel.getValue("relatedbiz"))) break;
                dataModel.setValue("relatedbiz", (Object)"relatedtype_other");
            }
        }
    }

    private void refreshApproveOriAmount(int rowIndex) {
        IFormView view = this.getView();
        IPageCache pageCache = view.getPageCache();
        String traceId = RequestContext.get().getTraceId();
        String isByCode = traceId + MODIFYBYCODE;
        if ((CommonServiceHelper.isSSC((IFormView)view) || CommonServiceHelper.isSCENE((IFormView)view)) && !isByCode.equals(pageCache.get("isByCode"))) {
            IDataModel dataModel = this.getModel();
            BigDecimal approveAmount = (BigDecimal)dataModel.getValue("expeapprovecurramount", rowIndex);
            BigDecimal exchangeRate = (BigDecimal)dataModel.getValue("exchangerate", rowIndex);
            exchangeRate = exchangeRate == null || exchangeRate.abs().compareTo(BigDecimal.valueOf(1.0E-8)) < 0 ? BigDecimal.ONE : exchangeRate;
            String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue("expquotetype", rowIndex)), (Object)"0");
            DynamicObject entrycurrency = (DynamicObject)dataModel.getValue("entrycurrency", rowIndex);
            BigDecimal approveAmountOri = AmountUtils.getOriAmount((BigDecimal)approveAmount, (BigDecimal)exchangeRate, (int)AmountUtils.getCurrencyPrecision((Object)entrycurrency.getPkValue()), (String)quoteType);
            dataModel.beginInit();
            dataModel.setValue("expeapproveamount", (Object)approveAmountOri, rowIndex);
            dataModel.endInit();
            view.updateView("expeapproveamount", rowIndex);
        }
    }

    private void refreshExchangeRate(IDataModel dataModel, DynamicObject entryCurrency, String exchangeRateProp, String quoteTypeProp, int rowIndex) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        String quoteType = "0";
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        DynamicObject company = (DynamicObject)dataModel.getValue("company");
        DynamicObject costCompany = (DynamicObject)dataModel.getValue("costcompany");
        Map exchangeRateAndQuoteType = null;
        if (entryCurrency != null && currency != null && company != null) {
            Long srcCurrencyId = (Long)entryCurrency.getPkValue();
            Long targetCurrencyId = (Long)currency.getPkValue();
            exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)dataModel);
            exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ZERO);
            quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
        }
        if (StringUtils.isNotEmpty((CharSequence)quoteType)) {
            dataModel.setValue(quoteTypeProp, (Object)quoteType, rowIndex);
        }
        dataModel.setValue(exchangeRateProp, (Object)exchangeRate, rowIndex);
    }

    private void refreshReceiveAmount(IDataModel dataModel) {
        TempEncashAmountUtils.loan_refreshReceiveAmount((IDataModel)dataModel);
    }

    private void refreshBillAmount(IDataModel model) {
        TempEncashAmountUtils.loan_getEncashedAmount((IDataModel)model);
        this.setPayAmountLabel(model);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        switch (entryName) {
            case "expenseentryentity": {
                this.refreshReceiveAmount(dataModel);
                this.refreshBillAmount(dataModel);
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        String name = e.getEntryProp().getName();
        if ("expenseentryentity".equals(name)) {
            this.refreshReceiveAmount(this.getModel());
            this.refreshBillAmount(this.getModel());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object optype = args.getSource();
        if (optype == null) {
            return;
        }
        if (optype instanceof Save || optype instanceof Submit) {
            if (!"G".equals(this.getModel().getValue("billstatus"))) {
                this.refreshBillAmount(this.getModel());
            }
            if (optype instanceof Submit) {
                this.refreshNonPayAmount(this.getModel());
            }
        }
        if (ErEntityTypeUtils.isPrePayBill((String)this.getView().getEntityId())) {
            return;
        }
        if (optype instanceof DeleteEntry) {
            RefObject afterConfirm = new RefObject();
            if (!((DeleteEntry)optype).getOption().tryGetVariableValue(deleteExpenseEntry, afterConfirm) && "expenseentryentity".equals(((DeleteEntry)optype).getParameter().get("entryId")) && this.isDownBill()) {
                if (this.getModel().getEntryRowCount("expenseentryentity") > 1) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8d39\u7528\u7533\u8bf7\u4e0b\u63a8\u7684\u501f\u6b3e\u5355\uff0c\u5220\u9664\u5206\u5f55\u540e\u4e0d\u80fd\u518d\u65b0\u589e\u5206\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u5220\u9664\uff1f", (String)"ErLoanBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(deleteExpenseEntry));
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u7684\u501f\u6b3e\u5355\u6700\u540e\u4e00\u6761\u5206\u5f55\u4e0d\u53ef\u5220\u9664\u3002", (String)"ErLoanBaseBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (deleteExpenseEntry.equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(deleteExpenseEntry, "true");
            this.getView().invokeOperation("deleteexpeentry", operateOption);
        }
    }

    private boolean isDownBill() {
        boolean isDownBill = false;
        DynamicObjectCollection expenseEntryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        int rowCount = expenseEntryColl.size();
        if (rowCount == 0) {
            return false;
        }
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject expenseEntry = (DynamicObject)expenseEntryColl.get(i);
            String sourceBillId = ErEntityTypeUtils.isPrePayBill((String)this.getView().getEntityId()) ? expenseEntry.getString("wbsrcbillid") : expenseEntry.getString("sourcebillid");
            if (sourceBillId.isEmpty() || "0".equals(sourceBillId)) continue;
            isDownBill = true;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"entrycurrency"});
        }
        return isDownBill;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.isDownBill()) {
            BasedataEdit expenseItem = (BasedataEdit)this.getView().getControl("expenseitem");
            expenseItem.setF7MultipleSelect(false);
            BasedataEdit project = (BasedataEdit)this.getView().getControl("std_project");
            project.setF7MultipleSelect(false);
            OrgEdit orgEdit = (OrgEdit)this.getControl("entrycostdept");
            if (orgEdit != null) {
                orgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                    public void beforeF7Select(BeforeF7SelectEvent arg0) {
                        ListShowParameter parameter = (ListShowParameter)arg0.getFormShowParameter();
                        parameter.setMultiSelect(false);
                    }
                });
            }
        }
    }

    private void refreshNonPayAmount(IDataModel dataModel) {
        DynamicObjectCollection expenseList;
        if (ErEntityTypeUtils.isPrePayBill((String)dataModel.getDataEntityType().getName()) && (expenseList = dataModel.getEntryEntity("expenseentryentity")) != null && !expenseList.isEmpty()) {
            for (int i = 0; i < expenseList.size(); ++i) {
                BigDecimal expeapprovecurramount = ((DynamicObject)expenseList.get(i)).getBigDecimal("expeapprovecurramount");
                dataModel.setValue("expnonpayamount", (Object)expeapprovecurramount, i);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        switch (opKey = e.getOperateKey()) {
            case "confirmstopreim": {
                OperationResult opResult = e.getOperationResult();
                if (!opResult.isSuccess()) break;
                this.getView().close();
            }
        }
    }
}

