/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.loan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.model.EntityInfo;
import org.apache.commons.lang3.StringUtils;

public class ErLoanBaseBillList
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_", "bar_unaudit"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        switch (opKey = e.getOperateKey()) {
            case "stopreim": {
                this.doStopReim(e);
                break;
            }
            case "changeinvoice": {
                String entityId = ((ListView)this.getView()).getEntityTypeId();
                if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
                    this.doChangeInvoice(e);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6362\u53d1\u7968\u4ec5\u652f\u6301\u8d39\u7528\u62a5\u9500\u5355\u53ca\u5bf9\u516c\u62a5\u9500\u5355\u3002", (String)"", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private static List<EntityInfo> getLoanEntityInfos(ListSelectedRow row) {
        EntityInfo agent = new EntityInfo.Builder().statusName(new String[]{"A", "B", "C", "E"}).entityName("cas_agentpaybill").entryName("entry").sourceName("sourcebillid").build();
        EntityInfo pay = new EntityInfo.Builder().statusName(new String[]{"A", "B", "C", "E", "J"}).entityName("cas_paybill").entryName("entry").sourceName("e_sourcebillid").build();
        ArrayList<EntityInfo> res = new ArrayList<EntityInfo>(2);
        res.add(agent);
        res.add(pay);
        return res;
    }

    private void doStopReim(AfterDoOperationEventArgs e) {
        ListView view = (ListView)this.getView();
        OperationResult opResult = e.getOperationResult();
        ListSelectedRowCollection rows = this.getSelectedRows();
        Set selectbillIds = rows.stream().map(v -> (Long)v.getPrimaryKeyValue()).collect(Collectors.toSet());
        if (selectbillIds.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\"\u6b62\u4ed8\"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"ErLoanBaseBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        for (ListSelectedRow row : rows) {
            boolean isHsOnWayBills;
            String status = row.getBillStatus();
            if (!status.equals("F") && !status.equals("E")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5ba1\u6838\u901a\u8fc7\u201d\u6216\u201c\u7b49\u5f85\u4ed8\u6b3e\u201d\u7684\u5355\u636e\u624d\u53ef\u6b62\u4ed8\u3002", (String)"ErLoanBaseBillList_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityTypeId()) || ErEntityTypeUtils.isDailyReimburseBill((String)view.getEntityTypeId())) {
                DynamicObject selectedDy = this.getSelectReimburseBill((Long)row.getPrimaryKeyValue());
                if (selectedDy != null && selectedDy.getBoolean("isbeforeshare")) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8d39\u7528\u5206\u644a\u7684\u5355\u636e\u4e0d\u652f\u6301\u6b62\u4ed8\u3002", (String)"ErLoanBaseBillList_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map targetBills = BFTrackerServiceHelper.findTargetBills((String)view.getEntityTypeId(), (Long[])new Long[]{(Long)row.getPrimaryKeyValue()});
                if (targetBills.containsKey("er_expensesharebill") || targetBills.containsKey("ap_finapbill") || targetBills.containsKey("er_withholdingbill")) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u4e0b\u6e38\"\u8d39\u7528\u5206\u644a\u5355\"\u6216\"\u8d22\u52a1\u5e94\u4ed8\u5355\"\u6216\"\u8d39\u7528\u9884\u63d0\u5355\"\uff0c\u4e0d\u5141\u8bb8\u6b62\u4ed8\u3002", (String)"ErLoanBaseBillList_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                EntityInfo applypay = new EntityInfo.Builder().statusName(new String[]{"A", "B", "C", "D", "E", "F"}).entityName("er_applypaybill").entryName("accountentry").sourceName("recsrcbillid").build();
                ArrayList<EntityInfo> res = new ArrayList<EntityInfo>(1);
                res.add(applypay);
                boolean isHasOnWayApplyPayBill = ErCommonUtils.isHasOnWayDownBill((String)view.getEntityTypeId(), (Long)((Long)row.getPrimaryKeyValue()), res);
                if (isHasOnWayApplyPayBill) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u5728\u9014\u4e0b\u6e38\"\u6302\u8d26\u4ed8\u6b3e\u7533\u8bf7\u5355\"\uff0c\u4e0d\u5141\u8bb8\u6b62\u4ed8\u3002", (String)"ErLoanBaseBillList_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (ErEntityTypeUtils.isDailyLoanBill((String)view.getEntityTypeId()) || ErEntityTypeUtils.isPrePayBill((String)view.getEntityTypeId())) {
                Map tBills = BFTrackerServiceHelper.findDirtTargetBills((String)view.getEntityTypeId(), (Long[])new Long[]{(Long)row.getPrimaryKeyValue()});
                HashSet directTargetBillIds = new HashSet(8);
                tBills.values().stream().filter(v -> !v.isEmpty()).forEach(v -> v.stream().filter(u -> u != null && u.getId() != null).forEach(r -> directTargetBillIds.add(r.getId().getBillId())));
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"er_withholdingbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", directTargetBillIds)});
                if (dynamicObjects != null && dynamicObjects.size() > 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u4e0b\u6e38\"\u8d39\u7528\u9884\u63d0\u5355\"\uff0c\u4e0d\u5141\u8bb8\u6b62\u4ed8\u3002", (String)"ErLoanBaseBillList_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!(isHsOnWayBills = ErCommonUtils.isHasOnWayDownBill((String)view.getEntityTypeId(), (Long)((Long)row.getPrimaryKeyValue()), ErLoanBaseBillList.getLoanEntityInfos(row)))) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u5728\u9014\u4e0b\u6e38\"\u4ee3\u53d1\u5355\"\u6216\"\u4ed8\u6b3e\u5355\"\uff0c\u4e0d\u5141\u8bb8\u6b62\u4ed8\u3002", (String)"ErLoanBaseBillList_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (opResult.isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object selectId = selectedRows.get(0).getPrimaryKeyValue();
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setCustomParam("isstopreim", (Object)true);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (ErEntityTypeUtils.isApplyPayBill((String)view.getEntityTypeId()) || ErEntityTypeUtils.isDailyReimburseBill((String)view.getEntityTypeId()) || ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityTypeId())) {
                formShowParameter.setFormId(view.getEntityTypeId());
            } else {
                formShowParameter.setFormId(String.format("%1$s_stop", view.getEntityTypeId()));
            }
            formShowParameter.setBillStatus(BillOperationStatus.EDIT);
            formShowParameter.setPkId(selectId);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "stopreim"));
            view.showForm((FormShowParameter)formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "stopreim": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "changeinvoice": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        ListSelectedRowCollection list;
        super.beforeItemClick(e);
        if (StringUtils.equals((CharSequence)e.getOperationKey(), (CharSequence)"unaudit") && (list = this.getSelectedRows()).size() > 0) {
            ListSelectedRow row = list.get(0);
            String entityType = ((ListView)this.getView()).getEntityTypeId();
            DynamicObject dys = QueryServiceHelper.queryOne((String)entityType, (String)"isstopreim", (QFilter[])new QFilter[]{new QFilter("id", "=", row.getPrimaryKeyValue())});
            Boolean isStop = dys.getBoolean("isstopreim");
            if (isStop.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b62\u4ed8\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ErLoanBaseBillList_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    private DynamicObject getSelectReimburseBill(Long pkId) {
        ListView view = (ListView)this.getView();
        String entityName = view.getListModel().getEntityId();
        return QueryServiceHelper.queryOne((String)entityName, (String)"billstatus,isbeforeshare,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
    }

    private void doChangeInvoice(AfterDoOperationEventArgs e) {
        ListView view = (ListView)this.getView();
        OperationResult opResult = e.getOperationResult();
        ListSelectedRowCollection rows = this.getSelectedRows();
        Set selectbillIds = rows.stream().map(v -> (Long)v.getPrimaryKeyValue()).collect(Collectors.toSet());
        if (selectbillIds.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\"\u6362\u53d1\u7968\"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"ErLoanBaseBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        for (ListSelectedRow row : rows) {
            String status = row.getBillStatus();
            if (!(status.equals("E") || status.equals("F") || status.equals("G"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\"\u5ba1\u6838\u901a\u8fc7\"\u6216\"\u7b49\u5f85\u4ed8\u6b3e\"\u6216\"\u5df2\u4ed8\u6b3e\"\u7684\u5355\u636e\u5141\u8bb8\u6362\u53d1\u7968\u3002", (String)"ErLoanBaseBillList_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject selectedDy = this.getSelectReimburseBill((Long)row.getPrimaryKeyValue());
            if (selectedDy != null && selectedDy.getBoolean("isbeforeshare")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8d39\u7528\u5206\u644a\u7684\u5355\u636e\u4e0d\u652f\u6301\u6362\u53d1\u7968\u3002", (String)"ErLoanBaseBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            selectedDy = QueryServiceHelper.queryOne((String)view.getListModel().getEntityId(), (String)"billstatus,isredoffset,hasvoucher,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)((Long)row.getPrimaryKeyValue()))});
            if (selectedDy != null && selectedDy.getBoolean("isredoffset")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ea2\u51b2\u7684\u5355\u636e\u4e0d\u652f\u6301\u6362\u53d1\u7968\u3002", (String)"ErLoanBaseBillList_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedDy != null && selectedDy.getBoolean("hasvoucher") && !"true".equals(ErStdConfig.get((String)"OffsetControl"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\u4e0d\u652f\u6301\u6362\u53d1\u7968\u3002", (String)"ErLoanBaseBillList_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)view.getEntityTypeId(), (Long[])new Long[]{(Long)row.getPrimaryKeyValue()});
            if (!targetBills.containsKey("er_expensesharebill") && !targetBills.containsKey("ap_finapbill")) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u4e0b\u6e38\"\u8d39\u7528\u5206\u644a\u5355\"\u6216\"\u8d22\u52a1\u5e94\u4ed8\u5355\"\uff0c\u4e0d\u5141\u8bb8\u6362\u53d1\u7968\u3002", (String)"ErLoanBaseBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (opResult.isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object selectId = selectedRows.get(0).getPrimaryKeyValue();
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setCustomParam("ischangeinvoice", (Object)true);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setFormId(view.getEntityTypeId());
            formShowParameter.setBillStatus(BillOperationStatus.EDIT);
            formShowParameter.setPkId(selectId);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeinvoice"));
            view.showForm((FormShowParameter)formShowParameter);
        }
    }
}

