/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import org.apache.commons.lang3.StringUtils;

public class ErWorkFlowFlexListForOtherPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(ErWorkFlowFlexListForOtherPlugin.class);
    private Map<String, String> auditorsMap = new HashMap<String, String>();

    public void filterColumnSetFilter(SetFilterEvent args) {
        CommonFilterColumn cfc;
        super.filterColumnSetFilter(args);
        Object source = args.getSource();
        if (source instanceof CommonFilterColumn && "company.name".equals((cfc = (CommonFilterColumn)source).getFieldName())) {
            args.getQFilters().add(new QFilter("orgpattern.patterntype", "in", (Object)new Object[]{"1", "2"}));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent linkClick = args.getHyperLinkClickEvent();
        BillList billList = (BillList)linkClick.getSource();
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        if (selectedRow == null) {
            return;
        }
        if ("nextauditor".equals(linkClick.getFieldName())) {
            args.setCancel(true);
            ListShowParameter listShow = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = listShow.getPageId();
            WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)selectedRow.getPrimaryKeyValue());
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                long t1 = System.currentTimeMillis();
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                List filterPkIds = collection.stream().filter(bill -> bill.containsProperty("billstatus") && !StringUtils.equalsAny((CharSequence)bill.get("billstatus").toString(), (CharSequence[])new CharSequence[]{"A", "D", "H", "I"})).map(bill -> bill.get("id").toString()).collect(Collectors.toList());
                if (!filterPkIds.isEmpty()) {
                    ErWorkFlowFlexListForOtherPlugin.this.getNextAuditors(filterPkIds);
                }
                long t2 = System.currentTimeMillis();
                log.info("\u5ba1\u6838\u4eba\u6570\u636e\u52a0\u8f7dB \u7528\u65f6\uff1a " + (t2 - t1) + "ms");
                return collection;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc;
        super.packageData(e);
        if (e.getSource() instanceof ColumnDesc && "nextauditor".equals((columnDesc = (ColumnDesc)e.getSource()).getKey()) && this.auditorsMap != null && this.auditorsMap.size() > 0) {
            String auditor = this.auditorsMap.get(e.getRowData().getPkValue().toString());
            e.setFormatValue((Object)auditor);
        }
    }

    private void getNextAuditors(List<String> pkIds) {
        this.auditorsMap = new HashMap<String, String>(pkIds.size());
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            List node = (List)entry.getValue();
            int count = 0;
            String nodeName = "";
            StringBuilder participantName = new StringBuilder();
            StringBuilder msg = new StringBuilder();
            try {
                for (BizProcessStatus e : node) {
                    nodeName = e.getCurrentNodeName();
                    String auditor = e.getParticipantName();
                    e.getProcessStatus();
                    if (auditor == null || "".equals(auditor.trim())) continue;
                    participantName.append(",");
                    participantName.append(auditor);
                    if (++count != 3) continue;
                    participantName.append("...");
                    break;
                }
                if (!StringUtils.isBlank((CharSequence)nodeName)) {
                    msg.append(nodeName);
                    if (!StringUtils.isBlank((CharSequence)participantName)) {
                        msg.append('/');
                        msg.append(participantName.toString().replaceFirst(",", ""));
                    }
                }
            }
            catch (Exception e) {
                log.info("ErWorkFlowFlexListForOtherPlugin>>>\u83b7\u53d6\u5ba1\u6279\u4eba\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
            }
            this.auditorsMap.put((String)entry.getKey(), msg.toString());
        }
    }
}

