/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.entryimport.datahandle.AbstractEntryModelDataHandler;
import kd.fi.er.formplugin.entryimport.service.EntryImportServiceFactory;
import org.apache.commons.lang3.StringUtils;

public class EntryImportBillFormPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog((String)"EntryImportBillFormPlugin");
    private static final String EXP_ENTRYIMPORTOP = "expentryimport";
    private static final String EXP_ENTRY = "expenseentryentity";
    private static final String ACC_ENTRYIMPORTOP = "accentryimport";
    private static final String ACC_ENTRY = "accountentry";
    private static final String TRIP_ACCENTRYIMPORTOP = "tripaccentryimport";
    private static final String TRIP_ENTRYENTITYIMPORTOP = "tripgridentryimport";
    private static final String TRIP_ACCENTRY = "accountentry";
    private static final String TRIP_ENTRYENTITY = "entryentity";
    private static final String ASSET_ENTRYENTITY = "assetentry";
    private static final String RULEENTRY_IMPORTOP = "ruleentryimport";
    private static final String ASSET_IMPORTOP = "assetentryimport";
    private static final Map<String, String> ENTRYOP_TO_ACTID = new HashMap<String, String>(2);
    private static final Map<String, String> ENTRYOP_TO_ENTRYID = new HashMap<String, String>(2);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap3", "receiveentrytoolbar", "advcontoolbarap2", "doing_advcontoolbarap", "trip2advtoolbar", "advcontoolbarap31"});
    }

    public void itemClick(ItemClickEvent evt) {
        String optKey;
        super.itemClick(evt);
        switch (optKey = evt.getOperationKey()) {
            case "expentryimport": 
            case "accentryimport": 
            case "ruleentryimport": 
            case "tripaccentryimport": 
            case "tripgridentryimport": 
            case "assetentryimport": {
                FormShowParameter showForm = new FormShowParameter();
                showForm.setFormId("er_entryimport");
                showForm.getOpenStyle().setShowType(ShowType.Modal);
                String billFormId = this.getModel().getDataEntityType().getName();
                logger.info("\u5206\u5f55\u5bfc\u5165 >>> \u5355\u636eid: " + billFormId);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("BillFormId", billFormId);
                params.put("BillEntryId", ENTRYOP_TO_ENTRYID.get(optKey));
                showForm.setCustomParams(params);
                showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ENTRYOP_TO_ACTID.get(optKey)));
                this.getView().showForm(showForm);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        final String actionId = e.getActionId();
        if ("er_progressbar".equals(actionId)) {
            if (this.getControl("totalencashamountlabel") != null) {
                WriteOffMoneyUtils.showPayAmount((IDataModel)this.getModel(), (Label)((Label)this.getControl("totalencashamountlabel")));
            }
            this.getView().getPageCache().put("isImport", "true");
            this.getView().updateView();
            this.getView().getPageCache().remove("task_percent");
            String taskError = this.getView().getPageCache().get("task_error");
            if (StringUtils.isNotBlank((CharSequence)taskError)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5f02\u5e38\uff0c\u8be6\u60c5\u5982\u4e0b\u3002", (String)"EntryImportBillFormPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), taskError, MessageTypes.Default);
                this.getView().getPageCache().remove("task_error");
            }
        }
        if (!ENTRYOP_TO_ACTID.values().contains(actionId)) {
            return;
        }
        final Map returnData = (Map)e.getReturnData();
        if (returnData == null) {
            return;
        }
        logger.info("EntryImport >> \u5bfc\u5165\u6570\u636e\u5185\u5bb9 >> " + SerializationUtils.toJsonString((Object)returnData));
        final IDataModel model = this.getModel();
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"er_shareentryimport")) {
            this.dealModelDataAfterEntryImport("expenseentryentity_rule", model, view, pageCache, returnData);
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"er_assetentryimport")) {
            this.dealModelDataAfterEntryImport(ASSET_ENTRYENTITY, model, view, pageCache, returnData);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formId", "er_progressbar");
        paramMap.put("showType", ShowType.Modal);
        paramMap.put("needCallBack", Boolean.TRUE);
        ShowPageUtils.showWebForm(paramMap, (AbstractFormPlugin)this);
        ThreadService.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractEntryModelDataHandler dataHandler = null;
                    Thread.sleep(500L);
                    switch (actionId) {
                        case "er_entryimport": {
                            dataHandler = EntryImportServiceFactory.getModelDataHandlerService(EntryImportBillFormPlugin.EXP_ENTRY);
                            break;
                        }
                        case "er_accentryimport": 
                        case "er_tripaccentryimport": {
                            dataHandler = EntryImportServiceFactory.getModelDataHandlerService("accountentry");
                            break;
                        }
                        case "er_tripgridentryimport": {
                            dataHandler = EntryImportServiceFactory.getModelDataHandlerService(EntryImportBillFormPlugin.TRIP_ENTRYENTITY);
                            break;
                        }
                    }
                    if (dataHandler != null) {
                        dataHandler.setEntryData(model, view, pageCache, returnData);
                        view.getActionResult();
                    }
                }
                catch (Exception e) {
                    logger.error("execute entryimport error:", (Throwable)e);
                    String error = pageCache.get("task_error");
                    if (error == null || error.isEmpty()) {
                        view.getPageCache().put("task_error", e.getMessage());
                    }
                }
                finally {
                    pageCache.put("task_percent", "100");
                }
            }
        }, (TaskType)TaskType.ER_WORK_TASK, (RequestContext)RequestContext.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealModelDataAfterEntryImport(String entryEntityName, IDataModel model, IFormView view, IPageCache pageCache, Map<String, Object> returnData) {
        try {
            AbstractEntryModelDataHandler dataHandler = EntryImportServiceFactory.getModelDataHandlerService(entryEntityName);
            if (dataHandler != null) {
                dataHandler.setEntryData(model, view, pageCache, returnData);
                view.getActionResult();
            }
        }
        catch (Exception ex) {
            logger.error("execute entryimport error:", (Object)ex.getMessage());
            String error = pageCache.get("task_error");
            if (error == null || error.isEmpty()) {
                view.getPageCache().put("task_error", ex.getMessage());
            }
        }
        finally {
            pageCache.put("task_percent", "100");
        }
    }

    static {
        ENTRYOP_TO_ACTID.put(EXP_ENTRYIMPORTOP, "er_entryimport");
        ENTRYOP_TO_ACTID.put(ACC_ENTRYIMPORTOP, "er_accentryimport");
        ENTRYOP_TO_ACTID.put(TRIP_ACCENTRYIMPORTOP, "er_tripaccentryimport");
        ENTRYOP_TO_ACTID.put(RULEENTRY_IMPORTOP, "er_shareentryimport");
        ENTRYOP_TO_ACTID.put(TRIP_ENTRYENTITYIMPORTOP, "er_tripgridentryimport");
        ENTRYOP_TO_ACTID.put(ASSET_IMPORTOP, "er_assetentryimport");
        ENTRYOP_TO_ENTRYID.put(EXP_ENTRYIMPORTOP, EXP_ENTRY);
        ENTRYOP_TO_ENTRYID.put(ACC_ENTRYIMPORTOP, "accountentry");
        ENTRYOP_TO_ENTRYID.put(TRIP_ACCENTRYIMPORTOP, "accountentry");
        ENTRYOP_TO_ENTRYID.put(RULEENTRY_IMPORTOP, "expenseentryentity_rule");
        ENTRYOP_TO_ENTRYID.put(TRIP_ENTRYENTITYIMPORTOP, TRIP_ENTRYENTITY);
        ENTRYOP_TO_ENTRYID.put(ASSET_IMPORTOP, ASSET_ENTRYENTITY);
    }
}

