/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.excelhandle;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.formplugin.entryimport.excelhandle.AbstractEntryExcelDataHandler;

public class AssetEntryExcelDataHandler
extends AbstractEntryExcelDataHandler {
    private static final Log logger = LogFactory.getLog(AssetEntryExcelDataHandler.class);

    public AssetEntryExcelDataHandler() {
        super("assetentry");
    }

    @Override
    public void doConvert(List<Map<String, String>> returnData, StringBuilder errorInfo) {
        int setSize = 32;
        HashSet<String> assetCatNums = new HashSet<String>(setSize);
        HashSet<String> orgNums = new HashSet<String>(setSize);
        HashSet<String> currencyNums = new HashSet<String>(setSize);
        HashSet<String> assetStoreplaceNums = new HashSet<String>(setSize);
        HashSet<String> assetUnitNums = new HashSet<String>(setSize);
        for (Map<String, String> rowData2 : returnData) {
            assetCatNums.add(rowData2.get("asset_cat.number"));
            orgNums.add(rowData2.get("asset_costdept.number"));
            currencyNums.add(rowData2.get("assetcurrency.number"));
            assetStoreplaceNums.add(rowData2.get("asset_storeplace.number"));
            assetUnitNums.add(rowData2.get("asset_unit.number"));
            String assetPricewithouttaxStr = rowData2.get("assetpricewithouttax");
            String assetQuantityStr = rowData2.get("asset_quantity");
            String assetorientryamountStr = rowData2.get("assetorientryamount");
            String assettaxrateStr = rowData2.get("assettaxrate");
            String assetexchangerateStr = rowData2.get("assetexchangerate");
            String assettaxamountStr = rowData2.get("assettaxamount");
            BigDecimal assetPricewithouttax = BigDecimal.ZERO;
            BigDecimal assetQuantity = BigDecimal.ZERO;
            BigDecimal assetorientryamount = BigDecimal.ZERO;
            BigDecimal assettaxrate = BigDecimal.ZERO;
            BigDecimal assetexchangerate = BigDecimal.ONE;
            BigDecimal assettaxamount = BigDecimal.ZERO;
            if (assetPricewithouttaxStr != null && !assetPricewithouttaxStr.isEmpty()) {
                assetPricewithouttax = new BigDecimal(assetPricewithouttaxStr);
            }
            if (assetPricewithouttax.compareTo(BigDecimal.ZERO) < 0) {
                this.buildErrorInfo(errorInfo, rowData2.get("excelrow"), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"AssetEntryExcelDataHandler_4", (String)"fi-er-formplugin", (Object[])new Object[0]), assetPricewithouttaxStr + "", ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u5c0f\u4e8e0\u3002", (String)"AssetEntryExcelDataHandler_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (assetQuantityStr != null && !assetQuantityStr.isEmpty()) {
                assetQuantity = new BigDecimal(assetQuantityStr);
            }
            if (assetQuantity.compareTo(BigDecimal.ZERO) < 0) {
                this.buildErrorInfo(errorInfo, rowData2.get("excelrow"), ResManager.loadKDString((String)"\u6570\u91cf", (String)"AssetEntryExcelDataHandler_5", (String)"fi-er-formplugin", (Object[])new Object[0]), assetQuantityStr + "", ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u5c0f\u4e8e0\u3002", (String)"AssetEntryExcelDataHandler_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (assettaxrateStr != null && !assettaxrateStr.isEmpty()) {
                assettaxrate = new BigDecimal(assettaxrateStr);
            }
            if (assettaxrate.compareTo(BigDecimal.ZERO) < 0 || assettaxrate.compareTo(new BigDecimal(100)) > 0) {
                this.buildErrorInfo(errorInfo, rowData2.get("excelrow"), ResManager.loadKDString((String)"\u7a0e\u7387", (String)"AssetEntryExcelDataHandler_6", (String)"fi-er-formplugin", (Object[])new Object[0]), assettaxrateStr + "", ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u5e94\u4e3a0\u81f3100\u3002", (String)"AssetEntryExcelDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (assetorientryamountStr != null && !assetorientryamountStr.isEmpty()) {
                assetorientryamount = new BigDecimal(assetorientryamountStr);
            }
            if (assetorientryamount.compareTo(BigDecimal.ZERO) < 0) {
                this.buildErrorInfo(errorInfo, rowData2.get("excelrow"), ResManager.loadKDString((String)"\u91d1\u989d", (String)"AssetEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]), assetorientryamountStr + "", ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u5c0f\u4e8e0\u3002", (String)"AssetEntryExcelDataHandler_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (assetexchangerateStr != null && !assetexchangerateStr.isEmpty()) {
                assetexchangerate = new BigDecimal(assetexchangerateStr);
            }
            if (assetexchangerate.compareTo(BigDecimal.ZERO) <= 0) {
                this.buildErrorInfo(errorInfo, rowData2.get("excelrow"), ResManager.loadKDString((String)"\u6c47\u7387", (String)"AssetEntryExcelDataHandler_10", (String)"fi-er-formplugin", (Object[])new Object[0]), assetexchangerateStr + "", ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u4e0d\u5927\u4e8e0\u3002", (String)"AssetEntryExcelDataHandler_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (assettaxamountStr != null && !assettaxamountStr.isEmpty()) {
                assettaxamount = new BigDecimal(assettaxamountStr);
            }
            if (assettaxamount.compareTo(BigDecimal.ZERO) >= 0) continue;
            this.buildErrorInfo(errorInfo, rowData2.get("excelrow"), ResManager.loadKDString((String)"\u7a0e\u989d", (String)"AssetEntryExcelDataHandler_12", (String)"fi-er-formplugin", (Object[])new Object[0]), assettaxamountStr + "", ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u5c0f\u4e8e0\u3002", (String)"AssetEntryExcelDataHandler_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        orgNums.remove(null);
        orgNums.remove("");
        assetCatNums.remove(null);
        assetCatNums.remove("");
        currencyNums.remove(null);
        currencyNums.remove("");
        assetStoreplaceNums.remove(null);
        assetStoreplaceNums.remove("");
        assetUnitNums.remove(null);
        assetUnitNums.remove("");
        QFilter orgFilter = new QFilter("view", "=", (Object)1);
        orgFilter.and("isfreeze", "=", (Object)false);
        orgFilter.and("org.number", "in", orgNums);
        Map orgDyms = BusinessDataServiceHelper.loadFromCache((String)"bos_adminorg_structure", (String)"id,org.number", (QFilter[])new QFilter[]{orgFilter});
        Map assetCatDyms = BusinessDataServiceHelper.loadFromCache((String)"fa_assetcategory", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", assetCatNums), new QFilter("enable", "=", (Object)true)});
        Map cuDyms = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", currencyNums), new QFilter("enable", "=", (Object)true)});
        Map storePlaceDyms = BusinessDataServiceHelper.loadFromCache((String)"fa_storeplace", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", assetStoreplaceNums), new QFilter("enable", "=", (Object)true)});
        Map assetUnitDyms = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", assetUnitNums), new QFilter("enable", "=", (Object)true)});
        for (DynamicObject orgDym : orgDyms.values()) {
            orgNums.remove(orgDym.getString("org.number"));
        }
        for (DynamicObject assetCatDym : assetCatDyms.values()) {
            assetCatNums.remove(assetCatDym.getString("number"));
        }
        for (DynamicObject cuDym : cuDyms.values()) {
            currencyNums.remove(cuDym.getString("number"));
        }
        for (DynamicObject storePlaceDym : storePlaceDyms.values()) {
            assetStoreplaceNums.remove(storePlaceDym.getString("number"));
        }
        for (DynamicObject assetUnitDym : assetUnitDyms.values()) {
            assetUnitNums.remove(assetUnitDym.getString("number"));
        }
        returnData.forEach(rowData -> {
            if (assetCatNums.contains(rowData.get("asset_cat.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b", (String)"AssetEntryExcelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("asset_cat.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (orgNums.contains(rowData.get("asset_costdept.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u4f7f\u7528\u90e8\u95e8", (String)"AssetEntryExcelDataHandler_1", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("asset_costdept.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"ExpenseEntryExcelDataHandler_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (currencyNums.contains(rowData.get("assetcurrency.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ExpenseEntryExcelDataHandler_8", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("assetcurrency.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (assetStoreplaceNums.contains(rowData.get("asset_storeplace.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u5b58\u653e\u5730\u70b9", (String)"AssetEntryExcelDataHandler_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("asset_storeplace.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (assetUnitNums.contains(rowData.get("asset_unit.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"AssetEntryExcelDataHandler_3", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("asset_unit.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        });
    }
}

