/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.excelhandle;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.entryimport.excelhandle.AbstractEntryExcelDataHandler;

public class ExpenseEntryExcelDataHandler
extends AbstractEntryExcelDataHandler {
    public ExpenseEntryExcelDataHandler() {
        super("expenseentryentity");
    }

    @Override
    public void doConvert(List<Map<String, String>> returnData, StringBuilder errorInfo) {
        int setSize = 32;
        HashSet costdeptNums = new HashSet(setSize);
        HashSet costCompanyNums = new HashSet(setSize);
        HashSet expItemNums = new HashSet(setSize);
        HashSet currencyNums = new HashSet(setSize);
        HashSet reimburserNums = new HashSet(setSize);
        HashSet projectNums = new HashSet(setSize);
        HashSet applyProjectNums = new HashSet(setSize);
        IFormView view = this.getView();
        Long company = 0L;
        Long costcompany = 0L;
        if (null != view) {
            IDataModel model = view.getModel();
            if (null != model.getProperty("company")) {
                company = ErCommonUtils.getPk((Object)model.getValue("company"));
            }
            if (null != model.getProperty("costcompany")) {
                costcompany = ErCommonUtils.getPk((Object)model.getValue("costcompany"));
            }
        }
        for (Map map : returnData) {
            costdeptNums.add(map.get("entrycostdept.number"));
            costCompanyNums.add(map.get("entrycostcompany.number"));
            expItemNums.add(map.get("expenseitem.number"));
            currencyNums.add(map.get("entrycurrency.number"));
            reimburserNums.add(map.get("reimburser.number"));
            projectNums.add(map.get("project.number"));
            applyProjectNums.add(map.get("std_project.number"));
            String deductibleTaxStr = (String)map.get("deductibletax");
            String taxAmountStr = (String)map.get("taxamount");
            if (deductibleTaxStr == null && taxAmountStr == null) continue;
            if (deductibleTaxStr == null || deductibleTaxStr.isEmpty()) {
                deductibleTaxStr = "0";
            }
            if (taxAmountStr == null || taxAmountStr.isEmpty()) {
                taxAmountStr = "0";
            }
            BigDecimal deductibleTaxAmount = BigDecimal.ZERO;
            BigDecimal taxAmount = BigDecimal.ZERO;
            try {
                deductibleTaxAmount = new BigDecimal(deductibleTaxStr);
            }
            catch (Exception e) {
                this.buildErrorInfo(errorInfo, (String)map.get("excelrow"), ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u7a0e\u989d ", (String)"ExpenseEntryExcelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0]), deductibleTaxStr, ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u683c\u5f0f\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ExpenseEntryExcelDataHandler_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            try {
                taxAmount = new BigDecimal(taxAmountStr);
            }
            catch (Exception e) {
                this.buildErrorInfo(errorInfo, (String)map.get("excelrow"), ResManager.loadKDString((String)"\u7a0e\u989d ", (String)"ExpenseEntryExcelDataHandler_2", (String)"fi-er-formplugin", (Object[])new Object[0]), taxAmountStr, ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u683c\u5f0f\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ExpenseEntryExcelDataHandler_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
        costdeptNums.remove(null);
        costdeptNums.remove("");
        costCompanyNums.remove(null);
        costCompanyNums.remove("");
        expItemNums.remove(null);
        expItemNums.remove("");
        currencyNums.remove(null);
        currencyNums.remove("");
        reimburserNums.remove(null);
        reimburserNums.remove("");
        projectNums.remove(null);
        projectNums.remove("");
        applyProjectNums.remove(null);
        projectNums.remove("");
        QFilter orgFilter = new QFilter("view", "=", (Object)1);
        orgFilter.and("isfreeze", "=", (Object)false);
        orgFilter.and("org.number", "in", costdeptNums);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_adminorg_structure", (String)"id,org.number", (QFilter[])new QFilter[]{orgFilter});
        QFilter companyFilter = new QFilter("structure.view", "=", (Object)10);
        companyFilter.and("structure.isfreeze", "=", (Object)false);
        if (ErCommonUtils.costcompanyonlyleaf()) {
            companyFilter.and("structure.isleaf", "=", (Object)true);
        }
        companyFilter.and("enable", "=", (Object)true);
        companyFilter.and("number", "in", costCompanyNums);
        Map costcompanyDyms = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{companyFilter});
        if (null != costcompany && 0L != costcompany) {
            QFilter qFilter = new QFilter("number", "in", expItemNums);
            qFilter.and(new QFilter("enable", "=", (Object)true)).and(new QFilter("isleaf", "=", (Object)true));
            Map expDyms = BaseDataServiceHelper.queryBaseDataFromCache((String)"er_expenseitemedit", (Long)costcompany, (QFilter)qFilter, (String)"id, number, isleaf");
            if (expDyms != null) {
                for (DynamicObject expDym : expDyms.values()) {
                    expItemNums.remove(expDym.getString("number"));
                }
            }
        }
        Map cuDyms = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", currencyNums), new QFilter("enable", "=", (Object)true)});
        Map reimDyms = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", reimburserNums)});
        Map projectDyms = BusinessDataServiceHelper.loadFromCache((String)"bd_project", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", projectNums)});
        Map applyProjectDyms = BusinessDataServiceHelper.loadFromCache((String)"bd_project", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", applyProjectNums), new QFilter("enable", "=", (Object)true)});
        for (DynamicObject deptDym : map.values()) {
            costdeptNums.remove(deptDym.getString("org.number"));
        }
        for (DynamicObject companyDym : costcompanyDyms.values()) {
            costCompanyNums.remove(companyDym.getString("number"));
        }
        for (DynamicObject cuDym : cuDyms.values()) {
            currencyNums.remove(cuDym.getString("number"));
        }
        for (DynamicObject reimDym : reimDyms.values()) {
            reimburserNums.remove(reimDym.getString("number"));
        }
        for (DynamicObject projectDym : projectDyms.values()) {
            projectNums.remove(projectDym.getString("number"));
        }
        for (DynamicObject applyProjectDym : applyProjectDyms.values()) {
            applyProjectNums.remove(applyProjectDym.getString("number"));
        }
        returnData.forEach(rowData -> {
            if (costdeptNums.contains(rowData.get("entrycostdept.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8", (String)"ExpenseEntryExcelDataHandler_4", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("entrycostdept.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"ExpenseEntryExcelDataHandler_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (costCompanyNums.contains(rowData.get("entrycostcompany.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8", (String)"ExpenseEntryExcelDataHandler_16", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("entrycostcompany.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (expItemNums.contains(rowData.get("expenseitem.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"ExpenseEntryExcelDataHandler_6", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("expenseitem.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (currencyNums.contains(rowData.get("entrycurrency.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ExpenseEntryExcelDataHandler_8", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("entrycurrency.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (reimburserNums.contains(rowData.get("reimburser.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u62a5\u9500\u4eba", (String)"ExpenseEntryExcelDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("reimburser.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (projectNums.contains(rowData.get("project.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u9879\u76ee", (String)"ExpenseEntryExcelDataHandler_10", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("project.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (applyProjectNums.contains(rowData.get("std_project.number"))) {
                this.buildErrorInfo(errorInfo, (String)rowData.get("excelrow"), ResManager.loadKDString((String)"\u9879\u76ee", (String)"ExpenseEntryExcelDataHandler_10", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)rowData.get("std_project.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"ExpenseEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        });
    }
}

