/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.asynclog.AsyncLogUtil;

public class InvoiceAsyncLogListPlugin
extends AbstractListPlugin {
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("handupdate".equalsIgnoreCase(itemKey)) {
            this.handUpdate(evt);
        }
        if ("operconfig".equalsIgnoreCase(itemKey)) {
            this.operconfig(evt);
        }
    }

    private void operconfig(ItemClickEvent evt) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("er_operation");
        listShowParameter.setFormId("bos_list");
        listShowParameter.setLookUp(false);
        listShowParameter.setListFilterParameter(null);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        listShowParameter.setShowTitle(true);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void handUpdate(ItemClickEvent evt) {
        AbstractListView view = (AbstractListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"InvoiceAsyncLogListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else {
            Set logIds = selectedRows.stream().map(v -> (Long)v.getPrimaryKeyValue()).collect(Collectors.toSet());
            int[] updateAsyncLog = AsyncLogUtil.updateAsyncLog(logIds);
            if (updateAsyncLog == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvoiceAsyncLogListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5bf9\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u8fdb\u884c\u53d1\u7968\u72b6\u6001\u66f4\u65b0\uff0c\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"InvoiceAsyncLogListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), updateAsyncLog[0], updateAsyncLog[1]));
                view.refresh();
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("billno".equalsIgnoreCase(fieldName)) {
            Object billId;
            IListView listView = (IListView)this.getView();
            Object stdId = listView.getFocusRowPkId();
            DynamicObject logObj = QueryServiceHelper.queryOne((String)"er_invoiceasynclog", (String)"bizobj billmetadatanumber, billid", (QFilter[])new QFilter("id", "=", stdId).toArray());
            String billmetadatanumber = logObj.getString("billmetadatanumber");
            boolean exists = QueryServiceHelper.exists((String)billmetadatanumber, (Object)(billId = logObj.get("billid")));
            if (!exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"InvoiceAsyncLogListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(billmetadatanumber);
                parameter.setPkId(billId);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            }
            args.setCancel(true);
        }
    }
}

