/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.invoicepackage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.invoicepackage.util.QuickReimUtil;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.CreditLevelServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.model.invoice.QuickConfigBo;
import kd.fi.er.formplugin.web.TripBaseBillEdit;
import kd.fi.er.model.FormModel;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.ISuperClosedCallBack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QuickReimPcPlugin
extends AbstractBillPlugIn
implements ClickListener,
SearchEnterListener {
    private static final String BIZ_ITEM_PANEL = "bizitempanel";
    private static final String BIZ_ITEM_SELECT = "selectBizItem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"more", "changeapplier"});
        Search search = (Search)this.getControl("search");
        search.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"quickreimtoolbarap"});
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
        this.initBizItemData();
        this.getView().setVisible(Boolean.FALSE, new String[]{"search"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container control = (Container)this.getView().getControl(BIZ_ITEM_PANEL);
        List<ControlAp> apControls = this.createApControls(this.loadCacheQuickReimConfig(true));
        List controls = apControls.stream().map(ap -> ap.buildRuntimeControl()).collect(Collectors.toList());
        control.getItems().addAll(controls);
        this.getView().createControlIndex(control.getItems());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List<QuickConfigBo> quickConfigBos = this.loadCacheQuickReimConfig(false);
        String more = this.getPageCache().get("more");
        if (StringUtils.isEmpty((CharSequence)more)) {
            if (CollectionUtils.isNotEmpty(quickConfigBos) && quickConfigBos.size() > 8) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"more"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"more"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(Boolean.parseBoolean(more)), new String[]{"more"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"search"});
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        List<QuickConfigBo> quickConfigBos;
        Optional<QuickConfigBo> match;
        super.onGetControl(e);
        String key = e.getKey();
        if (StringUtils.isNumeric((CharSequence)key) && (match = (quickConfigBos = this.loadCacheQuickReimConfig(false)).stream().filter(config -> config.getId().equals(Long.parseLong(key))).findFirst()).isPresent()) {
            Button item = new Button();
            item.setKey(key);
            item.setView(this.getView());
            item.addClickListener((ClickListener)this);
            e.setControl((Control)item);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "changeapplier": {
                this.openChangeApplier();
                break;
            }
            case "more": {
                this.showMoreBizItem();
                break;
            }
            default: {
                if (!StringUtils.isNumeric((CharSequence)key)) break;
                this.selectBizItem(key);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "next": {
                String selectItem = this.getPageCache().get(BIZ_ITEM_SELECT);
                if (StringUtils.isEmpty((CharSequence)selectItem)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u4e8b\u9879\u3002", (String)"QuickReimPcPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.createBill(Long.parseLong(selectItem));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        IDataModel model = this.getView().getModel();
        if ("er_changeapplier".equals(actionId)) {
            PluginProxy pluginProxy = PluginProxy.create(null, ISuperClosedCallBack.class, (String)"FI_ER_SUPERCLOSEDCALLBACK", null);
            AtomicBoolean b = new AtomicBoolean(true);
            pluginProxy.callReplace(p -> {
                b.set(p.beforeClosedCallBack(TripBaseBillEdit.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), event.getReturnData()}));
                return null;
            });
            if (b.get() && event.getReturnData() != null) {
                Map map = (Map)event.getReturnData();
                Long deptId = Long.parseLong(map.get("deptId").toString());
                Long companyId = Long.parseLong(map.get("newCompanyId").toString());
                String userId = map.get("consignorId").toString();
                String positionStr = map.get("newPositionStr") == null ? "" : map.get("newPositionStr").toString();
                String newTel = map.get("newtel") == null ? "" : map.get("newtel").toString();
                Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((Long)deptId);
                DynamicObject applier = (DynamicObject)model.getValue("applier");
                String applierId = applier.getPkValue().toString();
                if (!applierId.equals(userId)) {
                    this.getModel().setValue("applier", (Object)Long.parseLong(userId));
                    DynamicObject applierObj = (DynamicObject)this.getModel().getValue("applier");
                    String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applierObj.getPkValue()));
                    Image imageLb = (Image)this.getControl("imageap_photo");
                    imageLb.setUrl(applierPicUrl);
                    Label applierLabel = (Label)this.getView().getControl("applierv");
                    applierLabel.setText(applierObj.getString("name"));
                    String creditLevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)userId, (IFormView)this.getView());
                    if (StringUtils.isEmpty((CharSequence)creditLevelStr)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
                    } else {
                        ((Label)this.getControl("creditlevel")).setText(creditLevelStr);
                    }
                }
                this.getModel().setValue("costcompany", (Object)costCompanyId);
                this.getModel().setValue("costdept", (Object)deptId);
                this.getModel().setValue("company", (Object)companyId);
                this.getModel().setValue("org", (Object)deptId);
                Label orgLabel = (Label)this.getView().getControl("orgv");
                orgLabel.setText(((DynamicObject)this.getModel().getValue("org")).getString("name"));
                Label positionLabel = (Label)this.getView().getControl("applierpositionv");
                positionLabel.setText(positionStr);
                this.getModel().setValue("applierpositionstr", (Object)positionStr);
                this.getModel().setValue("tel", (Object)newTel);
                DynamicObject company = (DynamicObject)model.getValue("company");
                DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
                if (company != null && company.getPkValue() != null) {
                    Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)company, (Object)costCompany);
                    this.getModel().setValue("currency", (Object)baseCurrencyId);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        ChangeData changeData = valueSet[0];
        Object newValue = changeData.getNewValue();
        switch (name = e.getProperty().getName()) {
            case "applier": 
            case "company": {
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])valueSet);
                Container control = (Container)this.getControl(BIZ_ITEM_PANEL);
                List<QuickConfigBo> quickConfigBos = this.loadCacheQuickReimConfig(false);
                String[] objects = (String[])quickConfigBos.stream().map(config -> config.getId().toString()).toArray(String[]::new);
                control.deleteControls(objects);
                this.getPageCache().remove("reimconfig");
                this.initBizItemData();
                List<QuickConfigBo> newConfigs = this.loadCacheQuickReimConfig(false);
                if (newConfigs.size() > 8) {
                    this.getPageCache().put("more", "true");
                } else {
                    this.getPageCache().put("more", "false");
                }
                this.getView().updateView();
                break;
            }
            case "costcompany": {
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])valueSet);
                break;
            }
            case "costdept": {
                if (newValue == null) {
                    this.getModel().setValue("costdept", changeData.getOldValue());
                    return;
                }
                Long costCompanyId = newValue instanceof Long ? CoreBaseBillServiceHelper.getAccountOrgId((Long)((Long)newValue)) : CoreBaseBillServiceHelper.getAccountOrgId((Long)((Long)((DynamicObject)newValue).getPkValue()));
                this.getModel().setValue("costcompany", (Object)costCompanyId);
            }
        }
    }

    private void initData() {
        Long currentUserID = Long.valueOf(RequestContext.get().getUserId());
        Map initData = CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
        Long costCompanyId = (Long)initData.get("costcompany");
        if (costCompanyId == null || costCompanyId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u53f8\u672a\u627e\u5230\u53ef\u7528\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff0c\u8bf7\u5207\u6362\u516c\u53f8\u3002", (String)"QuickReimPcPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("costcompany", (Object)costCompanyId);
        this.getModel().setValue("costdept", initData.get("costdept"));
        Long applierId = (Long)initData.get("applier");
        this.getModel().setValue("applier", (Object)applierId);
        String creditLevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)applierId.toString(), (IFormView)this.getView());
        if (StringUtils.isEmpty((CharSequence)creditLevelStr)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
        } else {
            ((Label)this.getControl("creditlevel")).setText(creditLevelStr);
        }
        Long companyId = (Long)initData.get("company");
        this.getModel().setValue("company", (Object)companyId);
        DynamicObject org = (DynamicObject)initData.get("org");
        this.getModel().setValue("org", (Object)org);
        DynamicObject applierObj = (DynamicObject)this.getModel().getValue("applier");
        String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applierObj.getPkValue()));
        Image imageLb = (Image)this.getControl("imageap_photo");
        imageLb.setUrl(applierPicUrl);
        Label applierLabel = (Label)this.getView().getControl("applierv");
        applierLabel.setText(applierObj.getString("name"));
        Label orgLabel = (Label)this.getView().getControl("orgv");
        orgLabel.setText(org.getString("name"));
        Label positionLabel = (Label)this.getView().getControl("applierpositionv");
        positionLabel.setText(initData.get("applierpositionstr").toString());
        this.getModel().setValue("applierpositionstr", (Object)initData.get("applierpositionstr").toString());
        this.getModel().setValue("tel", initData.get("tel"));
        this.getModel().setValue("currency", initData.get("currency"));
    }

    private void initBizItemData() {
        List<QuickConfigBo> quickConfigs = this.loadCacheQuickReimConfig(false);
        List<ControlAp> apControls = quickConfigs.size() > 8 ? this.createApControls(quickConfigs.subList(0, 8)) : this.createApControls(quickConfigs);
        Container control = (Container)this.getControl(BIZ_ITEM_PANEL);
        List controlItems = apControls.stream().map(apControl -> apControl.createControl()).collect(Collectors.toList());
        for (int i = controlItems.size() - 1; i >= 0; --i) {
            Map o = (Map)controlItems.get(i);
            ArrayList<Map> list = new ArrayList<Map>();
            list.add(o);
            control.insertControls(-1, list);
        }
    }

    private List<ControlAp> createApControls(List<QuickConfigBo> configs) {
        ArrayList<ControlAp> controlItems = new ArrayList<ControlAp>(configs.size());
        for (QuickConfigBo config : configs) {
            ButtonAp ap = new ButtonAp();
            String name = config.getName();
            if (name.length() >= 8) {
                name = name.substring(0, 7) + "...";
            }
            ap.setName(new LocaleString(name));
            ap.setKey(config.getId().toString());
            Tips tips = new Tips();
            tips.setTriggerType("hover");
            tips.setContent(new LocaleString(config.getName()));
            tips.setShowIcon(false);
            tips.setType("text");
            tips.setIsConfirm(false);
            ap.setCtlTips(tips);
            ap.setWidth(new LocaleString("140px"));
            ap.setHeight(new LocaleString("90px"));
            ap.setRadius("10px");
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("30px");
            style.setMargin(margin);
            ap.setStyle(style);
            ap.setButtonStyle(2);
            ap.setImageKey(StringUtils.isEmpty((CharSequence)config.getMenuImg()) ? "/icons/pc/application/cwy_cwbz_48_48.png" : config.getMenuImg());
            ap.setImgHeight("50px");
            ap.setImgWidth("50px");
            ap.setTextAlign("center");
            ap.setAutoTextWrap(false);
            ap.setForeColor("#000000");
            controlItems.add((ControlAp)ap);
        }
        return controlItems;
    }

    private void openChangeApplier() {
        HashMap<String, String> customParam = new HashMap<String, String>();
        customParam.put("showProps", "applierprops");
        FormModel formModel = new FormModel("er_changeapplier", ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f", (String)"CoreBaseBillEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true, customParam);
        formModel.setShowType(ShowType.Modal);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    private List<QuickConfigBo> loadCacheQuickReimConfig(boolean needMeg) {
        String configCache = this.getPageCache().get("reimconfig");
        if (StringUtils.isNotEmpty((CharSequence)configCache)) {
            List quickConfigBos = JSONArray.parseArray((String)configCache, QuickConfigBo.class);
            return quickConfigBos;
        }
        Long companyId = this.getCompany();
        if (companyId == null || companyId == 0L) {
            if (needMeg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7533\u8bf7\u4eba\u516c\u53f8\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"QuickReimPcPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            return Collections.EMPTY_LIST;
        }
        List quickConfigs = QuickReimUtil.getQuickConfigs((Long)companyId, (boolean)needMeg, (IFormView)this.getView(), (QFilter)this.getGroupFilter());
        if (CollectionUtils.isEmpty((Collection)quickConfigs)) {
            return Collections.EMPTY_LIST;
        }
        List result = QuickReimUtil.getSortConfigs((List)quickConfigs);
        this.getPageCache().put("reimconfig", JSON.toJSONString((Object)result));
        return result;
    }

    private Long getCurrentUserId() {
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        Long currentUserId = applier != null ? (Long)applier.getPkValue() : Long.valueOf(RequestContext.get().getUserId());
        return currentUserId;
    }

    private void showMoreBizItem() {
        Container control = (Container)this.getView().getControl(BIZ_ITEM_PANEL);
        List<QuickConfigBo> quickConfigBos = this.loadCacheQuickReimConfig(false);
        String[] objects = (String[])quickConfigBos.stream().map(config -> config.getId().toString()).toArray(String[]::new);
        control.deleteControls(objects);
        List<ControlAp> apControls = this.createApControls(quickConfigBos);
        List controlItems = apControls.stream().map(apControl -> apControl.createControl()).collect(Collectors.toList());
        control.addControls(controlItems);
        this.getPageCache().put("more", "false");
        this.getView().setVisible(Boolean.TRUE, new String[]{"search"});
        this.getView().updateView();
    }

    public void search(SearchEnterEvent evt) {
        Object source = evt.getSource();
        String text = evt.getText();
        Container control = (Container)this.getView().getControl(BIZ_ITEM_PANEL);
        List<QuickConfigBo> quickConfigBos = this.loadCacheQuickReimConfig(false);
        String[] objects = (String[])quickConfigBos.stream().map(config -> config.getId().toString()).toArray(String[]::new);
        control.deleteControls(objects);
        List<QuickConfigBo> match = quickConfigBos.stream().filter(config -> config.getName().contains(text)).collect(Collectors.toList());
        List<ControlAp> apControls = this.createApControls(match);
        List controlItems = apControls.stream().map(apControl -> apControl.createControl()).collect(Collectors.toList());
        control.addControls(controlItems);
        this.getView().updateView();
    }

    private void selectBizItem(String key) {
        String oldKey = this.getPageCache().get(BIZ_ITEM_SELECT);
        if (key.equals(oldKey)) {
            return;
        }
        this.getPageCache().put(BIZ_ITEM_SELECT, key);
        HashMap fieldMap = new HashMap();
        HashMap<String, String> borderMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>();
        borderMap.put("r", "1px_solid_themeColor");
        borderMap.put("l", "1px_solid_themeColor");
        borderMap.put("t", "10px_solid_themeColor");
        borderMap.put("b", "1px_solid_themeColor");
        styleMap.put("b", borderMap);
        fieldMap.put("s", styleMap);
        this.getView().updateControlMetadata(key, fieldMap);
        if (StringUtils.isNotEmpty((CharSequence)oldKey)) {
            HashMap oldFieldMap = new HashMap();
            HashMap<String, String> oldBorderMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> oldStyleMap = new HashMap<String, HashMap<String, String>>();
            oldBorderMap.put("r", "");
            oldBorderMap.put("l", "");
            oldBorderMap.put("t", "");
            oldBorderMap.put("b", "");
            oldStyleMap.put("b", oldBorderMap);
            oldFieldMap.put("s", oldStyleMap);
            this.getView().updateControlMetadata(oldKey, oldFieldMap);
        }
    }

    private void createBill(Long billSettingId) {
        List<QuickConfigBo> quickConfigBos = this.loadCacheQuickReimConfig(false);
        List configs = quickConfigBos.stream().filter(config -> config.getId().equals(billSettingId)).collect(Collectors.toList());
        QuickConfigBo config2 = null;
        if (CollectionUtils.isNotEmpty(configs)) {
            config2 = (QuickConfigBo)configs.get(0);
        }
        if (config2 == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u53ef\u7528\u7684\u4e1a\u52a1\u4e8b\u9879\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"QuickReimPcPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Long groupId = config2.getGroup();
        QFilter billFilter = new QFilter("id", "=", (Object)groupId);
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)"er_setting_group", (String)"id,number,controlfield", (QFilter[])new QFilter[]{billFilter});
        String billNumber = "";
        if (billType != null) {
            billNumber = billType.getString("number");
        }
        if (StringUtils.isEmpty((CharSequence)billNumber)) {
            return;
        }
        Long bizItemId = config2.getBizItem();
        QFilter filter = new QFilter("id", "=", (Object)bizItemId);
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"er_standard_type", (String)"id,number", (QFilter[])new QFilter[]{filter});
        String bizItemNumber = "";
        if (setting != null) {
            bizItemNumber = setting.getString("number");
        }
        FormModel fm = new FormModel(billNumber, config2.getName(), "2");
        fm.setShowType(ShowType.InCurrentForm);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("bizitem", bizItemNumber);
        customParam.put("package_import_pc", "package_import_pc");
        Object userId = ((DynamicObject)this.getModel().getValue("applier")).getPkValue();
        customParam.put("quickreim_applier", userId);
        customParam.put("quickreim_creator", userId);
        customParam.put("quickreim_costcompany", ((DynamicObject)this.getModel().getValue("costcompany")).getPkValue());
        customParam.put("quickreim_costdept", ((DynamicObject)this.getModel().getValue("costdept")).getPkValue());
        customParam.put("quickreim_company", ((DynamicObject)this.getModel().getValue("company")).getPkValue());
        customParam.put("quickreim_org", ((DynamicObject)this.getModel().getValue("org")).getPkValue());
        customParam.put("quickreim_tel", this.getModel().getValue("tel"));
        customParam.put("quickreim_billstatus", "A");
        customParam.put("quickreim_currency", ((DynamicObject)this.getModel().getValue("currency")).getPkValue());
        customParam.put("quickreim_applierpositionstr", this.getModel().getValue("applierpositionstr"));
        fm.setCustomParam(customParam);
        ShowPageUtils.showPage((FormModel)fm, (AbstractFormPlugin)this);
    }

    private QFilter getGroupFilter() {
        String group = (String)this.getView().getFormShowParameter().getCustomParams().get("group");
        QFilter qFilter = "er_dailyapplybill".equals(group) ? new QFilter("group.number", "=", (Object)group) : new QFilter("group.number", "in", (Object)new String[]{"er_dailyreimbursebill", "er_publicreimbursebill"});
        return qFilter;
    }

    private Long getCompany() {
        Object company;
        Long companyId = null;
        IDataModel model = this.getModel();
        if (model != null && (company = (DynamicObject)model.getValue("company")) != null) {
            companyId = (Long)company.getPkValue();
        }
        if (companyId == null) {
            company = this.getView().getFormShowParameter().getCustomParam("company");
            if (company instanceof Integer) {
                companyId = ((Integer)company).longValue();
            } else if (company instanceof Long) {
                companyId = (Long)company;
            }
        }
        if (companyId == null) {
            Long currentUserID = Long.valueOf(RequestContext.get().getUserId());
            Map initData = CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
            companyId = (Long)initData.get("company");
        }
        return companyId;
    }
}

