/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.invoicepackage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.MenuItem;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.mcontrol.MBlockMenuItemAp;
import kd.fi.er.business.invoicecloud.invoicepackage.QuickReimServiceFactory;
import kd.fi.er.business.invoicecloud.invoicepackage.quickreimservice.AbstractQuickReimburseService;
import kd.fi.er.common.model.invoice.QuickConfigBo;
import org.apache.commons.lang3.StringUtils;

public class QuickReimburseMoreMob
extends AbstractMobBillPlugIn
implements ClickListener,
MobileSearchTextChangeListener {
    private static final Log log = LogFactory.getLog(QuickReimburseMoreMob.class);
    private static final String BLOCK_PANEL = "reimtypeblock";
    private QuickReimServiceFactory factory = new QuickReimServiceFactory();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl("search");
        mobileSearch.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void initialize() {
        Object o;
        Map customParams;
        if (this.getPageCache().get("reimconfig") == null && (customParams = this.getView().getFormShowParameter().getCustomParams()) != null && (o = customParams.get("reimconfig")) != null) {
            List quickConfigBos = ((JSONArray)o).toJavaList(QuickConfigBo.class);
            this.getPageCache().put("reimconfig", JSON.toJSONString((Object)quickConfigBos));
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        List<QuickConfigBo> configs = this.loadCacheQuickReimConfig();
        if (configs == null) {
            return;
        }
        List idList = configs.stream().map(dy -> dy.getId().toString()).collect(Collectors.toList());
        idList.add("more");
        if (!idList.contains(key)) {
            return;
        }
        MenuItem item = new MenuItem();
        item.setKey(key);
        item.setView(this.getView());
        item.addClickListener((ClickListener)this);
        e.setControl((Control)item);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container menuBlock = (Container)this.getControl(BLOCK_PANEL);
        List<QuickConfigBo> configs = this.loadCacheQuickReimConfig();
        if (configs == null) {
            return;
        }
        List<ControlAp> apControls = this.createApControls(configs);
        List controls = apControls.stream().map(ap -> ap.buildRuntimeControl()).collect(Collectors.toList());
        menuBlock.getItems().addAll(controls);
        this.getView().createControlIndex(menuBlock.getItems());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            this.getModel().setValue("costcompany", customParams.get("costcompany"));
            this.getModel().setValue("applier", customParams.get("applier"));
            this.getModel().setValue("company", customParams.get("company"));
            this.getModel().setValue("org", customParams.get("org"));
        }
        List<QuickConfigBo> quickReimConfig = this.loadCacheQuickReimConfig();
        List<ControlAp> apControls = this.createApControls(quickReimConfig);
        Container reimBlock = (Container)this.getControl(BLOCK_PANEL);
        List controlItems = apControls.stream().map(apControl -> apControl.createControl()).collect(Collectors.toList());
        reimBlock.addControls(controlItems);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.isNumeric((CharSequence)key)) {
            this.createBill(Long.parseLong(key));
        }
    }

    private void createBill(Long configId) {
        if (configId == null) {
            log.info("\u4e00\u952e\u62a5\u9500\u914d\u7f6e\u4e3a\u7a7a");
            return;
        }
        String configCache = this.getPageCache().get("reimconfig");
        List quickConfigCache = JSONArray.parseArray((String)configCache, QuickConfigBo.class);
        List matchConfigBOs = quickConfigCache.stream().filter(bo -> bo.getId().equals(configId)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(matchConfigBOs)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u52a0\u8f7d\u5230\u62a5\u9500\u6d41\u7a0b\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"QuickReimburseListMob_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        QuickConfigBo quickConfigBo = (QuickConfigBo)matchConfigBOs.get(0);
        AbstractQuickReimburseService process = this.factory.getQuickReimburseService(quickConfigBo, this.getView());
        if (process == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u52a0\u8f7d\u5230\u62a5\u9500\u6d41\u7a0b\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"QuickReimburseListMob_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        process.setPlugin((AbstractBillPlugIn)this);
        process.create();
    }

    private List<QuickConfigBo> loadCacheQuickReimConfig() {
        List<Object> quickConfigBos = new ArrayList<QuickConfigBo>();
        String configCache = this.getPageCache().get("reimconfig");
        if (StringUtils.isNotEmpty((CharSequence)configCache)) {
            quickConfigBos = JSONArray.parseArray((String)configCache, QuickConfigBo.class);
        }
        return quickConfigBos;
    }

    private List<ControlAp> createApControls(List<QuickConfigBo> configs) {
        ArrayList<ControlAp> controlItems = new ArrayList<ControlAp>(configs.size());
        for (QuickConfigBo config : configs) {
            MBlockMenuItemAp ap = new MBlockMenuItemAp();
            ap.setName(new LocaleString(config.getName()));
            ap.setKey(config.getId().toString());
            ap.setImageKey(config.getMenuImg());
            controlItems.add((ControlAp)ap);
        }
        return controlItems;
    }

    public void click(MobileSearchTextChangeEvent event) {
        String searchText = event.getText();
        List<QuickConfigBo> quickReimConfig = this.loadCacheQuickReimConfig();
        Container reimBlock = (Container)this.getControl(BLOCK_PANEL);
        String[] objects = (String[])quickReimConfig.stream().map(config -> config.getId().toString()).toArray(String[]::new);
        reimBlock.deleteControls(objects);
        List<QuickConfigBo> searchConfigs = quickReimConfig.stream().filter(config -> config.getName().contains(searchText)).collect(Collectors.toList());
        List<ControlAp> apControls = this.createApControls(searchConfigs);
        List controlItems = apControls.stream().map(apControl -> apControl.createControl()).collect(Collectors.toList());
        reimBlock.addControls(controlItems);
        this.getView().updateView();
    }
}

