/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.util.InvoiceProcessUtil;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.CopyInvoiceVOToInvoiceEntryBOServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.OffsetAmountInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DailyReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateExpenseItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoicesInOneServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveDuplicateInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoiceForReimInOneExpenseItem
extends AbstractImportInvoicePlugin {
    private static final Log log = LogFactory.getLog(AbstractImportInvoiceForReimInOneExpenseItem.class);

    @Override
    protected String getCloseCallBackKey() {
        return "selectinvoiceallinone";
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)this.getCloseCallBackKey())) {
            if (ErStdConfig.isDev() && !ErStdConfig.getShowImportInvoiceDataSimulatorPC()) {
                QueryBySerialNoAction action = new QueryBySerialNoAction("test");
                String apiReturnJson = action.execute();
                try {
                    List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                    this.executeProcess(invoiceVOs);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.getView().showErrorNotification(e.getMessage());
                }
            } else {
                this.showSelectedInvoicePage(this.getExtView(), itemKey);
            }
        }
    }

    @Override
    public void processInvoiceVO(InvoiceContext invoiceContext) throws InvoiceCloudException {
        IDataModel model = this.getModel();
        BeforeImportInvoiceService beforeImportServiceImpl = this.getBeforeImportInvoiceServiceImpl(invoiceContext);
        RemoveInvoiceService removeDuplicateInvoiceService = this.getRemoveDuplicateInvoiceServiceImpl(invoiceContext);
        PreHandleInvoiceService addInvoiceItemService = this.getPreHandleInvoiceServiceImpl(invoiceContext);
        CopyInvoiceVOToInvoiceEntryBOServiceImpl copyInvoiceVOToInvoiceEntryBOService = new CopyInvoiceVOToInvoiceEntryBOServiceImpl(invoiceContext, this.getView().getEntityId());
        OffsetAmountInvoiceServiceImpl offsetAmountInvoiceService = new OffsetAmountInvoiceServiceImpl(invoiceContext);
        MappingItemWithOrgInvoiceServiceImp mappingExpenseOrTripItemInvoiceService = new MappingItemWithOrgInvoiceServiceImp(invoiceContext, MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem, model.getDataEntity(true));
        MergeInvoiceService mergeInvoiceServiceImpl = this.getMergeInvoiceService(invoiceContext);
        CreateInvoiceServiceI createInvoiceEntryServiceImpl = this.getCreateInvoiceService(invoiceContext);
        IInvoiceService createExpenseOrTripItemService = this.getCreateExpenseOrTripItemService(invoiceContext);
        this.addProcessServices(new IInvoiceService[]{beforeImportServiceImpl, removeDuplicateInvoiceService, addInvoiceItemService, copyInvoiceVOToInvoiceEntryBOService, offsetAmountInvoiceService, mappingExpenseOrTripItemInvoiceService, mergeInvoiceServiceImpl, createInvoiceEntryServiceImpl, createExpenseOrTripItemService});
    }

    @Override
    public BeforeImportInvoiceService getBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new DailyReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public RemoveInvoiceService getRemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new RemoveDuplicateInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public MergeInvoiceService getMergeInvoiceService(InvoiceContext invoiceContext) {
        MergeInvoicesInOneServiceImpl mergeInvoiceServiceImpl = new MergeInvoicesInOneServiceImpl(invoiceContext, this.getView().getEntityId(), this.getModel());
        return mergeInvoiceServiceImpl;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateExpenseItemEntryServiceImpl createExpenseOrTripItemService = new CreateExpenseItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
        return createExpenseOrTripItemService;
    }

    @Override
    public PreHandleInvoiceService getPreHandleInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new PreHandleInvoiceServiceImpl(invoiceContext);
    }

    @Override
    public CreateInvoiceServiceI getCreateInvoiceService(InvoiceContext invoiceContext) {
        return new CreateInvoiceEntryServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("company");
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        InvoiceProcessUtil.updateInvoiceValidateSummary((IFormView)this.getExtView());
    }

    @Override
    protected String getClickKey() {
        return "selectinvoiceallinone";
    }
}

