/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.CopyInvoiceVOToInvoiceEntryBOServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.OffsetAmountInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimPCPlugin;
import org.apache.commons.lang3.StringUtils;

public class HandleInvoiceForSSCPluginV2
extends AbstractImportInvoiceForReimPCPlugin {
    private static final Log log = LogFactory.getLog(HandleInvoiceForSSCPluginV2.class);

    @Override
    protected String getCloseCallBackKey() {
        return "importinvoice";
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject newCostCompanyDO = (DynamicObject)this.getModel().getValue("costcompany");
        if (newCostCompanyDO != null) {
            boolean invoiceIsEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)((Long)newCostCompanyDO.getPkValue()));
            if (invoiceIsEnabled) {
                log.info("\u5171\u4eab\u5ba1\u6279\u754c\u9762: \u8be5\u8d39\u7528\u627f\u62c5\u516c\u53f8\u542f\u7528\u53d1\u7968\u4e91\u4e86.");
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advcontoolbarap31", "advcontoolbarap22"});
            } else {
                log.info("\u5171\u4eab\u5ba1\u6279\u754c\u9762: \u8be5\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u542f\u7528\u53d1\u7968\u4e91.");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap31", "advcontoolbarap22"});
            }
            log.info("\u5171\u4eab\u5ba1\u6279\u754c\u9762,\u8d39\u7528\u627f\u62c5\u516c\u53f8\u662f: " + SerializationUtils.toJsonString((Object)newCostCompanyDO));
        } else {
            log.info("\u5171\u4eab\u5ba1\u6279\u754c\u9762,\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a.");
        }
        int invoiceCount = this.getModel().getEntryRowCount("invoiceentry");
        AdvContainer invoiceHeadAdvCtn = (AdvContainer)this.getControl("invoice_entry_container");
        if (invoiceCount > 0) {
            invoiceHeadAdvCtn.setCollapse(false);
        } else {
            invoiceHeadAdvCtn.setCollapse(true);
        }
    }

    @Override
    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] rowIndexs = e.getRowIndexs();
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
            Set invoiceHeadWithExpenseItemIds = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItem -> !Objects.equals(invoiceItem.getLong("itementryid"), 0L)).map(invoiceItem -> invoiceItem.getLong("invoiceheadentryid")).collect(Collectors.toSet());
            ArrayList notAllowDeleteInvoiceRowIndexs = Lists.newArrayList();
            for (int rowIndex : rowIndexs) {
                DynamicObject invoiceHeadDO = (DynamicObject)invoiceHeadEntryDOs.get(rowIndex);
                Object invoiceHeadId = invoiceHeadDO.getPkValue();
                if (!invoiceHeadWithExpenseItemIds.contains(invoiceHeadId)) continue;
                notAllowDeleteInvoiceRowIndexs.add(rowIndex + 1);
            }
            if (!notAllowDeleteInvoiceRowIndexs.isEmpty()) {
                e.setCancel(true);
                String info = notAllowDeleteInvoiceRowIndexs.stream().map(i -> String.format(ResManager.loadKDString((String)"\u7b2c%1$s %2$s", (String)"HandleInvoiceForSSCPluginV2_3", (String)"fi-er-formplugin", (Object[])new Object[0]), i, ResManager.loadKDString((String)"\u884c", (String)"HandleInvoiceForSSCPluginV2_1", (String)"fi-er-formplugin", (Object[])new Object[0]))).collect(Collectors.joining(","));
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u201c%s\u201d\u4e0d\u662f\u5171\u4eab\u5bfc\u5165\u53d1\u7968\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"HandleInvoiceForSSCPluginV2_2", (String)"fi-er-formplugin", (Object[])new Object[0]), info));
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)this.getCloseCallBackKey())) {
            if (ErStdConfig.isDev()) {
                QueryBySerialNoAction action = new QueryBySerialNoAction("test");
                String apiReturnJson = action.execute();
                try {
                    List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                    this.executeProcess(invoiceVOs);
                }
                catch (InvoiceCloudException e) {
                    log.error((Throwable)e);
                }
            } else {
                this.showSelectedInvoicePage(this.getExtView(), itemKey);
            }
        }
    }

    @Override
    public void processInvoiceVO(InvoiceContext invoiceContext) {
        BeforeImportInvoiceService beforeImportServiceImpl = this.getBeforeImportInvoiceServiceImpl(invoiceContext);
        RemoveInvoiceService removeDuplicateInvoiceService = this.getRemoveDuplicateInvoiceServiceImpl(invoiceContext);
        PreHandleInvoiceService addInvoiceItemService = this.getPreHandleInvoiceServiceImpl(invoiceContext);
        CopyInvoiceVOToInvoiceEntryBOServiceImpl copyInvoiceVOToInvoiceEntryBOService = new CopyInvoiceVOToInvoiceEntryBOServiceImpl(invoiceContext, this.getView().getEntityId());
        OffsetAmountInvoiceServiceImpl offsetAmountInvoiceService = new OffsetAmountInvoiceServiceImpl(invoiceContext);
        CreateInvoiceServiceI createInvoiceEntryServiceImpl = this.getCreateInvoiceService(invoiceContext);
        this.addProcessServices(new IInvoiceService[]{beforeImportServiceImpl, removeDuplicateInvoiceService, addInvoiceItemService, copyInvoiceVOToInvoiceEntryBOService, offsetAmountInvoiceService, createInvoiceEntryServiceImpl});
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.updateInvoiceValidateSummary(this.getView());
    }

    @Override
    protected String getItemEntryEntityKey() {
        return "";
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return null;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"offset_invoice")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Boolean isOffset = (Boolean)e.getChangeSet()[0].getNewValue();
            BigDecimal offsetAmount = BigDecimal.ZERO;
            if (isOffset.booleanValue()) {
                offsetAmount = (BigDecimal)this.getModel().getValue("taxamount_invoice", rowIndex);
            }
            this.getModel().setValue("offsetamount", (Object)offsetAmount, rowIndex);
        }
    }

    @Override
    public void valiateAllInvoice() {
    }

    @Override
    public void valiateSelectedInvocie() {
    }

    @Override
    protected String getClickKey() {
        return "importinvoice";
    }
}

