/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceIframeUrlReqParam;
import kd.fi.er.business.utils.AttachmentCountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.ImportAttachmentPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoiceMobClientInterface;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;

public class ImportAttachmentMobPlugin
extends ImportAttachmentPlugin
implements InvoiceMobClientInterface {
    private static final Log logger = LogFactory.getLog(ImportAttachmentMobPlugin.class);
    private static final String INVOICE_ATTACH_COUNT = "invoiceattachcount";
    private static final String INVOICE_ATTACH_TOOLBAR = "invoicecloudtoolbar";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        String[] controlIds = new String[]{"selectinvoice", "viewinvoice"};
        this.addClickListeners(controlIds);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control ctl = (Control)source;
            String key = ctl.getKey();
            if (key.equalsIgnoreCase("selectinvoice")) {
                this.setClickKey(key);
                this.showSelectInvoiceMobPage();
            } else if (key.equalsIgnoreCase("viewinvoice")) {
                if (this.getModel().getProperty("invoiceattachinfo") != null && this.getView().getModel().getEntryRowCount("invoiceattachinfo") == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53d1\u7968\u9644\u4ef6\u6570\u636e\u3002", (String)"ImportAttachmentMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setClickKey("delete_attach_callback_key");
                this.showDeleteAttachPage();
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
        this.setInvoiceAttachCount();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Object operation = afterDoOperationEventArgs.getSource();
        if (operation instanceof Save || operation instanceof Submit) {
            this.setInvoiceAttachCount();
        }
    }

    @Override
    protected void setInvoiceCloudEnable(DynamicObject costCompany) {
        super.setInvoiceCloudEnable(costCompany);
        boolean invoiceIsEnabled = false;
        String proName = this.invoiceCloudEnableKey();
        if (this.getModel().getDataEntityType().getProperty(proName) != null) {
            invoiceIsEnabled = (Boolean)this.getModel().getValue(proName);
        }
        this.getView().setVisible(Boolean.valueOf(invoiceIsEnabled), new String[]{INVOICE_ATTACH_TOOLBAR});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB") && (returnData = event.getReturnData()) instanceof JSONObject) {
            JSONObject importInvoiceReturnData = (JSONObject)returnData;
            logger.info("\u661f\u701a\u53d1\u7968\u4e91\u5bfc\u5165\u53d1\u7968\uff0creturnData: {}", (Object)importInvoiceReturnData);
            SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
            if (simpleXhInvoiceVO != null && simpleXhInvoiceVO.getAttachData() != null) {
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            }
        }
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
        this.setInvoiceAttachCount();
    }

    private void showSelectInvoiceMobPage() {
        ImportInvoiceIframeUrlReqParam importRequestParam = new ImportInvoiceIframeUrlReqParam();
        importRequestParam.setBillId(this.getBillId());
        DynamicObject costCompanyDO = this.getCostCompanyDO();
        if (costCompanyDO == null) {
            return;
        }
        importRequestParam.setInvoiceCompanyId((Long)costCompanyDO.getPkValue());
        importRequestParam.setTaxRegNum(this.getTaxRegNum());
        importRequestParam.setEntityName(this.getModel().getDataEntityType().getName());
        InvoiceService.getInstanceService().showImportInvoicePageInMob((AbstractFormPlugin)this, this.getModel(), new CloseCallBack((IFormPlugin)this, "IMPORT_INVOICE_IN_MOB"), importRequestParam);
    }

    private String getBillId() {
        Long billId = ErCommonUtils.genBillIdIfNotExist((IDataModel)this.getModel());
        return String.valueOf(billId);
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        this.setInvoiceAttachCount();
    }

    private void setInvoiceAttachCount() {
        IFormView view = this.getView();
        long count = AttachmentCountUtils.getInvoiceAttachmentCount((IFormView)view);
        Label countLabel = (Label)view.getControl(INVOICE_ATTACH_COUNT);
        countLabel.setText(String.format("\uff08%d\uff09", count));
        view.updateView(countLabel.getKey());
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equalsIgnoreCase("invoiceattachinfo")) {
            this.setInvoiceAttachCount();
        }
    }

    @Override
    protected String getCloseCallBackKey() {
        return "IMPORT_INVOICE_IN_MOB";
    }
}

