/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DailyReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateExpenseItemEntryForMobServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalMergeExpenseOrTripItemInvoiceForMobServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimMobByItemEntry;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;

public class ImportInvoiceForDailyReimMobInOneExpenseItem
extends AbstractImportInvoiceForReimMobByItemEntry
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(ImportInvoiceForDailyReimMobInOneExpenseItem.class);

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
    }

    @Override
    public BeforeImportInvoiceService getBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new DailyReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        IDataModel model = this.getModel();
        IFormView pView = this.getView().getParentView();
        IDataModel pModel = pView.getModel();
        return new CreateExpenseItemEntryForMobServiceImpl(invoiceContext, model, pModel, this.getSelectedItem());
    }

    @Override
    public IncrementalServiceI getIncrementalService(InvoiceContext invoiceContext, int currIndex) {
        IncrementalMergeExpenseOrTripItemInvoiceForMobServiceImp incrementalServiceImpl = new IncrementalMergeExpenseOrTripItemInvoiceForMobServiceImp(invoiceContext, currIndex, -1);
        return incrementalServiceImpl;
    }

    @Override
    public boolean isPc() {
        return false;
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getControl("expenseentryentity") != null) {
            ((EntryGrid)this.getControl("expenseentryentity")).addHyperClickListener((HyperLinkClickListener)this);
        }
        this.addClickListeners(new String[]{"invoicenolabel"});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u6570\u636e\u7c7b\u578b\uff1a " + returnData.getClass().getName());
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getView().getParentView().getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            this.invoiceDeletePageRule(this.isDeleting());
        }
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        IDataModel model;
        IFormView view = this.getView();
        IFormView pView = view.getParentView();
        if (pView != null && (model = pView.getModel()).getDataEntityType().getProperty("company") != null) {
            return (DynamicObject)model.getValue("company");
        }
        return dataEntity.getDynamicObject("company");
    }

    @Override
    public IFormView getExtView() {
        return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        int rowIndex = arg0.getRowIndex();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"invoiceno_entry")) {
            this.showInvoiceListInMiniProg(rowIndex);
        }
    }

    private void showInvoiceListInMiniProg(int rowCurrIndex) {
        ArrayList<String> serialNos = new ArrayList<String>();
        IDataModel showInvoiceModel = this.getModel();
        DynamicObjectCollection expenseItemEntryDOs = showInvoiceModel.getEntryEntity("expenseentryentity");
        DynamicObjectCollection invoiceHeadEntryDOs = showInvoiceModel.getEntryEntity("invoiceentry");
        DynamicObjectCollection invoiceItemEntryDOs = showInvoiceModel.getEntryEntity("invoiceitementry");
        DynamicObject expenseItemEntryDO = (DynamicObject)expenseItemEntryDOs.get(rowCurrIndex);
        Long itemEntryID = (Long)expenseItemEntryDO.getPkValue();
        if (expenseItemEntryDO.getBoolean("invoicefromparent") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)expenseItemEntryDO.getString("splitline"))) {
            itemEntryID = Long.parseLong(expenseItemEntryDO.getString("splitline"));
        }
        Long finalItemEntryID = itemEntryID;
        Set invoiceHeadEntryIds = invoiceItemEntryDOs.stream().filter(invoiceItem -> Objects.equals(invoiceItem.getLong("itementryid"), finalItemEntryID)).map(invoiceItem -> invoiceItem.getLong("invoiceheadentryid")).collect(Collectors.toSet());
        DynamicObjectCollection invoiceAndExpenseEntrys = showInvoiceModel.getEntryEntity("invoiceandexpense");
        Set invoiceHeads = invoiceAndExpenseEntrys.stream().filter(entry -> Objects.equals(finalItemEntryID, entry.getLong("expenseentryid"))).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
        invoiceHeadEntryIds.addAll(invoiceHeads);
        serialNos.addAll(invoiceHeadEntryDOs.stream().filter(invoiceHead -> invoiceHeadEntryIds.contains(invoiceHead.getPkValue())).map(invoiceHead -> invoiceHead.getString("serialno")).collect(Collectors.toList()));
        log.info("\u70b9\u51fb\u53d1\u7968\u8d85\u94fe\u63a5\uff0cserialno: " + serialNos);
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        ShowInvoiceCloudPageUtil.showInvoiceListInMiniProgram((AbstractFormPlugin)this, config, serialNos, showInvoiceModel);
    }

    @Override
    public DynamicObject getCostCompanyDO() {
        IDataModel model = this.getModel();
        if (model.getProperty("costcompany") != null && model.getValue("costcompany") != null) {
            return (DynamicObject)model.getValue("costcompany");
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && parentView.getModel().getProperty("costcompany") != null && parentView.getModel().getValue("costcompany") != null) {
            return (DynamicObject)parentView.getModel().getValue("costcompany");
        }
        return null;
    }

    @Override
    protected boolean isUseExpenseDate() {
        return false;
    }

    @Override
    protected Set<String> getCurrentPageInvoiceSerialNos() {
        IDataModel model = this.getModel();
        IFormView pView = this.getView().getParentView();
        IDataModel pModel = pView.getModel();
        DynamicObjectCollection pInvoiceEntryDOs = pModel.getEntryEntity("invoiceentry");
        DynamicObjectCollection invoiceEntryDOs = model.getEntryEntity("invoiceentry");
        HashSet serialNosFromPage = Sets.newHashSet();
        serialNosFromPage.addAll(invoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getString("serialno")).collect(Collectors.toSet()));
        serialNosFromPage.addAll(pInvoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getString("serialno")).collect(Collectors.toSet()));
        return serialNosFromPage;
    }

    @Override
    protected int getCurrentIndex() {
        return this.getModel().getEntryCurrentRowIndex("expenseentryentity");
    }

    @Override
    protected Long getOrSetSelectedExpenseEntryId() {
        DynamicObject selectedItem = this.getSelectedItem();
        return selectedItem.getLong("id");
    }

    @Override
    protected DynamicObject getSelectedItem() {
        int currentIndex = this.getCurrentIndex();
        DynamicObject curSelectedItem = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity").get(currentIndex);
        long id = curSelectedItem.getLong("id");
        if (id == 0L) {
            id = ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType());
            curSelectedItem.set("id", (Object)id);
        }
        return curSelectedItem;
    }
}

