/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DailyReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripItemEntryServiceImplForMob;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceEntryServiceImpForTripMob;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalMergeExpenseOrTripItemInvoiceForMobServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimMobByItemEntry;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimMobInOneExpenseItem
extends AbstractImportInvoiceForReimMobByItemEntry {
    private static final Log log = LogFactory.getLog(ImportInvoiceForTripReimMobInOneExpenseItem.class);

    @Override
    public BeforeImportInvoiceService getBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new DailyReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateTripItemEntryServiceImplForMob createExpenseOrTripItemService = new CreateTripItemEntryServiceImplForMob(invoiceContext, this.getModel());
        return createExpenseOrTripItemService;
    }

    @Override
    public CreateInvoiceServiceI getCreateInvoiceService(InvoiceContext invoiceContext) {
        return new CreateInvoiceEntryServiceImpForTripMob(invoiceContext, this.getOrSetSelectedExpenseEntryId(), (AbstractFormPlugin)this);
    }

    @Override
    public IncrementalServiceI getIncrementalService(InvoiceContext invoiceContext, int index) {
        Integer parentIndex;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Integer expenseItemIndex = (Integer)customParams.get("index");
        if (expenseItemIndex == null) {
            expenseItemIndex = -1;
        }
        if ((parentIndex = (Integer)customParams.get("parentIndex")) == null) {
            parentIndex = -1;
        }
        IncrementalMergeExpenseOrTripItemInvoiceForMobServiceImp incrementServiceImpl = new IncrementalMergeExpenseOrTripItemInvoiceForMobServiceImp(invoiceContext, expenseItemIndex.intValue(), parentIndex.intValue());
        return incrementServiceImpl;
    }

    @Override
    protected String getCloseCallBackKey() {
        return null;
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
    }

    @Override
    public boolean isPc() {
        return false;
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"expenseitem")) {
            this.refreshSingle();
        }
    }

    @Override
    public IInvoiceService getMappingItemImpl(InvoiceContext invoiceContext) {
        IFormView view = this.getExtView();
        IDataModel model = view.getModel();
        MappingItemWithOrgInvoiceServiceImp mappingService = new MappingItemWithOrgInvoiceServiceImp(invoiceContext, this.getBillType(), Objects.requireNonNull(model).getDataEntity(true));
        return mappingService;
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.refreshInvoicNoLbl(this.getView());
    }

    protected void refreshSingle() {
        IDataModel model = this.getModel();
        DynamicObject expense = (DynamicObject)model.getValue("expenseitem");
        if (ItemFrom.TripBusiness.getValue().equals(model.getValue("itemfrom"))) {
            log.info("\u5546\u65c5\u4e0d\u8d70\u8fd9\u6bb5\u903b\u8f91");
            return;
        }
        IFormView pView = this.getView().getParentView();
        IDataModel pModel = pView.getModel();
        Set invoiceIds = pModel.getDataEntity(true).getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItem -> Objects.equals(this.getOrSetSelectedExpenseEntryId(), invoiceItem.getLong("itementryid"))).map(invoiceItem -> invoiceItem.getLong("invoiceheadentryid")).collect(Collectors.toSet());
        IPageCache pageCache = this.getPageCache();
        String invoiceEntry = pageCache.get("invoiceentry" + this.getOrSetSelectedExpenseEntryId());
        List invoiceEntryBOs = JSONArray.parseArray((String)invoiceEntry, InvoiceEntryBO.class);
        String invoiceItemEntry = pageCache.get("invoiceitementry" + this.getOrSetSelectedExpenseEntryId());
        List invoiceItemEntryBOs = JSONArray.parseArray((String)invoiceItemEntry, InvoiceItemEntryBO.class);
        if (invoiceItemEntryBOs != null) {
            invoiceIds.addAll(invoiceItemEntryBOs.stream().filter(invoiceItem -> invoiceItem.getExpenseEntryBO() != null && Objects.equals(this.getOrSetSelectedExpenseEntryId(), invoiceItem.getExpenseEntryBO().getEntryId())).map(invoiceItem -> invoiceItem.getInvoiceEntryBO().getEntryId()).collect(Collectors.toSet()));
        }
        long companyId = (Long)((DynamicObject)pView.getParentView().getModel().getValue("company")).getPkValue();
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer((IDataModel)pView.getParentView().getModel());
        boolean isSpecialInvoice = false;
        boolean isOffset = false;
        if (invoiceIds.isEmpty()) {
            if (expense != null) {
                isOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)companyId);
                isOffset = isOffset && expense.getBoolean("isoffset");
            }
        } else {
            DynamicObjectCollection invoiceEntrys;
            List currentList;
            if (invoiceEntryBOs != null) {
                isSpecialInvoice = invoiceEntryBOs.stream().allMatch(item -> Objects.equals(item.getInvoiceType(), InvoiceTypeEnum.key_4.getValue()) || Objects.equals(item.getInvoiceType(), InvoiceTypeEnum.key_2.getValue()));
            }
            if (invoiceItemEntryBOs != null) {
                isOffset = ErStdConfig.getInvoicesCredits() ? invoiceItemEntryBOs.stream().anyMatch(item -> item.getIsOffset()) : invoiceItemEntryBOs.stream().anyMatch(item -> item.getInvoiceCloudOffset());
            }
            if (!(currentList = (invoiceEntrys = pModel.getDataEntity(true).getDynamicObjectCollection("invoiceentry")).stream().filter(item -> invoiceIds.contains(item.getPkValue())).collect(Collectors.toList())).isEmpty()) {
                DynamicObjectCollection invoiceItemEntrys = pModel.getDataEntity(true).getDynamicObjectCollection("invoiceitementry");
                List itemList = invoiceItemEntrys.stream().filter(item -> invoiceIds.contains(item.get("invoiceheadentryid"))).collect(Collectors.toList());
                boolean isSpecialInvoiceEntry = currentList.stream().allMatch(item -> Objects.equals(item.getString("invoicetype"), InvoiceTypeEnum.key_4.getValue()) || Objects.equals(item.getString("invoicetype"), InvoiceTypeEnum.key_2.getValue()));
                boolean isOffsetEntry = InvoiceOffsetUtils.isInvoiceOffset(itemList);
                isSpecialInvoice = invoiceEntryBOs == null && invoiceItemEntryBOs == null ? isSpecialInvoiceEntry : isSpecialInvoiceEntry && isSpecialInvoice;
                boolean bl = isOffset = isOffset || isOffsetEntry;
            }
        }
        if (expense != null) {
            isOffset = isOffset && isOrgOffset && expense.getBoolean("isoffset");
        }
        model.setValue("offset", (Object)isOffset);
        BigDecimal deductibletax = BigDecimal.ZERO;
        if (isOffset) {
            deductibletax = (BigDecimal)model.getValue("taxamount");
        }
        model.setValue("deductibletax", (Object)deductibletax);
        model.setValue("isvactax", (Object)isSpecialInvoice);
    }

    protected void refreshInvoicNoLbl(IFormView view) {
        Object invoiceno = view.getModel().getValue("invoiceno_entry");
        if (invoiceno != null && view.getControl("invoicenolabel") != null) {
            ((Label)view.getControl("invoicenolabel")).setText(invoiceno.toString());
        }
    }

    protected List<String> getSerialNos(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        long itemId = this.getOrSetSelectedExpenseEntryId();
        Map itemInvoiceMap = InvoiceUtils.autoMapInvoiceMappingInfo((DynamicObject)dataEntity);
        Map InvoiceMap = InvoiceUtils.nonAutoMapInvoiceMappingInfo((DynamicObject)dataEntity);
        HashSet invoiceIds = new HashSet(16);
        Set autoInvoices = (Set)itemInvoiceMap.get(itemId);
        Set noAutoInvoices = (Set)InvoiceMap.get(itemId);
        if (autoInvoices != null) {
            invoiceIds.addAll(autoInvoices);
        }
        if (noAutoInvoices != null) {
            invoiceIds.addAll(noAutoInvoices);
        }
        if (invoiceIds == null || invoiceIds.isEmpty()) {
            return Collections.emptyList();
        }
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        List<String> serialNosFromPage = invoiceEntryDOs.stream().filter(invoiceEntryDO -> invoiceIds.contains(ErCommonUtils.getPk((Object)invoiceEntryDO))).map(invoiceEntryDO -> invoiceEntryDO.getString("serialno")).collect(Collectors.toList());
        return serialNosFromPage;
    }

    private Set<String> getBillInvoiceSerialNos(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        Set<String> serialNosFromPage = invoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getString("serialno")).collect(Collectors.toSet());
        return serialNosFromPage;
    }

    protected List<String> getSerialNosToCache() {
        ArrayList<String> serialNosFromPage = new ArrayList<String>();
        Long expenseId = this.getOrSetSelectedExpenseEntryId();
        IPageCache pageCache = this.getPageCache();
        String invoiceEntry = pageCache.get("invoiceentry" + expenseId);
        if (StringUtils.isNotBlank((CharSequence)invoiceEntry)) {
            List invoiceEntryBOs = JSONArray.parseArray((String)invoiceEntry, InvoiceEntryBO.class);
            serialNosFromPage.addAll(invoiceEntryBOs.stream().map(item -> item.getSerialNo()).collect(Collectors.toList()));
        }
        return serialNosFromPage;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"importinvoiceallforone", "invoicenolabel", "importinvoicemergebyitem"});
    }

    @Override
    public void click(EventObject evt) {
        Control ctl;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control && StringUtils.equals((CharSequence)(key = (ctl = (Control)source).getKey()), (CharSequence)"invoicenolabel")) {
            this.showInvoices();
        }
    }

    private void showInvoices() {
        ArrayList<String> serialNosFromPage = new ArrayList<String>();
        IFormView pView = this.getView().getParentView();
        IDataModel showInvoiceModel = this.getModel();
        if (pView != null) {
            serialNosFromPage.addAll(this.getSerialNos(pView));
            showInvoiceModel = pView.getModel();
            IFormView headView = pView.getParentView();
            if (headView != null) {
                showInvoiceModel = headView.getModel();
            }
        }
        serialNosFromPage.addAll(this.getSerialNosToCache());
        log.info("\u70b9\u51fb\u53d1\u7968\u8d85\u94fe\u63a5\uff0cserialno: " + serialNosFromPage);
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        ShowInvoiceCloudPageUtil.showInvoiceListInMiniProgram((AbstractFormPlugin)this, config, serialNosFromPage, showInvoiceModel);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + importInvoiceReturnData.toJSONString());
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getView().getParentView().getParentView().getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            this.invoiceDeletePageRule(this.isDeleting());
        }
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
    }

    @Override
    public DynamicObject getCostCompanyDO() {
        IFormView billHeadView;
        IFormView pView;
        DynamicObject costCompanyDO = null;
        IFormView view = this.getView();
        if (view != null && (pView = view.getParentView()) != null && (billHeadView = pView.getParentView()) != null) {
            costCompanyDO = (DynamicObject)billHeadView.getModel().getValue(this.getCostCompanyKey());
        }
        return costCompanyDO;
    }

    protected Boolean isAutoMapInvoice() {
        IFormView billHeadView;
        IFormView pView;
        IFormView view = this.getView();
        if (view != null && (pView = view.getParentView()) != null && (billHeadView = pView.getParentView()) != null) {
            return billHeadView.getModel().getDataEntity(true).getBoolean("automapinvoice");
        }
        return Boolean.TRUE;
    }

    @Override
    protected Long getOrSetSelectedExpenseEntryId() {
        Long enpenseid = (Long)this.getModel().getValue("enpenseid");
        return enpenseid;
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        IDataModel model;
        IFormView headView;
        IFormView view = this.getView();
        IFormView pView = view.getParentView();
        if (pView != null && (headView = pView.getParentView()) != null && (model = headView.getModel()).getDataEntityType().getProperty("company") != null) {
            return (DynamicObject)model.getValue("company");
        }
        return dataEntity.getDynamicObject("company");
    }

    @Override
    public void afterBindData(EventObject e) {
        Object invoiceno = this.getModel().getValue("invoiceno_entry");
        if (invoiceno != null && this.getControl("invoicenolabel") != null) {
            ((Label)this.getControl("invoicenolabel")).setText(invoiceno.toString());
        }
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateInvoiceCloudEnable();
    }

    @Override
    public Set<String> getCurrentPageInvoiceSerialNos() {
        IFormView pView = this.getExtView();
        HashSet serialNosFromPage = Sets.newHashSet();
        if (pView != null) {
            serialNosFromPage.addAll(this.getBillInvoiceSerialNos(pView));
        }
        serialNosFromPage.addAll(this.getSerialNosToCache());
        return serialNosFromPage;
    }

    @Override
    public IFormView getExtView() {
        return this.getView().getParentView();
    }

    @Override
    protected boolean isUseExpenseDate() {
        return false;
    }

    @Override
    protected DynamicObject getSelectedItem() {
        return this.getModel().getDataEntity(true);
    }

    @Override
    protected int getCurrentIndex() {
        return -1;
    }
}

