/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripEntryEntityServiceImplForMob;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalMergeExpenseOrTripItemInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingTripItemForMobImpl;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimMobByItemEntry;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimMobMergeExpenseItem
extends AbstractImportInvoiceForReimMobByItemEntry {
    private static final Log log = LogFactory.getLog(ImportInvoiceForTripReimMobMergeExpenseItem.class);
    private static final String[] requiredProps = new String[]{"from", "to", "startdate", "enddate", "vehicles", "tripexpenseitem"};

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateTripEntryEntityServiceImplForMob createExpenseItemEntryServiceImpl = new CreateTripEntryEntityServiceImplForMob(invoiceContext, this.getModel());
        createExpenseItemEntryServiceImpl.setCurSelectedItem(this.getSelectedItem());
        return createExpenseItemEntryServiceImpl;
    }

    @Override
    public IInvoiceService getMappingItemImpl(InvoiceContext invoiceContext) {
        return new MappingTripItemForMobImpl(invoiceContext, this.getSelectedItem());
    }

    @Override
    protected int getCurrentIndex() {
        return this.getModel().getEntryCurrentRowIndex("entryentity");
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"importinvoicemergebyitem", "invoice_add"});
    }

    @Override
    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control ctl = (Control)source;
            String key = ctl.getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"invoice_add")) {
                this.importInvoiceMob("invoice_add");
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"importinvoicemergebyitem")) {
                if (!this.requiredProps(this.getModel(), requiredProps)) {
                    return;
                }
                this.getModel().setValue("editentry", (Object)"4");
            }
        }
    }

    private boolean requiredProps(IDataModel model, String[] props) {
        for (String propName : props) {
            IDataEntityProperty property = model.getProperty(propName);
            Object propValue = model.getValue(propName);
            if (propValue != null) continue;
            String displayNameStr = null;
            try {
                LocaleString displayName = (LocaleString)property.getClass().getMethod("getDisplayName", new Class[0]).invoke((Object)property, new Object[0]);
                displayNameStr = displayName.getLocaleValue();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error((Throwable)e);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"ImportInvoiceForTripReimMobMergeExpenseItem_0", (String)"fi-er-formplugin", (Object[])new Object[0]), displayNameStr));
            return false;
        }
        return true;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + importInvoiceReturnData.toJSONString());
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getView().getParentView().getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            this.invoiceDeletePageRule(this.isDeleting());
        }
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
    }

    @Override
    protected boolean isUseExpenseDate() {
        return false;
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return (DynamicObject)this.getModel().getValue("company");
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        Control cot = (Control)evt.getSource();
        String key = cot.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"invoice_add")) {
            this.checkInvoiceImport(evt, key);
        }
    }

    @Override
    public IncrementalServiceI getIncrementalService(InvoiceContext invoiceContext, int index) {
        return new IncrementalMergeExpenseOrTripItemInvoiceServiceImp(invoiceContext, this.getModel(), true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        switch (name) {
            case "taxamount": {
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex(), (ChangeField)ChangeField.TAX_AMOUNT);
                break;
            }
            case "iteminoutamount": {
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex());
                break;
            }
        }
    }

    @Override
    protected String getClickKey() {
        return "invoice_add";
    }
}

