/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.AfterCreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.TripRemoveSameItemServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceServiceImpl;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimPCPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.validator.InvoiceValidator;
import kd.fi.er.formplugin.invoicecloud.v2.validator.TripCardInvoiceCurrencyValidator;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimPCPlugin
extends AbstractImportInvoiceForReimPCPlugin {
    private static final Log log = LogFactory.getLog(ImportInvoiceForTripReimPCPlugin.class);
    private final String TRIP_ITEM_ENTRY = "entryentity";
    private final String TRIP_ENTRY = "tripentry";

    @Override
    public IInvoiceService getBeforeCreateItemServiceImpl(InvoiceContext invoiceContext) {
        return new TripRemoveSameItemServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hlcEvent) {
        super.hyperLinkClick(hlcEvent);
        String fieldName = hlcEvent.getFieldName();
        int tripItemRowIndex = hlcEvent.getRowIndex();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"invoiceno_entry")) {
            int tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject tripItemEntryDO = (DynamicObject)((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(tripRowIndex)).getDynamicObjectCollection("entryentity").get(tripItemRowIndex);
            String invoiceFrom = tripItemEntryDO.getString("itemfrom");
            if (StringUtils.equals((CharSequence)invoiceFrom, (CharSequence)InvoiceFrom.InvoiceCloud.getValue())) {
                Long tripItemEntryId;
                Long invoiceFromEntryId = tripItemEntryId = (Long)tripItemEntryDO.getPkValue();
                if (tripItemEntryDO.getBoolean("invoicefromparent")) {
                    invoiceFromEntryId = Long.parseLong(tripItemEntryDO.getString("splitline"));
                }
                List<String> serialNos = this.getSerialNosByItemEntryId(invoiceFromEntryId);
                String rawInvoiceNo = tripItemEntryDO.getString("invoiceno_entry");
                String rawInvoiceCode = tripItemEntryDO.getString("invoicelink");
                if (StringUtils.isNotEmpty((CharSequence)rawInvoiceNo) && StringUtils.isNotEmpty((CharSequence)rawInvoiceCode)) {
                    Set<String> invoiceNos = Arrays.stream(rawInvoiceNo.split(",")).collect(Collectors.toSet());
                    Set<String> invoiceCodes = Arrays.stream(rawInvoiceCode.split(",")).collect(Collectors.toSet());
                    invoiceNos.add(rawInvoiceNo);
                    invoiceCodes.add(rawInvoiceCode);
                    List<String> serialNosFromInvoiceMergeEntry = this.getSerialNosByInvoiceNoAndCode(invoiceNos, invoiceCodes);
                    serialNos.addAll(serialNosFromInvoiceMergeEntry);
                }
                Set invoiceEntryIds = dataEntity.getDynamicObjectCollection("invoiceandexpense").stream().filter(entry -> Objects.equals(entry.getLong("expenseentryid"), tripItemEntryId)).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
                Set mapSerialNos = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).map(entry -> entry.getString("serialno")).collect(Collectors.toSet());
                serialNos.addAll(mapSerialNos);
                this.showInvoiceList(serialNos);
            }
        }
    }

    @Override
    public MergeInvoiceService getMergeInvoiceService(InvoiceContext invoiceContext) {
        return new MergeInvoiceServiceImpl(invoiceContext, this.getView().getEntityId(), this.getModel());
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new CreateTripItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
    }

    @Override
    public IInvoiceService getAfterCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new AfterCreateTripItemEntryServiceImpl(this.getView(), invoiceContext);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        int tripEntryCount;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)this.getCloseCallBackKey()) && (tripEntryCount = this.getModel().getEntryRowCount("tripentry")) < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u884c\u7a0b\uff0c\u518d\u5bfc\u5165\u53d1\u7968\u3002", (String)"ImportInvoiceForTripReimPCPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    @Override
    protected String getItemEntryEntityKey() {
        return "entryentity";
    }

    @Override
    protected void editExpenseOrTripItemEntry(long expenseItemEntryId, AbstractImportInvoiceForReimPCPlugin.InvoiceEditItemBean invoiceEditItemBean) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tripEntrys = dataEntity.getDynamicObjectCollection("tripentry");
        for (int tripIndex = 0; tripIndex < tripEntrys.size(); ++tripIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntrys.get(tripIndex);
            model.setEntryCurrentRowIndex("tripentry", tripIndex);
            DynamicObjectCollection itemEntrys = tripEntry.getDynamicObjectCollection("entryentity");
            for (int itemIndex = 0; itemIndex < itemEntrys.size(); ++itemIndex) {
                DynamicObject itemEntry = (DynamicObject)itemEntrys.get(itemIndex);
                if (!Objects.equals(expenseItemEntryId, itemEntry.getPkValue())) continue;
                log.info("\u4fee\u6539\u7b2c" + (tripIndex + 1) + "\u884c\u884c\u7a0b, \u7b2c" + (itemIndex + 1) + "\u884c\u5dee\u65c5\u9879\u76ee\u6570\u636e");
                BigDecimal reimAmount = (BigDecimal)model.getValue("orientryamount", itemIndex, tripIndex);
                BigDecimal airportConstructionFeeAmount = (BigDecimal)model.getValue("airportconstructionfee", itemIndex, tripIndex);
                BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", itemIndex, tripIndex);
                BigDecimal excludedAmount = (BigDecimal)model.getValue("notaxamount", itemIndex, tripIndex);
                model.setValue("orientryamount", (Object)reimAmount.add(invoiceEditItemBean.getDeltaTotalAmount()), itemIndex, tripIndex);
                model.setValue("airportconstructionfee", (Object)airportConstructionFeeAmount.add(invoiceEditItemBean.getDeltaAirportConstructionFee()), itemIndex, tripIndex);
                model.setValue("taxamount", (Object)taxAmount.add(invoiceEditItemBean.getDeltaTaxAmount()), itemIndex, tripIndex);
                model.setValue("notaxamount", (Object)excludedAmount.add(invoiceEditItemBean.getDeltaExcludeTaxAmount()), itemIndex, tripIndex);
                model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)invoiceEditItemBean.getInvoiceNo()), itemIndex, tripIndex);
                model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)invoiceEditItemBean.getInvoiceCode()), itemIndex, tripIndex);
                return;
            }
        }
    }

    @Override
    protected void processWhenInvoiceIsDisable() {
        super.processWhenInvoiceIsDisable();
        this.getView().setVisible(Boolean.FALSE, new String[]{"viewinvoice"});
    }

    @Override
    protected void processWhenInvoiceIsEnable() {
        super.processWhenInvoiceIsEnable();
        this.getView().setVisible(Boolean.TRUE, new String[]{"viewinvoice"});
    }

    protected void showInvoiceEntry() {
        boolean isShow = false;
        DynamicObject companyDO = (DynamicObject)this.getModel().getValue("company");
        Long companyId = null;
        if (companyDO != null) {
            companyId = (Long)companyDO.getPkValue();
            int showInvoiceEntry = SystemParamterUtil.getloancheckparam((long)companyId, (String)"isusedmonthlyinvoiceentry");
            isShow = showInvoiceEntry == 1;
        }
        ErCommonUtils.setValueWithoutDBField((IDataModel)this.getModel(), (String)"isshowinvoiceentry", (Object)isShow);
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject trip;
        super.afterBindData(e);
        this.showInvoiceEntry();
        if (!((Boolean)this.getModel().getValue("iscurrency")).booleanValue()) {
            return;
        }
        boolean enable = true;
        DynamicObjectCollection tripColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        Iterator iterator = tripColl.iterator();
        while (iterator.hasNext() && (enable = !(trip = (DynamicObject)iterator.next()).getDynamicObjectCollection("entryentity").stream().anyMatch(v -> StringUtils.equals((CharSequence)ItemFrom.InvoiceCloud.getValue(), (CharSequence)v.getString("itemfrom")) && StringUtils.isNotBlank((CharSequence)v.getString("invoiceno_entry"))))) {
        }
        if (this.getPageCache().get("AbstractTripStdCtrlPlugin-iscurrency-settlementtype") == null) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"iscurrency"});
        }
    }

    @Override
    protected boolean isUseExpenseDate() {
        return false;
    }

    @Override
    protected String getClickKey() {
        return "selectinvoice";
    }

    @Override
    protected List<InvoiceValidator> addInvoiceValidators() {
        return Collections.singletonList(new TripCardInvoiceCurrencyValidator());
    }
}

