/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.formplugin.invoicecloud.v2.util.MergeExpenseUtil;
import org.apache.commons.lang3.StringUtils;

public class MergeExpenseOrTripDetailPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(MergeExpenseOrTripDetailPlugin.class);
    private Set<String> selectItemMoney = Sets.newHashSet((Object[])new String[]{"expenseamount", "corresponded", "expeapproveamount", "expeapprovecurramount", "orientryamount", "taxamount", "iteminoutamount", "airportconstructionfee", "deductibletax", "price", "curprice", "proxyamt", "curproxyamt", "curproxyamt", "approvetax", "currexpenseamount", "wbamount", "wbcuramount", "pricewithtax", "accurprice", "acprice", "acexpeapprovecurramount", "acexpeapproveamount", "acorientryamount", "actaxamount", "changecurprice", "changeprice", "entrychangeamount", "entryorichangeamount", "changeorientryamount", "changetaxamount", "expwithholdingamount", "exporiwithholdingamount", "pushedcurramount", "pushedamount", "canloancurramount", "canloanamount", "reimbursedcurramount", "reimbursedamount", "expebalanceamount", "orgiexpebalanceamount", "curprice", "price", "approvetax", "expeapprovecurramount", "expeapproveamount", "taxamount", "currexpenseamount", "expenseamount", "budgetamount", "entrychangeableamount", "entryapplyprojectamount", "notaxamount", "entryamount", "orientryappamount", "entryappamount", "otherfeeamount", "curotherfeeamount", "exporiusedamount", "expusedamount", "expeorirepayamount", "experepayamount", "expeorihasreimamount", "expehasreimamount"});
    private Set<String> excludeKey = Sets.newHashSet((Object[])new String[]{"expnonpayamount", "isover"});

    private BigDecimal sumByRowIndexsInExpenseEntry(List<Integer> rowIndexs, String sumKey, String entityKey) {
        DynamicObjectCollection expenseEntry = this.getModel().getEntryEntity(entityKey);
        BigDecimal sumAmount = rowIndexs.stream().map(rowIndex -> ((DynamicObject)expenseEntry.get(rowIndex.intValue())).getBigDecimal(sumKey)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        return sumAmount;
    }

    private List<DynamicObject> getSelectedRows(String entryKey, List<Integer> rowIndexs, Boolean trip) {
        DynamicObjectCollection expenseEntry = null;
        expenseEntry = trip == false ? this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey) : ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection(entryKey);
        DynamicObjectCollection finalExpenseEntry = expenseEntry;
        return rowIndexs.stream().map(rowIndex -> (DynamicObject)finalExpenseEntry.get(rowIndex.intValue())).collect(Collectors.toList());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getView().getControl("trip2advtoolbar") != null) {
            this.addItemClickListeners(new String[]{"trip2advtoolbar"});
        }
        if (this.getView().getControl("advcontoolbarap3") != null) {
            this.addItemClickListeners(new String[]{"advcontoolbarap3"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propNewValue = valueSet[0].getNewValue();
        if (!"invoiceno_entry".equals(propName) || propName == null) {
            return;
        }
        String entity = this.getEntity();
        if (!this.checkAutoInvoice()) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entity);
        DynamicObject dynamicObject = entryEntity.stream().filter(item -> propNewValue.equals(item.getString("invoiceno_entry"))).findFirst().get();
        if (dynamicObject == null) {
            return;
        }
        String splitline = dynamicObject.getString("splitline");
        if (splitline == null || splitline.equals("")) {
            return;
        }
        List totalsplitline = entryEntity.stream().filter(ite -> splitline.equals(ite.get("splitline"))).collect(Collectors.toList());
        if (totalsplitline.size() <= 1) {
            return;
        }
        int parentIndex = this.isTripReimburseBill() ? this.getModel().getEntryCurrentRowIndex("tripentry") : -1;
        this.getModel().beginInit();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamic = (DynamicObject)entryEntity.get(i);
            if (!splitline.equals(dynamic.get("splitline"))) continue;
            this.getModel().setValue("invoiceno_entry", propNewValue, i, parentIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(entity);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IFormView view = this.getView();
        String itemKey = evt.getItemKey();
        BillExpenseInfoFildKeyType billType = ErEntityTypeUtils.getBillType((String)view.getEntityId());
        if (billType == null) {
            evt.setCancel(true);
            return;
        }
        String entryKey = billType.getExpenseEntityKey();
        switch (itemKey) {
            case "split": {
                boolean canSplit = MergeExpenseUtil.canSplit((IFormView)view, (String)entryKey);
                evt.setCancel(!canSplit);
                break;
            }
            case "merge": {
                boolean canMerge = MergeExpenseUtil.canMerge((IFormView)view, (String)entryKey);
                evt.setCancel(!canMerge);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "merge": {
                this.mergeExpense();
                break;
            }
            case "split": {
                this.splitExpense();
            }
        }
    }

    public void splitExpense() {
        String entityId = this.getView().getEntityId();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("er_splitcount");
        showParameter.setShowTitle(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String getEntity() {
        String entryKey = "expenseentryentity";
        if (this.isTripReimburseBill()) {
            entryKey = "entryentity";
        }
        return entryKey;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (!StringUtils.equals((CharSequence)"submit", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            return;
        }
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        Integer count = Integer.valueOf(this.getPageCache().get("splitcount"));
        String entryKey = this.getEntity();
        EntryGrid expenseEntryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
        if (selectedExpenseEntryRowsArr.length == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        DynamicObjectCollection expenseEntryDOs = this.getModel().getEntryEntity(entryKey);
        int selectRowIndex = selectedExpenseEntryRowsArr[0];
        DynamicObject selectDynamicObject = (DynamicObject)expenseEntryDOs.get(selectRowIndex);
        this.getModel().beginInit();
        int[] newExpenseEntityRows = this.getModel().appendEntryRow(entryKey, selectRowIndex, count - 1);
        this.getModel().endInit();
        this.getModel().updateCache();
        List collect = Arrays.stream(newExpenseEntityRows).boxed().collect(Collectors.toList());
        collect.add(0, selectRowIndex);
        int amtPrecision = 4;
        DynamicObject currency = null;
        if (expenseEntryDOs.getDynamicObjectType().getProperties().get((Object)"entrycurrency") != null) {
            currency = selectDynamicObject.getDynamicObject("entrycurrency");
        }
        if (currency == null) {
            currency = this.getModel().getDataEntity().getDynamicObject("currency");
        }
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        String parentPkValue = "";
        boolean invoiceFromParent = false;
        Boolean autoMap = null;
        if (this.getModel().getProperty("automapinvoice") != null) {
            autoMap = (Boolean)this.getModel().getValue("automapinvoice");
        }
        if (autoMap != null && autoMap.booleanValue() && StringUtils.isNotEmpty((CharSequence)selectDynamicObject.getString("invoiceno_entry"))) {
            parentPkValue = String.valueOf(selectDynamicObject.getPkValue());
            invoiceFromParent = true;
        }
        DynamicObject clone = (DynamicObject)OrmUtils.clone((Object)selectDynamicObject, (IDataEntityType)selectDynamicObject.getDataEntityType(), (boolean)false, (boolean)true);
        List<PropModel> properties = this.getProperties(selectDynamicObject.getDataEntityType().getProperties());
        long[] longIds = ORM.create().genLongIds((IDataEntityType)this.getModel().getEntryEntity(this.getEntryKey()).getDynamicObjectType(), count - 1);
        this.getModel().beginInit();
        for (int currentIndex = 1; currentIndex < collect.size(); ++currentIndex) {
            ((DynamicObject)this.getModel().getEntryEntity(this.getEntryKey()).get(((Integer)collect.get(currentIndex)).intValue())).set("id", (Object)longIds[currentIndex - 1]);
        }
        this.getModel().endInit();
        int tripIndex = this.isTripReimburseBill() ? this.getModel().getEntryCurrentRowIndex("tripentry") : -1;
        this.setDynamicValue(clone, (Integer)collect.get(0), count, 1, amtPrecision, selectDynamicObject.getPkValue().toString(), (Long)selectDynamicObject.getPkValue(), properties, false, tripIndex);
        if (autoMap != null) {
            this.buildSplitNonAutoInvoiceRelation(selectDynamicObject, longIds);
        }
        DynamicObject copyRow = this.getModel().getEntryRowEntity(this.getEntryKey(), ((Integer)collect.get(0)).intValue());
        this.getModel().beginInit();
        for (int currentIndex = 1; currentIndex < collect.size() - 1; ++currentIndex) {
            this.copyDynamicObject(copyRow, properties, (Integer)collect.get(currentIndex), longIds[currentIndex - 1], parentPkValue, invoiceFromParent, tripIndex);
        }
        this.getModel().endInit();
        InvoiceUtils2.clearCacheRelation();
        this.setDynamicValue(clone, (Integer)collect.get(count - 1), count, count, amtPrecision, parentPkValue, longIds[count - 2], properties, invoiceFromParent, tripIndex);
        long endTime = System.currentTimeMillis();
        log.info("[\u62c6\u5206\u8017\u65f6]:" + (endTime - startTime));
        this.getView().updateView(entryKey);
    }

    private void refreshFeeStand(int rowIndex) {
        String openfeestand = "openfeestand";
        if (this.getModel().getDataEntityType().getProperty(openfeestand) != null && Boolean.TRUE.equals(this.getModel().getValue(openfeestand))) {
            FeeStandardHelper.calcIsOverStd((int)rowIndex, (IDataModel)this.getModel());
        }
    }

    private boolean checkAutoInvoice() {
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        IDataEntityProperty automapinvoiceProperty = (IDataEntityProperty)properties.get((Object)"automapinvoice");
        if (automapinvoiceProperty == null) {
            return false;
        }
        IDataEntityProperty iDataEntityProperty = this.getModel().getProperty("splitline");
        return iDataEntityProperty != null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnMap;
        Object splitcount;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId() == null || !closedCallBackEvent.getActionId().equals(this.getView().getEntityId())) {
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        Integer count = 0;
        if (returnData instanceof Map && (splitcount = (returnMap = (Map)returnData).get("splitcount")) instanceof Integer) {
            count = (Integer)splitcount;
        }
        if (count == 0) {
            return;
        }
        this.getPageCache().put("splitcount", String.valueOf(count));
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u62c6\u5206\u660e\u7ec6\u884c\u5417\uff1f", (String)"MergeExpenseOrTripDetailPlugin_16", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
    }

    @Deprecated
    public void setDynamicValue(DynamicObject source, int row, int count, int index, int amtPrecision, String parentPkValue, Long pkValue, List<PropModel> propList, boolean invoiceFromParent) {
        ((DynamicObject)this.getModel().getEntryEntity(this.getEntryKey()).get(row)).set("id", (Object)pkValue);
        if (source.containsProperty("splitline")) {
            this.getModel().setValue("splitline", (Object)parentPkValue, row);
        }
        if (source.containsProperty("invoicefromparent")) {
            this.getModel().setValue("invoicefromparent", (Object)invoiceFromParent, row);
        }
        for (PropModel prop : propList) {
            if (this.excludeKey.contains(prop.getName()) || source.getDataEntityType().getPrimaryKey().getName().equals(prop.getName()) || "seq".equalsIgnoreCase(prop.getName()) || prop.getName() == null) continue;
            if (this.selectItemMoney.contains(prop.getName()) && source.get(prop.getName()) instanceof BigDecimal) {
                Map<String, Object> bigDecimal = this.computeMoney((BigDecimal)source.get(prop.getName()), count, index, amtPrecision);
                if (bigDecimal == null) continue;
                this.getModel().setValue(prop.getName(), bigDecimal.get("money"), row);
                continue;
            }
            if (prop.getName().contains("_lk")) {
                DynamicObjectCollection collection = (DynamicObjectCollection)source.get(prop.getName());
                if (collection.size() <= 0) continue;
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                collection.forEach(it -> {
                    IDataEntityType dataEntityType = ((DynamicObject)collection.get(0)).getDataEntityType();
                    DynamicObject clone = (DynamicObject)OrmUtils.clone((Object)collection.get(0), (IDataEntityType)dataEntityType, (boolean)true, (boolean)true);
                    dynamicObjects.add((Object)clone);
                });
                this.getModel().setValue(prop.getName(), (Object)dynamicObjects, row);
                continue;
            }
            this.getModel().setValue(prop.getName(), source.get(prop.getName()), row);
        }
    }

    public void setDynamicValue(DynamicObject source, int row, int count, int index, int amtPrecision, String parentPkValue, Long pkValue, List<PropModel> propList, boolean invoiceFromParent, int tripIndex) {
        if (source.containsProperty("splitline")) {
            this.getModel().setValue("splitline", (Object)parentPkValue, row, tripIndex);
        }
        if (source.containsProperty("invoicefromparent")) {
            this.getModel().setValue("invoicefromparent", (Object)invoiceFromParent, row, tripIndex);
        }
        for (PropModel prop : propList) {
            if (this.excludeKey.contains(prop.getName()) || source.getDataEntityType().getPrimaryKey().getName().equals(prop.getName()) || "seq".equalsIgnoreCase(prop.getName()) || prop.getName() == null) continue;
            if (this.selectItemMoney.contains(prop.getName()) && source.get(prop.getName()) instanceof BigDecimal) {
                Map<String, Object> bigDecimal = this.computeMoney((BigDecimal)source.get(prop.getName()), count, index, amtPrecision);
                if (bigDecimal == null) continue;
                this.getModel().setValue(prop.getName(), bigDecimal.get("money"), row, tripIndex);
                continue;
            }
            if (prop.getName().contains("_lk")) {
                DynamicObjectCollection collection = (DynamicObjectCollection)source.get(prop.getName());
                if (collection.size() <= 0) continue;
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
                collection.forEach(it -> {
                    IDataEntityType dataEntityType = ((DynamicObject)collection.get(0)).getDataEntityType();
                    DynamicObject clone = (DynamicObject)OrmUtils.clone((Object)collection.get(0), (IDataEntityType)dataEntityType, (boolean)true, (boolean)true);
                    dynamicObjects.add((Object)clone);
                });
                this.getModel().setValue(prop.getName(), (Object)dynamicObjects, row, tripIndex);
                continue;
            }
            this.getModel().setValue(prop.getName(), source.get(prop.getName()), row, tripIndex);
        }
    }

    public Map<String, Object> computeMoney(BigDecimal money, int count, int index, int amtprecision) {
        if (money == null) {
            return null;
        }
        HashMap<String, Object> item = new HashMap<String, Object>();
        BigDecimal divide = money.divide(new BigDecimal(count), amtprecision, 4);
        if (count != index) {
            item.put("money", divide);
            return item;
        }
        BigDecimal subtract = money;
        for (int i = 0; i < count - 1; ++i) {
            subtract = subtract.subtract(divide);
        }
        item.put("money", subtract);
        return item;
    }

    public void mergeExpense() {
        Set invoiceTypeItemSet;
        Boolean trip = this.isTripReimburseBill();
        String entity = this.getEntryKey();
        String amount = trip != false ? "orientryamount" : "expenseamount";
        String sdorientryamount = trip != false ? "notaxamount" : "orientryamount";
        DynamicObjectCollection expenseEntryDOs = this.getModel().getEntryEntity(entity);
        DynamicObjectCollection invoiceHeadEntryDOs = this.getModel().getEntryEntity("invoiceentry");
        DynamicObjectCollection invoiceItemEntryDOs = this.getModel().getEntryEntity("invoiceitementry");
        EntryGrid expenseEntryGrid = (EntryGrid)this.getControl(entity);
        int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
        List<Integer> selectedExpenseEntryRows = Arrays.stream(selectedExpenseEntryRowsArr).boxed().collect(Collectors.toList());
        int tripIndex = trip != false ? this.getModel().getEntryCurrentRowIndex("tripentry") : -1;
        Set<Long> willMergeExpenseEntryIds = selectedExpenseEntryRows.stream().map(index -> (Long)((DynamicObject)expenseEntryDOs.get(index.intValue())).getPkValue()).filter(pkId -> !pkId.equals(0L)).collect(Collectors.toSet());
        Set invoiceHeadEntryIds = InvoiceUtils.getInvoiceIdsOfItems((IDataModel)this.getModel(), willMergeExpenseEntryIds);
        this.resetInvoiceRelation(selectedExpenseEntryRowsArr, expenseEntryDOs, invoiceItemEntryDOs, invoiceHeadEntryDOs, willMergeExpenseEntryIds, invoiceHeadEntryIds, tripIndex);
        BigDecimal reimburseAmount = this.sumByRowIndexsInExpenseEntry(selectedExpenseEntryRows, amount, entity);
        BigDecimal airportConstruionFee = this.sumByRowIndexsInExpenseEntry(selectedExpenseEntryRows, "airportconstructionfee", entity);
        BigDecimal taxRate = BigDecimal.ZERO;
        List<DynamicObject> selectedExpenseEntryDOs = this.getSelectedRows(entity, selectedExpenseEntryRows, trip);
        long taxRateCount = selectedExpenseEntryDOs.stream().map(entry -> entry.getBigDecimal("taxrate")).distinct().count();
        if (taxRateCount == 1L) {
            taxRate = selectedExpenseEntryDOs.get(0).getBigDecimal("taxrate");
        }
        BigDecimal taxAmount = this.sumByRowIndexsInExpenseEntry(selectedExpenseEntryRows, "taxamount", entity);
        BigDecimal excludedTaxAmount = this.sumByRowIndexsInExpenseEntry(selectedExpenseEntryRows, sdorientryamount, entity);
        Integer firstRowIndex = selectedExpenseEntryRows.get(0);
        if (expenseEntryDOs.getDynamicObjectType().getProperties().containsKey((Object)"otherfeeamount")) {
            BigDecimal otherFeeAmount = this.sumByRowIndexsInExpenseEntry(selectedExpenseEntryRows, "otherfeeamount", entity);
            this.getModel().setValue("otherfeeamount", (Object)otherFeeAmount, firstRowIndex.intValue());
            BigDecimal curOtherFeeAmount = this.sumByRowIndexsInExpenseEntry(selectedExpenseEntryRows, "curotherfeeamount", entity);
            this.getModel().setValue("curotherfeeamount", (Object)curOtherFeeAmount, firstRowIndex.intValue());
        }
        this.getModel().setValue(amount, (Object)reimburseAmount, firstRowIndex.intValue(), tripIndex);
        this.getModel().setValue("airportconstructionfee", (Object)airportConstruionFee, firstRowIndex.intValue(), tripIndex);
        this.getModel().setValue("taxrate", (Object)taxRate, firstRowIndex.intValue(), tripIndex);
        this.getModel().setValue("taxamount", (Object)taxAmount, firstRowIndex.intValue(), tripIndex);
        this.getModel().setValue(sdorientryamount, (Object)excludedTaxAmount, firstRowIndex.intValue(), tripIndex);
        String proxyTax = "proxyamt";
        if (this.getModel().getProperty(proxyTax) != null) {
            BigDecimal proxyTaxAmt = this.sumByRowIndexsInExpenseEntry(selectedExpenseEntryRows, proxyTax, entity);
            this.getModel().setValue(proxyTax, (Object)proxyTaxAmt, firstRowIndex.intValue());
        }
        if ((invoiceTypeItemSet = selectedExpenseEntryRows.stream().map(rowNum -> ((DynamicObject)expenseEntryDOs.get(rowNum.intValue())).getString("invoicetypeitem")).collect(Collectors.toSet())).size() > 1) {
            this.getModel().setValue("invoicetypeitem", (Object)0, firstRowIndex.intValue(), tripIndex);
        }
        for (int i2 = 0; i2 < invoiceHeadEntryDOs.size(); ++i2) {
            Long invoiceObjID = (Long)((DynamicObject)invoiceHeadEntryDOs.get(i2)).getPkValue();
            if (!invoiceHeadEntryIds.contains(invoiceObjID)) continue;
            this.getModel().setValue("islinkagedetail", (Object)false, i2);
        }
        List<Integer> needDelExpenseIndex = selectedExpenseEntryRows.subList(1, selectedExpenseEntryRows.size());
        this.getModel().deleteEntryRows(entity, needDelExpenseIndex.stream().mapToInt(i -> i).toArray());
        this.refreshFeeStand(firstRowIndex);
    }

    private String getEntryKey() {
        if (this.isTripReimburseBill()) {
            return "entryentity";
        }
        return "expenseentryentity";
    }

    private boolean isTripReimburseBill() {
        return ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId());
    }

    private boolean isPublicBill() {
        return ErEntityTypeUtils.isCostEstimateBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isWithholdingBill((String)this.getView().getEntityId());
    }

    private boolean isReimburseBill() {
        return ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId());
    }

    private List<PropModel> getProperties(DataEntityPropertyCollection properties) {
        List<PropModel> propModelList = this.buildPropList(properties);
        HashSet removeProp = Sets.newHashSet((Object[])new String[]{"id", "seq", "splitline", "invoicefromparent"});
        removeProp.addAll(this.excludeKey);
        propModelList.removeIf(prop -> removeProp.contains(prop.getName()));
        return propModelList;
    }

    private void copyDynamicObject(DynamicObject copyObject, List<PropModel> properties, int currentIndex, long pkValue, String parentPkValue, boolean invoiceFromParent, int tripIndex) {
        for (PropModel prop : properties) {
            this.getModel().setValue(prop.getName(), copyObject.get(prop.getName()), currentIndex, tripIndex);
        }
        if (copyObject.containsProperty("splitline")) {
            this.getModel().setValue("splitline", (Object)parentPkValue, currentIndex, tripIndex);
        }
        if (copyObject.containsProperty("invoicefromparent")) {
            this.getModel().setValue("invoicefromparent", (Object)invoiceFromParent, currentIndex, tripIndex);
        }
    }

    private List<PropModel> buildPropList(DataEntityPropertyCollection propertyCollection) {
        ArrayList<PropModel> propList = new ArrayList<PropModel>(propertyCollection.size());
        if (this.isTripReimburseBill()) {
            propList.add(new PropModel("travelcostdept", (IDataEntityProperty)propertyCollection.get((Object)"travelcostdept"), 10));
            propList.add(new PropModel("travelcostcenter", (IDataEntityProperty)propertyCollection.get((Object)"travelcostcenter"), 10));
            propList.add(new PropModel("travelcostcompany", (IDataEntityProperty)propertyCollection.get((Object)"travelcostcompany"), 10));
            propList.add(new PropModel("entrycurrency", (IDataEntityProperty)propertyCollection.get((Object)"entrycurrency"), 10));
            propList.add(new PropModel("detailquotetype", (IDataEntityProperty)propertyCollection.get((Object)"detailquotetype"), 10));
            propList.add(new PropModel("exchangerate", (IDataEntityProperty)propertyCollection.get((Object)"exchangerate"), 10));
            propList.add(new PropModel("travelexpenseitem", (IDataEntityProperty)propertyCollection.get((Object)"travelexpenseitem"), 10));
            propList.add(new PropModel("expenseitem", (IDataEntityProperty)propertyCollection.get((Object)"expenseitem"), 10));
            propList.add(new PropModel("trip2startdate", (IDataEntityProperty)propertyCollection.get((Object)"trip2startdate"), 10));
            propList.add(new PropModel("trip2enddate", (IDataEntityProperty)propertyCollection.get((Object)"trip2enddate"), 10));
            propList.add(new PropModel("trip2from", (IDataEntityProperty)propertyCollection.get((Object)"trip2from"), 10));
            propList.add(new PropModel("trip2to", (IDataEntityProperty)propertyCollection.get((Object)"trip2to"), 10));
            propList.add(new PropModel("trip2mulwayto", (IDataEntityProperty)propertyCollection.get((Object)"trip2mulwayto"), 10));
            propList.add(new PropModel("orientryamount", (IDataEntityProperty)propertyCollection.get((Object)"orientryamount"), 10));
            propList.add(new PropModel("entryamount", (IDataEntityProperty)propertyCollection.get((Object)"entryamount"), 10));
            propList.add(new PropModel("orientryappamount", (IDataEntityProperty)propertyCollection.get((Object)"orientryappamount"), 10));
            propList.add(new PropModel("entryappamount", (IDataEntityProperty)propertyCollection.get((Object)"entryappamount"), 10));
            propList.add(new PropModel("taxrate", (IDataEntityProperty)propertyCollection.get((Object)"taxrate"), 10));
            propList.add(new PropModel("taxamount", (IDataEntityProperty)propertyCollection.get((Object)"taxamount"), 10));
            propList.add(new PropModel("notaxamount", (IDataEntityProperty)propertyCollection.get((Object)"notaxamount"), 10));
            propList.add(new PropModel("approvetax", (IDataEntityProperty)propertyCollection.get((Object)"approvetax"), 10));
            propList.add(new PropModel("price", (IDataEntityProperty)propertyCollection.get((Object)"price"), 10));
            propList.add(new PropModel("curprice", (IDataEntityProperty)propertyCollection.get((Object)"curprice"), 10));
            propList.add(new PropModel("offset", (IDataEntityProperty)propertyCollection.get((Object)"offset"), 10));
            propList.add(new PropModel("deductibletax", (IDataEntityProperty)propertyCollection.get((Object)"deductibletax"), 10));
            propList.add(new PropModel("iteminoutamount", (IDataEntityProperty)propertyCollection.get((Object)"iteminoutamount"), 10));
        } else if (this.isReimburseBill()) {
            propList.add(new PropModel("entrycostdept", (IDataEntityProperty)propertyCollection.get((Object)"entrycostdept"), 10));
            propList.add(new PropModel("std_entrycostcenter", (IDataEntityProperty)propertyCollection.get((Object)"std_entrycostcenter"), 10));
            propList.add(new PropModel("entrycostcompany", (IDataEntityProperty)propertyCollection.get((Object)"entrycostcompany"), 10));
            propList.add(new PropModel("entrycurrency", (IDataEntityProperty)propertyCollection.get((Object)"entrycurrency"), 10));
            propList.add(new PropModel("expquotetype", (IDataEntityProperty)propertyCollection.get((Object)"expquotetype"), 10));
            propList.add(new PropModel("exchangerate", (IDataEntityProperty)propertyCollection.get((Object)"exchangerate"), 10));
            propList.add(new PropModel("expenseitem", (IDataEntityProperty)propertyCollection.get((Object)"expenseitem"), 10));
            propList.add(new PropModel("expenseamount", (IDataEntityProperty)propertyCollection.get((Object)"expenseamount"), 10));
            propList.add(new PropModel("currexpenseamount", (IDataEntityProperty)propertyCollection.get((Object)"currexpenseamount"), 10));
            propList.add(new PropModel("expeapproveamount", (IDataEntityProperty)propertyCollection.get((Object)"expeapproveamount"), 10));
            propList.add(new PropModel("expeapprovecurramount", (IDataEntityProperty)propertyCollection.get((Object)"expeapprovecurramount"), 10));
            propList.add(new PropModel("proxyamt", (IDataEntityProperty)propertyCollection.get((Object)"proxyamt"), 10));
            propList.add(new PropModel("curproxyamt", (IDataEntityProperty)propertyCollection.get((Object)"curproxyamt"), 10));
            propList.add(new PropModel("taxrate", (IDataEntityProperty)propertyCollection.get((Object)"taxrate"), 10));
            propList.add(new PropModel("taxamount", (IDataEntityProperty)propertyCollection.get((Object)"taxamount"), 10));
            propList.add(new PropModel("orientryamount", (IDataEntityProperty)propertyCollection.get((Object)"orientryamount"), 10));
            propList.add(new PropModel("approvetax", (IDataEntityProperty)propertyCollection.get((Object)"approvetax"), 10));
            propList.add(new PropModel("price", (IDataEntityProperty)propertyCollection.get((Object)"price"), 10));
            propList.add(new PropModel("curprice", (IDataEntityProperty)propertyCollection.get((Object)"curprice"), 10));
            propList.add(new PropModel("offset", (IDataEntityProperty)propertyCollection.get((Object)"offset"), 10));
            propList.add(new PropModel("deductibletax", (IDataEntityProperty)propertyCollection.get((Object)"deductibletax"), 10));
            propList.add(new PropModel("iteminoutamount", (IDataEntityProperty)propertyCollection.get((Object)"iteminoutamount"), 10));
        } else if (this.isPublicBill()) {
            propList.add(new PropModel("entrycostdept", (IDataEntityProperty)propertyCollection.get((Object)"entrycostdept"), 10));
            propList.add(new PropModel("std_entrycostcenter", (IDataEntityProperty)propertyCollection.get((Object)"std_entrycostcenter"), 10));
            propList.add(new PropModel("entrycostcompany", (IDataEntityProperty)propertyCollection.get((Object)"entrycostcompany"), 10));
            propList.add(new PropModel("entrycurrency", (IDataEntityProperty)propertyCollection.get((Object)"entrycurrency"), 10));
            propList.add(new PropModel("expquotetype", (IDataEntityProperty)propertyCollection.get((Object)"expquotetype"), 10));
            propList.add(new PropModel("exchangerate", (IDataEntityProperty)propertyCollection.get((Object)"exchangerate"), 10));
            propList.add(new PropModel("entrywltype", (IDataEntityProperty)propertyCollection.get((Object)"entrywltype"), 10));
            propList.add(new PropModel("entrywlunit", (IDataEntityProperty)propertyCollection.get((Object)"entrywlunit"), 10));
            propList.add(new PropModel("expenseitem", (IDataEntityProperty)propertyCollection.get((Object)"expenseitem"), 10));
        }
        propertyCollection.stream().forEach(prop -> {
            if (!propList.stream().anyMatch(propModel -> prop.getName().equals(propModel.getName()))) {
                propList.add(new PropModel(prop.getName(), (IDataEntityProperty)prop));
            }
        });
        propList.sort(Comparator.comparingInt(PropModel::getLevel).reversed());
        return propList;
    }

    private void buildSplitNonAutoInvoiceRelation(DynamicObject selectDynamicObject, long[] longIds) {
        Boolean autoMapInvoice;
        if (StringUtils.equals((CharSequence)selectDynamicObject.getString("itemfrom"), (CharSequence)InvoiceFrom.InvoiceCloud.getValue()) && !(autoMapInvoice = (Boolean)this.getModel().getValue("automapinvoice")).booleanValue()) {
            HashSet<Long> itemId = new HashSet<Long>();
            itemId.add((Long)selectDynamicObject.getPkValue());
            Set invoiceIdsOfItems = InvoiceUtils.getInvoiceIdsOfItems((IDataModel)this.getModel(), itemId);
            for (long expenseEntryId : longIds) {
                InvoiceUtils.createNonAutoInvoice((IDataModel)this.getModel(), (Long)expenseEntryId, (Set)invoiceIdsOfItems);
            }
        }
    }

    private void resetInvoiceRelation(int[] selectedRowsArr, DynamicObjectCollection expenseEntryDOs, DynamicObjectCollection invoiceItemEntryDOs, DynamicObjectCollection invoiceHeadEntryDOs, Set<Long> mergeExpenseEntryIds, Set<Long> invoiceHeadEntryIds, int tripIndex) {
        int firstRowIndex = selectedRowsArr[0];
        ArrayList<Object> selectRows = new ArrayList<Object>(selectedRowsArr.length);
        for (int index : selectedRowsArr) {
            selectRows.add(expenseEntryDOs.get(index));
        }
        Boolean autoMapInvoice = (Boolean)this.getModel().getValue("automapinvoice");
        if (autoMapInvoice.booleanValue()) {
            List parentId = selectRows.stream().filter(dynamicObject -> !dynamicObject.getBoolean("invoicefromparent")).map(obj -> (Long)obj.getPkValue()).collect(Collectors.toList());
            if (!parentId.isEmpty()) {
                Long newExpenseItemId = (Long)parentId.get(0);
                for (int i = 0; i < invoiceItemEntryDOs.size(); ++i) {
                    Long expenseItemId = ((DynamicObject)invoiceItemEntryDOs.get(i)).getLong("itementryid");
                    if (!mergeExpenseEntryIds.contains(expenseItemId)) continue;
                    this.getModel().setValue("itementryid", (Object)newExpenseItemId, i);
                }
            }
            List willMergeInvoiceHeadEntryDOs = invoiceHeadEntryDOs.stream().filter(invoiceHeadEntryDO -> invoiceHeadEntryIds.contains(invoiceHeadEntryDO.getPkValue())).collect(Collectors.toList());
            String unionInvoiceNo = willMergeInvoiceHeadEntryDOs.stream().map(invoiceHead -> invoiceHead.getString("invoiceno")).collect(Collectors.joining(","));
            String unionInvoiceCode = willMergeInvoiceHeadEntryDOs.stream().map(invoiceHead -> invoiceHead.getString("invoicecode")).collect(Collectors.joining(","));
            this.getModel().setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)unionInvoiceNo), firstRowIndex, tripIndex);
            this.getModel().setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)unionInvoiceCode), firstRowIndex, tripIndex);
        } else {
            Map nonAutoMapInvoiceRelation = InvoiceUtils.nonAutoMapInvoiceMappingInfo((IDataModel)this.getModel());
            Long pkValue = (Long)this.getModel().getEntryRowEntity(this.getEntryKey(), firstRowIndex).getPkValue();
            Set invoiceHeadIdSet = selectRows.stream().map(selectRow -> (Set)nonAutoMapInvoiceRelation.get(selectRow.getPkValue())).flatMap(Collection::stream).collect(Collectors.toSet());
            Set selectRowIdSet = selectRows.stream().map(selectRow -> (Long)selectRow.getPkValue()).collect(Collectors.toSet());
            InvoiceUtils.deleteNonAutoInvoice((IDataModel)this.getModel(), selectRowIdSet);
            InvoiceUtils.createNonAutoInvoice((IDataModel)this.getModel(), (Long)pkValue, invoiceHeadIdSet);
            String invoicecode = invoiceHeadEntryDOs.stream().filter(entry -> invoiceHeadIdSet.contains(entry.getPkValue())).map(entry -> entry.getString("invoicecode")).collect(Collectors.joining(","));
            String invoiceno = invoiceHeadEntryDOs.stream().filter(entry -> invoiceHeadIdSet.contains(entry.getPkValue())).map(entry -> entry.getString("invoiceno")).collect(Collectors.joining(","));
            this.getModel().setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)invoiceno), firstRowIndex, tripIndex);
            this.getModel().setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)invoicecode), firstRowIndex, tripIndex);
        }
        InvoiceUtils2.clearCacheRelation();
    }

    private static class InvoiceAndExpense {
        private Long id;
        private Long expenseEntryId;
        private Long invoiceEntryId;

        private InvoiceAndExpense() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getExpenseEntryId() {
            return this.expenseEntryId;
        }

        public void setExpenseEntryId(Long expenseEntryId) {
            this.expenseEntryId = expenseEntryId;
        }

        public Long getInvoiceEntryId() {
            return this.invoiceEntryId;
        }

        public void setInvoiceEntryId(Long invoiceEntryId) {
            this.invoiceEntryId = invoiceEntryId;
        }
    }

    private static class PropModel {
        private String name;
        private int level = 5;
        private IDataEntityProperty property;

        public PropModel(String name, IDataEntityProperty property) {
            this.name = name;
            this.property = property;
        }

        public PropModel(String name, IDataEntityProperty property, int level) {
            this.name = name;
            this.property = property;
            this.level = level;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public IDataEntityProperty getProperty() {
            return this.property;
        }

        public void setProperty(IDataEntityProperty property) {
            this.property = property;
        }
    }
}

