/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.servicehelper.OrgServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;

public class TaxCodeReflectItemFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(TaxCodeReflectItemFormPlugin.class);
    private static final String EXPENSE_ITEM = "expenseitem";
    private static final String ENTRY_EXPENSE_ITEM = "entryexpenseitem";
    private static final String EXPENSE_ITEM_RANGE_ENTRY = "expitemrange";
    private static final String EXPENSE_ITEM_DEFAULT = "isdefault";

    public void registerListener(EventObject e) {
        List<String> controlIds = Arrays.asList("bill_org", EXPENSE_ITEM, ENTRY_EXPENSE_ITEM);
        for (String id : controlIds) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(id);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        FormShowParameter fsp = event.getFormShowParameter();
        ArrayList listQF = Lists.newArrayList();
        DynamicObject createorg = this.getModel().getDataEntity(true).getDynamicObject("createorg");
        if (createorg == null) {
            return;
        }
        Long companyId = (Long)createorg.getPkValue();
        switch (key) {
            case "bill_org": {
                fsp.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7533\u8bf7\u4eba\u90e8\u95e8", (String)"TaxCodeReflectItemFormPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                List deptList = OrgServiceHelper.getAllSubOrgWithoutCompany((Long)companyId);
                deptList.add(companyId);
                QFilter bdFilter = new QFilter("id", "in", (Object)deptList);
                fsp.setCustomParam("isIncludeAllSub", (Object)true);
                ListShowParameter lsp = (ListShowParameter)fsp;
                lsp.getListFilterParameter().setFilter(bdFilter);
                break;
            }
            case "expenseitem": {
                fsp.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u8d39\u7528\u9879\u76ee", (String)"TaxCodeReflectItemFormPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                listQF.add(QFilter.of((String)"isleaf=?", (Object[])new Object[]{true}));
                ((ListShowParameter)fsp).setListFilterParameter(new ListFilterParameter((List)listQF, (String)null));
                break;
            }
            case "entryexpenseitem": {
                Set<Long> idsExist = this.getEntryItemIds();
                if (idsExist.isEmpty()) break;
                QFilter qFilter = new QFilter("id", "not in", idsExist);
                ListShowParameter cardF7Param = (ListShowParameter)event.getFormShowParameter();
                cardF7Param.getTreeFilterParameter().getQFilters().add(qFilter);
                cardF7Param.getListFilterParameter().getQFilters().add(qFilter);
                cardF7Param.setCustomParam("treeFilter", (Object)qFilter.toSerializedString());
                break;
            }
        }
    }

    private Set<Long> getEntryItemIds() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(EXPENSE_ITEM_RANGE_ENTRY);
        return collection.stream().map(e -> ErCommonUtils.getPk((Object)e.get(ENTRY_EXPENSE_ITEM))).filter(id -> id != null && !id.equals(0L)).collect(Collectors.toSet());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean isDefault;
        int index;
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        if (proName.equals(this.getItemKey()) && (index = this.getDefaultRowIndex(EXPENSE_ITEM_RANGE_ENTRY, EXPENSE_ITEM_DEFAULT)) != -1) {
            this.getModel().beginInit();
            this.getModel().setValue(this.getEntryItemKey(), (Object)ErCommonUtils.getPk((Object)newValue), index);
            this.getModel().endInit();
        }
        if (proName.equals(this.getEntryItemKey()) && (isDefault = changeData.getDataEntity().getBoolean(EXPENSE_ITEM_DEFAULT))) {
            this.getModel().beginInit();
            this.getModel().setValue(this.getItemKey(), (Object)ErCommonUtils.getPk((Object)newValue));
            this.getModel().endInit();
        }
        if (proName.equals(EXPENSE_ITEM_DEFAULT) && Boolean.TRUE.equals(newValue)) {
            Object item = this.getModel().getValue(this.getEntryItemKey(), rowIndex);
            this.getModel().beginInit();
            this.getModel().setValue(this.getItemKey(), (Object)ErCommonUtils.getPk((Object)item));
            this.updateDefault(EXPENSE_ITEM_RANGE_ENTRY, EXPENSE_ITEM_DEFAULT, rowIndex);
            this.getModel().endInit();
        }
        this.getView().updateView(this.getItemKey());
        this.getView().updateView(EXPENSE_ITEM_RANGE_ENTRY);
    }

    private void updateDefault(String entryId, String defaultField, int curIndex) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryId);
        this.getModel().beginInit();
        for (int i = 0; i < collection.size(); ++i) {
            if (i == curIndex) continue;
            this.getModel().setValue(defaultField, (Object)Boolean.FALSE, i);
        }
        this.getModel().endInit();
    }

    private int getDefaultRowIndex(String entryId, String defaultField) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entryId);
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            if (!entry.getBoolean(defaultField)) continue;
            return i;
        }
        return -1;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        if (event.getSource() instanceof Save) {
            DynamicObjectCollection expenseRange;
            DynamicObjectCollection invoiceOtherFactors = this.getModel().getEntryEntity("entryentity");
            ArrayList goodsNameInfo = Lists.newArrayList();
            HashSet<Integer> indexesToRemove = new HashSet<Integer>(0);
            for (int i = 0; i < invoiceOtherFactors.size(); ++i) {
                DynamicObject invoiceOtherFactor = (DynamicObject)invoiceOtherFactors.get(i);
                String info = invoiceOtherFactor.getString("invoicefactor") + invoiceOtherFactor.getString("mapfactor") + invoiceOtherFactor.getString("inv_mappingtype");
                if (goodsNameInfo.contains(info) || StringUtils.isBlank((CharSequence)invoiceOtherFactor.getString("mapfactor"))) {
                    indexesToRemove.add(i);
                    continue;
                }
                goodsNameInfo.add(info);
            }
            int[] indexArray = indexesToRemove.stream().mapToInt(index -> index).toArray();
            this.getModel().deleteEntryRows("entryentity", indexArray);
            String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
            if (entityName.equalsIgnoreCase("er_rel_tripitem_ratetype")) {
                return;
            }
            int index2 = this.getDefaultRowIndex(EXPENSE_ITEM_RANGE_ENTRY, EXPENSE_ITEM_DEFAULT);
            if (index2 == -1 && (expenseRange = this.getModel().getEntryEntity(EXPENSE_ITEM_RANGE_ENTRY)).size() > 0) {
                Object entryItem = ((DynamicObject)expenseRange.get(0)).get(this.getEntryItemKey());
                this.getModel().setValue(this.getItemKey(), entryItem);
            }
        }
    }

    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        String name = this.getModel().getDataEntityType().getName();
        if (name.contains("er_rel_expense_")) {
            return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
        }
        if (name.contains("er_rel_trip")) {
            return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
        }
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    protected String getItemKey() {
        return this.getBillType().getItem();
    }

    protected String getEntryItemKey() {
        return "entry" + this.getBillType().getItem();
    }
}

