/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.botpctl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.invoicecloud.cache.model.ErCacheUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ErBillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class ErBillOpControlPlugin
extends AbstractFormPlugin {
    private static final String DELETE_ENTRY_CALLBACK = "beforedeleteentry";
    private static final String DELETE_EXPENSE_POOL_IDS = "DELETE_EXPENSE_POOL_IDS";
    private static final String DELINVOICEHEADENTRY = "delinvoiceheadentry";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap3", "advcontoolbarap22", "advcontoolbarap31"});
        this.addClickListeners(new String[]{"image_expense_delete1", "expenseimportinvoice", "delexpense", "imageap_delete", DELINVOICEHEADENTRY});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        boolean isCancle;
        boolean isFromExenesePool;
        EntryData entryData;
        DynamicObject[] entryEntities2;
        int[] selectRows;
        EntryGrid entryGrid;
        Bill bill = Bill.getBillByEntityName(this.getView().getEntityId());
        if (bill == null) {
            return;
        }
        String itemKey = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"merge")) {
            boolean isFromExenesePool2;
            EntryData entryData2;
            DynamicObject[] entryEntities3;
            entryGrid = (EntryGrid)this.getControl(bill.getExpenseEntryKey());
            int[] selectRows2 = entryGrid.getSelectRows();
            if (selectRows2 != null && selectRows2.length >= 2 && (entryEntities3 = (entryData2 = entryGrid.getEntryData()).getDataEntitys()) != null && entryEntities3.length > 0 && (isFromExenesePool2 = Arrays.stream(selectRows2).mapToObj(index -> entryEntities3[index].getString("wbsrcbilltype")).anyMatch(ErBillOpControlPlugin::isExpensePoolBill))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u6c60\u4e0b\u63a8\u7684\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e0d\u5141\u8bb8\u5408\u5e76\u3002", (String)"ErBillOpControlPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"expenseimportinvoice") && (selectRows = (entryGrid = (EntryGrid)this.getControl(bill.getExpenseEntryKey())).getSelectRows()) != null && selectRows.length >= 1 && (entryEntities2 = (entryData = entryGrid.getEntryData()).getDataEntitys()) != null && entryEntities2.length > 0 && (isFromExenesePool = Arrays.stream(selectRows).mapToObj(index -> entryEntities2[index].getString("wbsrcbilltype")).anyMatch(ErBillOpControlPlugin::isExpensePoolBill))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u6c60\u4e0b\u63a8\u7684\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e0d\u5141\u8bb8\u201c\u6309\u884c\u5bfc\u5165\u53d1\u7968\u201d\u3002", (String)"ErBillOpControlPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)bill.getDeleteExpenseEntryOpKey()) && (isCancle = this.beforeDeleteConfirm(bill.getExpenseEntryKey(), ResManager.loadKDString((String)"\u5220\u9664\u8be5\u5206\u5f55\u4f1a\u8054\u52a8\u5220\u9664\u53d1\u7968\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ErBillOpControlPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), entryEntities -> {
            Set expenseItemIdsMappedInvoice = this.getModel().getEntryEntity("invoiceitementry").stream().map(entry -> entry.getLong("itementryid")).filter(id -> !Objects.equals(id, 0L)).collect(Collectors.toSet());
            return entryEntities.stream().anyMatch(entry -> expenseItemIdsMappedInvoice.contains(entry.getPkValue()));
        }))) {
            evt.setCancel(isCancle);
        }
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)bill.getDeleteInvoiceEntryOpKey()) && (isCancle = this.deleteInvoiceEntryOpKey(bill)).booleanValue()) {
            evt.setCancel(isCancle.booleanValue());
        }
    }

    private Boolean deleteInvoiceEntryOpKey(Bill bill) {
        DynamicObjectCollection itemColl = this.getModel().getEntryEntity(bill.getExpenseEntryKey());
        String expenseEntryName = "";
        boolean isCancle = false;
        if (itemColl != null) {
            expenseEntryName = itemColl.getDynamicObjectType().getDisplayName().getLocaleValue();
            isCancle = this.beforeDeleteConfirm("invoiceentry", String.format(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u53d1\u7968\u4f1a\u8054\u52a8\u5220\u9664%s\u5206\u5f55\u53ca\u5173\u8054\u7684\u6240\u6709\u53d1\u7968\u5206\u5f55\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ErBillOpControlPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]), expenseEntryName), entryEntities -> entryEntities.stream().anyMatch(invoiceEntry -> invoiceEntry.getDataEntityType().getProperties().get((Object)"invoicesrcbillid") != null && !Objects.equals(invoiceEntry.getLong("invoicesrcbillid"), 0L) && ErBillOpControlPlugin.isExpensePoolBill(invoiceEntry.getString("invoicesrcbilltype"))));
        }
        if (!isCancle) {
            isCancle = this.beforeDeleteConfirm("invoiceentry", ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ErBillOpControlPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), entryEntities -> {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                Set selectedInvoiceEntryIds = entryEntities.stream().map(entry -> (Long)entry.getPkValue()).collect(Collectors.toSet());
                return !dataEntity.getDynamicObjectCollection("invoiceitementry").stream().anyMatch(entry -> !Objects.equals(entry.getLong("itementryid"), 0L) && selectedInvoiceEntryIds.contains(entry.getLong("invoiceheadentryid")));
            });
        }
        if (!isCancle && StringUtils.isNotBlank((CharSequence)expenseEntryName)) {
            isCancle = this.beforeDeleteConfirm("invoiceentry", String.format(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u53d1\u7968\u4f1a\u8054\u52a8\u5220\u9664%s\u5206\u5f55\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ErBillOpControlPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), expenseEntryName), entryEntities -> {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                Set selectedInvoiceEntryIds = entryEntities.stream().map(entry -> (Long)entry.getPkValue()).collect(Collectors.toSet());
                DynamicObjectCollection invoiceItemEntryDOs = dataEntity.getDynamicObjectCollection("invoiceitementry");
                Set itemEntryIds = invoiceItemEntryDOs.stream().filter(entry -> !Objects.equals(entry.getLong("itementryid"), 0L) && selectedInvoiceEntryIds.contains(entry.getLong("invoiceheadentryid"))).map(entry -> entry.getLong("itementryid")).collect(Collectors.toSet());
                Set invoiceHeadEntryIds = invoiceItemEntryDOs.stream().filter(entry -> itemEntryIds.contains(entry.getLong("itementryid"))).map(entry -> entry.getLong("invoiceheadentryid")).collect(Collectors.toSet());
                return selectedInvoiceEntryIds.containsAll(invoiceHeadEntryIds);
            });
        }
        if (!isCancle && StringUtils.isNotBlank((CharSequence)expenseEntryName)) {
            isCancle = this.beforeDeleteConfirm("invoiceentry", String.format(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u53d1\u7968\u4f1a\u91cd\u65b0\u8ba1\u7b97\u5bf9\u5e94%s\u5206\u5f55\u7684\u62a5\u9500\u91d1\u989d\u7b49\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ErBillOpControlPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]), expenseEntryName), entryEntities -> true);
        }
        return isCancle;
    }

    public void beforeClick(BeforeClickEvent evt) {
        boolean isCancel;
        Image img;
        String operationKey;
        Bill bill = Bill.getBillByEntityName(this.getView().getEntityId());
        if (bill == null) {
            return;
        }
        Object source = evt.getSource();
        Control control = (Control)source;
        String key = control.getKey();
        if (source instanceof Image && StringUtils.equals((CharSequence)(operationKey = (img = (Image)source).getOperationKey()), (CharSequence)bill.getDeleteExpenseEntryOpKey()) && !this.isNoAutoMap() && (isCancel = this.beforeDeleteConfirm(bill.getExpenseEntryKey(), ResManager.loadKDString((String)"\u5220\u9664\u8be5\u5206\u5f55\u4f1a\u8054\u52a8\u5220\u9664\u53d1\u7968\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ErBillOpControlPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), entryEntities -> entryEntities.stream().anyMatch(entry -> StringUtils.isNotBlank((CharSequence)entry.getString("invoiceno_entry")))))) {
            evt.setCancel(isCancel);
        }
        if (source instanceof Label) {
            boolean isCancel2;
            Label label = (Label)source;
            if (StringUtils.equals((CharSequence)label.getKey(), (CharSequence)"expenseimportinvoice")) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(bill.getExpenseEntryKey());
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows != null && selectRows.length >= 1) {
                    EntryData entryData = entryGrid.getEntryData();
                    DynamicObject[] entryEntities2 = entryData.getDataEntitys();
                    boolean isFromExenesePool = Arrays.stream(selectRows).mapToObj(index -> entryEntities2[index].getString("wbsrcbilltype")).anyMatch(ErBillOpControlPlugin::isExpensePoolBill);
                    if (isFromExenesePool) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u6c60\u4e0b\u63a8\u7684\u5dee\u65c5\u660e\u7ec6\u5206\u5f55\u4e0d\u5141\u8bb8\u201c\u6309\u884c\u5bfc\u5165\u53d1\u7968\u201d\u3002", (String)"ErBillOpControlPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                    }
                }
            } else if (StringUtils.equals((CharSequence)label.getOperationKey(), (CharSequence)bill.getDeleteExpenseEntryOpKey()) && (isCancel2 = this.beforeDeleteConfirm("entryentity", ResManager.loadKDString((String)"\u5220\u9664\u8be5\u5206\u5f55\u4f1a\u8054\u52a8\u5220\u9664\u53d1\u7968\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"ErBillOpControlPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), entryEntities -> entryEntities.stream().anyMatch(entry -> StringUtils.isNotBlank((CharSequence)entry.getString("invoiceno_entry")))))) {
                evt.setCancel(isCancel2);
            }
        }
        if (key.equals(DELINVOICEHEADENTRY)) {
            Boolean isCancle = false;
            isCancle = !this.isNoAutoMap() ? this.deleteInvoiceEntryOpKey(bill) : Boolean.valueOf(this.beforeDeleteConfirm("invoiceentry", ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ErBillOpControlPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), m -> true));
            if (isCancle.booleanValue()) {
                evt.setCancel(isCancle.booleanValue());
            }
        }
    }

    private boolean isNoAutoMap() {
        return this.getModel().getDataEntityType().getProperties().containsKey((Object)"automapinvoice") && this.getView() instanceof IMobileView && (Boolean)this.getModel().getValue("automapinvoice") == false;
    }

    private boolean beforeDeleteConfirm(String entryName, String confirmMsg, Predicate<List<DynamicObject>> isNeedShowConfirm) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject[] entryEntities = (DynamicObject[])this.getModel().getEntryEntity(entryName).toArray((Object[])new DynamicObject[0]);
        if (entryEntities != null && entryEntities.length >= 1 && selectRows != null && selectRows.length >= 1 && isNeedShowConfirm.test(Arrays.stream(selectRows).mapToObj(index -> entryEntities[index]).collect(Collectors.toList()))) {
            ConfirmTransferBO transfer = new ConfirmTransferBO();
            transfer.setOK(false);
            transfer.setEntryName(entryName);
            transfer.setDeleteIds(IntStream.of(entryGrid.getSelectRows()).mapToObj(Integer::valueOf).collect(Collectors.toList()));
            ErCacheUtils.putValueToPageCache((IPageCache)this.getPageCache(), (String)DELETE_ENTRY_CALLBACK, (Object)transfer);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_ENTRY_CALLBACK, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        ConfirmTransferBO transfer;
        String callBackId = event.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)DELETE_ENTRY_CALLBACK) && event.getResult() == MessageBoxResult.Yes && (transfer = (ConfirmTransferBO)ErCacheUtils.getValueFromPageCache((IPageCache)this.getPageCache(), (String)DELETE_ENTRY_CALLBACK, ConfirmTransferBO.class)) != null && transfer.getDeleteIds() != null) {
            transfer.setOK(true);
            ErCacheUtils.removeInPage((IPageCache)this.getPageCache(), (String)DELETE_ENTRY_CALLBACK);
            this.getModel().deleteEntryRows(transfer.getEntryName(), transfer.getDeleteIds().stream().mapToInt(Integer::intValue).toArray());
            boolean needsuppleinvoice = (Boolean)this.getModel().getValue("needsuppleinvoice");
            boolean automapinvoice = (Boolean)this.getModel().getValue("automapinvoice");
            String billStatus = (String)this.getModel().getValue("billstatus");
            String name = this.getModel().getDataEntityType().getName();
            if (Arrays.asList(ErBillStatusEnum.E.name(), ErBillStatusEnum.F.name(), ErBillStatusEnum.G.name()).contains(billStatus) && (ErEntityTypeUtils.isPublicReimburseBill((String)name) || ErEntityTypeUtils.isDailyReimburseBill((String)name)) && this.getView() instanceof IMobileView && needsuppleinvoice && !automapinvoice) {
                this.getView().invokeOperation("saveinvoice");
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            String expensePoolIdsStr = (String)ErCacheUtils.getValueFromPageCache((IPageCache)this.getPageCache(), (String)DELETE_EXPENSE_POOL_IDS, String.class);
            ErCacheUtils.removeInPage((IPageCache)this.getPageCache(), (String)DELETE_EXPENSE_POOL_IDS);
            if (StringUtils.isNotBlank((CharSequence)expensePoolIdsStr)) {
                List expensePoolIds = JSON.parseArray((String)expensePoolIdsStr, Long.class);
                Set srcIdsFromExpensePool = expensePoolIds.stream().collect(Collectors.toSet());
                DynamicObjectCollection invoiceEntryDOs = this.getModel().getEntryEntity("invoiceentry");
                ArrayList needDelExpenseRowIndexs = Lists.newArrayListWithExpectedSize((int)invoiceEntryDOs.size());
                for (int i = 0; i < invoiceEntryDOs.size(); ++i) {
                    Long srcBillId = ((DynamicObject)invoiceEntryDOs.get(i)).getLong("invoicesrcbillid");
                    if (!srcIdsFromExpensePool.contains(srcBillId)) continue;
                    needDelExpenseRowIndexs.add(i);
                }
                if (!needDelExpenseRowIndexs.isEmpty()) {
                    this.getModel().deleteEntryRows("invoiceentry", needDelExpenseRowIndexs.stream().mapToInt(Integer::intValue).toArray());
                }
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            int[] deleteInvoiceIndexs = e.getRowIndexs();
            DynamicObjectCollection invoiceHeadEntryDOs = this.getModel().getEntryEntity("invoiceentry");
            if (invoiceHeadEntryDOs != null && !invoiceHeadEntryDOs.isEmpty()) {
                Set srcIdsFromExpensePool;
                List needDeleteInvoiceDOs = Arrays.stream(deleteInvoiceIndexs).mapToObj(index -> (DynamicObject)invoiceHeadEntryDOs.get(index)).collect(Collectors.toList());
                if (invoiceHeadEntryDOs.getDynamicObjectType().getProperty("invoicesrcbillid") != null && !(srcIdsFromExpensePool = needDeleteInvoiceDOs.stream().filter(invoiceEntry -> !Objects.equals(invoiceEntry.getLong("invoicesrcbillid"), 0L) && ErBillOpControlPlugin.isExpensePoolBill(invoiceEntry.getString("invoicesrcbilltype"))).map(entry -> entry.getLong("invoicesrcbillid")).collect(Collectors.toSet())).isEmpty()) {
                    ErCacheUtils.putValueToPageCache((IPageCache)this.getPageCache(), (String)DELETE_EXPENSE_POOL_IDS, srcIdsFromExpensePool);
                }
            }
        }
    }

    private static boolean isExpensePoolBill(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return false;
        }
        return ErEntityTypeUtils.isExpenseRecordBill((String)entityId) || ErEntityTypeUtils.isTripRecordBill((String)entityId);
    }

    private static class ConfirmTransferBO {
        private String entryName;
        private boolean isOK;
        private List<Integer> deleteIds;

        private ConfirmTransferBO() {
        }

        public boolean isOK() {
            return this.isOK;
        }

        public void setOK(boolean isOK) {
            this.isOK = isOK;
        }

        public List<Integer> getDeleteIds() {
            return this.deleteIds;
        }

        public void setDeleteIds(List<Integer> deleteIds) {
            this.deleteIds = deleteIds;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public void setEntryName(String entryName) {
            this.entryName = entryName;
        }
    }

    private static enum Bill {
        TripReimBill("er_tripreimbursebill", "entryentity", "deleteentry", "deleteentryexpen"),
        DailyReimBill("er_dailyreimbursebill", "expenseentryentity", "deleteinvoiceheadentry", "deleteentry"),
        PublicReimBill("er_publicreimbursebill", "expenseentryentity", "deleteinvoiceheadentry", "deleteentry");

        private static Map<String, Bill> billByEntityKey;
        private String entityKey;
        private String expenseEntryKey;
        private String deleteInvoiceEntryOpKey;
        private String deleteExpenseEntryOpKey;

        private Bill(String entityKey, String expenseEntryKey, String deleteInvoiceEntryOpKey, String deleteExpenseEntryOpKey) {
            this.entityKey = entityKey;
            this.expenseEntryKey = expenseEntryKey;
            this.deleteInvoiceEntryOpKey = deleteInvoiceEntryOpKey;
            this.deleteExpenseEntryOpKey = deleteExpenseEntryOpKey;
        }

        public String getEntityKey() {
            return this.entityKey;
        }

        public String getExpenseEntryKey() {
            return this.expenseEntryKey;
        }

        public String getDeleteInvoiceEntryOpKey() {
            return this.deleteInvoiceEntryOpKey;
        }

        public String getDeleteExpenseEntryOpKey() {
            return this.deleteExpenseEntryOpKey;
        }

        public static Bill getBillByEntityName(String entityKey) {
            return billByEntityKey.get(entityKey);
        }

        static {
            billByEntityKey = Maps.newHashMapWithExpectedSize((int)2);
            for (Bill b : Bill.values()) {
                billByEntityKey.put(b.getEntityKey(), b);
            }
        }
    }
}

