/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.clearold;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Label;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRemoveOldInvoicePlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(AbstractRemoveOldInvoicePlugin.class);

    private static String getMSG() {
        return ResManager.loadKDString((String)"\u7531\u4e8e\u672c\u6b21\u8865\u4e01\u5bf9\u5bfc\u5165\u53d1\u7968\u62a5\u9500\u529f\u80fd\u8fdb\u884c\u5347\u7ea7\uff0c\u5347\u7ea7\u540e\uff0c\u5386\u53f2\u6682\u5b58\u6216\u5ba1\u6838\u4e0d\u901a\u8fc7\u7684\u62a5\u9500\u5355\u4e2d\u5bfc\u5165\u7684\u53d1\u7968\u4e0d\u80fd\u6ee1\u8db3\u65b0\u6a21\u5f0f\u4e0b\u7684\u53d1\u7968\u7ba1\u7406\u9700\u8981\uff0c\u7cfb\u7edf\u4f1a\u5220\u9664\u8fd9\u4e9b\u53d1\u7968\u4e0e\u8d39\u7528\u660e\u7ec6\u4fe1\u606f\u3002\u82e5\u8fd9\u4e9b\u53d1\u7968\u4ecd\u9700\u8981\u62a5\u9500\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002", (String)"AbstractRemoveOldInvoicePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    public abstract void deleteItemEntryWithInvoice();

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"removeOldInvoice") && !KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection invoiceMergeEntry = dataEntity.getDynamicObjectCollection("invoicemerge");
            String invoiceMergeJson = SerializationUtils.toJsonString((Object)invoiceMergeEntry);
            String billJson = SerializationUtils.toJsonString((Object)dataEntity);
            log.warn("\u6e05\u9664\u8001\u7248\u672c\u53d1\u7968\u4fe1\u606f, \u5220\u9664\u524d\u7684\u5355\u636e\u6570\u636e\u662f:" + billJson);
            log.warn("\u8001\u7248\u672c\u4e0a\u7684\u53d1\u7968\u5e8f\u5217\u53f7\u662f:" + invoiceMergeJson);
            Set serialNosFromInvoiceMerge = dataEntity.getDynamicObjectCollection("invoicemerge").stream().map(invoiceMerge -> invoiceMerge.getString("serialno_merge")).collect(Collectors.toSet());
            Set serialNosFromInvoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry").stream().map(invoiceEntry -> invoiceEntry.getString("serialno")).collect(Collectors.toSet());
            log.warn("\u5373\u5c06\u91cd\u7f6e\u53d1\u7968\u4e3a\u672a\u4f7f\u7528serialNosFromInvoiceMerge>>>" + serialNosFromInvoiceMerge);
            log.warn("\u5373\u5c06\u91cd\u7f6e\u53d1\u7968\u4e3a\u672a\u4f7f\u7528serialNosFromInvoiceEntry>>>" + serialNosFromInvoiceEntry);
            if (serialNosFromInvoiceMerge.size() > 0 || serialNosFromInvoiceEntry.size() > 0) {
                DynamicObject costCompanyDO = dataEntity.getDynamicObject("costcompany");
                String billno_forCache = APIHelper.getBillNoCachedInCloud((DynamicObject)dataEntity);
                HashSet allSerialNos = Sets.newHashSet(serialNosFromInvoiceMerge);
                allSerialNos.addAll(serialNosFromInvoiceEntry);
                String serialNosStr = StringUtils.join((Iterable)allSerialNos, (String)",");
                log.warn("\u5373\u5c06\u91cd\u7f6e\u53d1\u7968\u4e3a\u672a\u4f7f\u7528serialNosStr" + serialNosStr);
                InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)costCompanyDO));
                try {
                    APIHelper.updateInvoiceStatus((InvoiceCloudCfgBO)config, (InvoiceStatusEnum)InvoiceStatusEnum.unused, (String)billno_forCache, (String)serialNosStr, (String)dataEntity.getString("billno"));
                }
                catch (Exception e) {
                    log.info("\u5347\u7ea7\u6570\u636e\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38: " + serialNosStr);
                    log.error((Throwable)e);
                }
            }
            this.deleteItemEntryWithInvoice();
            model.deleteEntryData("invoiceentry");
            model.deleteEntryData("invoicemerge");
            model.deleteEntryData("invoiceitementry");
            Label countLab = (Label)this.getControl("lbl_invoicecount");
            Label amountLab = (Label)this.getControl("lbl_totalamount");
            if (countLab != null) {
                countLab.setText("0");
            }
            if (amountLab != null) {
                amountLab.setText("\uffe50.00");
            }
            this.getView().invokeOperation("save");
        }
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        int oldInvoiceCount = model.getEntryRowCount("invoicemerge");
        if (Arrays.asList("A", "D").contains(billStatus) && oldInvoiceCount > 0) {
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("removeOldInvoice", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7", (String)"AbstractRemoveOldInvoicePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), AbstractRemoveOldInvoicePlugin.getMSG(), MessageBoxOptions.OK, ConfirmTypes.Save, callBack);
        }
    }
}

