/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.clearold;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.formplugin.invoicecloud.v2.clearold.AbstractRemoveOldInvoicePlugin;
import org.apache.commons.lang3.StringUtils;

public class RemoveOldInvoiceForTripReimPlugin
extends AbstractRemoveOldInvoicePlugin {
    private static String TRIP_ENTRY = "tripentry";
    private static String TRIP_ITEM_ENTRY = "entryentity";
    private static final Log log = LogFactory.getLog(RemoveOldInvoiceForTripReimPlugin.class);

    @Override
    public void deleteItemEntryWithInvoice() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tripEntryDOs = dataEntity.getDynamicObjectCollection(TRIP_ENTRY);
        int tripEntryCount = model.getEntryRowCount(TRIP_ENTRY);
        for (int tripIndex = 0; tripIndex < tripEntryCount; ++tripIndex) {
            model.setEntryCurrentRowIndex(TRIP_ENTRY, tripIndex);
            DynamicObject tripEntryDO = (DynamicObject)tripEntryDOs.get(tripIndex);
            DynamicObjectCollection tripItemEntryDOs = tripEntryDO.getDynamicObjectCollection(TRIP_ITEM_ENTRY);
            ArrayList needDelItemIndexs = Lists.newArrayList();
            for (int tripItemIdex = 0; tripItemIdex < tripItemEntryDOs.size(); ++tripItemIdex) {
                DynamicObject tirpItemEntryDO = (DynamicObject)tripItemEntryDOs.get(tripItemIdex);
                String invoiceNo = tirpItemEntryDO.getString("invoiceno_entry");
                if (!StringUtils.isNotBlank((CharSequence)invoiceNo)) continue;
                needDelItemIndexs.add(tripItemIdex);
            }
            if (needDelItemIndexs.isEmpty()) continue;
            log.info("\u5f85\u5220\u9664\u7684\u5dee\u65c5\u9879\u76ee\u5206\u5f55\u5e8f\u53f7\u662f:" + needDelItemIndexs);
            model.deleteEntryRows(TRIP_ITEM_ENTRY, needDelItemIndexs.stream().mapToInt(i -> i).toArray());
        }
        if (tripEntryCount > 0) {
            model.setEntryCurrentRowIndex(TRIP_ENTRY, 0);
        }
    }
}

