/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.collection.one4one;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceIframeUrlReqParam;
import kd.fi.er.business.invoicecloud.util.InvoiceProcessUtil;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.CopyInvoiceVOToInvoiceEntryBOServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.OffsetAmountInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.PubReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoicesOne4OneServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveDuplicateInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoiceForReimOne4One
extends AbstractImportInvoicePlugin {
    private static final Log log = LogFactory.getLog(AbstractImportInvoiceForReimOne4One.class);

    @Override
    public void showInvoiceList(List<String> serialNos) {
    }

    @Override
    public void processInvoiceVO(InvoiceContext invoiceContext) {
        BeforeImportInvoiceService beforeImportServiceImpl = this.getBeforeImportInvoiceServiceImpl(invoiceContext);
        RemoveInvoiceService removeDuplicateInvoiceService = this.getRemoveDuplicateInvoiceServiceImpl(invoiceContext);
        PreHandleInvoiceService addInvoiceItemService = this.getPreHandleInvoiceServiceImpl(invoiceContext);
        CopyInvoiceVOToInvoiceEntryBOServiceImpl copyInvoiceVOToInvoiceEntryBOService = new CopyInvoiceVOToInvoiceEntryBOServiceImpl(invoiceContext, this.getView().getEntityId());
        OffsetAmountInvoiceServiceImpl offsetAmountInvoiceService = new OffsetAmountInvoiceServiceImpl(invoiceContext);
        IInvoiceService mappingExpenseOrTripItemInvoiceService = this.getMappingItemImpl(invoiceContext);
        MergeInvoicesOne4OneServiceImpl mergeInvoiceServiceImpl = new MergeInvoicesOne4OneServiceImpl(invoiceContext, this.getView().getEntityId(), this.getModel());
        IInvoiceService BeforeCreateItemServiceImpl = this.getBeforeCreateItemServiceImpl(invoiceContext);
        PubReimburseBeforeImportInvoiceServiceImpl beforeImportInvoiceService = new PubReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getView());
        CreateInvoiceServiceI createInvoiceEntryServiceImpl = this.getCreateInvoiceService(invoiceContext);
        IInvoiceService createExpenseOrTripItemService = this.getCreateExpenseOrTripItemService(invoiceContext);
        IInvoiceService afterCreateExpenseOrTripItemService = this.getAfterCreateExpenseOrTripItemService(invoiceContext);
        this.addProcessServices(new IInvoiceService[]{beforeImportServiceImpl, removeDuplicateInvoiceService, addInvoiceItemService, copyInvoiceVOToInvoiceEntryBOService, offsetAmountInvoiceService, mappingExpenseOrTripItemInvoiceService, mergeInvoiceServiceImpl, BeforeCreateItemServiceImpl, beforeImportInvoiceService, createInvoiceEntryServiceImpl, createExpenseOrTripItemService, afterCreateExpenseOrTripItemService});
    }

    @Override
    public PreHandleInvoiceService getPreHandleInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new PreHandleInvoiceServiceImpl(invoiceContext);
    }

    @Override
    public RemoveInvoiceService getRemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new RemoveDuplicateInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public CreateInvoiceServiceI getCreateInvoiceService(InvoiceContext invoiceContext) {
        return new CreateInvoiceEntryServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public String getTaxRegNum() {
        DynamicObject costCompanyDO = this.getCostCompanyDO();
        if (costCompanyDO == null) {
            log.info("\u5f53\u524d\u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a");
            return "";
        }
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)((Long)costCompanyDO.getPkValue()));
        return taxRegNum;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)this.getCloseCallBackKey())) {
            if (ErStdConfig.isDev() && !ErStdConfig.getShowImportInvoiceDataSimulatorPC()) {
                QueryBySerialNoAction action = new QueryBySerialNoAction("test");
                String apiReturnJson = action.execute();
                try {
                    List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                    this.executeProcess(invoiceVOs);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.getView().showErrorNotification(e.getMessage());
                }
            } else {
                this.showSelectedInvoicePage();
            }
        }
    }

    protected void showSelectedInvoicePage() {
        DynamicObject costCompany = this.getCostCompanyDO();
        if (costCompany == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3002", (String)"AbstractImportInvoiceForReimOne4One_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)((Long)costCompany.getPkValue()));
        if (config == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"AbstractImportInvoiceForReimOne4One_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        String firmName = config.getFirmname();
        if (StringUtils.isBlank((CharSequence)firmName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u4f01\u4e1a\u5de5\u5546\u767b\u8bb0\u540d\u79f0\u672a\u586b\u5199\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u540e\u518d\u4f7f\u7528\u53d1\u7968\u5bfc\u5165\u529f\u80fd\u3002", (String)"AbstractImportInvoiceForReimOne4One_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ImportInvoiceIframeUrlReqParam importRequestParam = new ImportInvoiceIframeUrlReqParam();
        importRequestParam.setBillId(APIHelper.getBillNoCachedInCloud((DynamicObject)this.getModel().getDataEntity()));
        importRequestParam.setTaxRegNum(this.getTaxRegNum());
        importRequestParam.setInvoiceCompanyId((Long)this.getCostCompanyDO().getPkValue());
        importRequestParam.setEntityName(this.getView().getEntityId());
        String callBackKey = this.getAnotherCloseCallBackKey();
        if (!this.checkCacheClickKey(callBackKey)) {
            callBackKey = this.getCloseCallBackKey();
        }
        ShowInvoiceCloudPageUtil.showImportInvoicePageInPC((AbstractFormPlugin)this, this.getModel(), new CloseCallBack((IFormPlugin)this, callBackKey), importRequestParam);
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        super.loadAfterProcessUpdateData(context);
        InvoiceProcessUtil.refreshLinkage((IFormView)this.getExtView());
    }

    @Override
    protected boolean isUseExpenseDate() {
        return this.getBillType() != MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }
}

