/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.expensepool;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.servicehelper.InvoiceServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimMobInOneExpenseItem;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForPoolPCInOneExpenseItemMob
extends AbstractImportInvoiceForReimMobInOneExpenseItem {
    private static final String IMPORT_INVOICE_FLEX = "importinvoice_flex";
    private static final String INVOICE_SUMMARY_FLEX = "invoicesummary_flex";
    private static final String INVOICE_COUNT_LAB = "lbl_invoicecount";
    private static final String INVOICE_AMOUNT_LAB = "lbl_totalamount";
    private static final String IMPORT_INVOICE_IMG = "imageap_photo";
    private Log logger = LogFactory.getLog(ImportInvoiceForPoolPCInOneExpenseItemMob.class);
    private String[] week = new String[]{ResManager.loadKDString((String)"\u5468\u4e00", (String)"ImportInvoiceForPoolPCInOneExpenseItemMob_2", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5468\u4e8c", (String)"ImportInvoiceForPoolPCInOneExpenseItemMob_3", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5468\u4e09", (String)"ImportInvoiceForPoolPCInOneExpenseItemMob_4", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5468\u56db", (String)"ImportInvoiceForPoolPCInOneExpenseItemMob_5", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5468\u4e94", (String)"ImportInvoiceForPoolPCInOneExpenseItemMob_6", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5468\u516d", (String)"ImportInvoiceForPoolPCInOneExpenseItemMob_7", (String)"fi-er-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5468\u65e5", (String)"ImportInvoiceForPoolPCInOneExpenseItemMob_8", (String)"fi-er-formplugin", (Object[])new Object[0])};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{IMPORT_INVOICE_IMG, INVOICE_SUMMARY_FLEX});
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public String getTaxRegNum() {
        return null;
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        serialNos.removeIf(serialNo -> StringUtils.isBlank((CharSequence)serialNo));
        String taxRegNum = this.getTaxRegNum();
        if (StringUtils.isBlank((CharSequence)taxRegNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"ImportInvoiceForPoolPCInOneExpenseItem_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        ShowInvoiceCloudPageUtil.showAllInvoiceListInMiniProgram((AbstractFormPlugin)this, config, serialNos);
    }

    private void updateInvoiceSummaryLabel() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        int invoiceCount = invoiceEntryDOs.stream().mapToInt(invoiceHead -> invoiceHead.getInt("count")).sum();
        BigDecimal invoiceTotalAmount = invoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Label countLab = (Label)this.getControl(INVOICE_COUNT_LAB);
        Label amountLab = (Label)this.getControl(INVOICE_AMOUNT_LAB);
        countLab.setText(String.valueOf(invoiceCount));
        Integer amtprecision = 4;
        String sign = "\uffe5";
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        Long invoiceEntryCurrency = SystemParamterUtil.getInvoiceEntryCurrency((Long)((Long)company.getPkValue()));
        if (invoiceEntryCurrency != null && !currency.getPkValue().equals(invoiceEntryCurrency)) {
            String selectPropties = "id,createorg,number,name,enable,sign,amtprecision";
            DynamicObject invoiceCurrency = BusinessDataServiceHelper.loadSingle((Object)invoiceEntryCurrency, (String)"bd_currency", (String)selectPropties);
            if (invoiceCurrency != null) {
                sign = invoiceCurrency.getString("sign");
                amtprecision = invoiceCurrency.getInt("amtprecision");
            }
        } else {
            sign = currency.getString("sign");
            amtprecision = currency.getInt("amtprecision");
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)invoiceTotalAmount);
        amountLab.setText(formatMoneyByUser);
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.updateInvoiceSummaryLabel();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control ctl = (Control)source;
            if (StringUtils.equals((CharSequence)ctl.getKey(), (CharSequence)IMPORT_INVOICE_IMG)) {
                this.importInvoiceMob(ctl.getKey());
            } else if (StringUtils.equals((CharSequence)ctl.getKey(), (CharSequence)INVOICE_SUMMARY_FLEX)) {
                this.showAllInvoice();
            }
            String key = ctl.getKey();
            if ("vectorap111".equals(key) || "flex_arow111".equals(key)) {
                this.setVector(this.getView());
            }
        }
    }

    private void showAllInvoice() {
        List serialNos = InvoiceServiceHelper.getAllSerialNos((IDataModel)this.getModel());
        if (serialNos == null || serialNos.isEmpty()) {
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        ShowInvoiceCloudPageUtil.showAllInvoiceListInMiniProgram((AbstractFormPlugin)this, config, serialNos);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                this.logger.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + importInvoiceReturnData.toJSONString());
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getView().getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            this.invoiceDeletePageRule(this.isDeleting());
        }
    }

    @Override
    protected boolean isUseExpenseDate() {
        return false;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
        this.updateInvoiceSummaryLabel();
        this.updateImportInvoiceAfterEnableOrDisable();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateImportInvoiceAfterEnableOrDisable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        Object newCostCompanyDO;
        IDataEntityProperty property = e.getProperty();
        if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)"costcompany") && (newCostCompanyDO = (changeData = e.getChangeSet()[0]).getNewValue()) != null) {
            this.updateImportInvoiceAfterEnableOrDisable();
        }
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.updateInvoiceSummaryLabel();
        this.showTripInfo();
    }

    private void updateImportInvoiceAfterEnableOrDisable() {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        if (config != null) {
            if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud() && !KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloudInMob()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_INVOICE_FLEX, INVOICE_SUMMARY_FLEX});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{IMPORT_INVOICE_FLEX, INVOICE_SUMMARY_FLEX});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{IMPORT_INVOICE_FLEX, INVOICE_SUMMARY_FLEX});
            int invoiceCount = this.getModel().getEntryRowCount("invoiceentry");
            if (invoiceCount > 0) {
                this.getModel().deleteEntryRows("invoiceentry", IntStream.range(0, invoiceCount).toArray());
            }
        }
    }

    private void showTripInfo() {
        IDataModel model = this.getModel();
        String formid = (String)model.getValue("formid");
        Boolean isTrip = StringUtils.equals((CharSequence)formid, (CharSequence)"er_trip_recordbill");
        if (!isTrip.booleanValue()) {
            return;
        }
        this.showTripInfoLbl();
        this.showVehicleLbl();
        this.showFromToLbl();
        this.showDateLbl();
        this.showAreaLbl();
        this.refreshLbl();
    }

    private void showTripInfoLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"tripcityfield", "tripfrom", "tripto", "trippassenger", "startdate", "tripcheckindate", "tripdeparturedate", "triparea", "tripmulseatgrade"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"trip_info_card_flex"});
    }

    private void showVehicleLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"vehicle"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"vehicle"});
    }

    private void showFromToLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"tripcityfield", "tripfrom", "tripto"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"fromto_labe"});
    }

    private void showDateLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"trippassenger", "startdate", "tripcheckindate", "tripdeparturedate"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"trip_datetime_labe"});
    }

    private void showAreaLbl() {
        HashSet checkKeySet = Sets.newHashSet((Object[])new String[]{"triparea", "tripmulseatgrade"});
        this.getView().setVisible(this.isNotNull(this.getModel(), checkKeySet), new String[]{"tripmulseatgrade_labe"});
    }

    private Boolean isNotNull(IDataModel model, Set<String> checkKeySet) {
        Boolean isNotNull = Boolean.FALSE;
        for (String key : checkKeySet) {
            Object value = model.getValue(key);
            if (value == null) continue;
            if (value instanceof DynamicObjectCollection) {
                if (((DynamicObjectCollection)value).isEmpty()) continue;
                isNotNull = Boolean.TRUE;
                continue;
            }
            if (value instanceof String) {
                if (StringUtils.isBlank((CharSequence)((String)value)) || StringUtils.equals((CharSequence)key, (CharSequence)"vehicle") && StringUtils.equals((CharSequence)((String)value), (CharSequence)"0")) continue;
                isNotNull = Boolean.TRUE;
                continue;
            }
            isNotNull = Boolean.TRUE;
        }
        return isNotNull;
    }

    private void refreshLbl() {
        IDataModel dataModel = this.getModel();
        String vehicle = (String)dataModel.getValue("vehicle");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)vehicle) || StringUtils.equals((CharSequence)"2", (CharSequence)vehicle) || StringUtils.equals((CharSequence)"3", (CharSequence)vehicle) || StringUtils.equals((CharSequence)"4", (CharSequence)vehicle)) {
            DynamicObject tripfrom = (DynamicObject)dataModel.getValue("tripfrom");
            DynamicObject tripto = (DynamicObject)dataModel.getValue("tripto");
            Date startdate = (Date)dataModel.getValue("startdate");
            String trippassenger = dataModel.getValue("trippassenger").toString();
            DynamicObjectCollection tripmulseatgrade = (DynamicObjectCollection)dataModel.getValue("tripmulseatgrade");
            StringBuilder mulseatgrade = new StringBuilder();
            tripmulseatgrade.forEach(dynamicObject -> mulseatgrade.append(dynamicObject.getDynamicObject(1).get("name").toString()));
            Label fromToLabe = (Label)this.getControl("fromto_labe");
            Label tripDatetimeLabe = (Label)this.getControl("trip_datetime_labe");
            Label tripMulseatgradeLabe = (Label)this.getControl("tripmulseatgrade_labe");
            StringBuilder fromToLabeStr = new StringBuilder();
            if (tripfrom != null) {
                fromToLabeStr.append(tripfrom.getString("name"));
            }
            if (tripto != null && tripfrom != null) {
                fromToLabeStr.append(" \u2014 ").append(tripto.getString("name"));
            } else if (tripto != null && tripfrom == null) {
                fromToLabeStr.append(tripto.getString("name"));
            }
            fromToLabe.setText(fromToLabeStr.toString());
            StringBuilder dateStr = new StringBuilder();
            if (startdate != null) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
                String dateString = formatter.format(startdate);
                dateStr.append(dateString).append(" ");
                dateStr.append(this.dayForWeek(startdate)).append(" ");
            }
            if (StringUtils.isNotBlank((CharSequence)trippassenger)) {
                if (!StringUtils.isBlank((CharSequence)dateStr.toString())) {
                    dateStr.append("| ").append(trippassenger);
                } else {
                    dateStr.append(trippassenger);
                }
            }
            tripDatetimeLabe.setText(dateStr.toString());
            if (StringUtils.isBlank((CharSequence)mulseatgrade.toString())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tripmulseatgrade_labe"});
            } else {
                tripMulseatgradeLabe.setText(mulseatgrade.toString());
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tripmulseatgrade_labe"});
            }
        } else if (StringUtils.equals((CharSequence)"6", (CharSequence)vehicle)) {
            String dateString;
            SimpleDateFormat formatter;
            Label fromToLabe = (Label)this.getControl("fromto_labe");
            Label tripDatetimeLabe = (Label)this.getControl("trip_datetime_labe");
            Label tripMulseatgradeLabe = (Label)this.getControl("tripmulseatgrade_labe");
            Date tripCheckinDate = (Date)dataModel.getValue("tripcheckindate");
            Date tripDepartureDate = (Date)dataModel.getValue("tripdeparturedate");
            DynamicObject tripcityfield = (DynamicObject)dataModel.getValue("tripcityfield");
            DynamicObject triparea = (DynamicObject)dataModel.getValue("triparea");
            StringBuilder tripCheckinDateStr = new StringBuilder();
            if (tripCheckinDate != null) {
                formatter = new SimpleDateFormat("yyyy/MM/dd");
                dateString = formatter.format(tripCheckinDate);
                tripCheckinDateStr.append(dateString).append(" ");
                tripCheckinDateStr.append(this.dayForWeek(tripCheckinDate)).append(" ");
            }
            if (tripDepartureDate != null) {
                formatter = new SimpleDateFormat("yyyy/MM/dd");
                dateString = formatter.format(tripDepartureDate);
                tripCheckinDateStr.append("- ").append(dateString).append(" ");
                tripCheckinDateStr.append(this.dayForWeek(tripDepartureDate)).append(" ");
            }
            tripDatetimeLabe.setText(tripCheckinDateStr.toString());
            if (tripcityfield != null) {
                fromToLabe.setText(tripcityfield.getString("name"));
            }
            if (triparea != null) {
                tripMulseatgradeLabe.setText(triparea.getString("name"));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tripmulseatgrade_labe"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tripmulseatgrade_labe"});
            }
        } else if (StringUtils.equals((CharSequence)"5", (CharSequence)vehicle)) {
            String dateString;
            SimpleDateFormat formatter;
            Label fromToLabe = (Label)this.getControl("fromto_labe");
            Label tripDatetimeLabe = (Label)this.getControl("trip_datetime_labe");
            Label tripMulseatgradeLabe = (Label)this.getControl("tripmulseatgrade_labe");
            Date tripCheckinDate = (Date)dataModel.getValue("tripcheckindate");
            Date tripDepartureDate = (Date)dataModel.getValue("tripdeparturedate");
            DynamicObject tripcityfield = (DynamicObject)dataModel.getValue("tripcityfield");
            DynamicObject triparea = (DynamicObject)dataModel.getValue("triparea");
            StringBuilder tripCheckinDateStr = new StringBuilder();
            if (tripCheckinDate != null) {
                formatter = new SimpleDateFormat("yyyy/MM/dd");
                dateString = formatter.format(tripCheckinDate);
                tripCheckinDateStr.append(dateString).append(" ");
                tripCheckinDateStr.append(this.dayForWeek(tripCheckinDate)).append(" ");
            }
            if (tripDepartureDate != null) {
                formatter = new SimpleDateFormat("yyyy/MM/dd");
                dateString = formatter.format(tripDepartureDate);
                tripCheckinDateStr.append("- ").append(dateString).append(" ");
                tripCheckinDateStr.append(this.dayForWeek(tripDepartureDate)).append(" ");
            }
            tripDatetimeLabe.setText(tripCheckinDateStr.toString());
            if (tripcityfield != null) {
                fromToLabe.setText(tripcityfield.getString("name"));
            }
            if (triparea != null) {
                tripMulseatgradeLabe.setText(triparea.getString("name"));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tripmulseatgrade_labe"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tripmulseatgrade_labe"});
            }
        }
    }

    private String dayForWeek(Date pTime) {
        int dayForWeek = 0;
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(pTime);
            dayForWeek = 0;
            dayForWeek = c.get(7) == 1 ? 7 : c.get(7) - 1;
        }
        catch (Exception e) {
            this.logger.error("dayForWeek----> error", (Throwable)e);
        }
        return this.week[dayForWeek - 1];
    }
}

