/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.mob;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalMergeExpenseOrTripItemInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.incrementalService.IncrementalServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimMobByItemEntry;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimGridMobMergePlugIn
extends AbstractImportInvoiceForReimMobByItemEntry {
    private static final Log log = LogFactory.getLog(ImportInvoiceForTripReimGridMobMergePlugIn.class);
    private static String importInvoiceTypeKey = "";

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateTripItemEntryServiceImpl service = new CreateTripItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
        service.setCurSelectedItem(this.getSelectedItem());
        return service;
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"invoice_add"});
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        super.loadAfterProcessUpdateData(context);
        AmountChangeUtil.recalcReimburseAmountField((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true);
        AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)this.getModel().getValue("loanchecktype")));
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        InvoiceUtils.updateInvoiceLabel((IFormView)this.getView());
    }

    @Override
    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control ctl = (Control)source;
            String key = ctl.getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"invoice_add")) {
                this.importInvoiceMob(importInvoiceTypeKey);
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"importinvoicemergebyitem") || StringUtils.equals((CharSequence)key, (CharSequence)"importinvoiceallforone")) {
                importInvoiceTypeKey = key;
                this.getModel().setValue("editentry", (Object)"4");
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + importInvoiceReturnData.toJSONString());
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getView().getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            this.invoiceDeletePageRule(this.isDeleting());
        }
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        Control cot = (Control)evt.getSource();
        String key = cot.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"invoice_add") && "importinvoicemergebyitem".equalsIgnoreCase(importInvoiceTypeKey)) {
            this.checkInvoiceImport(evt, key);
        }
    }

    @Override
    public IncrementalServiceI getIncrementalService(InvoiceContext invoiceContext, int index) {
        return new IncrementalMergeExpenseOrTripItemInvoiceServiceImp(invoiceContext, this.getModel(), true);
    }

    @Override
    protected int getCurrentIndex() {
        return this.getModel().getEntryCurrentRowIndex("entryentity");
    }

    @Override
    protected boolean isUseExpenseDate() {
        return false;
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return null;
    }

    @Override
    protected DynamicObject getSelectedItem() {
        int tripRowIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
        int tripItemRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject curSelectedItem = this.getModel().getEntryRowEntity("entryentity", tripItemRowIndex, tripRowIndex);
        if ((Long)curSelectedItem.getPkValue() == 0L) {
            Long entryId = ORM.create().genLongId(this.getView().getEntityId());
            curSelectedItem.set("id", (Object)entryId);
        }
        return curSelectedItem;
    }
}

