/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.mob;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimGridSecondMob
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ImportInvoiceForTripReimGridSecondMob.class);
    private static final String TRIP_ITEM_ENTRY = "entryentity";
    private static final String INVOICE_AND_EXPENSE_ENTRY = "invoiceandexpense";
    private static final String INVOICE_ITEM_ENTRY = "invoiceitementry";
    private static final String INVOICE_HEAD_ENTRY = "invoiceentry";

    public void afterBindData(EventObject e) {
        ShowInvoiceCloudPageUtil.registCheckback(this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"travelcostcompany")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            int tripEntryCount = model.getEntryRowCount(TRIP_ITEM_ENTRY);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object customIndex = customParams.get("index");
            boolean isFirstTripEntry = Objects.equals(customIndex, 0) || customIndex == null && tripEntryCount == 1 && rowIndex == 0;
            DynamicObject newCostCompanyDO = (DynamicObject)newValue;
            if (newValue == null) {
                return;
            }
            if (newValue != null && isFirstTripEntry) {
                Map<Long, Set<Long>> itemMapInvoice = Maps.newHashMap();
                if (this.getView().getParentView() != null && this.getView().getParentView().getModel().getProperty(INVOICE_ITEM_ENTRY) != null && !(itemMapInvoice = InvoiceUtils.autoMapInvoiceMappingInfo((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true))).isEmpty()) {
                    boolean isImportNonDeductionTaxAmout = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)((Long)newCostCompanyDO.getPkValue()));
                    DynamicObjectCollection coll = this.getModel().getEntryEntity(TRIP_ITEM_ENTRY);
                    for (int i = 0; i < coll.size(); ++i) {
                        this.refreshItemTaxAndTaxAmount((DynamicObject)coll.get(i), itemMapInvoice, isImportNonDeductionTaxAmout, 0, i);
                    }
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"invoiceno_entry"});
        CardEntry entryEnity = (CardEntry)this.getControl(TRIP_ITEM_ENTRY);
        entryEnity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        Control ctl;
        Object source = evt.getSource();
        if (!(source instanceof Control) || StringUtils.equals((CharSequence)(ctl = (Control)source).getKey(), (CharSequence)"invoiceno_entry")) {
            // empty if block
        }
    }

    private Long getInvoiceOrgId() {
        DynamicObject costCompanyDO = (DynamicObject)this.getView().getParentView().getModel().getValue("costcompany");
        return ErCommonUtils.getPk((Object)costCompanyDO);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"invoiceno_entry")) {
            int rowIndex = event.getRowIndex();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection tripItemEntities = dataEntity.getDynamicObjectCollection(TRIP_ITEM_ENTRY);
            Long tripItemEntryId = (Long)((DynamicObject)tripItemEntities.get(rowIndex)).getPkValue();
            if (!Objects.equals(tripItemEntryId, 0L)) {
                IDataModel pModel = this.getView().getParentView().getModel();
                Set<String> serialNos = this.getSerialNoByTripItemId(pModel.getDataEntity(true), tripItemEntryId);
                logger.info("\u70b9\u51fb\u53d1\u7968\u8d85\u94fe\u63a5\uff0cserialno: " + serialNos);
                if (!serialNos.isEmpty()) {
                    InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getInvoiceOrgId()));
                    ShowInvoiceCloudPageUtil.showInvoiceListInMiniProgram(this, config, serialNos, pModel);
                }
            }
        }
    }

    private Set<String> getSerialNoByTripItemId(DynamicObject dataEntity, Long tripItemEntryId) {
        if (Objects.equals(tripItemEntryId, 0L)) {
            return Collections.emptySet();
        }
        DynamicObjectCollection invoiceItemEntrys = dataEntity.getDynamicObjectCollection(INVOICE_ITEM_ENTRY);
        Set invoiceHeadEntryIdsFromDetail = invoiceItemEntrys.stream().filter(entry -> Objects.equals(tripItemEntryId, entry.getLong("itementryid"))).map(entry -> entry.getLong("invoiceheadentryid")).collect(Collectors.toSet());
        DynamicObjectCollection invoiceAndExpenseEntrys = dataEntity.getDynamicObjectCollection(INVOICE_AND_EXPENSE_ENTRY);
        Set invoiceHeadEntryIdsFromRelation = invoiceAndExpenseEntrys.stream().filter(entry -> Objects.equals(tripItemEntryId, entry.getLong("expenseentryid"))).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
        DynamicObjectCollection invoiceHeadEntrys = dataEntity.getDynamicObjectCollection(INVOICE_HEAD_ENTRY);
        Set<String> serialNos = invoiceHeadEntrys.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getString("invoicefrom"), (CharSequence)ItemFrom.InvoiceCloud.getValue())).filter(entry -> invoiceHeadEntryIdsFromDetail.contains(entry.getPkValue()) || invoiceHeadEntryIdsFromRelation.contains(entry.getPkValue())).map(entry -> entry.getString("serialno")).filter(serialNo -> StringUtils.isNotBlank((CharSequence)serialNo)).collect(Collectors.toSet());
        return serialNos;
    }

    private void refreshItemTaxAndTaxAmount(DynamicObject item, Map<Long, Set<Long>> itemMapInvoice, boolean isImportNonDeductionTaxAmout, int parentIndex, int itemIndex) {
        if (item == null) {
            return;
        }
        Set<Long> invoiceHeadIds = itemMapInvoice.get(item.getPkValue());
        if (invoiceHeadIds == null) {
            return;
        }
        IDataModel model = this.getModel();
        IDataModel pModel = this.getView().getParentView().getModel();
        DynamicObject pBill = pModel.getDataEntity(true);
        BigDecimal invoiceTaxAmout = pBill.getDynamicObjectCollection(INVOICE_ITEM_ENTRY).stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid"))).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal taxRate = BigDecimal.ZERO;
        Set taxRates = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection)pBill.getDynamicObjectCollection(INVOICE_ITEM_ENTRY), invoiceHeadIds).map(v -> v.getBigDecimal("invoiceitemtaxrate")).collect(Collectors.toSet());
        if (taxRates.size() == 1) {
            taxRate = (BigDecimal)taxRates.iterator().next();
        }
        if (!isImportNonDeductionTaxAmout) {
            BigDecimal reInvoiceTaxAmount = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection)pBill.getDynamicObjectCollection(INVOICE_ITEM_ENTRY), invoiceHeadIds).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (invoiceTaxAmout.compareTo(reInvoiceTaxAmount) != 0 || reInvoiceTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                taxRate = BigDecimal.ZERO;
            }
            invoiceTaxAmout = reInvoiceTaxAmount;
        }
        model.setValue("taxrate", (Object)taxRate.multiply(BigDecimal.valueOf(100L)), itemIndex, parentIndex);
        model.setValue("taxamount", (Object)invoiceTaxAmout, itemIndex, parentIndex);
    }
}

