/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.mob.noautomap;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.list.MobileSearch;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.invoicecloud.v2.mob.noautomap.ErAbsInvoiceRelateExpenseMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;

public class ErInvoiceRelateExpenseMobPlugin
extends ErAbsInvoiceRelateExpenseMobPlugin {
    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelap", "invoicelabelap"});
        this.addSearchListener("expensesearchap");
        this.addSearchListener("invoicesearchap");
        this.addRowClick("expenseentryentity");
        this.addRowClick("invoiceentry");
        this.addClickListeners(new String[]{"cancel", "confrim"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control && "confrim".equals(((Control)evt.getSource()).getKey())) {
            List<Long> expenseIds = this.getSelectedRowEntryId(this.getView());
            List<Long> invoiceIds = this.getChooseIds("invoiceentry");
            HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(4);
            map.put(this.getBillType().getExpenseEntryEntityName(), expenseIds);
            map.put("invoiceentry", invoiceIds);
            String msg = RelateExpenseOrTripItemAndInvoiceUtil.checkRelate((IFormView)this.getView().getParentView(), (BillOfInvoice)this.getBillType(), expenseIds, invoiceIds);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
            } else {
                this.getView().returnDataToParent(map);
                this.getView().close();
            }
        }
    }

    @Override
    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String key;
        super.click(mobileSearchTextChangeEvent);
        MobileSearch search = (MobileSearch)mobileSearchTextChangeEvent.getSource();
        switch (key = search.getKey()) {
            case "expensesearchap": {
                this.createExpense(mobileSearchTextChangeEvent.getText());
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Object source = evt.getSource();
        if (source instanceof EntryGrid) {
            EntryGrid grid = (EntryGrid)source;
            String entryKey = grid.getEntryKey();
            int[] rowIndexs = grid.getSelectRows();
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)entryKey, (CharSequence)BillOfInvoice.DailyReimburseBill.getExpenseEntryEntityName()) && rowIndexs != null) {
                this.selectedRelateInvoiceEntryByClickExpenseEntry();
            }
        }
    }

    @Override
    protected void createExpense(String search) {
        this.createData(this.getBillView(), "expenseentryentity", Arrays.asList("expenseitem", "expenseamount", "invoiceno_entry", "remark", "happendate"), search);
    }

    @Override
    protected void chooseExpense(String entry, boolean all) {
        this.choose(entry, all);
    }

    @Override
    protected void selectedRelateInvoiceEntryByClickExpenseEntry() {
        this.selectedRelateInvoiceEntryByClickExpenseEntry(this.getSelectedRowEntryId(this.getView()));
    }

    @Override
    protected BillOfInvoice getBillType() {
        return BillOfInvoice.DailyReimburseBill;
    }

    @Override
    protected IFormView getBillView() {
        return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
    }
}

