/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.mob.noautomap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.invoicecloud.v2.mob.noautomap.ErAbsInvoiceRelateExpenseMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;

public class ErInvoiceRelateExpenseTripMobPlugin
extends ErAbsInvoiceRelateExpenseMobPlugin {
    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addSearchListener("expensesearchap");
        this.addRowClick("expenseentryentity");
        this.addClickListeners(new String[]{"cancel", "confrim"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String pageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(pageId);
        this.getModel().setValue("billkind", parentView.getModel().getValue("billkind"));
        super.afterCreateNewData(e);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control && "cancel".equals(((Control)evt.getSource()).getKey())) {
            List<Long> expenseIds = this.getSelectedRowEntryId(this.getView());
            ArrayList invoiceIds = new ArrayList(0);
            HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(4);
            map.put(this.getBillType().getExpenseEntryEntityName(), expenseIds);
            map.put("invoiceentry", invoiceIds);
            String msg = "";
            msg = this.checkExpense(expenseIds, false);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            boolean noMapInvoice = expenseIds.stream().allMatch(entryId -> RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceEntrysByExpenseEntryId((DynamicObject)this.getBillView().getModel().getDataEntity(true), (Long)entryId).isEmpty());
            if (noMapInvoice) {
                msg = ResManager.loadKDString((String)"\u5df2\u5173\u8054\u53d1\u7968\u7684\u660e\u7ec6\u624d\u80fd\u53d6\u6d88\u5173\u8054\u3002", (String)"EM-E-405314", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            msg = RelateExpenseOrTripItemAndInvoiceUtil.checkRelate((IFormView)this.getBillView(), (BillOfInvoice)this.getBillType(), expenseIds, invoiceIds);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
            } else {
                this.getView().returnDataToParent(map);
                this.getView().close();
            }
        } else if (evt.getSource() instanceof Control && "confrim".equals(((Control)evt.getSource()).getKey())) {
            List<Long> expenseIds = this.getSelectedRowEntryId(this.getView());
            String msg = this.checkExpense(expenseIds, true);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                return;
            }
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("er_trip_choose_invoice");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_trip_choose_invoice"));
            showParameter.setCustomParam("billType", (Object)this.getBillType().name());
            showParameter.setCustomParam("expenseEntryIds", this.getSelectedRowEntryId(this.getView()));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object val = e.getChangeSet()[0].getNewValue();
        if ("chooseall".equals(name) && Boolean.TRUE.equals(val)) {
            this.chooseExpense("expenseentryentity", true);
        } else if ("chooseall".equals(name) && Boolean.FALSE.equals(val)) {
            this.chooseExpense("expenseentryentity", false);
        }
    }

    private String checkExpense(List<Long> expenseIds, boolean confrim) {
        if (expenseIds.isEmpty()) {
            if (confrim) {
                String entityDisplayName = ((EntityType)this.getModel().getDataEntityType().getAllEntities().get("expenseentryentity")).getDisplayName().toString();
                return String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c%1$s\u201d%2$s", (String)"RelateExpenseOrTripItemAndInvoiceUtil_5", (String)"fi-er-formplugin", (Object[])new Object[0]), entityDisplayName, ResManager.loadKDString((String)"\u540e\u518d\u5173\u8054\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            return ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u660e\u7ec6\u540e\u518d\u53d6\u6d88\u5173\u8054\u3002", (String)"EM-W-117750", (String)"fi-er-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String key;
        super.click(mobileSearchTextChangeEvent);
        MobileSearch search = (MobileSearch)mobileSearchTextChangeEvent.getSource();
        switch (key = search.getKey()) {
            case "expensesearchap": {
                this.createExpense(mobileSearchTextChangeEvent.getText());
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    @Override
    protected void createExpense(String search) {
        IFormView parentView = this.getBillView();
        if (parentView == null) {
            return;
        }
        this.getModel().deleteEntryData("expenseentryentity");
        DynamicObject bill = parentView.getModel().getDataEntity(true);
        DynamicObjectCollection sourceTrips = bill.getDynamicObjectCollection("tripentry");
        if (sourceTrips.size() == 0) {
            return;
        }
        String billKind = (String)parentView.getModel().getValue("billkind");
        int tripIndex = 1;
        DynamicObjectCollection newEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        for (DynamicObject sourceTrip : sourceTrips) {
            DynamicObjectCollection sourceEntry = sourceTrip.getDynamicObjectCollection("entryentity");
            sourceEntry.removeIf(m -> m.get("orientryamount") == null || BigDecimal.ZERO.compareTo(m.getBigDecimal("orientryamount")) == 0);
            if (sourceEntry.size() == 0) continue;
            for (DynamicObject e : sourceEntry) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)search) && (e.getString("expenseitem.name") == null || !e.getString("expenseitem.name").contains(search))) continue;
                DynamicObject d = newEntrys.addNew();
                d.set("tripIndex", (Object)tripIndex);
                DynamicObject from = e.getDynamicObject("trip2from");
                DynamicObject to = e.getDynamicObject("trip2to");
                Date begin = e.getDate("trip2startdate");
                Date end = e.getDate("trip2startdate");
                if ("0".equals(billKind)) {
                    if (from == null || to == null) {
                        from = sourceTrip.getDynamicObject("from");
                        to = sourceTrip.getDynamicObject("to");
                    }
                    if (begin == null || end == null) {
                        begin = sourceTrip.getDate("startdate");
                        end = sourceTrip.getDate("enddate");
                    }
                }
                d.set("trip2from", (Object)from);
                d.set("trip2to", (Object)to);
                d.set("trip2startdate", (Object)begin);
                d.set("trip2enddate", (Object)end);
                d.set("entryitem", e.get("expenseitem"));
                d.set("orientryamount", (Object)e.getBigDecimal("orientryamount"));
                d.set("detailcurrency", e.get("entrycurrency"));
                d.set("invoiceno_entry", e.get("invoiceno_entry"));
                d.set("expenseentryentityentryid", (Object)e.getLong("id"));
                String info = this.buildTripInfo(from, to);
                if ("0".equals(billKind)) {
                    d.set("info", (Object)(tripIndex + "." + info));
                    continue;
                }
                d.set("info", (Object)info);
            }
            ++tripIndex;
        }
        this.getView().updateView("expenseentryentity");
    }

    @Override
    protected void chooseExpense(String entry, boolean all) {
        this.choose(entry, all);
    }

    @Override
    protected void selectedRelateInvoiceEntryByClickExpenseEntry() {
    }

    @Override
    protected BillOfInvoice getBillType() {
        return BillOfInvoice.TripReimburseBill;
    }

    @Override
    protected IFormView getBillView() {
        return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
    }

    private String buildTripInfo(DynamicObject from, DynamicObject to) {
        StringBuilder sb = new StringBuilder();
        if (from != null && from.getString("name") != null) {
            sb.append(from.getString("name")).append("-");
        }
        if (to != null && to.getString("name") != null) {
            sb.append(to.getString("name")).append(" ");
        }
        return sb.toString();
    }
}

