/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.util.InvoiceProcessUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.invoice.model.InvoiceRelation;
import kd.fi.er.common.invoice.model.RelationMainView;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.formplugin.invoicecloud.v2.plugin.action.ActionFactory;
import kd.fi.er.formplugin.invoicecloud.v2.plugin.action.CommonAction;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.DeleteAttachmentByDeleteInvoiceUtil;
import kd.fi.er.formplugin.invoicecloud.v2.util.MergeExpenseUtil;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCommonBillPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener,
RowClickEventListener {
    protected Map<Long, InvoiceRelation> deleteExpenseRelationMap = new HashMap<Long, InvoiceRelation>();
    protected Map<Long, InvoiceRelation> deleteInvoiceRelationMap = new HashMap<Long, InvoiceRelation>();

    public void registerListener(EventObject e) {
        if (this.getView().getControl("trip2advtoolbar") != null) {
            this.addItemClickListeners(new String[]{"trip2advtoolbar"});
        }
        if (this.getView().getControl("advcontoolbarap3") != null) {
            this.addItemClickListeners(new String[]{"advcontoolbarap3"});
        }
        if (this.getView().getControl("importinvoiceallforone") != null) {
            this.addClickListeners(new String[]{"importinvoiceallforone"});
        }
        if (this.getView().getControl("advcontoolbarap22") != null) {
            this.addItemClickListeners(new String[]{"advcontoolbarap22"});
        }
        if (this.getControl("tbmain") != null) {
            this.addItemClickListeners(new String[]{"tbmain"});
        }
        if (this.getControl("invoiceentry") != null) {
            EntryGrid invoiceEntry = (EntryGrid)this.getControl("invoiceentry");
            invoiceEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (this.getModel().getProperty("adjustmenttype") != null && parameter.getCustomParam("ischangeinvoice") != null && ((Boolean)parameter.getCustomParam("ischangeinvoice")).booleanValue()) {
            this.getModel().setValue("adjustmenttype", (Object)"ischangeinvoice");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getCommonAction().afterBindData(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        IFormView view = this.getView();
        String itemKey = evt.getItemKey();
        String entryKey = this.getCommonAction().getEntryKey();
        IDataModel dataModel = this.getModel();
        switch (itemKey) {
            case "expenseimportinvoice": 
            case "redexpenseimportinvoice": {
                boolean canImportInvoice = MergeExpenseUtil.canImportInvoice((IFormView)view, (String)entryKey);
                evt.setCancel(!canImportInvoice);
                break;
            }
            case "changeinvoice": {
                EntryGrid expenseGrid = (EntryGrid)view.getControl("expenseentryentity");
                if (expenseGrid == null) break;
                int[] rowIndexs = expenseGrid.getSelectRows();
                DynamicObjectCollection expList = dataModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
                if (rowIndexs == null || rowIndexs.length < 1 || expList == null || expList.size() <= 0) break;
                for (int i = 0; i < rowIndexs.length; ++i) {
                    if (!((DynamicObject)expList.get(rowIndexs[i])).containsProperty("expischangeinvoice") || ((DynamicObject)expList.get(rowIndexs[i])).getBoolean("expischangeinvoice")) continue;
                    evt.setCancel(true);
                    view.showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d39\u7528\u660e\u7ec6\u53d1\u7968\u672a\u89e3\u7ed1\uff0c\u4e0d\u652f\u6301\u6362\u53d1\u7968\u3002", (String)"ErLoanBaseBillList_14", (String)"fi-er-formplugin", (Object[])new Object[]{rowIndexs[i] + 1}));
                    return;
                }
                break;
            }
            case "unbindinvoice": {
                EntryGrid invoiceGrid = (EntryGrid)view.getControl("invoiceentry");
                if (invoiceGrid == null) break;
                int[] rowIndexs = invoiceGrid.getSelectRows();
                if (rowIndexs == null || rowIndexs.length != 1) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u53d1\u7968\u4fe1\u606f\u3002", (String)"ErLoanBaseBillList_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection invoiceList = dataModel.getDataEntity(true).getDynamicObjectCollection("invoiceentry");
                if (invoiceList == null || invoiceList.size() <= 0) break;
                DynamicObject invoice = (DynamicObject)invoiceList.get(rowIndexs[0]);
                if (invoice == null) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6570\u636e\u53d1\u751f\u5f02\u5e38\u3002", (String)"PublicReimListPlugin_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (invoice.containsProperty("ispool") && Boolean.TRUE.equals(invoice.getBoolean("ispool"))) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8d26\u5355\u7684\u53d1\u7968\u4e0d\u652f\u6301\u89e3\u7ed1\u3002", (String)"ErLoanBaseBillList_17", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                IPageCache pageCache = this.getPageCache();
                pageCache.put("unbindinvoice", "true");
                pageCache.put("deleteinvoiceentryid", invoice.getPkValue().toString());
                InvoiceUtils.unbindInvoices((IDataModel)dataModel, (IFormView)view, (int)rowIndexs[0]);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control control = (Control)evt.getSource();
        String itemKey = control.getKey();
        String entryKey = this.getCommonAction().getEntryKey();
        switch (itemKey) {
            case "importinvoiceallforone": {
                boolean canImportInvoice = MergeExpenseUtil.canImportInvoice((IFormView)this.getView(), (String)entryKey);
                evt.setCancel(!canImportInvoice);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey;
        super.itemClick(evt);
        switch (itemkey = evt.getItemKey()) {
            case "changeinvoice": {
                Toolbar toolbar = (Toolbar)this.getView().getControl("advcontoolbarap22");
                if (toolbar == null) break;
                toolbar.itemClick("supplementinvoice", "");
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        IFormView view = this.getView();
        String entryName = e.getEntryProp().getName();
        String entryKey = this.getCommonAction().getEntryKey();
        int[] rowIndexes = e.getRowIndexs();
        if (entryName.equals(entryKey)) {
            boolean canDeleteExpense = MergeExpenseUtil.canDeleteExpense((IFormView)view, (String)entryKey, (int[])rowIndexes);
            e.setCancel(!canDeleteExpense);
            this.saveDeleteExpenseIds(entryKey, rowIndexes);
        } else if (entryName.equals("tripentry")) {
            int[] indexes = InvoiceUtils2.getIndexes((IDataModel)this.getModel(), (String)entryKey);
            if (indexes.length != 0) {
                boolean canDeleteExpense = MergeExpenseUtil.canDeleteExpense((IFormView)view, (String)entryKey, (int[])indexes);
                e.setCancel(!canDeleteExpense);
            }
            this.saveDeleteExpenseIds(entryKey, indexes);
        } else if (entryName.equals("invoiceentry")) {
            boolean canDeleteInvoice = true;
            if (!"true".equals(this.getPageCache().get("unbindinvoice"))) {
                canDeleteInvoice = MergeExpenseUtil.canDeleteInvoice((IFormView)view, (String)entryKey, (int[])rowIndexes);
            }
            ThreadCache.put((Object)"canDeleteInvoice", (Object)canDeleteInvoice);
            e.setCancel(!canDeleteInvoice);
            this.saveDeleteInvoiceIds(entryName, rowIndexes);
            DeleteAttachmentByDeleteInvoiceUtil.recordSerialnoByDeleteInvoie(e.getEntryProp().getName(), e.getRowIndexs(), this.getModel());
            this.getCommonAction().beforeDeleteInvoice(this.getView(), rowIndexes);
        }
    }

    public void beforeDeleteEntry(BeforeDeleteEntryEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("invoiceentry")) {
            int[] rowIndexes = InvoiceUtils2.getIndexes((IDataModel)this.getModel(), (String)"invoiceentry", (boolean)false);
            this.saveDeleteInvoiceIds(entryName, rowIndexes);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        InvoiceUtils2.clearCacheRelation();
        String name = e.getEntryProp().getName();
        boolean autoMapInvoice = false;
        if (this.getModel().getProperty("automapinvoice") != null) {
            autoMapInvoice = (Boolean)this.getModel().getValue("automapinvoice");
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            InvoiceUtils.invoiceDeletePageRule((IFormView)this.getView(), (boolean)InvoiceUtils.isDeleting((IFormView)this.getView()));
            if (autoMapInvoice) {
                if (!this.deleteInvoiceRelationMap.isEmpty()) {
                    this.getCommonAction().deleteInvoiceItemAndAdjustExpense(this.getView(), this.deleteInvoiceRelationMap);
                    this.getCommonAction().updateGoodsName(this.getView());
                    this.deleteInvoiceRelationMap.clear();
                }
            } else if ("invoiceentry".equals(name) && "true".equals(this.getPageCache().get("unbindinvoice")) && this.getModel().getProperty("expischangeinvoice") != null) {
                RelateExpenseOrTripItemAndInvoiceUtil.clearDirtyExpenseAndInvoiceEntry((IFormView)this.getView(), (Long)(!StringUtils.isEmpty((CharSequence)this.getPageCache().get("deleteinvoiceentryid")) ? Long.parseLong(this.getPageCache().get("deleteinvoiceentryid")) : 0L));
            } else {
                this.getCommonAction().deleteNonAutoInvoiceItemAndAdjustExpense(this.getView(), this.deleteInvoiceRelationMap);
                this.deleteInvoiceRelationMap.clear();
            }
            InvoiceProcessUtil.updateInvoiceValidateSummary((IFormView)this.getView());
            InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
            DeleteAttachmentByDeleteInvoiceUtil.deleteAttachmentByDeleteInvoice(e.getEntryProp().getName(), (AbstractFormPlugin)this, this.getModel());
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"expenseentryentity") || StringUtils.equals((CharSequence)name, (CharSequence)"entryentity") || StringUtils.equals((CharSequence)name, (CharSequence)"tripentry")) {
            if (autoMapInvoice) {
                if (CollectionUtils.isNotEmpty((Collection)this.getModel().getEntryEntity("invoiceentry")) && !this.deleteExpenseRelationMap.isEmpty()) {
                    this.getCommonAction().deleteMapInvoice(this.getView(), this.deleteExpenseRelationMap);
                    this.getCommonAction().updateInvoiceDetails_auto(this.getView(), this.deleteExpenseRelationMap);
                    this.getCommonAction().unLockHeadIsCurrency(this.getView());
                    this.deleteExpenseRelationMap.clear();
                }
            } else {
                this.getCommonAction().deleteNonAutoRelationWhenDelExpense(this.getView(), this.deleteExpenseRelationMap);
                this.getCommonAction().updateInvoiceDetails_nonauto(this.getView(), this.deleteExpenseRelationMap);
                this.deleteExpenseRelationMap.clear();
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.getCommonAction().afterAddRow(e);
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        InvoiceUtils2.clearCacheRelation();
        String name = e.getEntryProp().getName();
        boolean autoMapInvoice = false;
        if (this.getModel().getProperty("automapinvoice") != null) {
            autoMapInvoice = (Boolean)this.getModel().getValue("automapinvoice");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"invoiceentry")) {
            if (autoMapInvoice) {
                this.getCommonAction().autoDeleteInvoiceExpenseItem(this.getView());
            } else {
                this.getCommonAction().deleteNonAutoInvoiceItemAndAdjustExpense(this.getView(), this.deleteInvoiceRelationMap);
            }
            InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getCommonAction().propertyChanged(e);
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getCommonAction().entryRowClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        switch (opKey = e.getOperateKey()) {
            case "confirmchangeinvoice": {
                OperationResult opResult = e.getOperationResult();
                if (!opResult.isSuccess()) break;
                this.getView().close();
            }
        }
        DeleteAttachmentByDeleteInvoiceUtil.afterOperationDeleteAttachment(e, (AbstractFormPlugin)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DeleteAttachmentByDeleteInvoiceUtil.setCacheNeedAttachment(args, (AbstractFormPlugin)this);
    }

    private boolean isReimBill() {
        return ErEntityTypeUtils.isReimBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isCheckingpayBill((String)this.getView().getEntityId());
    }

    private void saveDeleteExpenseIds(String entryKey, int[] rowIndexs) {
        if (!this.isReimBill()) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryKey);
        if (entryEntity.isEmpty()) {
            return;
        }
        IDataEntityProperty itemFromProp = model.getProperty("itemfrom");
        Set deleteExpenseRowIds = Arrays.stream(rowIndexs).mapToObj(index -> {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            if (dynamicObject != null) {
                String itemFrom;
                String string = itemFrom = itemFromProp == null ? ItemFrom.InvoiceCloud.getValue() : dynamicObject.getString("itemfrom");
                if (ItemFrom.InvoiceCloud.getValue().equals(itemFrom)) {
                    return (Long)dynamicObject.getPkValue();
                }
            }
            return 0L;
        }).filter(id -> id != null && !id.equals(0L)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(deleteExpenseRowIds)) {
            return;
        }
        Map allInvoiceRelation = InvoiceUtils2.getAllInvoiceRelationGroup((IFormView)this.getView(), (RelationMainView)RelationMainView.VIEW_EXPENSE);
        for (Long expenseId : deleteExpenseRowIds) {
            if (this.deleteExpenseRelationMap.containsKey(expenseId) || allInvoiceRelation.get(expenseId) == null) continue;
            this.deleteExpenseRelationMap.put(expenseId, (InvoiceRelation)allInvoiceRelation.get(expenseId));
        }
    }

    private void saveDeleteInvoiceIds(String entryKey, int[] rowIndexs) {
        IDataModel model = this.getModel();
        List deleteInvoiceHeadIds = InvoiceUtils2.getPkValueSet((IDataModel)model, (String)entryKey, (int[])rowIndexs);
        Map allInvoiceRelation = InvoiceUtils2.getAllInvoiceRelationGroup((IFormView)this.getView(), (RelationMainView)RelationMainView.VIEW_INVOICE);
        for (Long invoiceHeadId : deleteInvoiceHeadIds) {
            if (this.deleteInvoiceRelationMap.containsKey(invoiceHeadId) || allInvoiceRelation.get(invoiceHeadId) == null) continue;
            this.deleteInvoiceRelationMap.put(invoiceHeadId, (InvoiceRelation)allInvoiceRelation.get(invoiceHeadId));
        }
    }

    public CommonAction getCommonAction() {
        return ActionFactory.getCommonAction(this.getView());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("invoiceno".equals(fieldName)) {
            ActionFactory.getCommonAction(this.getView()).invoiceHyperLinkClick((AbstractFormPlugin)this, fieldName, evt.getRowIndex(), -1);
        }
    }
}

