/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.plugin.action;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.invoice.model.InvoiceRelation;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.plugin.action.CommonAction;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckingPayAction
extends CommonAction {
    public CheckingPayAction(IFormView formView) {
        super(formView);
    }

    @Override
    public BillExpenseInfoFildKeyType getBillType() {
        return BillExpenseInfoFildKeyType.CheckingPayBill;
    }

    @Override
    public String getEntryKey() {
        return this.getBillType().getExpenseEntityKey();
    }

    @Override
    public void deleteNonAutoRelationWhenDelExpense(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        if (MapUtils.isEmpty(deleteExpenseRelationMap)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceAndExpense = model.getEntryEntity("invoiceandexpense");
        Set<Long> expenseIdSet = deleteExpenseRelationMap.keySet();
        int[] relationIndexs = invoiceAndExpense.stream().filter(relation -> expenseIdSet.contains(relation.getLong("expenseentryid"))).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        model.beginInit();
        model.deleteEntryRows("invoiceandexpense", relationIndexs);
        model.endInit();
    }

    @Override
    public void deleteNonAutoRelationWhenDelInvoice(IFormView view, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        if (MapUtils.isEmpty(deleteInvoiceRelationMap)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceItemEntry = model.getEntryEntity("invoiceitementry");
        DynamicObjectCollection invoiceAndExpense = model.getEntryEntity("invoiceandexpense");
        Set<Long> invoiceIdSet = deleteInvoiceRelationMap.keySet();
        int[] invoiceItemIndex = invoiceItemEntry.stream().filter(invoiceItem -> invoiceIdSet.contains(invoiceItem.getLong("invoiceheadentryid"))).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        int[] relationIndexs = invoiceAndExpense.stream().filter(relation -> invoiceIdSet.contains(relation.getLong("invoiceentryid"))).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        model.beginInit();
        model.deleteEntryRows("invoiceitementry", invoiceItemIndex);
        model.deleteEntryRows("invoiceandexpense", relationIndexs);
        model.endInit();
    }

    @Override
    public void beforeDeleteInvoice(IFormView view, int[] rowIndexs) {
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceEntries = model.getEntryEntity("invoiceentry");
        DynamicObjectCollection entryEntities = model.getEntryEntity("entryentity");
        for (int index : rowIndexs) {
            DynamicObject invoiceentry = (DynamicObject)invoiceEntries.get(index);
            String invoiceno = invoiceentry.getString("invoiceno");
            for (DynamicObject entryentity : entryEntities) {
                String ticketnum = entryentity.getString("ticketnum");
                if (StringUtils.equals((CharSequence)invoiceno, (CharSequence)ticketnum)) {
                    entryentity.set("isuploadinvoicecloud", (Object)false);
                    entryentity.set("match", (Object)false);
                }
                if (!entryentity.getBoolean("travelbill") || !StringUtils.equals((CharSequence)invoiceno, (CharSequence)entryentity.getString("invoicenum"))) continue;
                entryentity.set("invoicenum", (Object)"");
                entryentity.set("invoicenum_tag", (Object)"");
            }
        }
        this.delNotTravelBillData(rowIndexs, invoiceEntries, entryEntities);
    }

    private void delNotTravelBillData(int[] deleteIndex, DynamicObjectCollection invoiceentries, DynamicObjectCollection entryentities) {
        List notTravelBills = entryentities.stream().filter(dynamicObject -> !dynamicObject.getBoolean("travelbill")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(notTravelBills)) {
            return;
        }
        for (int index : deleteIndex) {
            DynamicObject invoiceentry = (DynamicObject)invoiceentries.get(index);
            String invoiceno = invoiceentry.getString("invoiceno");
            for (DynamicObject entry : entryentities) {
                String invoicenum = entry.getString("invoicenum_tag");
                if (StringUtils.isEmpty((CharSequence)invoicenum)) {
                    entry.set("isuploadinvoicecloud", (Object)false);
                    entry.set("match", (Object)false);
                    continue;
                }
                if (!invoicenum.contains(invoiceno)) continue;
                String[] invoiceNums = invoicenum.split(",");
                ArrayList<String> invoiceNumList = new ArrayList<String>(Arrays.asList(invoiceNums));
                invoiceNumList.remove(invoiceno);
                if (CollectionUtils.isEmpty(invoiceNumList)) {
                    entry.set("invoicenum", (Object)"");
                    entry.set("invoicenum_tag", (Object)"");
                    continue;
                }
                entry.set("invoicenum", (Object)invoiceNumList.get(0));
                entry.set("invoicenum_tag", (Object)String.join((CharSequence)",", invoiceNumList));
            }
        }
    }

    @Override
    public void invoiceHyperLinkClick(AbstractFormPlugin plugin, String fieldName, int rowIndex, int parentIndex) {
        IDataModel model = plugin.getView().getModel();
        if ("invoiceno".equals(fieldName)) {
            String serialNo = (String)model.getValue("serialno", rowIndex);
            HashSet serialNos = Sets.newHashSet((Object[])new String[]{serialNo});
            String costCompanyKey = this.getBillType().getCostCompanyKey();
            Object costCompany = model.getValue(costCompanyKey);
            ShowInvoiceCloudPageUtil.viewInvoiceLst_pc(plugin, model, (Collection<String>)serialNos, ErCommonUtils.getPk((Object)costCompany));
        }
    }
}

