/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.plugin.action;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.common.invoice.model.InvoiceRelation;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.ItemInvoiceRelationEnum;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.formplugin.invoicecloud.model.AdjustItemEntryModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class CommonAction {
    protected IFormView formView;

    public CommonAction(IFormView formView) {
        this.formView = formView;
    }

    public abstract BillExpenseInfoFildKeyType getBillType();

    public void afterBindData(EventObject e) {
    }

    void adjustItemEntry(IFormView view, Map<Long, AdjustItemEntryModel> adjustModels, boolean needAdjustAmount) {
    }

    public void deleteInvoiceItemAndAdjustExpense(IFormView view, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        IDataModel model = view.getModel();
        HashSet<Long> needDeleteItemEntryIds = new HashSet<Long>();
        HashSet<Long> needAdjustItemEntryIds = new HashSet<Long>();
        Collection<InvoiceRelation> relations = deleteInvoiceRelationMap.values();
        for (InvoiceRelation relation : relations) {
            ItemInvoiceRelationEnum relationEnum = relation.getRelationEnum();
            Set expenseItemIds = relation.getOtherViewIds();
            if (ItemInvoiceRelationEnum.IsOneForOne == relationEnum || ItemInvoiceRelationEnum.IsNForOne == relationEnum) {
                needDeleteItemEntryIds.addAll(expenseItemIds);
                continue;
            }
            if (ItemInvoiceRelationEnum.IsOneForN != relationEnum && ItemInvoiceRelationEnum.IsNForN != relationEnum) continue;
            for (Long expenseItemId : expenseItemIds) {
                List invoices = InvoiceUtils.getAutoInvoiceInfoByItemId((IDataModel)model, (Long)expenseItemId);
                if (invoices.size() > 0) {
                    needAdjustItemEntryIds.add(expenseItemId);
                    continue;
                }
                needDeleteItemEntryIds.add(expenseItemId);
            }
        }
        this.deleteExpenseItem(view, needDeleteItemEntryIds);
        Map<Long, AdjustItemEntryModel> adjustItemEntryModels = this.adjustAutoItemEntry(view, needAdjustItemEntryIds, deleteInvoiceRelationMap);
        this.deleteInvoiceItemIndexs(view, deleteInvoiceRelationMap);
        this.adjustItemEntry(view, adjustItemEntryModels, true);
        this.afterDeleteAdjustEntry(view);
    }

    public void deleteNonAutoInvoiceItemAndAdjustExpense(IFormView view, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        IDataModel model = view.getModel();
        boolean needAdjustAmount = true;
        if (model.getProperty("billstatus") != null && model.getProperty("automapinvoice") != null && model.getProperty("needsuppleinvoice") != null) {
            boolean automapinvoice = (Boolean)model.getValue("automapinvoice");
            boolean suppleInvoice = (Boolean)model.getValue("needsuppleinvoice");
            HashSet canSupInvoiceStatus = Sets.newHashSet((Object[])new String[]{"E", "F", "G"});
            String billStatus = (String)model.getValue("billstatus");
            if (!automapinvoice && suppleInvoice && canSupInvoiceStatus.contains(billStatus)) {
                needAdjustAmount = false;
            }
        }
        this.deleteNonAutoRelationWhenDelInvoice(view, deleteInvoiceRelationMap);
        Collection<InvoiceRelation> values = deleteInvoiceRelationMap.values();
        Set<Long> needAdjustItemEntryIds = values.stream().flatMap(relation -> relation.getOtherViewIds().stream()).collect(Collectors.toSet());
        Map<Long, AdjustItemEntryModel> adjustItemEntryModels = this.adjustNonAutoItemEntry(view, needAdjustItemEntryIds, deleteInvoiceRelationMap);
        this.adjustItemEntry(view, adjustItemEntryModels, needAdjustAmount);
    }

    public abstract String getEntryKey();

    public List<DynamicObject> getExpenseEntryDetails(IFormView view) {
        return new ArrayList<DynamicObject>();
    }

    public void deleteMapInvoice(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        DynamicObjectCollection invoiceItemEntry;
        int[] deleteInvoiceItemSeqs;
        int[] deleteInvoiceSeqs;
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
        HashSet<Long> needDeleteInvoiceHeadIds = new HashSet<Long>();
        Set<Long> deleteExpenseItemIds = deleteExpenseRelationMap.keySet();
        Collection<InvoiceRelation> invoiceRelations = deleteExpenseRelationMap.values();
        Set invoiceHeadSet = invoiceRelations.stream().flatMap(relation -> relation.getOtherViewIds().parallelStream()).collect(Collectors.toSet());
        List invoiceItems = InvoiceUtils.getInvoiceItemByInvoiceHeadIds((IDataModel)model, invoiceHeadSet);
        Map<Long, List<DynamicObject>> invoiceItemGroupByHead = invoiceItems.stream().collect(Collectors.groupingBy(invoiceItem -> invoiceItem.getLong("invoiceheadentryid")));
        for (Map.Entry<Long, InvoiceRelation> next : deleteExpenseRelationMap.entrySet()) {
            Long key = next.getKey();
            InvoiceRelation value = next.getValue();
            Set invoiceHeadIds = value.getOtherViewIds();
            ItemInvoiceRelationEnum relationEnum = value.getRelationEnum();
            if (relationEnum == ItemInvoiceRelationEnum.IsOneForOne || relationEnum == ItemInvoiceRelationEnum.IsOneForN) {
                needDeleteInvoiceHeadIds.addAll(invoiceHeadIds);
                continue;
            }
            if (ItemInvoiceRelationEnum.IsNForOne == relationEnum) {
                Long invoiceHeadId;
                List<DynamicObject> invoiceItemEntry2;
                Set expenseIds;
                if (needDeleteInvoiceHeadIds.containsAll(invoiceHeadIds) || !deleteExpenseItemIds.containsAll(expenseIds = (invoiceItemEntry2 = invoiceItemGroupByHead.get(invoiceHeadId = (Long)invoiceHeadIds.iterator().next())).stream().map(invoiceItem -> invoiceItem.getLong("itementryid")).collect(Collectors.toSet()))) continue;
                needDeleteInvoiceHeadIds.addAll(invoiceHeadIds);
                continue;
            }
            if (ItemInvoiceRelationEnum.IsNForN != relationEnum) continue;
            for (Long invoiceHeadId : invoiceHeadIds) {
                List<DynamicObject> invoiceItemList;
                Set expenseIdSet;
                if (needDeleteInvoiceHeadIds.contains(invoiceHeadId) || !deleteExpenseItemIds.containsAll(expenseIdSet = (invoiceItemList = invoiceItemGroupByHead.get(invoiceHeadId)).stream().map(invoiceItem -> invoiceItem.getLong("itementryid")).collect(Collectors.toSet()))) continue;
                needDeleteInvoiceHeadIds.add(invoiceHeadId);
            }
        }
        if (!needDeleteInvoiceHeadIds.isEmpty() && (deleteInvoiceSeqs = invoiceEntry.stream().filter(invoice -> needDeleteInvoiceHeadIds.contains(invoice.getPkValue())).mapToInt(invoice -> invoice.getInt("seq") - 1).toArray()).length != 0) {
            EntryGrid entryGrid = (EntryGrid)view.getControl("invoiceentry");
            if (entryGrid != null) {
                entryGrid.setStopSelectRow(true);
                model.deleteEntryRows("invoiceentry", deleteInvoiceSeqs);
                entryGrid.setStopSelectRow(false);
                entryGrid.selectRows(-1);
            } else {
                model.deleteEntryRows("invoiceentry", deleteInvoiceSeqs);
            }
        }
        if ((deleteInvoiceItemSeqs = (invoiceItemEntry = model.getEntryEntity("invoiceitementry")).stream().filter(invoiceItem -> deleteExpenseItemIds.contains(invoiceItem.getLong("itementryid"))).mapToInt(invoiceItem -> invoiceItem.getInt("seq") - 1).toArray()).length != 0) {
            model.beginInit();
            model.deleteEntryRows("invoiceitementry", deleteInvoiceItemSeqs);
            model.endInit();
        }
    }

    public void updateInvoiceDetails_auto(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        this.updateTaxDetails(view, deleteExpenseRelationMap);
    }

    public void updateInvoiceDetails_nonauto(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        this.updateIsMapExpense(view, deleteExpenseRelationMap);
    }

    protected void updateTaxDetails(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        Collection<InvoiceRelation> values = deleteExpenseRelationMap.values();
        String entityId = view.getEntityId();
        BillExpenseInfoFildKeyType billType = ErEntityTypeUtils.getBillType((String)entityId);
        for (InvoiceRelation invoiceRelation : values) {
            Set invoiceHeadIds = invoiceRelation.getOtherViewIds();
            InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)view, (Set)invoiceHeadIds, (BillExpenseInfoFildKeyType)billType);
        }
    }

    public Map<Long, AdjustItemEntryModel> adjustAutoItemEntry(IFormView view, Set<Long> needAdjustItemEntryIds, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        if (needAdjustItemEntryIds.isEmpty()) {
            return new HashMap<Long, AdjustItemEntryModel>();
        }
        IDataModel model = view.getModel();
        BillExpenseInfoFildKeyType billType = this.getBillType();
        String itemKey = billType.getItemKey();
        String offsetKey = billType.getItem().getIsOffsetKey();
        Map idItemMap = model.getEntryEntity(this.getEntryKey()).stream().filter(expenseItem -> expenseItem.getPkValue() != null && (Long)expenseItem.getPkValue() != 0L).collect(HashMap::new, (map, item) -> map.put(item.getPkValue(), item.getDynamicObject(itemKey)), HashMap::putAll);
        HashMap adjustModelMap = Maps.newHashMapWithExpectedSize((int)needAdjustItemEntryIds.size());
        boolean nonOffsetImportTaxAmount = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)ErCommonUtils.getPk((Object)model.getValue("costcompany")));
        Set<Long> deleteInvoiceHeadIds = deleteInvoiceRelationMap.keySet();
        for (Long itemId : needAdjustItemEntryIds) {
            BigDecimal taxAmount;
            List allInvoiceInfo = InvoiceUtils.getAutoInvoiceInfoByItemId((IDataModel)model, (Long)itemId);
            List allInvoiceItem = InvoiceUtils.getAutoInvoiceItemByItemId((IDataModel)model, (Long)itemId);
            List remainingInvoiceInfo = allInvoiceInfo.stream().filter(info -> !deleteInvoiceHeadIds.contains(info.getPkValue())).collect(Collectors.toList());
            List invoiceItems = allInvoiceItem.stream().filter(item -> deleteInvoiceHeadIds.contains(item.getLong("invoiceheadentryid"))).collect(Collectors.toList());
            List remainingInvoiceItem = allInvoiceItem.stream().filter(item -> !deleteInvoiceHeadIds.contains(item.getLong("invoiceheadentryid"))).collect(Collectors.toList());
            BigDecimal excludeTaxAmount = invoiceItems.stream().map(invoiceItemDO -> invoiceItemDO.getBigDecimal("excludeamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal taxRate = BigDecimal.ZERO;
            DynamicObject expenseItem2 = (DynamicObject)idItemMap.get(itemId);
            boolean offset = false;
            Set invoiceHeadIds = remainingInvoiceInfo.stream().map(invoice -> (Long)invoice.getPkValue()).collect(Collectors.toSet());
            if (expenseItem2 != null) {
                offset = InvoiceOffsetUtils.isInvoiceOffset((IDataModel)model, invoiceHeadIds) && expenseItem2.getBoolean(offsetKey);
            }
            BigDecimal deductibleTax = InvoiceOffsetUtils.getOffsetInvoiceItem(invoiceItems.stream()).map(invoiceItemDO -> invoiceItemDO.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            String invoiceNo = "";
            String invoiceCode = "";
            if (nonOffsetImportTaxAmount) {
                taxAmount = invoiceItems.stream().map(invoiceItemDO -> invoiceItemDO.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                Set taxRateSet = remainingInvoiceItem.stream().map(item -> item.getBigDecimal("invoiceitemtaxrate")).collect(Collectors.toSet());
                if (taxRateSet.size() == 1) {
                    taxRate = (BigDecimal)taxRateSet.iterator().next();
                }
            } else {
                taxAmount = InvoiceOffsetUtils.getOffsetInvoiceItem(invoiceItems.stream()).map(invoiceItemDO -> invoiceItemDO.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal notOffsetTaxAmount = InvoiceOffsetUtils.getNotOffsetInvoiceItem(invoiceItems.stream()).map(invoiceItemDO -> invoiceItemDO.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                excludeTaxAmount = excludeTaxAmount.add(notOffsetTaxAmount);
                Set taxRateSet = InvoiceOffsetUtils.getOffsetInvoiceItem(remainingInvoiceItem.stream()).map(item -> item.getBigDecimal("invoiceitemtaxrate")).collect(Collectors.toSet());
                if (taxRateSet.size() == 1) {
                    taxRate = (BigDecimal)taxRateSet.iterator().next();
                }
            }
            List invoiceNos = remainingInvoiceInfo.stream().map(invoiceHeadDO -> invoiceHeadDO.getString("invoiceno")).collect(Collectors.toList());
            invoiceNo = StringUtils.join(invoiceNos, (String)",");
            List invoiceCodes = remainingInvoiceInfo.stream().map(invoiceHeadDO -> invoiceHeadDO.getString("invoicecode")).collect(Collectors.toList());
            invoiceCode = StringUtils.join(invoiceCodes, (String)",");
            Map seatGrade = ReimburseUtils.getSeatGrade(remainingInvoiceInfo);
            BigDecimal airportConstructionFee = remainingInvoiceInfo.stream().map(invoiceHeadDO -> invoiceHeadDO.getBigDecimal("invoiceairportconstfee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            AdjustItemEntryModel adjustModel = new AdjustItemEntryModel();
            adjustModel.setEntryId(itemId);
            adjustModel.setTotalAmount(taxAmount.add(excludeTaxAmount));
            adjustModel.setTaxRate(taxRate);
            adjustModel.setTaxAmount(taxAmount);
            adjustModel.setExcludeTaxAmount(excludeTaxAmount);
            adjustModel.setOffset(offset);
            adjustModel.setDeductibleTax(deductibleTax);
            adjustModel.setUnionInvoiceNo(invoiceNo);
            adjustModel.setUnionInvoiceCode(invoiceCode);
            adjustModel.setSeatGrade(seatGrade);
            adjustModel.setAirportConstructionFee(airportConstructionFee);
            adjustModelMap.put(itemId, adjustModel);
        }
        return adjustModelMap;
    }

    public Map<Long, AdjustItemEntryModel> adjustNonAutoItemEntry(IFormView view, Set<Long> needAdjustItemEntryIds, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        if (needAdjustItemEntryIds.isEmpty()) {
            return new HashMap<Long, AdjustItemEntryModel>();
        }
        IDataModel model = view.getModel();
        BillExpenseInfoFildKeyType billType = this.getBillType();
        String itemKey = billType.getItemKey();
        String offsetKey = billType.getItem() == null ? "" : billType.getItem().getIsOffsetKey();
        Map idItemMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)itemKey)) {
            idItemMap = model.getEntryEntity(this.getEntryKey()).stream().filter(expenseItem -> expenseItem.getPkValue() != null && (Long)expenseItem.getPkValue() != 0L).collect(HashMap::new, (map, item) -> map.put(item.getPkValue(), item.getDynamicObject(itemKey)), HashMap::putAll);
        }
        HashMap<Long, AdjustItemEntryModel> adjustModelMap = new HashMap<Long, AdjustItemEntryModel>(needAdjustItemEntryIds.size());
        for (Long itemId : needAdjustItemEntryIds) {
            AdjustItemEntryModel adjustModel = new AdjustItemEntryModel();
            List invoiceEntryInfo = InvoiceUtils.getNonAutoInvoiceInfoByItemId((IDataModel)model, (Long)itemId);
            DynamicObject expenseItem2 = (DynamicObject)idItemMap.get(itemId);
            boolean offset = false;
            Set invoiceHeadIds = invoiceEntryInfo.stream().map(invoice -> (Long)invoice.getPkValue()).collect(Collectors.toSet());
            if (StringUtils.isNotEmpty((CharSequence)offsetKey)) {
                if (expenseItem2 != null) {
                    offset = InvoiceOffsetUtils.isInvoiceOffset((IDataModel)model, invoiceHeadIds) && expenseItem2.getBoolean(offsetKey);
                }
            } else {
                offset = InvoiceOffsetUtils.isInvoiceOffset((IDataModel)model, invoiceHeadIds);
            }
            String invoiceNo = invoiceEntryInfo.stream().map(invoice -> invoice.getString("invoiceno")).collect(Collectors.joining(","));
            String invoiceCode = invoiceEntryInfo.stream().map(invoice -> invoice.getString("invoicecode")).collect(Collectors.joining(","));
            adjustModel.setOffset(offset);
            adjustModel.setUnionInvoiceNo(invoiceNo);
            adjustModel.setUnionInvoiceCode(invoiceCode);
            if (invoiceEntryInfo.isEmpty()) {
                adjustModel.setItemFrom(ItemFrom.Manual.getValue());
            }
            adjustModelMap.put(itemId, adjustModel);
        }
        return adjustModelMap;
    }

    public void updateGoodsName(IFormView view) {
    }

    public void unLockHeadIsCurrency(IFormView view) {
        Map mapInfo = InvoiceUtils.autoMapInvoiceMappingInfo((DynamicObject)view.getModel().getDataEntity());
        if (mapInfo.isEmpty()) {
            view.setEnable(Boolean.TRUE, new String[]{"iscurrency"});
        }
    }

    void deleteExpenseItem(IFormView view, Set<Long> needDeleteItemEntryIds) {
    }

    void afterDeleteAdjustEntry(IFormView view) {
    }

    public void deleteInvoiceItemIndexs(IFormView view, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        HashSet<Integer> delInvoiceItemIndex = new HashSet<Integer>();
        Set<Long> invoiceHeadIds = deleteInvoiceRelationMap.keySet();
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceItemEntry = model.getEntryEntity("invoiceitementry");
        for (int i = 0; i < invoiceItemEntry.size(); ++i) {
            long invoiceHeadId = ((DynamicObject)invoiceItemEntry.get(i)).getLong("invoiceheadentryid");
            if (!invoiceHeadIds.contains(invoiceHeadId)) continue;
            delInvoiceItemIndex.add(i);
        }
        if (!delInvoiceItemIndex.isEmpty()) {
            model.beginInit();
            model.deleteEntryRows("invoiceitementry", delInvoiceItemIndex.stream().mapToInt(Integer::intValue).toArray());
            model.endInit();
        }
    }

    public void autoDeleteInvoiceExpenseItem(IFormView view) {
        this.afterDeleteAdjustEntry(view);
    }

    public void autoDeleteInvoice(IFormView view) {
        IDataModel model = view.getModel();
        if (model.getProperty("invoiceentry") != null) {
            int[] deleteIndexs;
            DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
            if (invoiceEntry.size() > 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5207\u6362\u540e\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u5373\u5c06\u6e05\u9664\u53d1\u7968\u76f8\u5173\u4fe1\u606f\u3002", (String)"AbstractImportInvoiceForReimPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if ((deleteIndexs = invoiceEntry.stream().filter(invoice -> ItemFrom.InvoiceCloud.getValue().equals(invoice.getString("invoicefrom"))).map(invoice -> invoice.getInt("seq") - 1).mapToInt(Integer::intValue).toArray()).length > 0) {
                model.deleteEntryRows("invoiceentry", deleteIndexs);
            }
        }
    }

    public void setInvoiceCloudEnable(IFormView view, boolean isEnable) {
        IDataModel model = view.getModel();
        String enableKey = "";
        if (model.getProperty("isenableinvoice") != null) {
            enableKey = "isenableinvoice";
        } else if (model.getProperty("invoicecloudenable") != null) {
            enableKey = "invoicecloudenable";
        }
        if (model.getProperty(enableKey) != null && StringUtils.isNotEmpty((CharSequence)enableKey)) {
            model.setValue(enableKey, (Object)isEnable);
        }
    }

    public void processWhenInvoiceIsDisable(IFormView view) {
        this.autoDeleteInvoiceExpenseItem(view);
        this.autoDeleteInvoice(view);
        view.setVisible(Boolean.FALSE, new String[]{"viewinvoice"});
    }

    public void deleteNonAutoRelationWhenDelExpense(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
    }

    public void deleteNonAutoRelationWhenDelInvoice(IFormView view, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
    }

    public void beforeDeleteInvoice(IFormView view, int[] rowIndexs) {
    }

    public void invoiceHyperLinkClick(AbstractFormPlugin plugin, String fieldName, int rowIndex, int parentIndex) {
    }

    public void updateIsMapExpense(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        Collection<InvoiceRelation> values = deleteExpenseRelationMap.values();
        Set invoiceHeadIds = values.stream().flatMap(invoiceRelation -> invoiceRelation.getOtherViewIds().parallelStream()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(invoiceHeadIds)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
        if (invoiceEntry.getDynamicObjectType().getProperty("ismapexpense") == null) {
            return;
        }
        Integer[] seqs = (Integer[])invoiceEntry.stream().filter(invoice -> invoiceHeadIds.contains(invoice.getPkValue())).map(invoice -> invoice.getInt("seq") - 1).toArray(Integer[]::new);
        Map nonAutoMapItemMappingInfo = InvoiceUtils2.nonAutoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"nonAutoMapItemMappingInfo");
        for (Integer seq : seqs) {
            DynamicObject invoice2 = (DynamicObject)invoiceEntry.get(seq.intValue());
            Object pkValue = invoice2.getPkValue();
            Set expenseIds = (Set)nonAutoMapItemMappingInfo.get(pkValue);
            if (CollectionUtils.isEmpty((Collection)expenseIds)) {
                model.setValue("ismapexpense", (Object)"0", seq.intValue());
                continue;
            }
            model.setValue("ismapexpense", (Object)"1", seq.intValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        this.costCompanyChanged(e, name, rowIndex);
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    protected void costCompanyChanged(PropertyChangedArgs e, String name, int rowIndex) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        BillExpenseInfoFildKeyType billType = this.getBillType();
        if (billType == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)billType.getCostCompanyKey())) {
            Long costCompanyId = 0L;
            if (newValue instanceof DynamicObject) {
                DynamicObject newCostCompanyDO = (DynamicObject)newValue;
                costCompanyId = (Long)newCostCompanyDO.getPkValue();
            } else if (newValue instanceof Long) {
                costCompanyId = (Long)newValue;
            }
            if (newValue != null) {
                boolean invoiceIsEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)costCompanyId);
                this.setInvoiceCloudEnable(this.formView, invoiceIsEnabled);
                if (!invoiceIsEnabled) {
                    this.processWhenInvoiceIsDisable(this.formView);
                }
            }
        }
    }

    protected void setValueIfExist(IDataModel dataModel, String property, DynamicObject value, int rowIndex) {
        if (dataModel.getProperty(property) != null) {
            dataModel.setValue(property, value == null ? null : value.get("id"), rowIndex);
            this.formView.updateView(property, rowIndex);
        }
    }

    protected void valueChanged(PropertyChangedArgs e, String name, int rowIndex, String name1, String name2) {
        if (name1.equals(name)) {
            boolean hasProperty;
            IDataModel model = this.formView.getModel();
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            String nameStr = "";
            if (newValue != null && (hasProperty = newValue.getDataEntityType().getProperties().containsKey((Object)"name"))) {
                nameStr = newValue.getString("name");
            }
            model.beginInit();
            model.setValue(name2, (Object)nameStr, rowIndex);
            model.endInit();
            this.formView.updateView(name2, rowIndex);
        }
    }
}

