/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.plugin.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.invoice.model.InvoiceRelation;
import kd.fi.er.common.invoice.model.RelationMainView;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.ItemInvoiceRelationEnum;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.formplugin.invoicecloud.model.AdjustItemEntryModel;
import kd.fi.er.formplugin.invoicecloud.v2.plugin.action.CommonAction;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DailyReimburseAction
extends CommonAction {
    private Function<String, Boolean> HasProperty = p -> this.formView.getModel().getProperty(p) != null;

    public DailyReimburseAction(IFormView formView) {
        super(formView);
    }

    @Override
    public BillExpenseInfoFildKeyType getBillType() {
        return BillExpenseInfoFildKeyType.DailyReimburse;
    }

    @Override
    public String getEntryKey() {
        return this.getBillType().getExpenseEntityKey();
    }

    @Override
    public List<DynamicObject> getExpenseEntryDetails(IFormView view) {
        return view.getModel().getEntryEntity(this.getEntryKey());
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateMultiReimburseControl(this.formView.getModel());
    }

    @Override
    public void updateGoodsName(IFormView view) {
        IDataModel model = view.getModel();
        if (model.getProperty("expensegoodsname") == null) {
            return;
        }
        DynamicObjectCollection invoiceEntryDOs = model.getEntryEntity("invoiceentry");
        DynamicObjectCollection invoiceItemDOs = model.getEntryEntity("invoiceitementry");
        Set existInvoiceIds = invoiceEntryDOs.stream().map(entry -> (Long)entry.getPkValue()).filter(id -> !Objects.equals(id, 0L)).collect(Collectors.toSet());
        Map<Long, String> expenseEntryIdToGoodName = invoiceItemDOs.stream().filter(entry -> existInvoiceIds.contains(entry.getLong("invoiceheadentryid")) && !Objects.equals(entry.getLong("itementryid"), 0L) && StringUtils.isNotBlank((CharSequence)entry.getString("goodsname"))).collect(Collectors.toMap(entry -> entry.getLong("itementryid"), entry -> entry.getString("goodsname"), (existing, newValue) -> existing));
        DynamicObjectCollection expenseEntryDOs = model.getEntryEntity("expenseentryentity");
        for (int i = 0; i < expenseEntryDOs.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)expenseEntryDOs.get(i);
            Long expenseEntryId = dynamicObject.getBoolean("invoicefromparent") ? Long.valueOf(dynamicObject.getString("splitline")) : (Long)dynamicObject.getPkValue();
            String goodName = expenseEntryIdToGoodName.get(expenseEntryId);
            model.setValue("expensegoodsname", (Object)StringUtils.defaultIfBlank((CharSequence)goodName, (CharSequence)""), i);
        }
    }

    @Override
    public void deleteExpenseItem(IFormView view, Set<Long> needDeleteItemEntryIds) {
        if (needDeleteItemEntryIds.isEmpty()) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection entry = model.getEntryEntity(this.getEntryKey());
        ArrayList<Integer> deleteIndexList = new ArrayList<Integer>();
        for (int entryIndex = 0; entryIndex < entry.size(); ++entryIndex) {
            DynamicObject dynamicObject = (DynamicObject)entry.get(entryIndex);
            if (dynamicObject == null || !needDeleteItemEntryIds.contains(dynamicObject.getPkValue())) continue;
            deleteIndexList.add(entryIndex);
        }
        if (deleteIndexList.isEmpty()) {
            return;
        }
        int[] deleteIndex = deleteIndexList.stream().mapToInt(Integer::intValue).toArray();
        model.deleteEntryRows(this.getEntryKey(), deleteIndex);
    }

    @Override
    public void adjustItemEntry(IFormView view, Map<Long, AdjustItemEntryModel> adjustModels, boolean needAdjustAmount) {
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(this.getEntryKey());
        boolean autoMapInvoice = false;
        if (model.getProperty("automapinvoice") != null) {
            autoMapInvoice = (Boolean)model.getValue("automapinvoice");
        }
        Set specialInvoiceTypes = InvoiceTypeUtils.loadSpecialInvoiceTypes();
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            Object pkValue = dynamicObject.getPkValue();
            if (!adjustModels.containsKey(pkValue)) continue;
            AdjustItemEntryModel adjustModel = adjustModels.get(pkValue);
            if (needAdjustAmount) {
                BigDecimal oldTotalAmount = (BigDecimal)model.getValue("expenseamount", index);
                BigDecimal oldTaxAmount = (BigDecimal)model.getValue("taxamount", index);
                BigDecimal oldExcludeTaxAmount = (BigDecimal)model.getValue("orientryamount", index);
                BigDecimal oldDeductibleTax = (BigDecimal)model.getValue("deductibletax", index);
                if (StringUtils.isNotEmpty((CharSequence)adjustModel.getItemFrom())) {
                    model.setValue("itemfrom", (Object)adjustModel.getItemFrom(), index);
                }
                if (adjustModel.getTotalAmount() != null) {
                    BigDecimal newTotalAmount = oldTotalAmount.subtract(adjustModel.getTotalAmount());
                    model.setValue("expenseamount", (Object)newTotalAmount, index);
                }
                if (adjustModel.getTaxRate() != null) {
                    model.setValue("taxrate", (Object)BigDecimal.valueOf(100L).multiply(adjustModel.getTaxRate()), index);
                }
                if (adjustModel.getTaxAmount() != null) {
                    BigDecimal newTaxAmount = oldTaxAmount.subtract(adjustModel.getTaxAmount());
                    if (newTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                        model.setValue("taxamount", (Object)BigDecimal.ZERO, index);
                    } else {
                        model.setValue("taxamount", (Object)newTaxAmount, index);
                    }
                }
                if (adjustModel.getExcludeTaxAmount() != null) {
                    BigDecimal newExcludeTaxAmount = oldExcludeTaxAmount.subtract(adjustModel.getExcludeTaxAmount());
                    if (newExcludeTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                        model.setValue("orientryamount", (Object)BigDecimal.ZERO, index);
                    } else {
                        model.setValue("orientryamount", (Object)newExcludeTaxAmount, index);
                    }
                }
                if (adjustModel.getAirportConstructionFee() != null) {
                    model.setValue("airportconstructionfee", (Object)adjustModel.getAirportConstructionFee(), index);
                }
                if (adjustModel.getTaxAmount() != null) {
                    BigDecimal newDeductibleTax = oldDeductibleTax.subtract(adjustModel.getDeductibleTax());
                    if (newDeductibleTax.compareTo(BigDecimal.ZERO) < 0) {
                        model.setValue("deductibletax", (Object)BigDecimal.ZERO, index);
                    } else {
                        model.setValue("deductibletax", (Object)newDeductibleTax, index);
                    }
                }
                boolean offset = false;
                DynamicObject expenseItem = (DynamicObject)model.getValue("expenseitem", index);
                if (expenseItem != null && expenseItem.containsProperty("offset")) {
                    offset = expenseItem.getBoolean("offset") && adjustModel.isOffset();
                }
                model.setValue("offset", (Object)offset, index);
                List invoiceEntry = autoMapInvoice ? InvoiceUtils.getAutoInvoiceInfoByItemId((IDataModel)model, (Long)((Long)pkValue)) : InvoiceUtils.getNonAutoInvoiceInfoByItemId((IDataModel)model, (Long)((Long)pkValue));
                boolean isSpecialType = invoiceEntry.isEmpty() ? false : invoiceEntry.stream().allMatch(invoice -> specialInvoiceTypes.contains(invoice.getString("invoicetype")));
                model.setValue("is_special_invoice", (Object)isSpecialType, index);
            }
            model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)adjustModel.getUnionInvoiceCode()), index);
            model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)adjustModel.getUnionInvoiceNo()), index);
        }
    }

    @Override
    public void autoDeleteInvoiceExpenseItem(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(this.getEntryKey());
        int[] deleteIndex = entryEntity.stream().filter(item -> ItemFrom.InvoiceCloud.getValue().equals(item.getString("itemfrom"))).map(item -> (Integer)item.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        if (deleteIndex.length > 0) {
            model.deleteEntryRows(this.getEntryKey(), deleteIndex);
        }
    }

    @Override
    public void deleteNonAutoRelationWhenDelInvoice(IFormView view, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        if (MapUtils.isEmpty(deleteInvoiceRelationMap)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceItemEntry = model.getEntryEntity("invoiceitementry");
        DynamicObjectCollection invoiceAndExpense = model.getEntryEntity("invoiceandexpense");
        DynamicObjectType invoiceExpenseType = invoiceAndExpense.getDynamicObjectType();
        Set<Long> invoiceIdSet = deleteInvoiceRelationMap.keySet();
        int[] invoiceItemIndex = invoiceItemEntry.stream().filter(invoiceItem -> invoiceIdSet.contains(invoiceItem.getLong("invoiceheadentryid"))).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        int[] relationIndexs = invoiceAndExpense.stream().filter(relation -> {
            if (invoiceIdSet.contains(relation.getLong("invoiceentryid"))) {
                if (invoiceExpenseType.getProperty("invoiceexpisunbind") != null) {
                    return !relation.getBoolean("invoiceexpisunbind");
                }
                return true;
            }
            return false;
        }).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        model.beginInit();
        model.deleteEntryRows("invoiceitementry", invoiceItemIndex);
        model.deleteEntryRows("invoiceandexpense", relationIndexs);
        model.endInit();
    }

    @Override
    public void deleteNonAutoRelationWhenDelExpense(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        if (MapUtils.isEmpty(deleteExpenseRelationMap)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceAndExpense = model.getEntryEntity("invoiceandexpense");
        Set<Long> expenseIdSet = deleteExpenseRelationMap.keySet();
        int[] relationIndexs = invoiceAndExpense.stream().filter(relation -> expenseIdSet.contains(relation.getLong("expenseentryid"))).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        model.beginInit();
        model.deleteEntryRows("invoiceandexpense", relationIndexs);
        model.endInit();
    }

    @Override
    public void updateInvoiceDetails_nonauto(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        super.updateInvoiceDetails_nonauto(view, deleteExpenseRelationMap);
        IDataModel model = view.getModel();
        for (Map.Entry<Long, InvoiceRelation> next : deleteExpenseRelationMap.entrySet()) {
            Long expenseItemId = next.getKey();
            InvoiceRelation relation = next.getValue();
            ItemInvoiceRelationEnum relationEnum = relation.getRelationEnum();
            Set invoiceHeadIdSet = relation.getOtherViewIds();
            for (Long invoiceHeadId : invoiceHeadIdSet) {
                int[] invoiceIndexes = InvoiceUtils2.getIndexes((IDataModel)model, (String)"invoiceentry", (Set)invoiceHeadIdSet);
                if (invoiceIndexes.length == 0) continue;
                InvoiceRelation invoiceRelation = InvoiceUtils2.getInvoiceRelation((IFormView)view, (RelationMainView)RelationMainView.VIEW_INVOICE, (Long)invoiceHeadId);
                if (invoiceRelation == null || invoiceRelation.getRelationEnum() == null) {
                    RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmount((IDataModel)model, (int[])new int[0], (int)invoiceIndexes[0]);
                    continue;
                }
                if (invoiceRelation.getRelationEnum() == ItemInvoiceRelationEnum.IsOneForOne || invoiceRelation.getRelationEnum() == ItemInvoiceRelationEnum.IsNForOne) {
                    Set expenseIndexSet = invoiceRelation.getOtherViewIds();
                    int[] expenseIndexes = InvoiceUtils2.getIndexes((IDataModel)model, (String)"expenseentryentity", (Set)expenseIndexSet);
                    if (invoiceIndexes.length == 0 || expenseIndexes.length == 0) continue;
                    RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmount((IDataModel)model, (int[])expenseIndexes, (int)invoiceIndexes[0]);
                    continue;
                }
                RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmount((IDataModel)model, (int[])new int[0], (int)invoiceIndexes[0]);
            }
        }
        InvoiceUtils2.clearIndexesCache((String)"invoiceentry");
        InvoiceUtils2.clearIndexesCache((String)"expenseentryentity");
    }

    @Override
    public void deleteNonAutoInvoiceItemAndAdjustExpense(IFormView view, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        super.deleteNonAutoInvoiceItemAndAdjustExpense(view, deleteInvoiceRelationMap);
        IDataModel dataModel = view.getModel();
        this.updateMultiReimburseControl(dataModel);
        for (Map.Entry<Long, InvoiceRelation> next : deleteInvoiceRelationMap.entrySet()) {
            ItemInvoiceRelationEnum newRelationEnum;
            Set expenseIdSet;
            Long expenseId;
            InvoiceRelation newInvoiceRelation;
            Long invoiceHeadId = next.getKey();
            InvoiceRelation invoiceRelation = next.getValue();
            ItemInvoiceRelationEnum oldRelationEnum = invoiceRelation.getRelationEnum();
            if (ItemInvoiceRelationEnum.IsOneForN != oldRelationEnum || (newInvoiceRelation = InvoiceUtils2.getInvoiceRelation((IFormView)view, (RelationMainView)RelationMainView.VIEW_EXPENSE, (Long)(expenseId = (Long)(expenseIdSet = invoiceRelation.getOtherViewIds()).stream().findFirst().get()))) == null || ItemInvoiceRelationEnum.IsOneForOne != (newRelationEnum = newInvoiceRelation.getRelationEnum())) continue;
            int[] expenseIndexes = InvoiceUtils2.getIndexes((IDataModel)view.getModel(), (String)this.getEntryKey(), (Set)expenseIdSet);
            int[] invoiceIndexes = InvoiceUtils2.getIndexes((IDataModel)view.getModel(), (String)"invoiceentry", (Set)newInvoiceRelation.getOtherViewIds());
            int expenseIndex = -1;
            int invoiceIndex = -1;
            if (expenseIndexes.length != 0) {
                expenseIndex = expenseIndexes[0];
            }
            if (invoiceIndexes.length != 0) {
                invoiceIndex = invoiceIndexes[0];
            }
            RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmount((IDataModel)view.getModel(), (int[])new int[]{expenseIndex}, (int)invoiceIndex);
        }
    }

    private void updateMultiReimburseControl(IDataModel dataModel) {
        if (this.HasProperty.apply("multireimbursecontrol").booleanValue()) {
            Optional<DynamicObject> optional = dataModel.getEntryEntity("invoiceentry").stream().filter(v -> v.getBoolean("ismutilreimburse")).findAny();
            dataModel.setValue("multireimbursecontrol", (Object)optional.isPresent());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        this.buyerNameChanged(e, name, rowIndex);
        this.sellerNameChanged(e, name, rowIndex);
        this.currentReimburseAmountChanged(e, name, rowIndex);
        this.totalAmountChanged(e, name, rowIndex);
        this.oriApproveAmountChanged(e, name, rowIndex);
        this.sellerChanged(e, name, rowIndex);
        this.buyerChanged(e, name, rowIndex);
        this.multiReimburseChanged(e, name, rowIndex);
        this.invoiceTaxChanged(e, name, rowIndex);
        this.invoiceTaxRateChanged(e, name, rowIndex);
        this.invoiceTotalAmountChanged(e, name, rowIndex);
        this.invoiceOffsetChanged(e, name, rowIndex);
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.formView.getModel();
        if (entryName.equals("invoiceentry")) {
            this.initInvoiceEntryRow(e, model);
            this.initInvoiceItemEntryRow(e, model);
        }
    }

    private void initInvoiceEntryRow(AfterAddRowEventArgs e, IDataModel model) {
        BillExpenseInfoFildKeyType type = this.getBillType();
        if (type == null) {
            return;
        }
        String costCompanyKey = type.getCostCompanyKey();
        if (model.getProperty(costCompanyKey) == null) {
            return;
        }
        Object costCompany = model.getValue(costCompanyKey);
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities != null && rowDataEntities.length > 0) {
            long[] ids = ORM.create().genLongIds(this.formView.getEntityId(), rowDataEntities.length);
            for (int i = 0; i < rowDataEntities.length; ++i) {
                Object entryBuyerOrg;
                int rowIndex;
                Object entryCurrency;
                DynamicObject entry = rowDataEntities[i].getDataEntity();
                if (!InvoiceFrom.ManualAdd.equalsFrom(entry.getString("invoicefrom"))) continue;
                Long id = (Long)entry.get("id");
                if (id == null || id == 0L) {
                    entry.set("id", (Object)ids[i]);
                }
                if ((entryCurrency = model.getValue("invoicecurrency", rowIndex = rowDataEntities[i].getRowIndex())) == null && currency != null) {
                    model.setValue("invoicecurrency", (Object)ErCommonUtils.getPk((Object)currency), rowIndex);
                }
                if ((entryBuyerOrg = model.getValue("buyerorg", rowIndex)) != null || costCompany == null) continue;
                model.setValue("buyerorg", (Object)ErCommonUtils.getPk((Object)costCompany), rowIndex);
            }
        }
    }

    private void initInvoiceItemEntryRow(AfterAddRowEventArgs e, IDataModel model) {
    }

    private void buyerNameChanged(PropertyChangedArgs e, String name, int rowIndex) {
        if ("buyerorgname".equals(name)) {
            IDataModel model = this.formView.getModel();
            String value = (String)e.getChangeSet()[0].getNewValue();
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)value)});
            model.beginInit();
            this.setValueIfExist(model, "buyerorg", org, rowIndex);
            model.endInit();
        }
    }

    private void sellerNameChanged(PropertyChangedArgs e, String name, int rowIndex) {
        if ("makeoutcompname".equals(name)) {
            IDataModel model = this.formView.getModel();
            String value = (String)e.getChangeSet()[0].getNewValue();
            DynamicObject org = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)value)});
            model.beginInit();
            this.setValueIfExist(model, "sellerorg", org, rowIndex);
            model.endInit();
        }
    }

    private void currentReimburseAmountChanged(PropertyChangedArgs e, String name, int rowIndex) {
        BigDecimal oriBalanceAmount;
        BigDecimal reimburseAmount;
        IDataModel model;
        boolean allowOver;
        if ("poolreimburseamount".equals(name) && !(allowOver = ((Boolean)(model = this.formView.getModel()).getValue("isexcessreim", rowIndex)).booleanValue()) && (reimburseAmount = (BigDecimal)e.getChangeSet()[0].getNewValue()).compareTo(oriBalanceAmount = (BigDecimal)model.getValue("oribalanceamount", rowIndex)) > 0) {
            model.beginInit();
            model.setValue("poolreimburseamount", (Object)oriBalanceAmount, rowIndex);
            model.endInit();
        }
    }

    private void totalAmountChanged(PropertyChangedArgs e, String name, int rowIndex) {
        if ("totalamount".equals(name)) {
            IDataModel model = this.formView.getModel();
            BigDecimal value = (BigDecimal)e.getChangeSet()[0].getNewValue();
            String invoiceFrom = (String)model.getValue("invoicefrom", rowIndex);
            if (InvoiceFrom.ManualAdd.equalsFrom(invoiceFrom)) {
                boolean isMultiReimburse;
                if (this.HasProperty.apply("oribalanceamount").booleanValue()) {
                    model.setValue("oribalanceamount", (Object)value, rowIndex);
                }
                if (this.HasProperty.apply("poolreimburseamount").booleanValue() && !(isMultiReimburse = ((Boolean)model.getValue("ismutilreimburse", rowIndex)).booleanValue())) {
                    model.setValue("poolreimburseamount", (Object)value, rowIndex);
                }
            } else if (InvoiceFrom.InvoiceCloud.equalsFrom(invoiceFrom)) {
                String invoiceTypeStr = (String)model.getValue("invoicetype", rowIndex);
                if (InvoiceTypeEnum.key_30.getValue().equals(invoiceTypeStr) || InvoiceTypeEnum.key_21.getValue().equals(invoiceTypeStr)) {
                    boolean isMultiReimburse;
                    if (this.HasProperty.apply("oribalanceamount").booleanValue()) {
                        model.setValue("oribalanceamount", (Object)value, rowIndex);
                    }
                    if (this.HasProperty.apply("poolreimburseamount").booleanValue() && !(isMultiReimburse = ((Boolean)model.getValue("ismutilreimburse", rowIndex)).booleanValue())) {
                        model.setValue("poolreimburseamount", (Object)value, rowIndex);
                    }
                }
            }
        }
    }

    private void oriApproveAmountChanged(PropertyChangedArgs e, String name, int rowIndex) {
        if ("expeapproveamount".equals(name) && this.HasProperty.apply("billingpoolid").booleanValue()) {
            IDataModel model = this.formView.getModel();
            ChangeData changeData = e.getChangeSet()[0];
            Long expEntryId = (Long)changeData.getDataEntity().getPkValue();
            InvoiceRelation expenseViewRelation = InvoiceUtils2.getInvoiceRelation((IFormView)this.formView, (RelationMainView)RelationMainView.VIEW_EXPENSE, (Long)expEntryId);
            if (expenseViewRelation == null) {
                return;
            }
            if (expenseViewRelation.getRelationEnum() == ItemInvoiceRelationEnum.IsOneForOne || expenseViewRelation.getRelationEnum() == ItemInvoiceRelationEnum.IsNForOne) {
                Set invoiceHeadIds = expenseViewRelation.getOtherViewIds();
                Long invoiceHeadId = (Long)invoiceHeadIds.iterator().next();
                int[] invoiceIndexes = InvoiceUtils2.getIndexes((IDataModel)model, (String)"invoiceentry", (Set)invoiceHeadIds);
                int invoiceIndex = invoiceIndexes[0];
                InvoiceRelation invoiceViewRelation = InvoiceUtils2.getInvoiceRelation((IFormView)this.formView, (RelationMainView)RelationMainView.VIEW_INVOICE, (Long)invoiceHeadId);
                Set expenseIds = invoiceViewRelation.getOtherViewIds();
                int[] expenseIndexes = InvoiceUtils2.getIndexes((IDataModel)model, (String)this.getEntryKey(), (Set)expenseIds);
                RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmount((IDataModel)model, (int[])expenseIndexes, (int)invoiceIndex);
            }
        }
    }

    private void sellerChanged(PropertyChangedArgs e, String name, int rowIndex) {
        this.valueChanged(e, name, rowIndex, "sellerorg", "makeoutcompname");
    }

    private void buyerChanged(PropertyChangedArgs e, String name, int rowIndex) {
        this.valueChanged(e, name, rowIndex, "buyerorg", "buyerorgname");
    }

    private void multiReimburseChanged(PropertyChangedArgs e, String name, int rowIndex) {
        if ("ismutilreimburse".equals(name)) {
            boolean value;
            Optional<DynamicObject> optional;
            boolean newValue;
            String serialNo;
            boolean turnOff;
            IDataModel model = this.formView.getModel();
            ChangeData[] changeSet = e.getChangeSet();
            boolean bl = turnOff = (Boolean)changeSet[0].getNewValue() == false;
            if (turnOff && StringUtils.isNotBlank((CharSequence)(serialNo = (String)model.getValue("serialno", rowIndex))) && "1".equals(this.formView.getPageCache().get(serialNo))) {
                model.beginInit();
                model.setValue("ismutilreimburse", (Object)true, rowIndex);
                model.endInit();
                this.formView.updateView("ismutilreimburse", rowIndex);
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u62a5\u9500\u4e2d\u7684\u53d1\u7968\u7684\u591a\u6b21\u62a5\u9500\u5c5e\u6027\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"InvoiceCommonBillPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if ((newValue = !turnOff ? true : (optional = model.getEntryEntity("invoiceentry").stream().filter(v -> v.getBoolean("ismutilreimburse")).findAny()).isPresent()) != (value = ((Boolean)model.getValue("multireimbursecontrol")).booleanValue())) {
                model.setValue("multireimbursecontrol", (Object)newValue);
            }
            Long invoiceEntryId = changeSet[0].getDataEntity().getLong("id");
            RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmountByInvoiceId((IFormView)this.formView, Collections.singletonList(invoiceEntryId).stream().collect(Collectors.toSet()));
        }
    }

    private void invoiceTaxChanged(PropertyChangedArgs e, String name, int rowIndex) {
        IDataModel model;
        if (name.equals("taxamount_invoice") && !InvoiceFrom.InvoiceCloud.equalsFrom((String)(model = this.formView.getModel()).getValue("invoicefrom", rowIndex))) {
            ChangeData[] changeSet = e.getChangeSet();
            BigDecimal totalAmount = (BigDecimal)model.getValue("totalamount", rowIndex);
            BigDecimal taxAmount = (BigDecimal)changeSet[0].getNewValue();
            BigDecimal noTaxAmount = totalAmount.subtract(taxAmount);
            model.setValue("invoicenotaxamount", (Object)noTaxAmount, rowIndex);
            boolean offset = (Boolean)model.getValue("offset_invoice");
            if (offset) {
                model.setValue("offsetamount", (Object)taxAmount, rowIndex);
            } else {
                model.setValue("offsetamount", (Object)BigDecimal.ZERO, rowIndex);
            }
            model.setValue("inoutamount", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void invoiceTotalAmountChanged(PropertyChangedArgs e, String name, int rowIndex) {
        IDataModel model;
        if (name.equals("totalamount") && !InvoiceFrom.InvoiceCloud.equalsFrom((String)(model = this.formView.getModel()).getValue("invoicefrom", rowIndex))) {
            BigDecimal taxRate;
            ChangeData changeData = e.getChangeSet()[0];
            BigDecimal totalAmount = (BigDecimal)changeData.getNewValue();
            String taxRateStr = (String)model.getValue("alltaxrate", rowIndex);
            try {
                taxRate = new BigDecimal(taxRateStr).divide(new BigDecimal(100));
            }
            catch (Exception exception) {
                return;
            }
            BigDecimal taxAmount = totalAmount.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 4, RoundingMode.HALF_EVEN);
            BigDecimal noTaxAmount = totalAmount.subtract(taxAmount);
            model.setValue("taxamount_invoice", (Object)taxAmount, rowIndex);
            model.setValue("invoicenotaxamount", (Object)noTaxAmount, rowIndex);
        }
    }

    private void invoiceTaxRateChanged(PropertyChangedArgs e, String name, int rowIndex) {
        IDataModel model;
        if (name.equals("alltaxrate") && !InvoiceFrom.InvoiceCloud.equalsFrom((String)(model = this.formView.getModel()).getValue("invoicefrom", rowIndex))) {
            BigDecimal taxRate;
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            BigDecimal totalAmount = (BigDecimal)model.getValue("totalamount", rowIndex);
            try {
                taxRate = new BigDecimal(newValue).divide(new BigDecimal(100));
            }
            catch (Exception exception) {
                return;
            }
            if (BigDecimal.ZERO.compareTo(taxRate) > 0) {
                return;
            }
            BigDecimal taxAmount = totalAmount.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), 4, RoundingMode.HALF_EVEN);
            model.setValue("taxamount_invoice", (Object)taxAmount, rowIndex);
        }
    }

    private void invoiceOffsetChanged(PropertyChangedArgs e, String name, int rowIndex) {
        IDataModel model;
        if (name.equals("offset_invoice") && !InvoiceFrom.InvoiceCloud.equalsFrom((String)(model = this.formView.getModel()).getValue("invoicefrom", rowIndex))) {
            boolean offset = (Boolean)e.getChangeSet()[0].getNewValue();
            BigDecimal offsetAmount = BigDecimal.ZERO;
            if (offset) {
                offsetAmount = (BigDecimal)model.getValue("taxamount_invoice", rowIndex);
            }
            model.setValue("offsetamount", (Object)offsetAmount, rowIndex);
            model.setValue("inoutamount", (Object)BigDecimal.ZERO, rowIndex);
        }
    }
}

