/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.plugin.action;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.common.invoice.model.InvoiceRelation;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.formplugin.invoicecloud.model.AdjustItemEntryModel;
import kd.fi.er.formplugin.invoicecloud.v2.plugin.action.CommonAction;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseAction
extends CommonAction {
    public TripReimburseAction(IFormView formView) {
        super(formView);
    }

    @Override
    public BillExpenseInfoFildKeyType getBillType() {
        return BillExpenseInfoFildKeyType.TripReimburse;
    }

    @Override
    public String getEntryKey() {
        return this.getBillType().getExpenseEntityKey();
    }

    @Override
    public List<DynamicObject> getExpenseEntryDetails(IFormView view) {
        IDataModel model = view.getModel();
        List<DynamicObject> tripItemEntryDOs = model.getDataEntity(true).getDynamicObjectCollection("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        return tripItemEntryDOs;
    }

    @Override
    public void deleteExpenseItem(IFormView view, Set<Long> needDeleteItemEntryIds) {
        if (needDeleteItemEntryIds.isEmpty()) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection tripEntryDOs = model.getEntryEntity("tripentry");
        int parentCount = tripEntryDOs.size();
        HashMap needDelRowMap = Maps.newHashMapWithExpectedSize((int)parentCount);
        for (int parentIndex = 0; parentIndex < parentCount; ++parentIndex) {
            DynamicObject tripEntryDO = (DynamicObject)tripEntryDOs.get(parentIndex);
            DynamicObjectCollection tripItemEntryDOs = tripEntryDO.getDynamicObjectCollection("entryentity");
            int itemCount = tripItemEntryDOs.size();
            for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
                DynamicObject dynamicObject = (DynamicObject)tripItemEntryDOs.get(itemIndex);
                if (!needDeleteItemEntryIds.contains(dynamicObject.getPkValue())) continue;
                Set curNeedDelItemRows = (Set)needDelRowMap.get(parentIndex);
                if (curNeedDelItemRows == null) {
                    curNeedDelItemRows = Sets.newHashSetWithExpectedSize((int)itemCount);
                    needDelRowMap.put(parentIndex, curNeedDelItemRows);
                }
                curNeedDelItemRows.add(itemIndex);
            }
        }
        int tripEntryIndex = model.getEntryCurrentRowIndex("tripentry");
        for (int parentIndex = 0; parentIndex < parentCount; ++parentIndex) {
            model.setEntryCurrentRowIndex("tripentry", parentIndex);
            Set curNeedDelItemRows = (Set)needDelRowMap.get(parentIndex);
            if (curNeedDelItemRows == null || curNeedDelItemRows.isEmpty()) continue;
            model.deleteEntryRows("entryentity", curNeedDelItemRows.stream().mapToInt(i -> i).toArray());
        }
        model.setEntryCurrentRowIndex("tripentry", tripEntryIndex);
        view.updateView("entryentity", tripEntryIndex);
    }

    @Override
    public void adjustItemEntry(IFormView view, Map<Long, AdjustItemEntryModel> adjustModels, boolean needAdjustAmount) {
        IDataModel model = view.getModel();
        int tripEntryRowCount = model.getEntryRowCount("tripentry");
        if (tripEntryRowCount < 1) {
            return;
        }
        if (adjustModels.isEmpty()) {
            return;
        }
        boolean autoMapInvoice = false;
        if (model.getProperty("automapinvoice") != null) {
            autoMapInvoice = (Boolean)model.getValue("automapinvoice");
        }
        Set specialInvoiceTypes = InvoiceTypeUtils.loadSpecialInvoiceTypes();
        DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
        for (int parentIndex = 0; parentIndex < tripEntry.size(); ++parentIndex) {
            DynamicObject trip = (DynamicObject)tripEntry.get(parentIndex);
            DynamicObjectCollection tripExpenseEntry = trip.getDynamicObjectCollection("entryentity");
            if (tripExpenseEntry == null || tripExpenseEntry.isEmpty()) continue;
            for (int index = 0; index < tripExpenseEntry.size(); ++index) {
                DynamicObject expenseEntryDO = (DynamicObject)tripExpenseEntry.get(index);
                Object pkValue = expenseEntryDO.getPkValue();
                if (!adjustModels.containsKey(pkValue)) continue;
                AdjustItemEntryModel adjustModel = adjustModels.get(pkValue);
                if (needAdjustAmount) {
                    BigDecimal oldTotalAmount = (BigDecimal)model.getValue("orientryamount", index, parentIndex);
                    BigDecimal oldTaxAmount = (BigDecimal)model.getValue("taxamount", index, parentIndex);
                    BigDecimal oldExcludeTaxAmount = (BigDecimal)model.getValue("notaxamount", index, parentIndex);
                    BigDecimal oldDeductibleTax = (BigDecimal)model.getValue("deductibletax", index, parentIndex);
                    if (StringUtils.isNotEmpty((CharSequence)adjustModel.getItemFrom())) {
                        model.setValue("itemfrom", (Object)adjustModel.getItemFrom(), index, parentIndex);
                    }
                    if (adjustModel.getTotalAmount() != null) {
                        BigDecimal newTotalAmount = oldTotalAmount.subtract(adjustModel.getTotalAmount());
                        model.setValue("orientryamount", (Object)newTotalAmount, index, parentIndex);
                    }
                    if (adjustModel.getTaxRate() != null) {
                        model.setValue("taxrate", (Object)BigDecimal.valueOf(100L).multiply(adjustModel.getTaxRate()), index, parentIndex);
                    }
                    if (adjustModel.getTaxAmount() != null) {
                        BigDecimal newTaxAmount = oldTaxAmount.subtract(adjustModel.getTaxAmount());
                        if (newTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                            model.setValue("taxamount", (Object)BigDecimal.ZERO, index, parentIndex);
                        } else {
                            model.setValue("taxamount", (Object)newTaxAmount, index, parentIndex);
                        }
                    }
                    if (adjustModel.getExcludeTaxAmount() != null) {
                        BigDecimal newExcludeTaxAmount = oldExcludeTaxAmount.subtract(adjustModel.getExcludeTaxAmount());
                        if (newExcludeTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                            model.setValue("notaxamount", (Object)BigDecimal.ZERO, index, parentIndex);
                        } else {
                            model.setValue("notaxamount", (Object)newExcludeTaxAmount, index, parentIndex);
                        }
                    }
                    if (adjustModel.getAirportConstructionFee() != null) {
                        model.setValue("airportconstructionfee", (Object)adjustModel.getAirportConstructionFee(), index, parentIndex);
                    }
                    if (adjustModel.getSeatGrade() != null) {
                        ReimburseUtils.setSeatGrades((IDataModel)model, (int)index, (int)parentIndex, adjustModel.getSeatGrade());
                    }
                    boolean offset = false;
                    DynamicObject expenseItem = (DynamicObject)model.getValue("expenseitem", index, parentIndex);
                    if (expenseItem != null && expenseItem.containsProperty("isoffset")) {
                        offset = expenseItem.getBoolean("isoffset") && adjustModel.isOffset();
                    }
                    model.setValue("offset", (Object)offset, index, parentIndex);
                    List invoiceEntry = autoMapInvoice ? InvoiceUtils.getAutoInvoiceInfoByItemId((IDataModel)model, (Long)((Long)pkValue)) : InvoiceUtils.getNonAutoInvoiceInfoByItemId((IDataModel)model, (Long)((Long)pkValue));
                    boolean isSpecialType = invoiceEntry.stream().allMatch(invoice -> specialInvoiceTypes.contains(invoice.getString("invoicetype")));
                    model.setValue("isvactax", (Object)isSpecialType, index, parentIndex);
                    if (adjustModel.getTaxAmount() != null) {
                        BigDecimal newDeductibleTax = oldDeductibleTax.subtract(adjustModel.getDeductibleTax());
                        if (newDeductibleTax.compareTo(BigDecimal.ZERO) < 0) {
                            model.setValue("deductibletax", (Object)BigDecimal.ZERO, index, parentIndex);
                        } else {
                            model.setValue("deductibletax", (Object)newDeductibleTax, index, parentIndex);
                        }
                    }
                }
                model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)adjustModel.getUnionInvoiceCode()), index, parentIndex);
                model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)adjustModel.getUnionInvoiceNo()), index, parentIndex);
            }
        }
    }

    @Override
    public void autoDeleteInvoiceExpenseItem(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection tripEntryDOs = model.getEntryEntity("tripentry");
        int parentCount = tripEntryDOs.size();
        HashMap needDelRowMap = Maps.newHashMapWithExpectedSize((int)parentCount);
        for (int parentIndex = 0; parentIndex < parentCount; ++parentIndex) {
            DynamicObject tripEntryDO = (DynamicObject)tripEntryDOs.get(parentIndex);
            DynamicObjectCollection tripItemEntryDOs = tripEntryDO.getDynamicObjectCollection("entryentity");
            Set deleteIndexs = tripItemEntryDOs.stream().filter(item -> ItemFrom.InvoiceCloud.getValue().equals(item.getString("itemfrom"))).map(item -> (Integer)item.get("seq") - 1).collect(Collectors.toSet());
            needDelRowMap.put(parentIndex, deleteIndexs);
        }
        int tripEntryIndex = model.getEntryCurrentRowIndex("tripentry");
        for (int parentIndex = 0; parentIndex < parentCount; ++parentIndex) {
            model.setEntryCurrentRowIndex("tripentry", parentIndex);
            Set curNeedDelItemRows = (Set)needDelRowMap.get(parentIndex);
            if (curNeedDelItemRows == null || curNeedDelItemRows.isEmpty()) continue;
            model.deleteEntryRows("entryentity", curNeedDelItemRows.stream().mapToInt(i -> i).toArray());
        }
        model.setEntryCurrentRowIndex("tripentry", tripEntryIndex);
        view.updateView("entryentity", tripEntryIndex);
    }

    @Override
    public void deleteNonAutoRelationWhenDelExpense(IFormView view, Map<Long, InvoiceRelation> deleteExpenseRelationMap) {
        if (MapUtils.isEmpty(deleteExpenseRelationMap)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceAndExpense = model.getEntryEntity("invoiceandexpense");
        Set<Long> expenseIdSet = deleteExpenseRelationMap.keySet();
        int[] relationIndexs = invoiceAndExpense.stream().filter(relation -> expenseIdSet.contains(relation.getLong("expenseentryid"))).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        model.beginInit();
        model.deleteEntryRows("invoiceandexpense", relationIndexs);
        model.endInit();
    }

    @Override
    public void deleteNonAutoRelationWhenDelInvoice(IFormView view, Map<Long, InvoiceRelation> deleteInvoiceRelationMap) {
        if (MapUtils.isEmpty(deleteInvoiceRelationMap)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection invoiceItemEntry = model.getEntryEntity("invoiceitementry");
        DynamicObjectCollection invoiceAndExpense = model.getEntryEntity("invoiceandexpense");
        DynamicObjectType invoiceExpenseType = invoiceAndExpense.getDynamicObjectType();
        Set<Long> invoiceIdSet = deleteInvoiceRelationMap.keySet();
        int[] invoiceItemIndex = invoiceItemEntry.stream().filter(invoiceItem -> invoiceIdSet.contains(invoiceItem.getLong("invoiceheadentryid"))).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        int[] relationIndexs = invoiceAndExpense.stream().filter(relation -> {
            if (invoiceIdSet.contains(relation.getLong("invoiceentryid"))) {
                if (invoiceExpenseType.getProperty("invoiceexpisunbind") != null) {
                    return !relation.getBoolean("invoiceexpisunbind");
                }
                return true;
            }
            return false;
        }).map(relation -> (Integer)relation.get("seq") - 1).mapToInt(Integer::intValue).toArray();
        model.beginInit();
        model.deleteEntryRows("invoiceitementry", invoiceItemIndex);
        model.deleteEntryRows("invoiceandexpense", relationIndexs);
        model.endInit();
    }
}

