/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.service.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.AttachmentCountUtils;
import kd.fi.er.common.model.invoice.AttachVo;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DeleteAttachmentByDeleteInvoiceUtil {
    private static final Log log = LogFactory.getLog(DeleteAttachmentByDeleteInvoiceUtil.class);
    private static final String DELETE_INVOICE_SERIALNO = "deleteInvoiceSerialno";
    protected static final String CACHE_ATTACHNO_BYDELETE_INVOICE = "cache_attachno_bydelete_invoice";
    private static final String CACHE_SERIALNO_BYDELETE_INVOICE = "cache_serialno_bydelete_invoice";

    public static void deleteAttachmentByDeleteInvoice(String entryName, AbstractFormPlugin plugin, IDataModel dataModel) {
        if ("invoiceentry".equals(entryName) && KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            Set deleteInvoiceSerialno = (Set)ThreadCache.get((Object)DELETE_INVOICE_SERIALNO);
            if (CollectionUtils.isEmpty((Collection)deleteInvoiceSerialno)) {
                return;
            }
            DynamicObject bill = dataModel.getDataEntity(true);
            log.info("\u5220\u9664\u53d1\u7968\u540e\uff0c\u540c\u6b65\u5220\u9664\u9644\u4ef6");
            if (bill.getDynamicObjectType().getProperty("invoiceattachinfo") != null) {
                DynamicObjectCollection attach = bill.getDynamicObjectCollection("invoiceattachinfo");
                List leaveAtta = attach.stream().filter(m -> !deleteInvoiceSerialno.contains(m.getString("attachserialno"))).collect(Collectors.toList());
                log.info("\u5220\u9664\u53d1\u7968\u540e\uff0c\u540c\u6b65\u5220\u9664\u9644\u4ef6\uff0c leaveAtta: {}, : {}", (Object)leaveAtta.size(), (Object)attach.size());
                if (leaveAtta.size() < attach.size()) {
                    ArrayList<AttachVo> attachVos = new ArrayList<AttachVo>(attach.size());
                    for (DynamicObject d : leaveAtta) {
                        AttachVo attachVo = new AttachVo();
                        attachVo.setAttachNo(d.getString("attachno"));
                        attachVo.setAttachType(d.getString("attachtype"));
                        attachVo.setAttachUrl(d.getString("attachurl"));
                        attachVo.setRemark(d.getString("attachremark"));
                        attachVo.setSerialNo(d.getString("attachserialno"));
                        attachVos.add(attachVo);
                    }
                    InvoicePluginUtils.updateAttachments(plugin, plugin.getView(), true, attachVos, true);
                    IPageCache pageCache = plugin.getView().getPageCache();
                    String serialnos = pageCache.get(CACHE_SERIALNO_BYDELETE_INVOICE);
                    Set oldSerials = new HashSet(0);
                    if (StringUtils.isNotBlank((CharSequence)serialnos)) {
                        oldSerials = (Set)JSON.parseObject((String)serialnos, Set.class);
                    }
                    deleteInvoiceSerialno.addAll(oldSerials);
                    plugin.getView().getPageCache().put(CACHE_SERIALNO_BYDELETE_INVOICE, SerializationUtils.toJsonString((Object)deleteInvoiceSerialno));
                }
            }
            ThreadCache.remove((Object)DELETE_INVOICE_SERIALNO);
        }
    }

    public static void recordSerialnoByDeleteInvoie(String entryName, int[] rowIndexs, IDataModel dataModel) {
        if ("invoiceentry".equals(entryName) && KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud() && KingdeeInvoiceCloudConfig.syncInvoiceAttachmentToBill()) {
            if (rowIndexs == null || rowIndexs.length == 0) {
                return;
            }
            DynamicObject bill = dataModel.getDataEntity(true);
            if (bill.getDynamicObjectType().getProperty("invoiceattachinfo") != null) {
                HashSet deleteInvoiceSerialno = Sets.newHashSetWithExpectedSize((int)12);
                DynamicObjectCollection invoiceHeadDOs = bill.getDynamicObjectCollection("invoiceentry");
                for (int rowIndex : rowIndexs) {
                    if (rowIndex >= invoiceHeadDOs.size()) continue;
                    deleteInvoiceSerialno.add(((DynamicObject)invoiceHeadDOs.get(rowIndex)).getString("serialno"));
                }
                ThreadCache.put((Object)DELETE_INVOICE_SERIALNO, (Object)deleteInvoiceSerialno);
            }
        }
    }

    public static void setCacheNeedAttachment(BeforeDoOperationEventArgs args, AbstractFormPlugin plugin) {
        if (args.getSource() instanceof FormOperate) {
            String uidStr;
            FormOperate operate = (FormOperate)args.getSource();
            if (Arrays.asList("save", "submit").contains(operate.getType()) && StringUtils.isNotEmpty((CharSequence)(uidStr = DeleteAttachmentByDeleteInvoiceUtil.getCacheNeedAttachment((EventObject)args, plugin)))) {
                Set uids = (Set)SerializationUtils.fromJsonString((String)uidStr, Set.class);
                log.info("\u7f13\u5b58\u7684\u5373\u5c06\u5220\u9664\u7684\u53d1\u7968\u4e91\u9644\u4ef6\u6d41\u6c34\u53f7\uff1a" + uids);
                if (uids.size() > 0 && args.getSource() instanceof FormOperate) {
                    ((FormOperate)args.getSource()).getOption().setVariableValue(CACHE_ATTACHNO_BYDELETE_INVOICE, SerializationUtils.toJsonString((Object)uids));
                }
            }
        }
    }

    public static void afterOperationDeleteAttachment(AfterDoOperationEventArgs afterDoOperationEventArgs, AbstractFormPlugin plugin) {
        AttachmentPanel panel = (AttachmentPanel)plugin.getControl("attachmentpanel");
        if (panel != null && afterDoOperationEventArgs.getSource() instanceof FormOperate && Arrays.asList("save", "submit").contains(((FormOperate)afterDoOperationEventArgs.getSource()).getType())) {
            String uidStr = DeleteAttachmentByDeleteInvoiceUtil.getCacheNeedAttachment((EventObject)afterDoOperationEventArgs, plugin);
            if (panel != null && StringUtils.isNotEmpty((CharSequence)uidStr)) {
                Set uids = (Set)SerializationUtils.fromJsonString((String)uidStr, Set.class);
                if (uids.size() > 0) {
                    List billAttachmentData = panel.getAttachmentData();
                    for (Map billAttach : billAttachmentData) {
                        String attachNo;
                        String uid = (String)billAttach.get("uid");
                        if (!AttachmentCountUtils.isInvoiceAttach((String)uid) || !uids.contains(attachNo = AttachmentCountUtils.getRealAttachNo((String)uid))) continue;
                        panel.remove(billAttach);
                    }
                }
                plugin.getPageCache().remove(CACHE_ATTACHNO_BYDELETE_INVOICE);
                plugin.getPageCache().remove(CACHE_SERIALNO_BYDELETE_INVOICE);
            }
        }
    }

    private static String getCacheNeedAttachment(EventObject eventObject, AbstractFormPlugin plugin) {
        if (eventObject instanceof AfterDoOperationEventArgs && ((AfterDoOperationEventArgs)eventObject).getOperationResult() != null && ((AfterDoOperationEventArgs)eventObject).getOperationResult().isSuccess() || eventObject instanceof BeforeDoOperationEventArgs) {
            IPageCache pageCache = plugin.getView().getPageCache();
            String uidStr = pageCache.get(CACHE_ATTACHNO_BYDELETE_INVOICE);
            return uidStr;
        }
        return null;
    }

    public static void removeAttachmentByInvoice(IFormView viewWithPanel, AttachmentPanel filePanel, List<Map<String, Object>> removeResults) {
        ArrayList removes = Lists.newArrayListWithExpectedSize((int)removeResults.size());
        for (Map<String, Object> u : removeResults) {
            HashMap<String, Object> removeResult = new HashMap<String, Object>();
            removeResult.put("remove", Boolean.TRUE);
            removeResult.put("uid", u.get("uid"));
            removes.add(removeResult);
        }
        if (removes.size() > 0) {
            IClientViewProxy proxy = (IClientViewProxy)viewWithPanel.getService(IClientViewProxy.class);
            proxy.invokeControlMethod(filePanel.getKey(), "removeAttachment", removes.toArray(new Object[0]));
        }
    }

    public static Set getTempDeleteSerialno(IFormView billView) {
        DynamicObject dataEntity = billView.getModel().getDataEntity(true);
        String attachNos = billView.getPageCache().get(CACHE_SERIALNO_BYDELETE_INVOICE);
        if (StringUtils.isNotBlank((CharSequence)attachNos)) {
            Set tempDeleteAttachNo = (Set)SerializationUtils.fromJsonString((String)attachNos, Set.class);
            if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoiceattachinfo")) {
                DynamicObjectCollection attachEntries = dataEntity.getDynamicObjectCollection("invoiceattachinfo");
                Set serialNosFromEntry = attachEntries.stream().map(e -> e.getString("attachserialno")).collect(Collectors.toSet());
                tempDeleteAttachNo.removeAll(serialNosFromEntry);
            }
            return tempDeleteAttachNo;
        }
        return new HashSet(0);
    }
}

