/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.tripbusi;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.StringUtils;

public class ExpitemRelInvoiceEdit
extends AbstractFormPlugin {
    private static final String SELECTED_INVOICE_IDS = "selectedInvoiceIds";
    private static final String SHOW_SELECTED_INVOICE = "showselectedinvoice";
    private static final Log log = LogFactory.getLog(ExpitemRelInvoiceEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "bar_save", "bar_cancel"});
        this.addClickListeners(new String[]{"resetinvoiceinfo"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String showSelectedInvoice = (String)showParameter.getCustomParam(SHOW_SELECTED_INVOICE);
        Label showInvoiceInfoLabel = (Label)view.getControl(SHOW_SELECTED_INVOICE);
        showInvoiceInfoLabel.setText(showSelectedInvoice);
        IPageCache pageCache = this.getPageCache();
        String selectedInvoiceIds = (String)showParameter.getCustomParam(SELECTED_INVOICE_IDS);
        pageCache.put(SELECTED_INVOICE_IDS, selectedInvoiceIds);
        log.info(String.format("Show selectedInvoiceIds : %s ", selectedInvoiceIds));
        Object invoiceCurrencyObj = showParameter.getCustomParam("invoiceCurrency");
        long invoiceCurrency = invoiceCurrencyObj instanceof Integer ? ((Integer)invoiceCurrencyObj).longValue() : ((Long)invoiceCurrencyObj).longValue();
        this.getModel().setValue("invoicecurrency", (Object)invoiceCurrency);
        this.initAllExpenseData();
        this.setCheckedNode();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"resetinvoiceinfo")) {
            IDataModel model = this.getModel();
            String formName = model.getDataEntityType().getName();
            HashMap<String, String> customParam = new HashMap<String, String>();
            customParam.put("formId", formName);
            IPageCache pageCache = this.getPageCache();
            String selectedInvoiceIds = pageCache.get(SELECTED_INVOICE_IDS);
            customParam.put(SELECTED_INVOICE_IDS, selectedInvoiceIds);
            FormModel formModel = new FormModel("er_tripreiminvoiceinfo", ResManager.loadKDString((String)"\u9009\u62e9\u53d1\u7968", (String)"ExpitemRelInvoiceEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "14", true, customParam);
            formModel.setShowType(ShowType.Modal);
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && StringUtils.equals((CharSequence)"er_tripreiminvoiceinfo", (CharSequence)actionId)) {
            Map returnMap = (Map)returnData;
            String showSelectedInvoice = (String)returnMap.get(SHOW_SELECTED_INVOICE);
            Label showInvoiceInfoLabel = (Label)this.getView().getControl(SHOW_SELECTED_INVOICE);
            if (StringUtils.isNotBlank((CharSequence)showSelectedInvoice)) {
                showInvoiceInfoLabel.setText(showSelectedInvoice);
                IPageCache pageCache = this.getPageCache();
                String selectedInvoiceIds = (String)returnMap.get(SELECTED_INVOICE_IDS);
                pageCache.put(SELECTED_INVOICE_IDS, selectedInvoiceIds);
                this.initAllExpenseData();
                this.setCheckedNode();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equalsIgnoreCase("bar_save")) {
            DynamicObject invoiceCurrencyObj = (DynamicObject)this.getModel().getValue("invoicecurrency");
            long invoiceCurrency = (Long)invoiceCurrencyObj.getPkValue();
            List<Long> selectExpList = this.getSelectTripExpenseIdList();
            if (selectExpList.isEmpty()) {
                return;
            }
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            IDataModel parentModel = parentView.getModel();
            DynamicObjectCollection tripEntry = parentModel.getDataEntity(true).getDynamicObjectCollection("tripentry");
            for (int parentIndex = 0; parentIndex < tripEntry.size(); ++parentIndex) {
                DynamicObject tripEntryObj = (DynamicObject)tripEntry.get(parentIndex);
                DynamicObjectCollection entryEntity = tripEntryObj.getDynamicObjectCollection("entryentity");
                for (int index = 0; index < entryEntity.size(); ++index) {
                    DynamicObject tripExpense = (DynamicObject)entryEntity.get(index);
                    long pkId = tripExpense.getLong("id");
                    if (!selectExpList.contains(pkId)) continue;
                    DynamicObject tripExpCurrencyObj = tripExpense.getDynamicObject("entrycurrency");
                    if (tripExpCurrencyObj == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u8d39\u7528\u660e\u7ec6\u4e0e\u53d1\u7968\u4fe1\u606f\u884c\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"ExpitemRelInvoiceEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        return;
                    }
                    long tripExpCurrency = (Long)tripExpCurrencyObj.getPkValue();
                    if (tripExpCurrency == invoiceCurrency) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u8d39\u7528\u660e\u7ec6\u4e0e\u53d1\u7968\u4fe1\u606f\u884c\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"ExpitemRelInvoiceEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"bar_save", (CharSequence)key)) {
            HashMap<String, Object> returnParam = new HashMap<String, Object>();
            List<Long> selectedTripItemIds = this.getSelectTripExpenseIdList();
            IPageCache pageCache = this.getPageCache();
            String selectedInvoiceIds = pageCache.get(SELECTED_INVOICE_IDS);
            returnParam.put("selectedTripItemIds", selectedTripItemIds);
            returnParam.put(SELECTED_INVOICE_IDS, selectedInvoiceIds);
            this.getView().returnDataToParent(returnParam);
            this.getView().close();
        }
    }

    private void initAllExpenseData() {
        IFormView view = this.getView();
        TreeView expenseTree = (TreeView)view.getControl("tree_allexpense");
        expenseTree.deleteAllNodes();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObjectCollection tripEntry = parentModel.getDataEntity(true).getDynamicObjectCollection("tripentry");
        for (int index = 0; index < tripEntry.size(); ++index) {
            DynamicObject tripIfo = (DynamicObject)tripEntry.get(index);
            DynamicObjectCollection expenseEntry = tripIfo.getDynamicObjectCollection("entryentity");
            List childList = null;
            for (DynamicObject expenseInfo : expenseEntry) {
                String ordernum;
                DynamicObject expense;
                String itemfrom = expenseInfo.getString("itemfrom");
                if (StringUtils.equals((CharSequence)itemfrom, (CharSequence)"3") || (expense = expenseInfo.getDynamicObject("expenseitem")) == null || StringUtils.isNotBlank((CharSequence)(ordernum = expenseInfo.getString("ordernum")))) continue;
                String expenseitem = expense.getString("name");
                DynamicObject entrycurrency = expenseInfo.getDynamicObject("entrycurrency");
                String sign = entrycurrency.getString("sign");
                BigDecimal orientryamount = expenseInfo.getBigDecimal("orientryamount");
                int amtprecision = entrycurrency.getInt("amtprecision");
                BigDecimal oriEntryAmountScale = orientryamount.setScale(amtprecision);
                boolean mustSameInvoiceType = ErStdConfig.isMustSameInvoiceTypeInRelatingInvoice();
                if (oriEntryAmountScale.compareTo(BigDecimal.ZERO) == 0 || mustSameInvoiceType && !this.isTheSameInvoiceType(ErCommonUtils.getPk((Object)expenseInfo))) continue;
                TreeNode childNode = new TreeNode();
                childNode.setId(this.setAndGetSelectedRowEntryId(expenseInfo).toString());
                childNode.setText(expenseitem + sign + oriEntryAmountScale);
                if (childList == null) {
                    childList = Lists.newArrayListWithExpectedSize((int)expenseEntry.size());
                }
                childList.add(childNode);
            }
            if (childList == null || childList.size() <= 0) continue;
            StringBuffer traveler = new StringBuffer();
            DynamicObjectCollection dyobjTravelers = tripIfo.getDynamicObjectCollection("travelers");
            if (dyobjTravelers != null) {
                for (DynamicObject travelerObj : dyobjTravelers) {
                    DynamicObject userObj = travelerObj.getDynamicObject("fbasedataid");
                    if (userObj == null) continue;
                    traveler.append(userObj.getString("name"));
                    traveler.append("\uff1b");
                }
            }
            TreeNode node = new TreeNode();
            node.setId(tripIfo.getPkValue().toString());
            String from = tripIfo.getDynamicObject("from").getLocaleString("name").toString();
            String to = tripIfo.getDynamicObject("to").getLocaleString("name").toString();
            String nodeText = index + 1 + "." + from + "->" + to;
            node.setText(nodeText + "  " + traveler);
            node.addChildren(childList);
            expenseTree.addNode(node);
            expenseTree.expand(tripIfo.getPkValue().toString());
        }
    }

    private void setCheckedNode() {
        IFormView view = this.getView();
        TreeView expenseTree = (TreeView)view.getControl("tree_allexpense");
        List unCheckedNodes = expenseTree.getTreeState().getCheckedNodeIds();
        unCheckedNodes.stream().forEach(unchecked -> expenseTree.uncheckNode(unchecked));
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        ArrayList checkedNodes = Lists.newArrayList();
        IPageCache pageCache = this.getPageCache();
        String selectedInvoiceIds = pageCache.get(SELECTED_INVOICE_IDS);
        if (selectedInvoiceIds == null || StringUtils.isBlank((CharSequence)selectedInvoiceIds)) {
            return;
        }
        DynamicObjectCollection invoiceAndExpense = parentModel.getEntryEntity("invoiceandexpense");
        invoiceAndExpense.stream().filter(relation -> StringUtils.contains((CharSequence)selectedInvoiceIds, (CharSequence)String.valueOf(relation.getLong("invoiceentryid")))).map(relation -> relation.get("expenseentryid").toString()).distinct().forEach(expenseid -> {
            TreeNode node = new TreeNode();
            node.setId(expenseid);
            checkedNodes.add(node);
        });
        expenseTree.checkNodes((List)checkedNodes);
    }

    private Long setAndGetSelectedRowEntryId(DynamicObject entryEntity) {
        Long entryId = (Long)entryEntity.getPkValue();
        if (Objects.equals(entryId, 0L)) {
            entryId = ORM.create().genLongId(this.getView().getEntityId());
            entryEntity.set("id", (Object)entryId);
        }
        return entryId;
    }

    private boolean isTheSameInvoiceType(Long tripExpenseItemId) {
        DynamicObject pDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        String selectedInvoiceIds = this.getPageCache().get(SELECTED_INVOICE_IDS);
        if (selectedInvoiceIds == null) {
            selectedInvoiceIds = "";
        }
        Set selectedInvoiceSet = Arrays.stream(selectedInvoiceIds.split(",")).collect(Collectors.toSet());
        DynamicObjectCollection invoiceHeadDOs = pDataEntity.getDynamicObjectCollection("invoiceentry");
        Set invoiceTypes = invoiceHeadDOs.stream().filter(entry -> selectedInvoiceSet.contains(entry.getPkValue().toString())).map(entry -> entry.getString("invoicetype")).collect(Collectors.toSet());
        if (invoiceTypes.size() != 1) {
            return false;
        }
        String mappedInvoiceType = (String)invoiceTypes.iterator().next();
        DynamicObjectCollection invoiceAndExpenseDOs = pDataEntity.getDynamicObjectCollection("invoiceandexpense");
        Set invoiceHeadEntryIds = invoiceAndExpenseDOs.stream().filter(entry -> Objects.equals(entry.getLong("expenseentryid"), tripExpenseItemId)).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
        boolean isSame = invoiceHeadDOs.stream().filter(entry -> invoiceHeadEntryIds.contains(entry.getPkValue())).allMatch(entry -> StringUtils.equals((CharSequence)entry.getString("invoicetype"), (CharSequence)mappedInvoiceType));
        return isSame;
    }

    private List<Long> getSelectTripExpenseIdList() {
        TreeView expenseTree = (TreeView)this.getView().getControl("tree_allexpense");
        List strSelectedTrip = expenseTree.getTreeState().getCheckedNodes();
        ArrayList selectedTripItemIds = Lists.newArrayList();
        for (Map node : strSelectedTrip) {
            Object isParent = node.get("isParent");
            if (isParent != null && ((Boolean)isParent).booleanValue()) continue;
            selectedTripItemIds.add(Long.parseLong((String)node.get("id")));
        }
        return selectedTripItemIds;
    }
}

