/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.tripbusi;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveDuplicateInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.invoicecloud.v2.util.SimpleRelateExpenseOrTripItemAndInvoiceUtil;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.PropBo;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceSupplementPCPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TripExpenseSupPlugin
extends AbstractImportInvoiceSupplementPCPlugin {
    private static final String SUPPLEMENTINVOICE = "supplementinvoice";
    private static final Log log = LogFactory.getLog(TripExpenseSupPlugin.class);
    private static final Set<String> LOCKSUPPLEMENTSTATUSSET = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"A", "B", "C", "D", "H", "I"}));
    private static final String TRIP_PANEL = "trippanel";
    private static final String TRIP_COUNT = "TRIP_COUNT";
    private static final String TRAVELER = "travelers";
    private static final String ORI_ENTRY_AMOUNT = "orientryamount";
    private static final String EXPENSE_ITEM = "expenseitem";
    private static final String INVOICE_NO_ENTRY = "invoiceno_entry";
    private static final String TRIP_FROM = "from";
    private static final String TRIP_TO = "to";
    private static final String IMPORTINVOICE = "importInvoice";
    private static final String DELETEINVOICE = "deleteInvoice";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", SUPPLEMENTINVOICE, "cancel"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter source = (FormShowParameter)e.getSource();
        int tripCount = (Integer)source.getCustomParam(TRIP_COUNT);
        FlexPanelAp flexPanelAp = this.createFlexPanelAp();
        List<EntryAp> entryAps = this.createDynamicEntryAp(tripCount);
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        flexPanelAp.getItems().addAll(entryAps);
        mapEntry.put("id", TRIP_PANEL);
        mapEntry.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            log.error((Throwable)exp);
        }
        int tripCount = (Integer)this.getView().getFormShowParameter().getCustomParam(TRIP_COUNT);
        this.registDynamicProps(newMainType, tripCount);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        if (parentView == null || parentModel == null) {
            this.getView().showTipNotification("no parent view or model!");
            return;
        }
        if (parentModel.getProperty("tripentry") == null || parentView.getControl("tripentry") == null) {
            this.getView().showTipNotification("no trip entry!");
            return;
        }
        this.initTripGridData(parentView, parentModel, dataEntity);
        e.setDataEntity((Object)dataEntity);
    }

    public void beforeBindData(EventObject e) {
        int tripCount = (Integer)this.getView().getFormShowParameter().getCustomParam(TRIP_COUNT);
        Container tripPanel = (Container)this.getView().getControl(TRIP_PANEL);
        List<EntryAp> entryAps = this.createDynamicEntryAp(tripCount);
        for (int index = 0; index < tripCount; ++index) {
            EntryAp entryAp = entryAps.get(index);
            EntryGrid entryControl = (EntryGrid)entryAp.buildRuntimeControl();
            entryControl.setEntryKey("entryap" + index);
            tripPanel.getItems().add(entryControl);
        }
        this.getView().createControlIndex(tripPanel.getItems());
    }

    @Override
    public void afterBindData(EventObject e) {
        Container tripPanel = (Container)this.getView().getControl(TRIP_PANEL);
        List items = tripPanel.getItems();
        for (int i = 0; i < items.size(); ++i) {
            Control item = (Control)items.get(i);
            if (!(item instanceof EntryGrid)) continue;
            IFormView parentView = this.getView().getParentView();
            IDataModel parentModel = parentView.getModel();
            if (parentView == null || parentModel == null) {
                this.getView().showTipNotification("no parent view or model!");
                return;
            }
            if (parentModel.getProperty("tripentry") == null || parentView.getControl("tripentry") == null) {
                this.getView().showTipNotification("no trip entry!");
                return;
            }
            String key = item.getKey();
            int tripIndex = Integer.parseInt(key.replace("entryap", ""));
            DynamicObjectCollection tripEntry = parentModel.getEntryEntity("tripentry");
            DynamicObject tripOb = (DynamicObject)tripEntry.get(tripIndex);
            DynamicObject fromOb = tripOb.getDynamicObject(TRIP_FROM);
            DynamicObject toOb = tripOb.getDynamicObject(TRIP_TO);
            MulBasedataDynamicObjectCollection travelersCollection = (MulBasedataDynamicObjectCollection)tripOb.getDynamicObjectCollection(TRAVELER);
            StringBuilder tripInfoStr = new StringBuilder();
            String fromName = fromOb.getString("name");
            String toName = toOb.getString("name");
            String travelerNames = this.getTravelerNames((Boolean)parentModel.getValue("istravelers"), travelersCollection);
            tripInfoStr.append(tripIndex + 1);
            tripInfoStr.append(".");
            tripInfoStr.append(fromName);
            tripInfoStr.append("-");
            tripInfoStr.append(toName);
            tripInfoStr.append("  ");
            tripInfoStr.append(travelerNames);
            HashMap<String, String> nameCN = new HashMap<String, String>();
            nameCN.put("zh_CN", tripInfoStr.toString());
            HashMap<String, HashMap<String, String>> text = new HashMap<String, HashMap<String, String>>();
            text.put("text", nameCN);
            this.loadParentData(parentView, parentModel, tripIndex);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{key});
            this.getView().updateControlMetadata(key, text);
        }
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new CreateTripItemEntryServiceImpl(invoiceContext, this.getParentModel(), this.isOrgOffset());
    }

    @Override
    public CreateInvoiceServiceI getCreateInvoiceService(InvoiceContext invoiceContext) {
        return new CreateInvoiceEntryServiceImpl(invoiceContext, this.getParentModel());
    }

    @Override
    public RemoveInvoiceService getRemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new RemoveDuplicateInvoiceServiceImpl(invoiceContext, this.getParentModel());
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (StringUtils.contains((CharSequence)key, (CharSequence)"entryap")) {
            EntryGrid grid = new EntryGrid();
            grid.setKey(key);
            grid.setView(this.getView());
            grid.setEntryKey(key);
            e.setControl((Control)grid);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals(SUPPLEMENTINVOICE)) {
            int tripCount = (Integer)this.getView().getFormShowParameter().getCustomParam(TRIP_COUNT);
            for (int i = 0; i < tripCount; ++i) {
                String entryKey = "entryap" + i;
                EntryGrid control = (EntryGrid)this.getControl(entryKey);
                int[] selectRows = control.getSelectRows();
                if (selectRows.length == 0) continue;
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5dee\u65c5\u660e\u7ec6\uff0c\u518d\u5bfc\u5165\u53d1\u7968\u3002", (String)"TripExpenseSupPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals(SUPPLEMENTINVOICE)) {
            this.getExtView().getPageCache().put("clickKey", SUPPLEMENTINVOICE);
            this.showSelectedInvoicePage("", this.getExtView(), itemKey);
        }
    }

    @Override
    public DynamicObject getCostCompanyDO() {
        return (DynamicObject)this.getView().getParentView().getModel().getValue(this.getCostCompanyKey());
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return (DynamicObject)this.getView().getParentView().getModel().getValue("company");
    }

    private List<EntryAp> createDynamicEntryAp(int tripCount) {
        ArrayList<EntryAp> list = new ArrayList<EntryAp>(tripCount);
        for (int index = 0; index < tripCount; ++index) {
            EntryAp entryAp = new EntryAp();
            entryAp.setKey("entryap" + index);
            entryAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5dee\u65c5\u660e\u7ec6", (String)"TripExpenseSupPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0])));
            entryAp.setShowSelChexkbox(true);
            entryAp.setCollapsible(true);
            EntryFieldAp expenseItemAp = new EntryFieldAp();
            expenseItemAp.setId(EXPENSE_ITEM + index);
            expenseItemAp.setKey(EXPENSE_ITEM + index);
            expenseItemAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5dee\u65c5\u9879\u76ee", (String)"TripExpenseSupPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0])));
            expenseItemAp.setFireUpdEvt(false);
            TextField expenseItem = new TextField();
            expenseItem.setId(EXPENSE_ITEM + index);
            expenseItem.setKey(EXPENSE_ITEM + index);
            expenseItemAp.setField((Field)expenseItem);
            EntryFieldAp oriAmountAp = new EntryFieldAp();
            oriAmountAp.setId(ORI_ENTRY_AMOUNT + index);
            oriAmountAp.setKey(ORI_ENTRY_AMOUNT + index);
            oriAmountAp.setName(new LocaleString(ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d", (String)"TripExpenseSupPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0])));
            oriAmountAp.setFireUpdEvt(false);
            DecimalField oriAmount = new DecimalField();
            oriAmount.setId(ORI_ENTRY_AMOUNT + index);
            oriAmount.setKey(ORI_ENTRY_AMOUNT + index);
            oriAmount.setScale(2);
            oriAmountAp.setField((Field)oriAmount);
            EntryFieldAp invoiceNoAp = new EntryFieldAp();
            invoiceNoAp.setId(INVOICE_NO_ENTRY + index);
            invoiceNoAp.setKey(INVOICE_NO_ENTRY + index);
            invoiceNoAp.setName(new LocaleString(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"TripExpenseSupPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0])));
            invoiceNoAp.setFireUpdEvt(false);
            TextField invoiceNo = new TextField();
            invoiceNo.setId(INVOICE_NO_ENTRY + index);
            invoiceNo.setKey(INVOICE_NO_ENTRY + index);
            invoiceNoAp.setField((Field)invoiceNo);
            entryAp.getItems().add(expenseItemAp);
            entryAp.getItems().add(oriAmountAp);
            entryAp.getItems().add(invoiceNoAp);
            list.add(entryAp);
        }
        return list;
    }

    private FlexPanelAp createFlexPanelAp() {
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setKey(TRIP_PANEL);
        return panelAp;
    }

    private void registDynamicProps(MainEntityType newMainType, int tripCount) {
        MainEntityType headContainer = (MainEntityType)newMainType.getAllEntities().get("er_tripinvoicesup");
        for (int index = 0; index < tripCount; ++index) {
            EntryProp entryProp = new EntryProp();
            entryProp.setName("entryap" + index);
            entryProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5dee\u65c5\u660e\u7ec6", (String)"TripExpenseSupPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0])));
            entryProp.setDbIgnore(true);
            entryProp.setAlias("");
            entryProp.setDefaultRows(0);
            EntryType entryType = new EntryType();
            entryType.setName("entryap" + index);
            entryType.setExtendName("entryap" + index);
            entryType.setDbIgnore(true);
            LongProp entryId = new LongProp();
            IntegerProp seq = new IntegerProp();
            entryId.setDbIgnore(true);
            entryId.setPrimaryKey(true);
            entryId.setName("Id" + index);
            entryId.setDisplayName(new LocaleString("Id"));
            entryId.setAlias("");
            seq.setDbIgnore(true);
            seq.setName("seq" + index);
            seq.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"TripExpenseSupPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0])));
            seq.setAlias("");
            TextProp traveler = new TextProp();
            traveler.setDbIgnore(true);
            traveler.setName(INVOICE_NO_ENTRY + index);
            traveler.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"TripExpenseSupPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0])));
            traveler.setAlias("");
            DecimalProp oriAmount = new DecimalProp();
            oriAmount.setDbIgnore(true);
            oriAmount.setName(ORI_ENTRY_AMOUNT + index);
            oriAmount.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d", (String)"TripExpenseSupPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0])));
            oriAmount.setAlias("");
            oriAmount.setScale(2);
            TextProp expenseItem = new TextProp();
            expenseItem.setDbIgnore(true);
            expenseItem.setName(EXPENSE_ITEM + index);
            expenseItem.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5dee\u65c5\u9879\u76ee", (String)"TripExpenseSupPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0])));
            expenseItem.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)entryId);
            entryType.registerSimpleProperty((DynamicSimpleProperty)seq);
            entryType.registerSimpleProperty((DynamicSimpleProperty)traveler);
            entryType.registerSimpleProperty((DynamicSimpleProperty)expenseItem);
            entryType.registerSimpleProperty((DynamicSimpleProperty)oriAmount);
            entryProp.setItemType((IDataEntityType)entryType);
            headContainer.registerCollectionProperty((DynamicCollectionProperty)entryProp);
        }
    }

    private void initTripGridData(IFormView parentView, IDataModel parentModel, DynamicObject dataEntity) {
        int tripCount = (Integer)this.getView().getFormShowParameter().getCustomParam(TRIP_COUNT);
        DynamicObjectCollection tripEntry = parentModel.getEntryEntity("tripentry");
        for (int index = 0; index < tripCount; ++index) {
            DynamicObject tripInfoOb = (DynamicObject)tripEntry.get(index);
            DynamicObjectCollection entryEntity = tripInfoOb.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection tripRows = dataEntity.getDynamicObjectCollection("entryap" + index);
            DynamicObjectType type = tripRows.getDynamicObjectType();
            tripRows.clear();
            for (int entityIndex = 0; entityIndex < entryEntity.size(); ++entityIndex) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entityIndex);
                DynamicObject newRow = new DynamicObject(type);
                newRow.set(INVOICE_NO_ENTRY + index, (Object)dynamicObject.getString(INVOICE_NO_ENTRY));
                newRow.set(EXPENSE_ITEM + index, (Object)dynamicObject.getDynamicObject(EXPENSE_ITEM).getString("name"));
                newRow.set(ORI_ENTRY_AMOUNT + index, (Object)dynamicObject.getBigDecimal(ORI_ENTRY_AMOUNT));
                newRow.set("id" + index, dynamicObject.getPkValue());
                tripRows.add((Object)newRow);
            }
        }
    }

    private String getTravelerNames(boolean isTravelers, MulBasedataDynamicObjectCollection travelers) {
        if (!isTravelers) {
            return "";
        }
        return travelers.stream().map(traveler -> traveler.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining("\uff1b"));
    }

    private void loadParentData(IFormView parentView, IDataModel parentModel, int tripIndex) {
        DynamicObject tripEntry = (DynamicObject)parentModel.getEntryEntity("tripentry").get(tripIndex);
        DynamicObjectCollection entryEntity = tripEntry.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            this.getModel().setValue(ORI_ENTRY_AMOUNT + tripIndex, (Object)dynamicObject.getBigDecimal(ORI_ENTRY_AMOUNT), i, tripIndex);
            this.getModel().setValue(EXPENSE_ITEM + tripIndex, (Object)dynamicObject.getDynamicObject(EXPENSE_ITEM).getString("name"), i, tripIndex);
            this.getModel().setValue(INVOICE_NO_ENTRY + tripIndex, (Object)dynamicObject.getString(INVOICE_NO_ENTRY), i, tripIndex);
        }
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext invoiceContext) {
        Set invoiceCurrencyId;
        IDataModel parentModel = this.getParentModel();
        List invoiceEntryBOs = invoiceContext.getInvoiceEntryBOs();
        if (invoiceEntryBOs == null || invoiceEntryBOs.size() == 0) {
            log.error("\u6ca1\u6709\u9009\u62e9\u5f85\u540e\u8865\u53d1\u7968\u7684\u8d39\u7528\u660e\u7ec6\u5206\u5f55, \u6216\u662f\u6ca1\u6709\u53d1\u7968\u5bfc\u5165");
            return;
        }
        Set newInvoiceIds = invoiceEntryBOs.stream().map(v -> v.getEntryId()).collect(Collectors.toSet());
        List<DynamicObject> selectedItems = this.getSelectedItems();
        if (CollectionUtils.isNotEmpty(selectedItems)) {
            Set expenseIds = selectedItems.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toSet());
            ArrayList<PropBo> propBos = new ArrayList<PropBo>(invoiceEntryBOs.size());
            for (int i = 0; i < invoiceEntryBOs.size(); ++i) {
                PropBo propBo = new PropBo();
                propBo.setInvoiceEntryId(((InvoiceEntryBO)invoiceEntryBOs.get(i)).getEntryId());
                propBo.setSerialNo(((InvoiceEntryBO)invoiceEntryBOs.get(i)).getSerialNo());
                propBos.add(propBo);
            }
            InvoiceUtils.buildMapinfo((IDataModel)parentModel, expenseIds, propBos);
            SimpleRelateExpenseOrTripItemAndInvoiceUtil.refreshExpenseField((IDataModel)parentModel, (BillOfInvoice)this.getBillOfInvoice(), expenseIds, newInvoiceIds);
        }
        if ((invoiceCurrencyId = invoiceContext.getInvoiceEntryBOs().stream().map(bo -> bo.getInvoiceCurrencyId()).collect(Collectors.toSet())).isEmpty() || invoiceCurrencyId.size() == 1 && invoiceCurrencyId.contains(null)) {
            parentModel.setValue("iscurrency", (Object)true);
        }
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        this.updateInvoiceValidateSummary(this.getView());
        this.setImportInvoice(true);
        IFormView parentView = this.getView().getParentView();
        parentView.updateView("invoiceentry");
        this.getView().sendFormAction(parentView);
        this.getView().updateView();
    }

    protected BillOfInvoice getBillOfInvoice() {
        return BillOfInvoice.TripReimburseBill;
    }

    protected void setImportInvoice(boolean bool) {
        String billStatus = (String)this.getParentModel().getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        boolean needSuppleInvoice = (Boolean)this.getParentModel().getValue("needsuppleinvoice");
        if (!LOCKSUPPLEMENTSTATUSSET.contains(billStatus) && needSuppleInvoice) {
            this.getView().getParentView().getPageCache().put(IMPORTINVOICE, bool ? "1" : "0");
        }
    }

    private IDataModel getParentModel() {
        return this.getView().getParentView().getModel();
    }

    @Override
    public void updateInvoiceValidateSummary(IFormView view) {
        Label label;
        IDataModel parentModel = this.getParentModel();
        if (((EntityType)parentModel.getDataEntityType().getAllEntities().get("invoiceentry")).getProperty("ie_validatest") == null) {
            return;
        }
        DynamicObjectCollection invoiceHeadDOs = parentModel.getEntryEntity("invoiceentry");
        String notOKInvoiceNos = invoiceHeadDOs.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getString("ie_validatest"), (CharSequence)InvoiceVO.CheckStatus.NOT_OK.getValue())).map(entry -> entry.getString("invoiceno")).collect(Collectors.joining("\uff0c"));
        String validateSummary = "";
        if (StringUtils.isNotBlank((CharSequence)notOKInvoiceNos)) {
            validateSummary = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u201c%1$s\u201d%2$s", (String)"AbstractImportInvoiceForReimPCPlugin_13", (String)"fi-er-formplugin", (Object[])new Object[0]), notOKInvoiceNos, ResManager.loadKDString((String)"\u67e5\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"AbstractImportInvoiceForReimPCPlugin_21", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if ((label = (Label)view.getParentView().getControl("invoice_validate_summary")) != null) {
            label.setText(validateSummary);
        }
    }

    @Override
    public IFormView getExtView() {
        return this.getView().getParentView();
    }

    @Override
    protected String getCloseCallBackKey() {
        return SUPPLEMENTINVOICE;
    }

    @Override
    protected Set<String> getCurrentPageInvoiceSerialNos() {
        IDataModel parentModel = this.getParentModel();
        DynamicObjectCollection invoiceEntryDOs = parentModel.getEntryEntity("invoiceentry");
        Set<String> serialNosFromPage = invoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getString("serialno")).collect(Collectors.toSet());
        return serialNosFromPage;
    }

    @Override
    protected List<DynamicObject> getSelectedItems() {
        ArrayList<DynamicObject> selectItems = new ArrayList<DynamicObject>();
        int tripCount = (Integer)this.getView().getFormShowParameter().getCustomParam(TRIP_COUNT);
        DynamicObjectCollection tripEntry = this.getParentModel().getEntryEntity("tripentry");
        Map<Long, DynamicObject> parentDetails = tripEntry.stream().flatMap(trip -> trip.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toMap(detail -> (Long)detail.getPkValue(), detail -> detail));
        for (int tripRowIndex = 0; tripRowIndex < tripCount; ++tripRowIndex) {
            String entryKey = "entryap" + tripRowIndex;
            EntryGrid control = (EntryGrid)this.getControl(entryKey);
            int[] selectRows = control.getSelectRows();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
            for (int selectRow : selectRows) {
                DynamicObject selectRowObj = (DynamicObject)entryEntity.get(selectRow);
                long id = selectRowObj.getLong("id" + tripRowIndex);
                DynamicObject dynamicObject = parentDetails.get(id);
                if (dynamicObject == null) continue;
                selectItems.add(dynamicObject);
            }
        }
        return selectItems;
    }
}

