/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mealapplicationbill.mobile.plugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import org.apache.commons.lang3.ObjectUtils;

public class ErMealApplicationBillMobilePlugin
extends AbstractMobBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_change"});
        IDataModel model = this.getView().getModel();
        String number = model.getDataEntityType().getName();
        BasedataEdit expenseitemF7 = (BasedataEdit)this.getControl("headexpenseitem");
        expenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "costdept"));
    }

    public void afterCreateNewData(EventObject e) {
        Map map = CoreBaseBillServiceHelper.createNewData((Long)RequestContext.get().getCurrUserId());
        CoreBaseBillServiceHelper.initObjByMap((Object)this.getModel(), (Map)map);
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        String applierPicUrl = "";
        if (applier != null) {
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        Image imageap_photo = (Image)this.getControl("imageap_photo");
        imageap_photo.setUrl(applierPicUrl);
        Object entryCurrency = model.getValue("entrycurrency");
        if (entryCurrency == null) {
            model.setValue("entrycurrency", model.getValue("currency"));
        }
    }

    public void afterLoadData(EventObject e) {
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey().toLowerCase()) {
            case "btn_change": {
                String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
                CommonViewControlUtil.changeApplier(entityName, (IFormPlugin)this, this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("er_daily_applier_mb".equalsIgnoreCase(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            this.setApplierInfo(this.getModel(), map);
            this.setDeptInfo(this.getModel(), map);
        }
    }

    private void setApplierInfo(IDataModel model, Map paraMap) {
        DynamicObject applier = (DynamicObject)paraMap.get("applier");
        model.setValue("applier", applier == null ? null : applier.getPkValue());
        model.setValue("applierpositionstr", paraMap.get("applierpositionstr"));
        model.setValue("tel", paraMap.get("tel"));
        String applierStr = "";
        String applierPicUrl = "";
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
        }
        Image imageap_photo = (Image)this.getControl("imageap_photo");
        imageap_photo.setUrl(applierPicUrl);
    }

    protected void setDeptInfo(IDataModel model, Map<String, Object> map) {
        DynamicObject org = (DynamicObject)map.get("org");
        DynamicObject company = (DynamicObject)map.get("company");
        Long orgId = 0L;
        if (org != null) {
            orgId = (Long)org.getPkValue();
        }
        Long companyId = 0L;
        if (company != null) {
            companyId = (Long)company.getPkValue();
        }
        model.setValue("org", (Object)orgId);
        model.setValue("costcompany", (Object)CoreBaseBillServiceHelper.getAccountOrgId((Long)orgId));
        model.setValue("company", (Object)companyId);
        model.setValue("costdept", (Object)orgId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        switch (propName) {
            case "costdept": {
                this.costDeptChange(model, propValue);
                break;
            }
            case "currency": {
                DynamicObject entryCurrency = (DynamicObject)model.getValue("entrycurrency");
                if (entryCurrency == null || currency == null || company == null) break;
                Long srcCurrencyId = (Long)entryCurrency.getPkValue();
                Long targetCurrencyId = (Long)currency.getPkValue();
                Map exchangerateMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)model);
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangerateMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangerateMap.get("quoteType")), (Object)"0");
                model.setValue("exchangerate", (Object)exchangeRate);
                model.setValue("stdexpquotetype", (Object)quoteType);
                break;
            }
            case "exchangerate": 
            case "dinneramount": {
                DynamicObject tripCurrency = (DynamicObject)model.getValue("entrycurrency");
                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)tripCurrency.getLong("id"), (Long)currency.getLong("id"), (Object)model);
                int currencyPrecision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
                Object dinneramount = model.getValue("dinneramount");
                BigDecimal tripAmount = AmountUtils.getCurrencyAmount((BigDecimal)(dinneramount == null ? BigDecimal.ZERO : BigDecimal.valueOf(Double.parseDouble(String.valueOf(dinneramount)))), (BigDecimal)((BigDecimal)model.getValue("exchangerate")), (int)currencyPrecision, (String)((String)exchangeRateAndQuoteType.get("quoteType")));
                model.setValue("tripamount", (Object)tripAmount);
                model.setValue("stdexpquotetype", exchangeRateAndQuoteType.get("quoteType"));
                break;
            }
            case "costcompany": 
            case "company": {
                if (propValue == null) {
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    break;
                }
                String billtype = (String)model.getValue("formid");
                if (ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                    return;
                }
                Long oldCurrency = ErCommonUtils.getPk((Object)model.getValue("currency"));
                if (company == null || company.getPkValue() == null) break;
                Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)company, (Object)costCompany);
                if (baseCurrencyId == null || baseCurrencyId.compareTo(0L) == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DailyBillServiceHelper_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                if (oldCurrency != null && oldCurrency.equals(baseCurrencyId)) break;
                model.setValue("currency", (Object)baseCurrencyId);
            }
        }
    }

    protected void costDeptChange(IDataModel model, Object propValue) {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return;
        }
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
        model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
        boolean isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        DynamicObject costDept = (DynamicObject)propValue;
        DynamicObject costCompany = (DynamicObject)this.getModel().getValue("costcompany");
        if (!isNotRelated) {
            CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
            model.setValue("costcompany", (Object)costCompanyId);
        }
    }
}

