/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mob.costcompany;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.web.util.TempCheckExpenseItemUtils;
import kd.fi.er.formplugin.mob.costcompany.AbstractSecondPageCostCompanyMobPlugin;
import org.apache.commons.lang3.StringUtils;

public class SecondPageCostCompanyForTripMobPlugin
extends AbstractSecondPageCostCompanyMobPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getView().getParentView() != null && this.getView().getParentView().getModel() != null) {
            IDataModel parentModel = this.getView().getParentView().getModel();
            String number = parentModel.getDataEntityType().getName();
            if (((Boolean)this.getModel().getValue("isloan")).booleanValue()) {
                number = "er_loanbill";
            }
            BasedataEdit expenseitemF7 = (BasedataEdit)this.getControl("tripexpenseitem");
            expenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "entrycostdept"));
        }
        OrgEdit deptOrgEdit = (OrgEdit)this.getControl("entrycostdept");
        deptOrgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent arg0) {
                arg0.getFormShowParameter().setCustomParam("orgFuncId", (Object)"01");
            }
        });
        this.costCenterF7Filter();
    }

    private void costCenterF7Filter() {
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("std_entrycostcenter");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        IDataModel pModel = this.getView().getParentView().getModel();
        model.setValue("expensesassumeshowtypes", pModel.getValue("expensesassumeshowtypes"));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Objects.nonNull(this.getModel().getDataEntityType().getProperty("costorgusemode")) && Objects.nonNull(this.getModel().getDataEntityType().getProperty("company"))) {
            DynamicObject companyForMob = ErCostCenterUtil.getCompanyForMob((IFormView)this.getView());
            if (companyForMob == null) {
                this.getModel().setValue("costorgusemode", (Object)"0");
            } else {
                this.getModel().setValue("costorgusemode", (Object)ErCommonUtils.getCostOrgUseMode((Long)ErCommonUtils.getPk((Object)companyForMob)));
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "entrycostcompany": {
                ErCostCenterUtil.entryCostCompanyChange((IFormView)this.getView());
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)this.getExpenseEntryName())) {
            RowDataEntity[] rowDataEntitys;
            Map params = this.getView().getFormShowParameter().getCustomParams();
            for (RowDataEntity rowEntity : rowDataEntitys = e.getRowDataEntities()) {
                int rowIndex = rowEntity.getRowIndex();
                if (params.containsKey("entryedit") || params.containsKey("index")) {
                    if (rowIndex == 0) continue;
                    this.setDefaultCostCompanyAndDept(rowIndex);
                    continue;
                }
                this.setDefaultCostCompanyAndDept(rowIndex);
            }
        }
    }

    private void setDefaultCostCompanyAndDept(int rowIndex) {
        IDataModel model = this.getModel();
        IDataModel pModel = this.getView().getParentView().getModel();
        model.setValue("entrycostdept", (Object)ErCommonUtils.getPk((Object)pModel.getValue("costdept")), rowIndex);
        model.setValue("entrycostcompany", (Object)ErCommonUtils.getPk((Object)pModel.getValue("costcompany")), rowIndex);
        model.setValue("std_entrycostcenter", (Object)ErCommonUtils.getPk((Object)pModel.getValue("std_costcenter")), rowIndex);
    }

    @Override
    public String getExpenseEntryName() {
        return "tripentry";
    }

    @Override
    public String getExpenseItemKey() {
        return "tripexpenseitem";
    }

    @Override
    protected void checkExpenseItem(DynamicObject costDept, int rowIndex) {
        TempCheckExpenseItemUtils.checkExpenseItemTrip((DynamicObject)costDept, (IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIndex);
    }
}

