/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.mobile;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractMobBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.UserProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;

public class BankCardManagementPlugin
extends AbstractMobBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.payerControl();
    }

    private void payerControl() {
        IDataEntityProperty payerProp = this.getModel().getProperty("payer");
        if (payerProp instanceof UserProp) {
            ((UserProp)payerProp).setF7Style(2);
        }
    }

    public void initialize() {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("payerbank");
        basedataEdit.addBeforeF7SelectListener(evt -> evt.getFormShowParameter().setCustomParam("isMultiKeySearch", (Object)"true"));
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Long currentUserID = CommonServiceHelper.getCurrentUserID();
        model.setValue("payer", (Object)currentUserID);
        model.setValue("outpayer", (Object)CommonServiceHelper.getCurrentUserName());
        model.setValue("payeraccountname", (Object)CommonServiceHelper.getCurrentUserName());
        Long createOrgId = CommonServiceHelper.getCompanyIdByUserId((Long)currentUserID);
        if (createOrgId == null) {
            createOrgId = RequestContext.get().getOrgId();
        }
        model.setValue("createorg", (Object)createOrgId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        DynamicObject payer = (DynamicObject)model.getValue("payer");
        boolean cancel = false;
        if (payer != null) {
            Long payerId = (Long)payer.getPkValue();
            Long creatorId = (Long)model.getValue("creator_id");
            Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
            boolean isdefault = (Boolean)model.getValue("isdefault");
            if (creatorId.equals(currentUserId) || payerId.equals(currentUserId)) {
                List defaultAccts;
                if (isdefault && !payerId.equals(currentUserId) && (defaultAccts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)payerId, (Object)model.getDataEntity().getPkValue(), (boolean)false)).size() > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5df2\u5b58\u5728\u9ed8\u8ba4\u6536\u6b3e\u4fe1\u606f\uff0c\u65e0\u6cd5\u518d\u8bbe\u7f6e\u3002", (String)"BankCardManagementPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    cancel = true;
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u672c\u4eba\u6216\u975e\u672c\u4eba\u7ef4\u62a4\u7684\u8d26\u53f7\u4e0d\u80fd\u4fee\u6539", (String)"BankCardManagementPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                cancel = true;
            }
        }
        args.setCancel(cancel);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "payer": {
                DynamicObject payer = (DynamicObject)propValue;
                Object name = payer == null ? null : payer.get("name");
                dataModel.setValue("outpayer", name);
                dataModel.setValue("payeraccountname", name);
            }
        }
    }
}

